/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruResourcesMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysModules;
import com.jxdinfo.hussar.bsp.permit.model.SysStruResources;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruResourcesService;
import com.jxdinfo.hussar.bsp.permit.vo.StruResVo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysStruResourcesServiceImpl
extends ServiceImpl<SysStruResourcesMapper, SysStruResources>
implements ISysStruResourcesService {
    @Resource
    private SysStruResourcesMapper sysStruResourcesMapper;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;

    @Override
    public List<SysModules> getGradeAdminModuleId(List<String> functionIdList) {
        return this.sysStruResourcesMapper.getGradeAdminModuleId(functionIdList);
    }

    @Override
    public List<String> getFunId(List<String> resourceIdList) {
        return this.sysStruResourcesMapper.getFunId(resourceIdList);
    }

    @Override
    public List<String> getResIdList(String struId) {
        return this.sysStruResourcesMapper.getResIdList(struId);
    }

    @Override
    public List<String> getUserResIdList(List<String> roleResult) {
        return this.sysStruResourcesMapper.getUserResIdList(roleResult);
    }

    @Override
    public List<String> getResourceIdList(String resourceId, String type) {
        List<Object> resourceIdList = new ArrayList();
        if ("isModule".equals(type)) {
            resourceIdList = this.sysStruResourcesMapper.getResourceIdByModuleId(resourceId);
        } else if ("isFun".equals(type)) {
            resourceIdList = this.sysStruResourcesMapper.getResourceIdByFuncId(resourceId);
        } else {
            resourceIdList.add(resourceId);
        }
        return resourceIdList;
    }

    @Override
    @Transactional
    public Tip retrieveResource(Map<String, Object> map) {
        ShiroUser shiroUser = ShiroKit.getUser();
        String resourceId = map.get("resourceIdHidden").toString();
        String[] struIdArr = map.get("struIdHidden").toString().split(",");
        List originalIdList = (List)map.get("originalIdList");
        String type = map.get("type").toString();
        ArrayList<String> struIdList = new ArrayList<String>(Arrays.asList(struIdArr));
        List<String> resourceIdList1 = this.getResourceIdList(resourceId, type);
        this.sysStruResourcesMapper.deleteStruResource(originalIdList, resourceIdList1);
        this.sysRoleResourceMapper.deleteStruRoleResource(originalIdList, resourceIdList1);
        ArrayList<SysStruResources> resourceList = new ArrayList<SysStruResources>();
        for (String tmpStruId : struIdList) {
            if ("".equals(tmpStruId)) continue;
            for (String tmpResourceId : resourceIdList1) {
                SysStruResources sysStruResources = new SysStruResources();
                sysStruResources.setStruId(tmpStruId);
                sysStruResources.setResourceId(tmpResourceId);
                sysStruResources.setCreateTime(new Date());
                sysStruResources.setCreator(shiroUser.getId());
                resourceList.add(sysStruResources);
            }
        }
        SuccessTip tip = new SuccessTip();
        if (resourceList.size() != 0) {
            if (super.saveBatch(resourceList, resourceList.size())) {
                tip.setMessage("\u56de\u6536\u6210\u529f\uff01");
                return tip;
            }
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u56de\u6536\u5931\u8d25\uff01");
        }
        tip.setMessage("\u56de\u6536\u6210\u529f\uff01");
        return tip;
    }

    @Override
    @Transactional
    public Tip delegateResource(Map<String, Object> map) {
        ShiroUser shiroUser = ShiroKit.getUser();
        String resourceId = map.get("resourceIdHidden").toString();
        String[] struIdArr = map.get("struIdHidden").toString().split(",");
        String type = map.get("type").toString();
        ArrayList<String> struIdList = new ArrayList<String>(Arrays.asList(struIdArr));
        List<String> resourceIdList1 = this.getResourceIdList(resourceId, type);
        this.sysStruResourcesMapper.deleteStruResource(struIdList, resourceIdList1);
        ArrayList<SysStruResources> resourceList = new ArrayList<SysStruResources>();
        for (String tmpStruId : struIdList) {
            for (String tmpResourceId : resourceIdList1) {
                SysStruResources sysStruResources = new SysStruResources();
                sysStruResources.setStruId(tmpStruId);
                sysStruResources.setResourceId(tmpResourceId);
                sysStruResources.setCreateTime(new Date());
                sysStruResources.setCreator(shiroUser.getId());
                resourceList.add(sysStruResources);
            }
        }
        SuccessTip tip = new SuccessTip();
        if (resourceList.size() != 0) {
            if (super.saveBatch(resourceList, resourceList.size())) {
                tip.setMessage("\u4e0b\u653e\u6210\u529f\uff01");
                return tip;
            }
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4e0b\u653e\u5931\u8d25\uff01");
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u6240\u9009\u8d44\u6e90\u5df2\u5168\u90e8\u4e0b\u653e\u5230\u9009\u4e2d\u7684\u7ec4\u7ec7\uff01");
    }

    @Override
    public List<String> getStruResourceCountMap(List<JSTreeModel> list, List<String> resourceIdList) {
        ArrayList<String> struIdList = new ArrayList<String>();
        for (JSTreeModel jsTreeModel : list) {
            String struId = jsTreeModel.getId();
            struIdList.add(struId);
        }
        int maxSize = resourceIdList.size();
        ArrayList<String> rtnList = new ArrayList<String>();
        List<StruResVo> result = this.sysStruResourcesMapper.getStruResourceCountMap(struIdList, resourceIdList);
        for (StruResVo struResVo : result) {
            String struId = struResVo.getStruId();
            String countStr = struResVo.getStruCount();
            Long count = Long.parseLong(countStr);
            if (count.intValue() != maxSize) continue;
            rtnList.add(struId);
        }
        return rtnList;
    }
}

