/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.organ.vo.RoleProcessVo;
import com.jxdinfo.hussar.bsp.permit.dao.SysRoleProcessMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleProcess;
import com.jxdinfo.hussar.bsp.permit.model.SysUserRole;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleProcessService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleProcessServiceImpl
extends ServiceImpl<SysRoleProcessMapper, SysRoleProcess>
implements ISysRoleProcessService {
    @Resource
    private SysRoleProcessMapper sysRoleProcessMapper;
    @Resource
    @Lazy
    private ISysRoleProcessService iSysRoleProcessService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Tip addOrDelRoleProcess(List<RoleProcessVo> adds, List<RoleProcessVo> dels, String roleId) {
        if (ToolUtil.isEmpty((Object)roleId)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "");
        }
        ArrayList<String> hasDel = new ArrayList<String>();
        for (RoleProcessVo roleProcessVo : dels) {
            hasDel.add(roleProcessVo.getId());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> addIds = new ArrayList<String>();
        for (RoleProcessVo roleProcessVo : adds) {
            addIds.add(roleProcessVo.getId());
            map.put(roleProcessVo.getId(), roleProcessVo.getName());
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"role_id", (Object)roleId);
        List se = this.sysRoleProcessMapper.selectList((Wrapper)wrapper);
        for (Object sysRoleProcess : se) {
            for (int i = 0; i < addIds.size(); ++i) {
                if (!((String)addIds.get(i)).equals(((SysRoleProcess)((Object)sysRoleProcess)).getProcessId())) continue;
                addIds.remove(addIds.get(i));
                --i;
            }
        }
        ArrayList<String> delNew = new ArrayList<String>();
        for (SysRoleProcess sysRoleProcess : se) {
            for (String del : hasDel) {
                if (!del.equals(sysRoleProcess.getProcessId())) continue;
                delNew.add(del);
            }
        }
        String currentUser = ShiroKit.getUser().getId();
        Date currentDate = new Date();
        if (ToolUtil.isNotEmpty(delNew)) {
            this.sysRoleProcessMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"role_id", (Object)roleId)).in((Object)"process_id", delNew));
        }
        ArrayList<SysRoleProcess> roleProcessList2 = new ArrayList<SysRoleProcess>();
        for (String processId : addIds) {
            SysRoleProcess sysRoleProcess = new SysRoleProcess();
            sysRoleProcess.setProcessId(processId);
            sysRoleProcess.setRoleId(roleId);
            sysRoleProcess.setProcessName((String)map.get(processId));
            sysRoleProcess.setCreateTime(currentDate);
            sysRoleProcess.setLastTime(currentDate);
            sysRoleProcess.setCreator(currentUser);
            sysRoleProcess.setLastEditor(currentUser);
            roleProcessList2.add(sysRoleProcess);
        }
        if (ToolUtil.isNotEmpty(roleProcessList2)) {
            this.saveBatch(roleProcessList2, roleProcessList2.size());
        }
        return new ErrorTip(HttpCode.OK.value().intValue(), "\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @Override
    public List<JSTreeModel> getRoleProcesstree(String roleId) {
        return this.sysRoleProcessMapper.getTree(roleId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<SysRoleProcess> getChecked(List<SysUserRole> roleId) {
        ArrayList<String> roleIds = new ArrayList<String>();
        for (SysUserRole sysUserRole : roleId) {
            roleIds.add(sysUserRole.getGrantedRole());
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"role_id", roleIds);
        List processList = this.iSysRoleProcessService.getBaseMapper().selectList((Wrapper)wrapper);
        List unique = processList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysRoleProcess>(Comparator.comparing(SysRoleProcess::getProcessId))), ArrayList::new));
        return unique;
    }
}

