/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysModulesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysFunctions;
import com.jxdinfo.hussar.bsp.permit.model.SysModules;
import com.jxdinfo.hussar.bsp.permit.model.SysResources;
import com.jxdinfo.hussar.bsp.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.bsp.permit.service.ISysModulesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResManageService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruResourcesService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.DataExportUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysResManageServiceImpl
implements ISysResManageService {
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private SysModulesMapper sysModulesMapper;
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private ISysModulesService sysModulesService;
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysStruResourcesService sysStruResourcesService;
    @Resource
    private ISysModulesService iSysModulesService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private GlobalProperties globalProperties;

    @Override
    public List<JSTreeModel> getResTree() {
        return this.sysModulesMapper.getModulesTree();
    }

    @Override
    public SysModules getModuleInfoById(String moduleId) {
        return this.sysModulesMapper.getModuleInfoById(moduleId);
    }

    @Override
    public Integer moduleSave(SysModules sysModules) {
        Date date = new Date();
        String userId = "";
        if (sysModules.getCreator() != null && "godaxe".equals(sysModules.getCreator())) {
            userId = sysModules.getCreator();
        } else if (ToolUtil.isNotEmpty((Object)ShiroKit.getUser())) {
            userId = ShiroKit.getUser().getId();
        }
        Integer count = 0;
        if (ToolUtil.isEmpty((Object)sysModules.getModuleId())) {
            sysModules.setModuleId(null);
            Long max = this.sysModulesMapper.getMaxOrderByParentId(sysModules.getParentModuleId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                BigDecimal num = new BigDecimal(1);
                BigDecimal order = BigDecimal.valueOf(max);
                sysModules.setSeq(order.add(num));
            } else {
                sysModules.setSeq(new BigDecimal(1));
            }
            sysModules.setCreateTime(date);
            sysModules.setCreator(userId);
            count = this.sysModulesMapper.insert((Object)sysModules);
        } else {
            sysModules.setLastTime(date);
            sysModules.setLastEditor(userId);
            count = this.sysModulesMapper.updateById((Object)sysModules);
        }
        return count;
    }

    @Override
    public List<JSTreeModel> moduleTreeById(String moduleId) {
        return this.sysModulesMapper.moduleTreeById(moduleId);
    }

    @Override
    public Integer functionSave(SysFunctions sysFunctions) {
        Date date = new Date();
        String userId = "";
        if (sysFunctions.getCreator() != null && "godaxe".equals(sysFunctions.getCreator())) {
            userId = sysFunctions.getCreator();
        } else if (ToolUtil.isNotEmpty((Object)ShiroKit.getUser())) {
            userId = ShiroKit.getUser().getId();
        }
        Integer count = 0;
        if (ToolUtil.isEmpty((Object)sysFunctions.getFunctionId())) {
            sysFunctions.setFunctionId(null);
            Long max = this.sysFunctionsMapper.getMaxOrderByParentId(sysFunctions.getModuleId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                BigDecimal num = new BigDecimal(1);
                BigDecimal order = BigDecimal.valueOf(max);
                sysFunctions.setSeq(order.add(num));
            } else {
                sysFunctions.setSeq(new BigDecimal(1));
            }
            sysFunctions.setCreateTime(date);
            sysFunctions.setCreator(userId);
            count = this.sysFunctionsMapper.insert((Object)sysFunctions);
        } else {
            sysFunctions.setLastTime(date);
            sysFunctions.setLastEditor(userId);
            count = this.sysFunctionsMapper.updateById((Object)sysFunctions);
        }
        return count;
    }

    @Override
    public SysFunctions getFunctionInfoById(String functionId) {
        return this.sysFunctionsMapper.getFunctionInfoById(functionId);
    }

    @Override
    public String resourceSave(SysResources sysResources) {
        Date date = new Date();
        String userId = "";
        if (sysResources.getCreator() != null && "godaxe".equals(sysResources.getCreator())) {
            userId = sysResources.getCreator();
        } else if (ToolUtil.isNotEmpty((Object)ShiroKit.getUser())) {
            userId = ShiroKit.getUser().getId();
        }
        if (ToolUtil.isEmpty((Object)sysResources.getResourceId())) {
            sysResources.setResourceId(null);
            Long max = this.sysResourcesMapper.getMaxOrderByParentId(sysResources.getFunctionId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                BigDecimal num = new BigDecimal(1);
                BigDecimal order = BigDecimal.valueOf(max);
                sysResources.setSeq(order.add(num));
            } else {
                sysResources.setSeq(new BigDecimal(1));
            }
            sysResources.setCreateTime(date);
            sysResources.setCreator(userId);
            this.sysResourcesMapper.insert((Object)sysResources);
        } else {
            sysResources.setLastTime(date);
            sysResources.setLastEditor(userId);
            this.sysResourcesMapper.updateById((Object)sysResources);
        }
        return sysResources.getResourceId();
    }

    @Override
    public SysResources getResourceInfoById(String resourceId) {
        return this.sysResourcesMapper.getResourceInfoById(resourceId);
    }

    @Override
    public JSONObject delModule(String moduleId) {
        List<Map<String, Object>> modulesResult = this.sysModulesMapper.getModulesByParentId(moduleId);
        List<Map<String, Object>> functionsResult = this.sysFunctionsMapper.getFunctionsByModuleId(moduleId);
        Boolean isDel = true;
        if (ToolUtil.isNotEmpty(modulesResult) || ToolUtil.isNotEmpty(functionsResult)) {
            isDel = false;
        }
        if (isDel.booleanValue()) {
            this.sysModulesMapper.deleteById((Serializable)((Object)moduleId));
        }
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        return json;
    }

    @Override
    public JSONObject delFunction(String functionId) {
        List<Map<String, Object>> resourcesResult = this.sysResourcesMapper.getResourcesByFunctionId(functionId);
        Boolean isDel = true;
        if (ToolUtil.isNotEmpty(resourcesResult)) {
            isDel = false;
        }
        if (isDel.booleanValue()) {
            this.sysFunctionsMapper.deleteById((Serializable)((Object)functionId));
        }
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        return json;
    }

    @Override
    public JSONObject delResource(String resourceId) {
        List<Map<String, Object>> roleResourcesResult = this.sysRoleResourceMapper.getRoleResourceByResourceId(resourceId);
        Boolean isDel = true;
        if (ToolUtil.isNotEmpty(roleResourcesResult)) {
            isDel = false;
        }
        if (isDel.booleanValue()) {
            this.sysResourcesMapper.deleteById((Serializable)((Object)resourceId));
        }
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        return json;
    }

    @Override
    public void saveModuleTreeOrder(JSONArray treeArr) {
        ArrayList<SysModules> sysModulesList = new ArrayList<SysModules>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = new JSONObject();
            json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            SysModules sysModules = new SysModules();
            sysModules.setModuleId(id);
            sysModules.setSeq(new BigDecimal(order));
            sysModulesList.add(sysModules);
        }
        if (ToolUtil.isNotEmpty(sysModulesList)) {
            this.sysModulesService.updateBatchById(sysModulesList, sysModulesList.size());
        }
    }

    @Override
    public List<JSTreeModel> functionTreeByModuleId(String moduleId) {
        return this.sysFunctionsMapper.functionTreeByModuleId(moduleId);
    }

    @Override
    public void saveFunctionTreeOrder(JSONArray treeArr) {
        ArrayList<SysFunctions> sysFunctionsList = new ArrayList<SysFunctions>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = new JSONObject();
            json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            SysFunctions sysFunctions = new SysFunctions();
            sysFunctions.setFunctionId(id);
            sysFunctions.setSeq(new BigDecimal(order));
            sysFunctionsList.add(sysFunctions);
        }
        if (ToolUtil.isNotEmpty(sysFunctionsList)) {
            this.sysFunctionsService.updateBatchById(sysFunctionsList, sysFunctionsList.size());
        }
    }

    @Override
    public List<JSTreeModel> resourceTreeByModuleId(String functionId) {
        return this.sysResourcesMapper.resourceTreeByModuleId(functionId);
    }

    @Override
    public boolean saveResourceTreeOrder(JSONArray treeArr) {
        ArrayList<SysResources> sysResourcesList = new ArrayList<SysResources>();
        boolean flag = false;
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = new JSONObject();
            json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            SysResources sysResources = new SysResources();
            sysResources.setResourceId(id);
            sysResources.setSeq(new BigDecimal(order));
            sysResourcesList.add(sysResources);
        }
        if (ToolUtil.isNotEmpty(sysResourcesList)) {
            flag = this.sysResourcesService.updateBatchById(sysResourcesList, sysResourcesList.size());
        }
        return flag;
    }

    @Override
    public List<JSTreeModel> moduleChangeById(String moduleId, String isLeaf) {
        return this.sysModulesMapper.moduleChangeTreeById(moduleId, isLeaf);
    }

    @Override
    public void functionTreeChange(String functionId, String parentId) {
        Long max = this.sysFunctionsMapper.getMaxOrderByParentId(parentId);
        BigDecimal order = new BigDecimal(1);
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            order = BigDecimal.valueOf(max);
            order = order.add(num);
        }
        this.sysFunctionsMapper.functionTreeChange(functionId, parentId, order);
    }

    @Override
    public List<JSTreeModel> resourceChangeById(String resourceId) {
        return this.sysFunctionsMapper.resourceChangeById(resourceId);
    }

    @Override
    public void resourceTreeChange(String resourceId, String parentId) {
        Long max = this.sysResourcesMapper.getMaxOrderByParentId(parentId);
        BigDecimal order = new BigDecimal(1);
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            order = BigDecimal.valueOf(max);
            order = order.add(num);
        }
        this.sysResourcesMapper.resourceTreeChange(resourceId, parentId, order);
    }

    @Override
    public void moduleTreeChange(String moduleId, String parentId) {
        Long max = this.sysModulesMapper.getMaxOrderByParentId(parentId);
        BigDecimal order = new BigDecimal(1);
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            order = BigDecimal.valueOf(max);
            order = order.add(num);
        }
        this.sysModulesMapper.moduleTreeChange(moduleId, parentId, order);
    }

    @Override
    public List<JSTreeModel> selfResourceTree(String[] rsourceIds) {
        return this.sysResourcesMapper.selfResourceTree(rsourceIds);
    }

    @Override
    public SysModules getModuleById(String moduleId) {
        return (SysModules)((Object)this.sysModulesMapper.selectById((Serializable)((Object)moduleId)));
    }

    @Override
    public SysFunctions getFunctionById(String functionId) {
        return (SysFunctions)((Object)this.sysFunctionsMapper.selectById((Serializable)((Object)functionId)));
    }

    @Override
    public List<JSTreeModel> getMenuResTree(String resType) {
        return this.sysModulesMapper.getMenuModulesTree(resType);
    }

    @Override
    public boolean isAllowEditModule(SysModules sysModules) {
        boolean flag = false;
        List<Map<String, Object>> modulesResult = this.sysModulesMapper.getModulesByParentId(sysModules.getModuleId());
        List<Map<String, Object>> functionsResult = this.sysFunctionsMapper.getFunctionsByModuleId(sysModules.getModuleId());
        SysModules oldModule = this.sysModulesMapper.getModuleInfoById(sysModules.getModuleId());
        if (oldModule.getIsLeaf().equals(sysModules.getIsLeaf())) {
            flag = true;
        } else if (ToolUtil.isEmpty(modulesResult) && ToolUtil.isEmpty(functionsResult)) {
            flag = true;
        }
        return flag;
    }

    @Override
    public List<JSTreeModel> getMoudleAndFunctionTree(String parentId) {
        return this.sysModulesMapper.getLazyLoadModulesTree(parentId);
    }

    @Override
    public List<JSTreeModel> getFunctionAndResTree(String nodeId) {
        return this.sysModulesMapper.getFunctionAndResTree(nodeId);
    }

    @Override
    public void exportRes(List<String> idList, HttpServletResponse response) {
        List modules = this.sysModulesMapper.selectBatchIds(idList);
        List functions = this.sysFunctionsMapper.selectBatchIds(idList);
        List resources = this.sysResourcesMapper.selectBatchIds(idList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("modules", modules);
        data.put("functions", functions);
        data.put("resources", resources);
        data.put("export_type", "resource");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "resource_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile(serializeData, fileName, response);
    }

    @Override
    @Transactional
    public Tip importRes(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize(content);
        String export_type = (String)data.get("export_type");
        if (!"resource".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + Constants.EXPORT_MAP.get("resource"));
        }
        List modules = (List)data.get("modules");
        List functions = (List)data.get("functions");
        List resources = (List)data.get("resources");
        Map<String, Integer> moduleCount = this.sysModulesService.insertOrUpdateList(modules);
        Map<String, Integer> functionCount = this.sysFunctionsService.insertOrUpdateList(functions);
        Map<String, Integer> resourceCount = this.sysResourcesService.insertOrUpdateList(resources);
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\u3002\u6a21\u5757\u65b0\u589e\u6570\u636e" + moduleCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + moduleCount.get("update") + "\u6761\uff1b\u529f\u80fd\u65b0\u589e\u6570\u636e" + functionCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + functionCount.get("update") + "\u6761\uff1b\u8d44\u6e90\u65b0\u589e\u6570\u636e" + resourceCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + resourceCount.get("update") + "\u6761\u3002");
        return success;
    }

    @Override
    public List<JSTreeModel> getFunResource(String type, String nodeId, String leaf, String nodeType) {
        String gradeParentId;
        ShiroUser shiroUser = ShiroKit.getUser();
        String struId = "";
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String empolyeeId;
            struId = empolyeeId = shiroUser.getEmployeeId();
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        List<Object> list1 = new ArrayList();
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        List<Object> resourceIdList = new ArrayList();
        ArrayList<String> functionIdList = new ArrayList<String>();
        ArrayList<SysModules> moduleIdList = new ArrayList<SysModules>();
        ArrayList<String> moduleIdList1 = new ArrayList<String>();
        ArrayList<Object> list = new ArrayList<Object>();
        if (isGradeAdmin && (resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId())).size() > 0) {
            functionIdList.addAll(this.sysStruResourcesService.getFunId(resourceIdList));
            List<SysModules> list2 = this.sysStruResourcesService.getGradeAdminModuleId(functionIdList);
            moduleIdList.addAll(list2);
            ArrayList<String> tmpModuleIds = new ArrayList<String>();
            tmpModuleIds.clear();
            for (SysModules sysModules : list2) {
                String parentId = sysModules.getParentModuleId();
                if ("1".equals(parentId)) continue;
                tmpModuleIds.add(parentId);
            }
            List<SysModules> parentModules = this.iSysModulesService.getParentModuleTree(tmpModuleIds);
            moduleIdList.addAll(parentModules);
            for (SysModules sysModules : moduleIdList) {
                String moduleId = sysModules.getModuleId();
                if (moduleIdList1.contains(moduleId)) continue;
                moduleIdList1.add(moduleId);
            }
            list.addAll(resourceIdList);
            list.addAll(functionIdList);
            list.addAll(moduleIdList1);
        }
        if ("menuRes".equals(type)) {
            String resType = this.sysDicRefService.getDictValue("res_type", "\u83dc\u5355\u8d44\u6e90");
            list1 = this.getMenuResTree(resType);
            result.add(root);
        } else if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)nodeId)) {
            boolean isFunAndRes;
            boolean isModule = ToolUtil.equals((Object)"isModule", (Object)nodeType);
            boolean bl = ToolUtil.equals((Object)"1", (Object)leaf);
            boolean isFun = ToolUtil.equals((Object)"isFun", (Object)nodeType);
            boolean bl2 = isFunAndRes = isModule && bl || isFun;
            if (ToolUtil.equals((Object)"#", (Object)nodeId)) {
                nodeId = "1";
                result.add(root);
                list1 = this.getMoudleAndFunctionTree(nodeId);
            } else if (isModule && !bl) {
                list1 = this.getMoudleAndFunctionTree(nodeId);
            } else if (isFunAndRes) {
                list1 = this.getFunctionAndResTree(nodeId);
            }
        } else {
            list1 = this.getResTree();
            result.add(root);
        }
        if (isGradeAdmin) {
            for (JSTreeModel jSTreeModel : list1) {
                String id = jSTreeModel.getId();
                if (!list.contains(id)) continue;
                jSTreeModel.getState().put("gradeDisabled", true);
                result.add(jSTreeModel);
            }
        } else {
            result.addAll(list1);
        }
        for (JSTreeModel jSTreeModel : result) {
            String isLeaf = jSTreeModel.getIsLeaf();
            String isModule = jSTreeModel.getType();
            if (!"isModule".equals(isModule) || !"0".equals(isLeaf)) continue;
            jSTreeModel.getState().put("notLeafModule", true);
        }
        return result;
    }

    @Override
    public List<JSTreeModel> getEditResTree() {
        Iterator gradeParentId;
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        List<JSTreeModel> list1 = this.getResTree();
        ShiroUser shiroUser = ShiroKit.getUser();
        String struId = "";
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String empolyeeId;
            struId = empolyeeId = shiroUser.getEmployeeId();
        }
        List<Object> resourceIdList = new ArrayList();
        ArrayList<String> functionIdList = new ArrayList<String>();
        ArrayList<SysModules> moduleIdList = new ArrayList<SysModules>();
        ArrayList<String> moduleIdList1 = new ArrayList<String>();
        ArrayList<Object> list = new ArrayList<Object>();
        if (isGradeAdmin && (resourceIdList = this.sysStruResourcesService.getResIdList((String)((Object)(gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId())))).size() > 0) {
            functionIdList.addAll(this.sysStruResourcesService.getFunId(resourceIdList));
            List<SysModules> leafModules = this.sysStruResourcesService.getGradeAdminModuleId(functionIdList);
            moduleIdList.addAll(leafModules);
            ArrayList<String> tmpModuleIds = new ArrayList<String>();
            tmpModuleIds.clear();
            for (SysModules sysModules : leafModules) {
                String parentId = sysModules.getParentModuleId();
                if ("1".equals(parentId)) continue;
                tmpModuleIds.add(parentId);
            }
            List<SysModules> parentModules = this.iSysModulesService.getParentModuleTree(tmpModuleIds);
            moduleIdList.addAll(parentModules);
            for (SysModules sysModules : moduleIdList) {
                String moduleId = sysModules.getModuleId();
                if (moduleIdList1.contains(moduleId)) continue;
                moduleIdList1.add(moduleId);
            }
            list.addAll(resourceIdList);
            list.addAll(functionIdList);
            list.addAll(moduleIdList1);
        }
        if (isGradeAdmin) {
            for (JSTreeModel model : list1) {
                String id = model.getId();
                if (!list.contains(id)) continue;
                model.getState().put("gradeDisabled", true);
                result.add(model);
            }
        } else {
            result.addAll(list1);
        }
        for (JSTreeModel js : result) {
            js.setState(false, false, false);
            if (!ToolUtil.equals((Object)js.getConstant(), (Object)"1")) continue;
            js.setState(false, false, true);
        }
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        result.add(root);
        return result;
    }
}

