/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.permit.dao.SysConfRolesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysConfRolesetMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysConfRoleset;
import com.jxdinfo.hussar.bsp.permit.model.SysRoles;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesetService;
import com.jxdinfo.hussar.bsp.permit.vo.SysConfRolesVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysConfRolesetServiceImpl
extends ServiceImpl<SysConfRolesetMapper, SysConfRoleset>
implements ISysConfRolesetService {
    @Resource
    private SysConfRolesetMapper sysConfRolesetMapper;
    @Resource
    private SysConfRolesMapper sysConfRolesMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;

    @Override
    public boolean addRole(Map<String, String> map) {
        String rolesName = map.get("rolesName");
        String count = map.get("count");
        BigDecimal cardinality = new BigDecimal(count);
        SysConfRoleset sysConfRoleset = new SysConfRoleset();
        sysConfRoleset.setSetId(null);
        sysConfRoleset.setSetName(rolesName);
        sysConfRoleset.setCorporationId("");
        sysConfRoleset.setCardinality(cardinality);
        sysConfRoleset.setCreateTime(new Date());
        Integer num = this.sysConfRolesetMapper.insert((Object)sysConfRoleset);
        return num == 1;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean editRole(Map<String, String> map) {
        String id = map.get("id");
        String rolesName = map.get("rolesName");
        SysConfRoleset sysConfRoleset = new SysConfRoleset();
        sysConfRoleset.setSetId(id);
        sysConfRoleset.setSetName(rolesName);
        sysConfRoleset.setCorporationId("");
        Integer num = this.sysConfRolesetMapper.updateById((Object)sysConfRoleset);
        return num == 1;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delRole(String id) {
        String[] ids = id.split(",");
        List<String> idList = Arrays.asList(ids);
        super.removeByIds(idList);
        this.sysConfRolesMapper.delete((Wrapper)new QueryWrapper().in((Object)"set_id", idList));
    }

    @Override
    public List<Object> getRoleView(String id) {
        ArrayList<Object> list = new ArrayList<Object>();
        List roleSetList = this.sysConfRolesetMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"set_id", (Object)id));
        List<SysConfRolesVo> roleList = this.sysConfRolesMapper.getSelectInRoles(id);
        list.add(roleSetList);
        list.add(roleList);
        return list;
    }

    @Override
    public Map<String, Object> getRolesList(String page, String limit, String name, String org) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
        List list = this.sysConfRolesetMapper.getRolesList(pages, name, org);
        map.put("count", pages.getTotal());
        map.put("data", list);
        map.put("code", 0);
        return map;
    }

    @Override
    public List<Map<String, Object>> getTransferData() {
        List roleList = this.sysRolesMapper.selectList((Wrapper)new QueryWrapper());
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (SysRoles role : roleList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("key", role.getRoleId());
            map.put("label", role.getRoleName());
            map.put("disabled", false);
            result.add(map);
        }
        return result;
    }

    @Override
    public List<SysConfRolesVo> getSelectInRoles(String id) {
        return this.sysConfRolesMapper.getSelectInRoles(id);
    }
}

