/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.jxdinfo.hussar.bsp.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/userRoleReview"})
public class UserRoleReviewController
extends BaseController {
    @Resource
    private ISysUserroleAuditService iSysUserroleAuditService;
    @Resource
    private ISysDicRefService iSysDicRefService;

    @RequestMapping(value={"/view"})
    @RequiresPermissions(value={"userRoleReview:view"})
    @BussinessLog(key="/userRoleReview/view", type="04", value="\u7528\u6237\u89d2\u8272\u5ba1\u6838\u9875\u9762")
    public String view() {
        return "/bsp/permit/roleManage/userRoleReview.html";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    @RequiresPermissions(value={"userRoleReview:list"})
    @BussinessLog(key="/userRoleReview/list", type="04", value="\u7528\u6237\u89d2\u8272\u5ba1\u6838\u5217\u8868")
    public Map<String, Object> list() {
        String userAccount = super.getPara("userAccount");
        String userName = super.getPara("userName");
        String type = super.getPara("type");
        String page = super.getPara("page");
        String limit = super.getPara("limit");
        Map<String, Object> result = this.iSysUserroleAuditService.getUserRoleReviewList(page, limit, userAccount, userName, type);
        return result;
    }

    @RequestMapping(value={"/reviewSubmit"})
    @RequiresPermissions(value={"userRoleReview:reviewSubmit"})
    @BussinessLog(key="/userRoleReview/reviewSubmit", type="03", value="\u7528\u6237\u89d2\u8272\u5ba1\u6838\u901a\u8fc7")
    @ResponseBody
    public Tip reviewSubmit() {
        String userId = this.getPara("userId").trim();
        String roleId = this.getPara("roleId").trim();
        String opsTypeId = this.getPara("opsTypeId").trim();
        this.iSysUserroleAuditService.reviewSubmit(userId, roleId, opsTypeId);
        SuccessTip tip = new SuccessTip();
        tip.setMessage("\u901a\u8fc7\u6210\u529f\uff01");
        return tip;
    }

    @RequestMapping(value={"/refuseSubmit"})
    @RequiresPermissions(value={"userRoleReview:refuseSubmit"})
    @BussinessLog(key="/userRoleReview/refuseSubmit", type="03", value="\u7528\u6237\u89d2\u8272\u5ba1\u6838\u9a73\u56de")
    @ResponseBody
    public Tip refuseSubmit() {
        String userId = this.getPara("userId");
        String roleId = this.getPara("roleId");
        String opsTypeId = this.getPara("opsTypeId");
        this.iSysUserroleAuditService.refuseSubmit(userId, roleId, opsTypeId);
        SuccessTip tip = new SuccessTip();
        tip.setMessage("\u9a73\u56de\u6210\u529f\uff01");
        return tip;
    }

    @RequestMapping(value={"/statusOption"})
    @ResponseBody
    public List<DicSingle> statusOption() {
        return this.iSysDicRefService.getDictByType("user_role_review");
    }
}

