/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.messagepush.BpmAbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.bsp.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.ProxyTreeVo;
import com.jxdinfo.hussar.bsp.permit.model.SysPasswordHist;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.bsp.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.constant.dictmap.UserDict;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.encrypt.CryptoUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.encrypt.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/user"})
public class SysUsersController
extends BaseController {
    private static String PREFIX = "/bsp/permit/";
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private ISysConfRolesService iSysConfRolesService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private HussarProperties hussarProperties;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private ISysStruAuditService iSysStruAuditService;
    @Resource
    private ISysUsersAuditService iSysUsersAuditService;
    @Resource
    private BpmAbstractPushMsgMatcher bpmAbstractPushMsgMatcher;

    @BussinessLog(key="/user/view", type="04", value="\u7528\u6237\u7ba1\u7406\u9875\u9762")
    @RequiresPermissions(value={"user:view"})
    @RequestMapping(value={"/view"})
    public String index() {
        return PREFIX + "userManage.html";
    }

    @RequiresPermissions(value={"user:chpwdonpage"})
    @RequestMapping(value={"/chpwd"})
    public String chpwd() {
        return PREFIX + "selfService/changePwd.html";
    }

    @BussinessLog(key="/user/pageResetAllPwd", type="04", value="\u6253\u5f00\u91cd\u7f6e\u6240\u6709\u7528\u6237\u5bc6\u7801\u9875\u9762")
    @RequiresPermissions(value={"user:pageResetAllPwd"})
    @RequestMapping(value={"/pageResetAllPwd"})
    public String pageResetAllPwd() {
        return PREFIX + "selfService/resetAllPwd.html";
    }

    @BussinessLog(key="/user/pageUserInfo", type="04", value="\u4e2a\u4eba\u4fe1\u606f\u9875\u9762")
    @RequiresPermissions(value={"user:pageUserInfo"})
    @RequestMapping(value={"/pageUserInfo"})
    public String pageUserInfo() {
        return PREFIX + "selfService/userInfo.html";
    }

    @RequestMapping(value={"/setgbpwd"})
    public String setgbpwd() {
        return PREFIX + "selfService/getBackPwd.html";
    }

    @RequiresPermissions(value={"user:userTree"})
    @RequestMapping(value={"/userTree"})
    @ResponseBody
    public List<JSTreeModel> userTree() {
        String isExport = super.getPara("isExport");
        String parentId = super.getPara("parentId");
        List<JSTreeModel> result = this.iSysUsersService.getUserTree(isExport, parentId);
        return result;
    }

    @Deprecated
    public List<ProxyTreeVo> doRecursive(List<ProxyTreeVo> list) {
        ArrayList<ProxyTreeVo> result = new ArrayList<ProxyTreeVo>();
        this.recursive(list, result, "");
        if (result.size() == 0) {
            for (ProxyTreeVo proxyTreeVo : list) {
                if (!"#".equals(proxyTreeVo.getParent())) continue;
                result.add(proxyTreeVo);
            }
        }
        return result;
    }

    @Deprecated
    public void recursive(List<ProxyTreeVo> list, List<ProxyTreeVo> result, String parentId) {
        for (int i = list.size() - 1; i >= 0; --i) {
            ProxyTreeVo proxyTreeVo;
            if (i > list.size() - 1) {
                i = list.size() - 1;
            }
            if (!"USER".equals((proxyTreeVo = list.get(i)).getCode()) && !parentId.equals(proxyTreeVo.getId())) continue;
            parentId = proxyTreeVo.getParent();
            result.add(proxyTreeVo);
            list.remove(i);
            this.recursive(list, result, parentId);
        }
    }

    @Deprecated
    @RequestMapping(value={"/proxyTree"})
    @ResponseBody
    public List<ProxyTreeVo> proxyTree() {
        String[] proxys = super.getPara("ids").trim().split(",");
        List<ProxyTreeVo> result = this.sysOrgManageService.getProxyTree(proxys);
        return this.doRecursive(result);
    }

    @RequiresPermissions(value={"user:orderTree"})
    @RequestMapping(value={"/orderTree"})
    @ResponseBody
    public List<JSTreeModel> orderTree() {
        String orgId = super.getPara("orgId").trim();
        List<JSTreeModel> result = this.sysOrgManageService.getUserOrderTree(orgId);
        return result;
    }

    @BussinessLog(key="/user/saveUserOrder", type="03", value="\u7528\u6237\u6392\u5e8f")
    @RequiresPermissions(value={"user:saveUserOrder"})
    @RequestMapping(value={"/saveUserOrder"})
    @ResponseBody
    public Tip saveUserOrder() {
        String treeInfo = super.getPara("treeInfo").trim();
        JSONArray treeArr = JSONArray.parseArray((String)treeInfo);
        if (ToolUtil.isNotEmpty((Object)treeArr)) {
            this.iSysUsersService.saveUserOrder(treeArr);
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u6ca1\u6709\u9700\u8981\u4fdd\u5b58\u6392\u5e8f\u7684\u7528\u6237\uff01");
    }

    @BussinessLog(key="/user/add", type="01", value="\u65b0\u589e\u7528\u6237")
    @RequiresPermissions(value={"user:add"})
    @RequestMapping(value={"/add"})
    @ResponseBody
    @CacheEvict(value={"user_ip"}, allEntries=true)
    public Tip addUser(SysUsers sysUsers) {
        String roleIds = super.getPara("roleIds").trim();
        Tip result = this.iSysUsersService.addUser(sysUsers, roleIds);
        return result;
    }

    @BussinessLog(key="/user/edit", type="03", value="\u4fee\u6539\u7528\u6237", pk="userId", dict=UserDict.class)
    @RequiresPermissions(value={"user:edit"})
    @RequestMapping(value={"/edit"})
    @ResponseBody
    @CacheEvict(value={"user_ip"}, allEntries=true)
    public Tip editUser(SysUsers sysUsers) {
        String userId = sysUsers.getUserId();
        String roleIds = super.getPara("roleIds").trim();
        if (!this.hussarProperties.getLoginUpperOpen().booleanValue()) {
            sysUsers.setUserAccount(sysUsers.getUserAccount().toUpperCase());
        }
        String[] ids = roleIds.split(",");
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < ids.length; ++i) {
            if (list.contains(ids[i])) continue;
            list.add(ids[i]);
        }
        ids = list.toArray(new String[list.size()]);
        if (this.iSysConfRolesService.isIncludeConfRole(ids)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01\uff08\u6240\u9009\u89d2\u8272\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u7684\u57fa\u6570\uff01\uff09");
        }
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isUserAudit() && this.iSysUsersAuditService.adjustEdit(sysUsers.getUserId())) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
        }
        sysUsers.setDepartmentId(sysUsers.getCorporationId());
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("userId", userId);
        map.put("roleIds", ids);
        map.put("sysUsers", (Object)sysUsers);
        return this.iSysUsersService.editUser(map);
    }

    @RequestMapping(value={"/userInfo"})
    @ResponseBody
    @BussinessLog(key="/user/userInfo", type="04", value="\u7528\u6237\u8be6\u60c5")
    @RequiresPermissions(value={"user:userInfo"})
    public ArrayList<Object> userInfo() {
        String id = super.getPara("id").trim();
        ArrayList<Object> list = this.iSysUsersService.getUserInfo(id);
        LogObjectHolder.me().set(list.get(0));
        return list;
    }

    @RequestMapping(value={"/currentUserInfo"})
    @ResponseBody
    public ArrayList<Object> currentUserInfo() {
        String userId = ShiroKit.getUser().getId();
        ArrayList<Object> list = this.iSysUsersService.getUserInfo(userId);
        return list;
    }

    @BussinessLog(key="/user/changeOrg", type="03", value="\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8")
    @RequiresPermissions(value={"user:changeOrg"})
    @RequestMapping(value={"/changeOrg"})
    @ResponseBody
    public Tip changeOrg() {
        String userId = super.getPara("userIdHidden").trim();
        String corporationId = super.getPara("corporationIdHidden").trim();
        String permitId = super.getPara("permitIdHidden").trim();
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("userId", userId);
        map.put("corporationId", corporationId);
        map.put("permitId", permitId);
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isUserAudit() && this.iSysUsersAuditService.adjustEdit(userId)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
        }
        return this.iSysUsersService.changeOrg(map);
    }

    @BussinessLog(key="/user/delete", type="02", value="\u5220\u9664\u7528\u6237")
    @RequiresPermissions(value={"user:delete"})
    @RequestMapping(value={"/delete"})
    @ResponseBody
    public Tip delUser() {
        String userId = super.getPara("userId").trim();
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        ShiroUser shiroUser = ShiroKit.getUser();
        SysUsers sysUser = this.iSysUsersService.getUser(userId);
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u5220\u9664\u7ba1\u7406\u5458\u7528\u6237\uff01\uff09");
        }
        if (shiroUser.getId().equals(userId)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u5220\u9664\u5f53\u524d\u7528\u6237\uff01\uff09");
        }
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isUserAudit() && this.iSysUsersAuditService.adjustEdit(userId)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
        }
        return this.iSysUsersService.delUser(sysUser);
    }

    @BussinessLog(key="/user/cancelUser", type="02", value="\u6ce8\u9500\u7528\u6237")
    @RequiresPermissions(value={"user:cancelUser"})
    @RequestMapping(value={"/cancelUser"})
    @ResponseBody
    public Tip cancelUser() {
        String userId = super.getPara("userId").trim();
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        ShiroUser shiroUser = ShiroKit.getUser();
        SysUsers sysUser = this.iSysUsersService.getUser(userId);
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u6ce8\u9500\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u6ce8\u9500\u7ba1\u7406\u5458\u7528\u6237\uff01\uff09");
        }
        if (shiroUser.getId().equals(userId)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u6ce8\u9500\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u6ce8\u9500\u5f53\u524d\u7528\u6237\uff01\uff09");
        }
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isUserAudit() && this.iSysUsersAuditService.adjustEdit(userId)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u6ce8\u9500\uff01");
        }
        return this.iSysUsersService.cancelUser(sysUser);
    }

    @RequestMapping(value={"/updatePwd"})
    @ResponseBody
    @BussinessLog(key="/user/updatePwd", type="03", value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @RequiresPermissions(value={"user:updatePwd"})
    public Tip updatePwd() {
        String data = super.getPara("data").trim();
        data = CryptoUtil.decode(data);
        String[] params = data.split("&");
        String oldPwd = "";
        String newPwd = "";
        String cPwd = "";
        for (String param : params) {
            String[] p = param.split("=");
            if ("old_pwd".equals(p[0])) {
                oldPwd = p[1];
            }
            if ("new_pwd".equals(p[0])) {
                newPwd = p[1];
            }
            if (!"c_pwd".equals(p[0])) continue;
            cPwd = p[1];
        }
        String regular = this.globalProperties.getPwdComplexityRegular().replaceAll("/", "");
        String hint = this.globalProperties.getUnmatchedHint();
        if (!newPwd.matches(regular)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), hint);
        }
        if (!newPwd.equals(cPwd)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01\uff08\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01\uff09");
        }
        String oPwd = this.credentialsMatcher.passwordEncode(oldPwd.getBytes());
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        String userId = ShiroKit.getUser().getId();
        SysUsers user = this.iSysUsersService.getUser(userId);
        String userAccount = user.getUserAccount();
        if (newPwd.toLowerCase().contains(userAccount.toLowerCase())) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01\uff08\u5bc6\u7801\u5305\u542b\u7528\u6237\u540d\uff01\uff09");
        }
        if (!oPwd.equals(user.getPassword())) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01\uff08\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff01\uff09");
        }
        List<SysPasswordHist> list = this.iSysUsersService.getPwdHist(userId);
        if (ToolUtil.isEmpty(list) && this.globalProperties.getDefaultPassword().equals(newPwd)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01\uff08\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u9ed8\u8ba4\u5bc6\u7801\u76f8\u540c\uff01\uff09");
        }
        for (SysPasswordHist sysPasswordHist : list) {
            if (!nPwd.equals(sysPasswordHist.getPassword())) continue;
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01\uff08\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u524d" + this.globalProperties.getPwdRepeatTime() + "\u6b21\u7684\u5bc6\u7801\u76f8\u540c\uff09");
        }
        user.setPassword(nPwd);
        this.iSysUsersService.updatePwd(user);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/resetAllPwd"})
    @ResponseBody
    @RequiresPermissions(value={"user:resetAllPwd"})
    @BussinessLog(key="/user/resetAllPwd", type="11", value="\u91cd\u7f6e\u5bc6\u7801")
    public Tip resetAllPwd() {
        String userId;
        SysUsers user;
        String data = super.getPara("data").trim();
        Object[] userIds = super.getPara("userIds").split(",");
        data = CryptoUtil.decode(data);
        String[] params = data.split("&");
        String adminPwd = "";
        String newPwd = "";
        String cPwd = "";
        for (String param : params) {
            String[] p = param.split("=");
            if ("admin_pwd".equals(p[0])) {
                adminPwd = p[1];
            }
            if ("new_pwd".equals(p[0])) {
                newPwd = p[1];
            }
            if (!"c_pwd".equals(p[0])) continue;
            cPwd = p[1];
        }
        String aPwd = this.credentialsMatcher.passwordEncode(adminPwd.getBytes());
        if (!aPwd.equals((user = this.iSysUsersService.getUser(userId = ShiroKit.getUser().getId())).getPassword())) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u91cd\u7f6e\u5931\u8d25\uff01\uff08\u60a8\u7684\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff09");
        }
        if (!newPwd.equals(cPwd)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u91cd\u7f6e\u5931\u8d25\uff01\uff08\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01\uff09");
        }
        String regular = this.globalProperties.getPwdComplexityRegular().replaceAll("/", "");
        String hint = this.globalProperties.getUnmatchedHint();
        if (!newPwd.matches(regular)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), hint);
        }
        List sysUsers = this.iSysUsersService.list((Wrapper)new QueryWrapper().in((Object)"user_id", userIds));
        for (SysUsers users : sysUsers) {
            if (!newPwd.toLowerCase().contains(users.getUserAccount().toLowerCase())) continue;
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01\uff08" + users.getUserName() + "\u5bc6\u7801\u5305\u542b\u7528\u6237\u540d\uff09");
        }
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("newPwd", nPwd);
        map.put("userIds", userIds);
        long count = this.iSysUsersService.resetAllPwd(map);
        return new ErrorTip(HttpCode.OK.value().intValue(), "\u91cd\u7f6e\u6210\u529f\uff0c" + count + "\u4e2a\u7528\u6237\u7684\u5bc6\u7801\u5df2\u88ab\u91cd\u7f6e\uff01");
    }

    @RequestMapping(value={"/setGetBackPwd"})
    @ResponseBody
    public Tip setGetBackPwd() {
        String ques = super.getPara("ques").trim();
        String key = super.getPara("key").trim();
        String userId = ShiroKit.getUser().getId();
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("userId", userId);
        map.put("ques", ques);
        map.put("key", key);
        if (this.iSysUsersService.setGetBackPwd(map)) {
            return SUCCESS_TIP;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u8bbe\u7f6e\u5931\u8d25\uff01");
    }

    @BussinessLog(key="/user/copyRole", type="03", value="\u590d\u5236\u89d2\u8272")
    @RequiresPermissions(value={"user:copyRole"})
    @RequestMapping(value={"/copyRole"})
    @ResponseBody
    public Tip copyRole() {
        String[] copyTos;
        String copyFrom = super.getPara("copyFrom").trim();
        for (String copyTo : copyTos = super.getPara("copyTo").trim().split(",")) {
            boolean result = this.iSysUsersService.copyRole(copyFrom, copyTo);
            if (result) continue;
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u89d2\u8272\u590d\u5236\u5931\u8d25\uff01\uff08\u590d\u5236\u7684\u89d2\u8272\u4e0e\u539f\u89d2\u8272\u4e2d\u6709\u4e0d\u76f8\u5bb9\u89d2\u8272\uff01\uff09");
        }
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/userList"})
    @ResponseBody
    @BussinessLog(key="/user/userList", type="04", value="\u91cd\u7f6e\u5bc6\u7801\u7528\u6237\u5217\u8868")
    @RequiresPermissions(value={"user:userList"})
    public Object userTableList() {
        String pageNum = super.getPara("page").trim();
        String limitNum = super.getPara("limit").trim();
        String userAccount = super.getPara("userAccount").trim();
        String userName = super.getPara("userName").trim();
        if (ToolUtil.isNotEmpty((Object)userAccount)) {
            userAccount = userAccount.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        if (ToolUtil.isNotEmpty((Object)userName)) {
            userName = userName.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        Page<SysUsers> page = new Page<SysUsers>((long)Integer.valueOf(pageNum).intValue(), (long)Integer.valueOf(limitNum).intValue());
        page = this.iSysUsersService.getUserList(page, userAccount, userName);
        JSONObject json = new JSONObject();
        json.put("data", (Object)page.getRecords());
        json.put("code", (Object)"0");
        json.put("msg", (Object)"");
        json.put("count", (Object)page.getTotal());
        return json;
    }

    @RequestMapping(value={"/saveSelfInfo"})
    @ResponseBody
    public Tip saveSelfInfo() {
        String shiroUserId = ShiroKit.getUser().getId();
        String userId = super.getPara("userId").trim();
        userId = CryptoUtil.decode(userId);
        if (shiroUserId != null && shiroUserId.equals(userId)) {
            String eMail = super.getPara("eMail").trim();
            eMail = CryptoUtil.decode(eMail);
            String weChat = super.getPara("weChat").trim();
            weChat = CryptoUtil.decode(weChat);
            String mobile = super.getPara("mobile").trim();
            mobile = CryptoUtil.decode(mobile);
            String telephone = super.getPara("telephone").trim();
            telephone = CryptoUtil.decode(telephone);
            SysUsers user = (SysUsers)((Object)this.iSysUsersService.getById((Serializable)((Object)userId)));
            user.setEMail(eMail);
            user.setWeChat(weChat);
            user.setMobile(mobile);
            user.setTelephone(telephone);
            user.updateById();
            this.bpmAbstractPushMsgMatcher.pushUser(user, "update", null);
            return SUCCESS_TIP;
        }
        return new ErrorTip(500, "\u975e\u6cd5\u8bf7\u6c42\uff01");
    }

    @RequiresPermissions(value={"user:updateUserStatus"})
    @RequestMapping(value={"/updateUserStatus"})
    @ResponseBody
    public void updateUserStatus() {
        this.iSysUsersService.updateUserStatus();
    }

    @RequestMapping(value={"/reChecking"})
    @ResponseBody
    public boolean reChecking(String reUrl, String userName, String cipher) {
        return this.iSysUsersService.reChecking(reUrl, userName, cipher);
    }

    @RequestMapping(value={"/exportData"})
    @RequiresPermissions(value={"user:exportData"})
    @BussinessLog(key="/user/exportData", type="04", value="\u7528\u6237\u6570\u636e\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.iSysUsersService.exportData(idList, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @ResponseBody
    @RequiresPermissions(value={"user:importData"})
    @BussinessLog(key="/user/importData", type="03", value="\u7528\u6237\u6570\u636e\u5bfc\u5165")
    public Tip importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return this.iSysUsersService.importData(content);
    }
}

