/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysFunctions;
import com.jxdinfo.hussar.bsp.permit.model.SysModules;
import com.jxdinfo.hussar.bsp.permit.model.SysResources;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleResource;
import com.jxdinfo.hussar.bsp.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.bsp.permit.service.ISysModulesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResManageService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruResourcesService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/resource"})
public class SysResManageController
extends BaseController {
    @Resource
    ISysResManageService sysResManageService;
    @Resource
    ISysResourcesService iSysResourcesService;
    @Resource
    ISysStruResourcesService iSysStruResourcesService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    SysResourcesMapper sysResourcesMapper;
    @Resource
    ISysRoleResourceService sysRoleResourceService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private ISysModulesService iSysModulesService;
    @Resource
    private ISysFunctionsService iSysFunctionsService;
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private ISysStruResourcesService sysStruResourcesService;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;

    @RequestMapping(value={"/resList"})
    @RequiresPermissions(value={"resource:resList"})
    @BussinessLog(key="/resource/resList", type="04", value="\u8d44\u6e90\u7ef4\u62a4\u9875\u9762")
    public String resList() {
        return "/bsp/permit/resourceManage/resourceManage.html";
    }

    @RequestMapping(value={"/resTree"})
    @ResponseBody
    public List<JSTreeModel> resTree(HttpServletRequest request) {
        String type = request.getParameter("type");
        String nodeId = super.getPara("nodeId");
        String leaf = super.getPara("isLeaf");
        String nodeType = super.getPara("nodeType");
        List<JSTreeModel> result = this.sysResManageService.getFunResource(type, nodeId, leaf, nodeType);
        return result;
    }

    @RequestMapping(value={"/moduleTreeById"})
    @ResponseBody
    public List<JSTreeModel> moduleTreeById(HttpServletRequest request) {
        String moduleId = request.getParameter("moduleId");
        String isHead = request.getParameter("isRoot");
        Boolean isRoot = Boolean.valueOf(isHead);
        List<JSTreeModel> result = this.sysResManageService.moduleTreeById(moduleId);
        if (isRoot.booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId("1");
            root.setCode("1");
            root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
            root.setParent("#");
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return result;
    }

    @RequiresPermissions(value={"resource:moduleAdd"})
    @RequestMapping(value={"moduleAdd"})
    public String moduleAdd(Model model) {
        String currentCode;
        String moduleId = super.getPara("moduleId");
        SysModules sysModules = this.sysResManageService.getModuleInfoById(moduleId);
        String moduleName = "";
        if (ToolUtil.isNotEmpty((Object)((Object)sysModules))) {
            moduleName = sysModules.getModuleName();
        }
        if (ToolUtil.isEmpty((Object)(currentCode = this.sysIdtableService.getCurrentCode("module_code", "sys_modules")))) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        model.addAttribute("currentCode", (Object)currentCode);
        model.addAttribute("moduleId", (Object)moduleId);
        model.addAttribute("moduleName", (Object)moduleName);
        return "/bsp/permit/resourceManage/modulesAdd.html";
    }

    @RequiresPermissions(value={"resource:moduleEdit"})
    @RequestMapping(value={"moduleEdit"})
    public String moduleEdit(Model model) {
        String moduleId = super.getPara("moduleId");
        SysModules result = this.sysResManageService.getModuleInfoById(moduleId);
        model.addAttribute("sysModules", (Object)result);
        return "/bsp/permit/resourceManage/modulesEdit.html";
    }

    @RequestMapping(value={"moduleView"})
    @BussinessLog(key="/resource/moduleView", type="04", value="\u67e5\u770b\u6a21\u5757\u4fe1\u606f")
    public String moduleView(Model model) {
        String moduleId = super.getPara("moduleId");
        SysModules result = this.sysResManageService.getModuleInfoById(moduleId);
        model.addAttribute("sysModules", (Object)result);
        return "/bsp/permit/resourceManage/modulesView.html";
    }

    @RequiresPermissions(value={"resource:moduleSave"})
    @RequestMapping(value={"moduleSave"})
    @BussinessLog(key="/resource/moduleSave", type="01", value="\u65b0\u589e\u6a21\u5757")
    @ResponseBody
    public Integer moduleSave(SysModules sysModules) {
        return this.sysResManageService.moduleSave(sysModules);
    }

    @RequiresPermissions(value={"resource:moduleEditSave"})
    @RequestMapping(value={"moduleEditSave"})
    @BussinessLog(key="/resource/moduleEdit", type="03", value="\u4fee\u6539\u6a21\u5757", pk="moduleId")
    @ResponseBody
    public Tip moduleEditSave(SysModules sysModules) {
        boolean isAllowEditModule = this.sysResManageService.isAllowEditModule(sysModules);
        SysModules sysModules1 = (SysModules)((Object)this.iSysModulesService.getById((Serializable)((Object)sysModules.getModuleId())));
        LogObjectHolder.me().set((Object)sysModules1);
        if (isAllowEditModule) {
            Integer count = this.sysResManageService.moduleSave(sysModules);
            if (count != 0) {
                SuccessTip tip = new SuccessTip();
                tip.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
                return tip;
            }
            return new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01\uff08\u5b58\u5728\u4e0b\u7ea7\u6a21\u5757\u6216\u4e0b\u7ea7\u529f\u80fd\u65f6\u4e0d\u80fd\u4fee\u6539\u6a21\u5757\u7c7b\u578b\uff01\uff09");
    }

    @RequiresPermissions(value={"resource:delModule"})
    @RequestMapping(value={"delModule"})
    @BussinessLog(key="/resource/delModule", type="02", value="\u5220\u9664\u6a21\u5757", pk="moduleId")
    @ResponseBody
    public JSONObject delModule() {
        String moduleId = super.getPara("moduleId");
        return this.sysResManageService.delModule(moduleId);
    }

    @RequiresPermissions(value={"resource:functionAdd"})
    @RequestMapping(value={"functionAdd"})
    public String functionAdd(Model model) {
        String moduleId = super.getPara("moduleId");
        SysModules sysModules = this.sysResManageService.getModuleInfoById(moduleId);
        String moduleCode = sysModules.getModuleCode();
        String moduleName = sysModules.getModuleName();
        String currentCode = this.sysIdtableService.getCurrentCode("function_code", "sys_functions");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        model.addAttribute("currentCode", (Object)(moduleCode + currentCode));
        model.addAttribute("moduleId", (Object)moduleId);
        model.addAttribute("moduleName", (Object)moduleName);
        return "/bsp/permit/resourceManage/functionAdd.html";
    }

    @RequiresPermissions(value={"resource:functionEdit"})
    @RequestMapping(value={"functionEdit"})
    public String functionEdit(Model model) {
        String functionId = super.getPara("functionId");
        SysFunctions result = this.sysResManageService.getFunctionInfoById(functionId);
        model.addAttribute("sysFunctions", (Object)result);
        return "/bsp/permit/resourceManage/functionEdit.html";
    }

    @RequestMapping(value={"functionView"})
    @RequiresPermissions(value={"resource:functionView"})
    @BussinessLog(key="/resource/functionView", type="04", value="\u67e5\u770b\u529f\u80fd\u4fe1\u606f")
    public String functionView(Model model) {
        String functionId = super.getPara("functionId");
        SysFunctions result = this.sysResManageService.getFunctionInfoById(functionId);
        model.addAttribute("sysFunctions", (Object)result);
        return "/bsp/permit/resourceManage/functionView.html";
    }

    @RequiresPermissions(value={"resource:functionSave"})
    @RequestMapping(value={"functionSave"})
    @ResponseBody
    @BussinessLog(key="/resource/functionAdd", type="01", value="\u65b0\u589e\u529f\u80fd", pk="functionId")
    public Integer functionSave(SysFunctions sysFunctions) {
        sysFunctions.setFunctionId(null);
        return this.sysResManageService.functionSave(sysFunctions);
    }

    @RequiresPermissions(value={"resource:functionEditSave"})
    @RequestMapping(value={"functionEditSave"})
    @ResponseBody
    @BussinessLog(key="/resource/functionEdit", type="03", value="\u4fee\u6539\u529f\u80fd", pk="functionId")
    public Integer functionEditSave(SysFunctions sysFunctions) {
        SysFunctions sysFunctions1 = (SysFunctions)((Object)this.iSysFunctionsService.getById((Serializable)((Object)sysFunctions.getFunctionId())));
        LogObjectHolder.me().set((Object)sysFunctions1);
        return this.sysResManageService.functionSave(sysFunctions);
    }

    @RequiresPermissions(value={"resource:delFunction"})
    @BussinessLog(key="/resource/delFunction", type="02", value="\u5220\u9664\u529f\u80fd", pk="functionId")
    @RequestMapping(value={"delFunction"})
    @ResponseBody
    public JSONObject delFunction() {
        String functionId = super.getPara("functionId");
        return this.sysResManageService.delFunction(functionId);
    }

    @RequiresPermissions(value={"resource:resourceAdd"})
    @RequestMapping(value={"resourceAdd"})
    public String resourceAdd(Model model) {
        String functionId = super.getPara("functionId");
        SysFunctions sysFunctions = this.sysResManageService.getFunctionInfoById(functionId);
        String functionCode = sysFunctions.getFunctionCode();
        String functionName = sysFunctions.getFunctionName();
        String currentCode = this.sysIdtableService.getCurrentCode("resource_code", "sys_resources");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        List<DicSingle> resTypes = this.sysDicRefService.getDictByType("res_type");
        model.addAttribute("currentCode", (Object)(functionCode + currentCode));
        model.addAttribute("resTypes", resTypes);
        model.addAttribute("functionId", (Object)functionId);
        model.addAttribute("functionName", (Object)functionName);
        return "/bsp/permit/resourceManage/resourceAdd.html";
    }

    @RequiresPermissions(value={"resource:resourceEdit"})
    @RequestMapping(value={"resourceEdit"})
    public String resourceEdit(Model model) {
        String resourceId = super.getPara("resourceId");
        SysResources result = this.sysResManageService.getResourceInfoById(resourceId);
        List<DicSingle> resTypes = this.sysDicRefService.getDictByType("res_type");
        model.addAttribute("resTypes", resTypes);
        model.addAttribute("sysResources", (Object)result);
        return "/bsp/permit/resourceManage/resourceEdit.html";
    }

    @RequiresPermissions(value={"resource:resourceSave"})
    @RequestMapping(value={"resourceSave"})
    @ResponseBody
    @BussinessLog(key="/resource/resourceAdd", type="01", value="\u65b0\u589e\u8d44\u6e90", pk="resourceId")
    public String resourceSave(SysResources sysResources) {
        sysResources.setResourceId(null);
        String resourceId = this.sysResManageService.resourceSave(sysResources);
        return resourceId;
    }

    @RequiresPermissions(value={"resource:resourceEditSave"})
    @RequestMapping(value={"resourceEditSave"})
    @ResponseBody
    @CacheEvict(value={"authorization_info", "menu_info"}, allEntries=true)
    @BussinessLog(key="/resource/resourceEdit", type="03", value="\u4fee\u6539\u8d44\u6e90", pk="resourceId")
    public void resourceEditSave(SysResources sysResources) {
        if ("res_menu".equals(sysResources.getResTypeId())) {
            sysResources.setIsRepeatAuthenticate("0");
        }
        SysResources result = this.sysResManageService.getResourceInfoById(sysResources.getResourceId());
        LogObjectHolder.me().set((Object)result);
        this.sysResManageService.resourceSave(sysResources);
    }

    @RequestMapping(value={"resourceView"})
    @BussinessLog(key="/resource/resourceView", type="04", value="\u67e5\u770b\u8d44\u6e90\u4fe1\u606f")
    public String resourceView(Model model) {
        String resourceId = super.getPara("resourceId");
        SysResources result = this.sysResManageService.getResourceInfoById(resourceId);
        List<DicSingle> resTypes = this.sysDicRefService.getDictByType("res_type");
        model.addAttribute("resTypes", resTypes);
        model.addAttribute("sysResources", (Object)result);
        return "/bsp/permit/resourceManage/resourceView.html";
    }

    @RequiresPermissions(value={"resource:delResource"})
    @BussinessLog(key="/resource/delResource", type="02", value="\u5220\u9664\u8d44\u6e90", pk="resourceId")
    @RequestMapping(value={"delResource"})
    @ResponseBody
    public JSONObject delResource() {
        String resourceId = super.getPara("resourceId");
        return this.sysResManageService.delResource(resourceId);
    }

    @RequestMapping(value={"moduleTreeOrder"})
    @ResponseBody
    @RequiresPermissions(value={"resource:moduleTreeOrder"})
    @BussinessLog(key="/resource/moduleTreeOrder", type="03", value="\u8d44\u6e90\u6a21\u5757\u4e0b\u7ea7\u6392\u5e8f")
    public void moduleTreeOrder() {
        String treeInfo = super.getPara("treeInfo");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        this.sysResManageService.saveModuleTreeOrder(treeArr);
    }

    @RequestMapping(value={"/functionTreeById"})
    @ResponseBody
    public List<JSTreeModel> functionTreeById() {
        String moduleId = super.getPara("moduleId");
        String moduleName = super.getPara("moduleName");
        List<JSTreeModel> result = this.sysResManageService.functionTreeByModuleId(moduleId);
        JSTreeModel root = new JSTreeModel();
        root.setId(moduleId);
        root.setText(moduleName);
        root.setParent("#");
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isModule");
        result.add(root);
        return result;
    }

    @RequestMapping(value={"functionTreeOrder"})
    @ResponseBody
    @RequiresPermissions(value={"resource:functionTreeOrder"})
    @BussinessLog(key="/resource/functionTreeOrder", type="03", value="\u8d44\u6e90\u529f\u80fd\u4e0b\u7ea7\u6392\u5e8f")
    public void functionTreeOrder() {
        String treeInfo = super.getPara("treeInfo");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        this.sysResManageService.saveFunctionTreeOrder(treeArr);
    }

    @RequestMapping(value={"resourceTreeById"})
    @ResponseBody
    public List<JSTreeModel> resourceTreeById() {
        String functionId = super.getPara("functionId");
        String functionName = super.getPara("functionName");
        List<JSTreeModel> result = this.sysResManageService.resourceTreeByModuleId(functionId);
        JSTreeModel root = new JSTreeModel();
        root.setId(functionId);
        root.setText(functionName);
        root.setParent("#");
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isFun");
        result.add(root);
        return result;
    }

    @RequestMapping(value={"resourceTreeOrder"})
    @ResponseBody
    @RequiresPermissions(value={"resource:resourceTreeOrder"})
    @BussinessLog(key="/resource/resourceTreeOrder", type="03", value="\u8d44\u6e90\u4e0b\u7ea7\u6392\u5e8f")
    public boolean resourceTreeOrder() {
        String treeInfo = super.getPara("treeInfo");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        return this.sysResManageService.saveResourceTreeOrder(treeArr);
    }

    @RequestMapping(value={"moduleChangeById"})
    @ResponseBody
    public List<JSTreeModel> moduleChangeById() {
        String moduleId = super.getPara("moduleId");
        String isLeaf = super.getPara("isLeaf");
        List<JSTreeModel> result = this.sysResManageService.moduleChangeById(moduleId, isLeaf);
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return result;
    }

    @RequestMapping(value={"moduleTreeChange"})
    @ResponseBody
    @RequiresPermissions(value={"resource:moduleTreeChange"})
    @BussinessLog(key="/resource/moduleTreeChange", type="03", value="\u6a21\u5757\u8f6c\u79fb")
    public void moduleTreeChange() {
        String moduleId = super.getPara("moduleId");
        String parentId = super.getPara("parentId");
        this.sysResManageService.moduleTreeChange(moduleId, parentId);
    }

    @RequestMapping(value={"functionTreeChange"})
    @ResponseBody
    @RequiresPermissions(value={"resource:functionTreeChange"})
    @BussinessLog(key="/resource/functionTreeChange", type="03", value="\u529f\u80fd\u8f6c\u79fb")
    public void functionTreeChange() {
        String functionId = super.getPara("functionId");
        String parentId = super.getPara("parentId");
        this.sysResManageService.functionTreeChange(functionId, parentId);
    }

    @RequestMapping(value={"resourceChangeById"})
    @ResponseBody
    public List<JSTreeModel> resourceChangeById() {
        String resourceId = super.getPara("resourceId");
        List<JSTreeModel> result = this.sysResManageService.resourceChangeById(resourceId);
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return result;
    }

    @RequestMapping(value={"resourceTreeChange"})
    @ResponseBody
    @RequiresPermissions(value={"resource:resourceTreeChange"})
    @BussinessLog(key="/resource/resourceTreeChange", type="03", value="\u8d44\u6e90\u8f6c\u79fb")
    public void resourceTreeChange() {
        String resourceId = super.getPara("resourceId");
        String parentId = super.getPara("parentId");
        this.sysResManageService.resourceTreeChange(resourceId, parentId);
    }

    @RequestMapping(value={"/selfResourceTree"})
    @ResponseBody
    public List<JSTreeModel> selfResourceTree() {
        String[] rsourceIds = super.getPara("rsourceIds").trim().split(",");
        List<JSTreeModel> result = this.sysResManageService.selfResourceTree(rsourceIds);
        List<JSTreeModel> tree = this.doRecursive(result);
        block0: for (JSTreeModel js : tree) {
            for (String id : rsourceIds) {
                if (ToolUtil.equals((Object)js.getId(), (Object)id)) {
                    js.setState(true, true, true);
                    continue block0;
                }
                js.setState(false, false, true);
            }
        }
        return tree;
    }

    public List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursive(list, result, "");
        if (result.size() == 0) {
            for (JSTreeModel map : list) {
                if (!"#".equals(map.getParent())) continue;
                result.add(map);
            }
        }
        JSTreeModel model = new JSTreeModel();
        model.setParent("#");
        model.setCode("GROUP");
        model.setText("\u89d2\u8272\u8d44\u6e90\u6811");
        model.setId("1");
        model.setType("isRoot");
        model.setState(true, true, true);
        result.add(model);
        return result;
    }

    public void recursive(List<JSTreeModel> list, List<JSTreeModel> result, String parentId) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i > list.size() - 1) {
                i = list.size() - 1;
            }
            if (i < 0) break;
            JSTreeModel map = list.get(i);
            if (!"1".equals(map.getIsRes()) && !parentId.equals(map.getId())) continue;
            parentId = map.getParent();
            result.add(map);
            list.remove(i);
            this.recursive(list, result, parentId);
        }
    }

    @RequestMapping(value={"/sameUrl"})
    @ResponseBody
    public List<SysResources> sameUrl() {
        String url = super.getPara("url");
        SysResources sysResources = new SysResources();
        sysResources.setFunction(null);
        List<SysResources> list = this.sysResourcesMapper.sameUrl(url);
        return list;
    }

    @RequestMapping(value={"/editResTree"})
    @ResponseBody
    public List<JSTreeModel> editResTree() {
        Iterator gradeParentId;
        String[] rsourceIds = super.getPara("rsourceIds").trim().split(",");
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        List<JSTreeModel> list1 = this.sysResManageService.getResTree();
        ShiroUser shiroUser = ShiroKit.getUser();
        String struId = "";
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String empolyeeId;
            struId = empolyeeId = shiroUser.getEmployeeId();
        }
        List<Object> resourceIdList = new ArrayList();
        ArrayList<String> functionIdList = new ArrayList<String>();
        ArrayList<SysModules> moduleIdList = new ArrayList<SysModules>();
        ArrayList<String> moduleIdList1 = new ArrayList<String>();
        ArrayList<Object> list = new ArrayList<Object>();
        if (isGradeAdmin && (resourceIdList = this.sysStruResourcesService.getResIdList((String)((Object)(gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId())))).size() > 0) {
            functionIdList.addAll(this.sysStruResourcesService.getFunId(resourceIdList));
            List<SysModules> leafModules = this.sysStruResourcesService.getGradeAdminModuleId(functionIdList);
            moduleIdList.addAll(leafModules);
            ArrayList<String> tmpModuleIds = new ArrayList<String>();
            tmpModuleIds.clear();
            for (SysModules sysModules : leafModules) {
                String parentId = sysModules.getParentModuleId();
                if ("1".equals(parentId)) continue;
                tmpModuleIds.add(parentId);
            }
            List<SysModules> parentModules = this.iSysModulesService.getParentModuleTree(tmpModuleIds);
            moduleIdList.addAll(parentModules);
            for (SysModules sysModules : moduleIdList) {
                String moduleId = sysModules.getModuleId();
                if (moduleIdList1.contains(moduleId)) continue;
                moduleIdList1.add(moduleId);
            }
            list.addAll(resourceIdList);
            list.addAll(functionIdList);
            list.addAll(moduleIdList1);
        }
        if (isGradeAdmin) {
            for (JSTreeModel model : list1) {
                String id = model.getId();
                if (!list.contains(id)) continue;
                model.getState().put("gradeDisabled", true);
                result.add(model);
            }
        } else {
            result.addAll(list1);
        }
        block3: for (JSTreeModel js : result) {
            js.setState(false, false, false);
            if (ToolUtil.equals((Object)js.getConstant(), (Object)"1")) {
                js.setState(false, false, true);
                for (String id : rsourceIds) {
                    if (!ToolUtil.equals((Object)js.getId(), (Object)id)) continue;
                    js.setState(true, true, true);
                    continue block3;
                }
                continue;
            }
            for (String id : rsourceIds) {
                if (!ToolUtil.equals((Object)js.getId(), (Object)id)) continue;
                js.setState(true, true, false);
                continue block3;
            }
        }
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        result.add(root);
        return result;
    }

    @RequestMapping(value={"/roleTreeView"})
    @ResponseBody
    public List<JSTreeModel> getRoleTreeView() {
        String resourceId = super.getPara("resourceId");
        List roleResourceList = this.sysRoleResourceService.list((Wrapper)new QueryWrapper().eq((Object)"RESOURCE_ID", (Object)resourceId));
        if (ToolUtil.isEmpty((Object)roleResourceList)) {
            ArrayList<JSTreeModel> emptyList = new ArrayList<JSTreeModel>();
            JSTreeModel model = new JSTreeModel();
            model.setId("1");
            model.setCode("GROUP");
            model.setParent("#");
            model.setText("\u5173\u8054\u89d2\u8272");
            model.setType("isRoot");
            model.setState(false, false, true);
            emptyList.add(model);
            return emptyList;
        }
        ArrayList<String> roleIds = new ArrayList<String>();
        for (SysRoleResource roleResource : roleResourceList) {
            roleIds.add(roleResource.getRoleId());
        }
        List<JSTreeModel> result = this.orgMaintenanceService.selfRoleTree(roleIds.toArray(new String[roleIds.size()]));
        List<JSTreeModel> tree = this.getRoleTree(result);
        block1: for (JSTreeModel js : tree) {
            for (String id : roleIds) {
                if (ToolUtil.equals((Object)js.getId(), (Object)id)) {
                    js.setState(true, true, true);
                    continue block1;
                }
                js.setState(false, false, true);
            }
        }
        return tree;
    }

    public List<JSTreeModel> getRoleTree(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursiveRoleTree(list, result, "");
        JSTreeModel model = new JSTreeModel();
        model.setId("1");
        model.setCode("GROUP");
        model.setParent("#");
        model.setText("\u5173\u8054\u89d2\u8272");
        model.setType("isRoot");
        result.add(model);
        return result;
    }

    public void recursiveRoleTree(List<JSTreeModel> list, List<JSTreeModel> result, String parentId) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i > list.size() - 1) {
                i = list.size() - 1;
            }
            if (i < 0) break;
            JSTreeModel map = list.get(i);
            if (!"ROLE".equals(map.getCode()) && !parentId.equals(map.getId())) continue;
            parentId = map.getParent();
            result.add(map);
            list.remove(i);
            this.recursiveRoleTree(list, result, parentId);
        }
    }

    @RequestMapping(value={"/resourceAddSaveRole"})
    @ResponseBody
    public Tip resourceAddSaveRole() {
        String resourceId = super.getPara("resourceId");
        String[] roleIds = super.getPara("roleIds").split(",");
        Date currentDate = new Date();
        String currentUser = ShiroKit.getUser().getAccount();
        ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
        for (String roleId : roleIds) {
            if (ToolUtil.isEmpty((Object)roleId)) continue;
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setRoleId(roleId);
            sysRoleResource.setResourceId(resourceId);
            sysRoleResource.setCreateTime(currentDate);
            sysRoleResource.setCreator(currentUser);
            sysRoleResource.setLastEditor(currentUser);
            sysRoleResource.setLastTime(currentDate);
            sysRoleResourceList.add(sysRoleResource);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
            this.sysRoleResourceService.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
        }
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/resourceEditSaveRole"})
    @ResponseBody
    public Tip resourceEditSaveRole() {
        String resourceId = super.getPara("resourceId");
        String[] roleIds = super.getPara("roleIds").split(",");
        this.sysRoleResourceService.resourceEditSaveRole(resourceId, roleIds);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/roleTreeEdit"})
    @ResponseBody
    public List<JSTreeModel> getRoleTreeEdit() {
        String resourceId = super.getPara("resourceId");
        List roleResourceList = this.sysRoleResourceService.list((Wrapper)new QueryWrapper().eq((Object)"resource_id", (Object)resourceId));
        List<JSTreeModel> result = this.sysRolesService.getRoleTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent("#");
        jsTreeModel.setCode("GROUP");
        jsTreeModel.setText("\u5173\u8054\u89d2\u8272");
        jsTreeModel.setId("1");
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        block0: for (JSTreeModel tree : result) {
            tree.setState(false, false, false);
            for (SysRoleResource roleResource : roleResourceList) {
                if (!tree.getId().equals(roleResource.getRoleId())) continue;
                tree.setState(true, true, false);
                continue block0;
            }
        }
        return result;
    }

    @RequestMapping(value={"/exportRes"})
    @RequiresPermissions(value={"resource:exportRes"})
    @BussinessLog(key="/resource/exportRes", type="03", value="\u8d44\u6e90\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.sysResManageService.exportRes(idList, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @ResponseBody
    @RequiresPermissions(value={"resource:importData"})
    @BussinessLog(key="/resource/importData", type="03", value="\u8d44\u6e90\u5bfc\u5165")
    public Tip importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return this.sysResManageService.importRes(content);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/checkResource"})
    @ResponseBody
    public JSONObject checkResource(String resourceUrl) {
        JSONObject json = new JSONObject();
        json.put("flag", (Object)this.iSysResourcesService.checkResource(resourceUrl));
        this.abstractOTPCredentialsMatcher.getClass();
        json.put("csrfToken", (Object)this.abstractOTPCredentialsMatcher.generate("FCUD3YLMJYG2F72L2NFDXYPL6UJBUUN24BGBK6JDEIKHUA4ZOD2A"));
        return json;
    }

    @RequestMapping(value={"/checkHasResources"})
    @ResponseBody
    public Tip checkHasResources(String resourceId, String type) {
        List<String> list = this.iSysStruResourcesService.getResourceIdList(resourceId, type);
        if (list.size() > 0) {
            return SUCCESS_TIP;
        }
        Tip tip = new Tip();
        tip.setCode(0);
        tip.setMessage("\u4e0d\u5b58\u5728\u53ef\u4e0b\u653e\u7684\u8d44\u6e90");
        return tip;
    }

    @BussinessLog(key="/resource/delegateResource", type="03", value="\u8d44\u6e90\u4e0b\u653e")
    @RequiresPermissions(value={"resource:delegateResource"})
    @RequestMapping(value={"/delegateResource"})
    @ResponseBody
    public Tip delegateResource() {
        String resourceIdHidden = super.getPara("resourceIdHidden").trim();
        String struIdHidden = super.getPara("struIdHidden").trim();
        String type = super.getPara("typeHidden").trim();
        if (ToolUtil.isEmpty((Object)resourceIdHidden)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("resourceIdHidden", resourceIdHidden);
        map.put("struIdHidden", struIdHidden);
        map.put("type", type);
        return this.iSysStruResourcesService.delegateResource(map);
    }

    @BussinessLog(key="/resource/retrieveResource", type="03", value="\u8d44\u6e90\u56de\u6536")
    @RequiresPermissions(value={"resource:retrieveResource"})
    @RequestMapping(value={"/retrieveResource"})
    @ResponseBody
    public Tip retrieveResource() {
        String resourceIdHidden = super.getPara("resourceIdHidden").trim();
        String struIdHidden = super.getPara("struIdHidden").trim();
        String type = super.getPara("typeHidden").trim();
        String original = super.getPara("original").trim();
        if (ToolUtil.isEmpty((Object)resourceIdHidden)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        List originalIdList = JSONObject.parseArray((String)original, String.class);
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("resourceIdHidden", resourceIdHidden);
        map.put("struIdHidden", struIdHidden);
        map.put("originalIdList", originalIdList);
        map.put("type", type);
        return this.iSysStruResourcesService.retrieveResource(map);
    }
}

