/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.permit.model.SysOnline;
import com.jxdinfo.hussar.bsp.permit.service.ISysOnlineService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/online"})
public class SysOnlineController
extends BaseController {
    private static String PREFIX = "/bsp/permit/audit/";
    @Resource
    private ISysOnlineService iSysOnlineService;

    @BussinessLog(key="/online/view", type="04", value="\u5728\u7ebf\u7528\u6237\u9875\u9762")
    @RequiresPermissions(value={"online:view"})
    @RequestMapping(value={"/view"})
    public String view() {
        return PREFIX + "onlineUser.html";
    }

    @RequiresPermissions(value={"online:list"})
    @RequestMapping(value={"/list"})
    @ResponseBody
    public Object list() {
        String currpage = super.getPara("page");
        String limit = super.getPara("limit");
        String userAccount = super.getPara("userAccount");
        String userName = super.getPara("userName");
        Page<SysOnline> page = new Page<SysOnline>((long)Integer.valueOf(currpage).intValue(), (long)Integer.valueOf(limit).intValue());
        page = this.iSysOnlineService.getOnlineList(page, userAccount, userName);
        JSONObject json = new JSONObject();
        json.put("data", (Object)page.getRecords());
        json.put("code", (Object)"0");
        json.put("msg", (Object)"");
        json.put("count", (Object)page.getTotal());
        return json;
    }

    @BussinessLog(key="/online/stopSession", type="02", value="\u7ec8\u6b62\u4f1a\u8bdd")
    @RequiresPermissions(value={"online:stopSession"})
    @RequestMapping(value={"/stopSession"})
    @ResponseBody
    public Tip stopSession() {
        String[] sessionIds;
        String ids = super.getPara("ids").trim();
        for (String id : sessionIds = ids.split(",")) {
            if (!id.equals(ShiroKit.getSession().getId())) continue;
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u7ec8\u6b62\u5931\u8d25\uff01\uff08\u6240\u9009\u4f1a\u8bdd\u4e2d\u5305\u542b\u5f53\u524d\u4f1a\u8bdd\uff01\uff09");
        }
        this.iSysOnlineService.delRecord(ids);
        SuccessTip tip = new SuccessTip();
        tip.setMessage("\u7ec8\u6b62\u6210\u529f\uff01");
        return tip;
    }
}

