/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.druid.util.StringUtils;
import com.jxdinfo.hussar.bsp.permit.model.SysSecurityLog;
import com.jxdinfo.hussar.bsp.permit.service.ISysResTypeService;
import com.jxdinfo.hussar.bsp.permit.service.ISysSecurityLogService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.export.ExportExcel;
import com.jxdinfo.hussar.common.export.bean.ExcelEntity;
import com.jxdinfo.hussar.common.export.bean.ExcelTitle;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/securityLog"})
@Controller
public class SecurityLogController
extends BaseController {
    @Resource
    private ISysSecurityLogService iSysSecurityLogService;
    @Resource
    private ISysResTypeService iSysResTypeService;

    @RequestMapping(value={"/view"})
    @RequiresPermissions(value={"securityLog:view"})
    @BussinessLog(key="/securityLog/view", type="04", value="\u5b89\u5168\u65e5\u5fd7\u9875\u9762")
    public String view(Model model) {
        model.addAttribute("sessionId", (Object)"");
        return "/bsp/permit/audit/securityLog.html";
    }

    @RequestMapping(value={"view2/{sessionId}"})
    @RequiresPermissions(value={"securityLog:view2"})
    @BussinessLog(key="/securityLog/view2", type="04", value="\u4f1a\u8bdd\u8ffd\u8e2a\u9875\u9762")
    public String view2(@PathVariable String sessionId, Model model) {
        if (ToolUtil.isEmpty((Object)sessionId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        model.addAttribute("sessionId", (Object)sessionId);
        return "/bsp/permit/audit/sessionTrace.html";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    @RequiresPermissions(value={"securityLog:list"})
    @BussinessLog(key="/securityLog/list", type="04", value="\u4f1a\u8bdd\u8ffd\u8e2a\u5217\u8868")
    public Object list() throws IOException {
        String page = super.getPara("page");
        String limit = super.getPara("limit");
        String isQuery = super.getPara("isQuery");
        String startDate = super.getPara("dateStart");
        String endDate = super.getPara("dateEnd");
        String logType = super.getPara("logType");
        String userAccount = super.getPara("userAccount");
        String sessionId = super.getPara("sessionId");
        String levelEvent = super.getPara("levelEvent");
        if (!StringUtils.isEmpty((String)userAccount)) {
            userAccount = userAccount.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        Date start = ToolUtil.isEmpty((Object)startDate) ? null : DateUtil.parseTime((String)startDate);
        Date end = ToolUtil.isEmpty((Object)endDate) ? null : DateUtil.parseTime((String)endDate);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("startDate", start);
        map.put("endDate", end);
        map.put("logType", logType);
        map.put("userAccount", userAccount);
        map.put("levelEvent", levelEvent);
        map.put("isQuery", isQuery);
        map.put("sessionId", sessionId);
        Object result = this.iSysSecurityLogService.getSecurityLogList(page, limit, map);
        return result;
    }

    @RequestMapping(value={"/logTypeOption"})
    @ResponseBody
    public List logTypeOption() {
        List<Object> list = new ArrayList();
        list = this.iSysResTypeService.getLogTypeOption();
        return list;
    }

    @RequestMapping(value={"/cmdDetail"})
    @RequiresPermissions(value={"securityLog:cmdDetail"})
    @BussinessLog(key="/securityLog/cmdDetail", type="04", value="\u5ba1\u8ba1\u65e5\u5fd7\u660e\u7ec6")
    @ResponseBody
    public SysSecurityLog list(String logId) {
        if (ToolUtil.isNotEmpty((Object)logId)) {
            SysSecurityLog list = (SysSecurityLog)((Object)this.iSysSecurityLogService.getById((Serializable)((Object)logId)));
            return list;
        }
        return new SysSecurityLog();
    }

    @RequestMapping(value={"/selectNum"})
    @ResponseBody
    @BussinessLog(key="/securityLog/selectNum", type="04", value="\u67e5\u8be2\u5bfc\u51fa\u884c\u6570")
    public Integer selectNum() throws IOException {
        String startDate = super.getPara("dateStart");
        String endDate = super.getPara("dateEnd");
        String logType = super.getPara("logType");
        String userAccount = super.getPara("userAccount");
        String sessionId = super.getPara("sessionId");
        String levelEvent = super.getPara("levelEvent");
        if (!StringUtils.isEmpty((String)userAccount)) {
            userAccount = userAccount.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        Date start = ToolUtil.isEmpty((Object)startDate) ? null : DateUtil.parseTime((String)startDate);
        Date end = ToolUtil.isEmpty((Object)endDate) ? null : DateUtil.parseTime((String)endDate);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("startDate", start);
        map.put("endDate", end);
        map.put("logType", logType);
        map.put("userAccount", userAccount);
        map.put("levelEvent", levelEvent);
        map.put("sessionId", sessionId);
        Integer result = this.iSysSecurityLogService.getListRow(map);
        return result;
    }

    @RequestMapping(value={"/export"})
    @RequiresPermissions(value={"securityLog:export"})
    @BussinessLog(key="/securityLog/export", type="04", value="\u5bfc\u51fa\u65e5\u5fd7\u660e\u7ec6")
    @ResponseBody
    public void exportLog(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String startDate = super.getPara("dateStart");
        String endDate = super.getPara("dateEnd");
        String logType = super.getPara("logType");
        String userAccount = super.getPara("userAccount");
        String sessionId = super.getPara("sessionId");
        String levelEvent = super.getPara("levelEvent");
        String str = super.getPara("str");
        if (!StringUtils.isEmpty((String)userAccount)) {
            userAccount = userAccount.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        String[] strs = str.split(",");
        Date start = ToolUtil.isEmpty((Object)startDate) ? null : DateUtil.parseTime((String)startDate);
        Date end = ToolUtil.isEmpty((Object)endDate) ? null : DateUtil.parseTime((String)endDate);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("startDate", start);
        map.put("endDate", end);
        map.put("logType", logType);
        map.put("userAccount", userAccount);
        map.put("levelEvent", levelEvent);
        map.put("sessionId", sessionId);
        List<SysSecurityLog> list = this.iSysSecurityLogService.getSecurityLogList(map);
        ArrayList<ExcelTitle> excelTitles = new ArrayList<ExcelTitle>();
        String[] title = new String[]{"\u5e8f\u53f7", "\u7528\u6237\u8d26\u53f7", "\u7528\u6237\u540d\u79f0", "\u6240\u5c5e\u673a\u6784\u540d\u79f0", "\u65e5\u5fd7\u7c7b\u578b", "\u64cd\u4f5c\u4e1a\u52a1\u542b\u4e49", "\u7cfb\u7edf/\u4e1a\u52a1\u7ea7\u4e8b\u4ef6", "\u6267\u884c\u72b6\u6001", "\u5ba2\u6237\u7aef\u5730\u5740", "\u64cd\u4f5c\u65f6\u95f4", "\u65e5\u5fd7"};
        String[] idTitle = new String[]{"no", "userAccount", "userName", "corporationName", "logTypeName", "resourceAlias", "levelEventName", "state", "remoteaddr", "logTime", "logContent"};
        block2: for (int i = 0; i < title.length; ++i) {
            for (int j = 0; j < strs.length; ++j) {
                if (!idTitle[i].equals(strs[j]) && i != 0) continue;
                ExcelTitle excelTitle = new ExcelTitle();
                excelTitle.setTitle_id(idTitle[i]);
                excelTitle.setTitle_text(title[i]);
                excelTitles.add(excelTitle);
                continue block2;
            }
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Date date = new Date(System.currentTimeMillis());
        String fileName = "\u5ba1\u8ba1\u65e5\u5fd7\u8868" + formatter.format(date) + ".xls";
        String sheetName = "\u5ba1\u8ba1\u65e5\u5fd7\u8868";
        SimpleDateFormat logFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        ArrayList<Map<String, Object>> querys = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Object> querysMap = new HashMap<String, Object>(10);
            querysMap.put("no", i + 1);
            querysMap.put("userAccount", list.get(i).getUserAccount());
            querysMap.put("userName", list.get(i).getUserName());
            querysMap.put("corporationName", list.get(i).getCorporationName());
            querysMap.put("logTypeName", list.get(i).getLogTypeName());
            querysMap.put("resourceAlias", list.get(i).getResourceAlias());
            querysMap.put("levelEventName", list.get(i).getLevelEventName());
            querysMap.put("state", list.get(i).getState());
            querysMap.put("remoteaddr", list.get(i).getRemoteaddr());
            querysMap.put("logTime", logFormatter.format(list.get(i).getLogTime()));
            querysMap.put("logContent", list.get(i).getLogContent());
            querys.add(querysMap);
            if (i == 999) break;
        }
        ExcelEntity excelEntity = new ExcelEntity();
        excelEntity.setQuerys(querys);
        excelEntity.setTitles(excelTitles);
        excelEntity.setBlankLeft(true);
        excelEntity.setBlankTop(true);
        ExportExcel exportExcel = new ExportExcel();
        try {
            this.setResponseHeader(response, fileName);
            ServletOutputStream os = response.getOutputStream();
            exportExcel.exportExcel((OutputStream)os, excelEntity);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setResponseHeader(HttpServletResponse response, String fileName) {
        try {
            try {
                fileName = new String(fileName.getBytes(), "ISO8859-1");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.addHeader("Pargam", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

