/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.messagepush.BpmAbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.bsp.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.bsp.permit.dictmap.RoleGroupDict;
import com.jxdinfo.hussar.bsp.permit.dictmap.RoleManagerDict;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleResource;
import com.jxdinfo.hussar.bsp.permit.model.SysRoles;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResTypeService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.userutil.UserUtil;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/roleManager"})
public class RoleManagerController
extends BaseController {
    @Resource
    private UserUtil userUtil;
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysResTypeService iSysResTypeService;
    @Resource
    private ISysRolesService iSysRolesService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysRoleResourceService iSysRoleResourceService;
    @Resource
    private ISysConfRolesService isConfRolesService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysUserroleAuditService isAuditService;
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private BpmAbstractPushMsgMatcher bpmAbstractPushMsgMatcher;

    @RequestMapping(value={"/view"})
    @RequiresPermissions(value={"roleManager:view"})
    @BussinessLog(key="/roleManager/view", type="04", value="\u89d2\u8272\u7ba1\u7406\u9875\u9762")
    public String view() {
        return "/bsp/permit/roleManage/roleManage.html";
    }

    @RequiresPermissions(value={"roleManager:roleTree"})
    @RequestMapping(value={"/roleTree"})
    @ResponseBody
    public List<JSTreeModel> roleTree() {
        String nodeId = super.getPara("nodeId");
        String userId = super.getPara("userId");
        String functionType = super.getPara("functionType");
        return this.iSysRolesService.getRoleTree(nodeId, userId, functionType);
    }

    @RequestMapping(value={"/lazyRoleTree"})
    @ResponseBody
    public List<JSTreeModel> lazyRoleTree(String nodeId) {
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String isExport = super.getPara("isExport");
            return this.iSysRolesService.getLazyOrganRoleTree(nodeId, Boolean.parseBoolean(isExport));
        }
        return this.iSysRolesService.getLazyRoleTree(nodeId);
    }

    @RequestMapping(value={"/selfRoleTree"})
    @ResponseBody
    public List<JSTreeModel> selfRoleTree() {
        String[] roleIds = super.getPara("roleIds").trim().split(",");
        return this.iSysRolesService.getSelfRoleTree(roleIds);
    }

    public List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursive(list, result, "");
        JSTreeModel model = new JSTreeModel();
        model.setId("1");
        model.setCode("GROUP");
        model.setParent("#");
        model.setText("\u89d2\u8272\u6811");
        model.setType("isRoot");
        result.add(model);
        return result;
    }

    public void recursive(List<JSTreeModel> list, List<JSTreeModel> result, String parentId) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i > list.size() - 1) {
                i = list.size() - 1;
            }
            if (i < 0) break;
            JSTreeModel map = list.get(i);
            if (!"ROLE".equals(map.getCode()) && !parentId.equals(map.getId())) continue;
            parentId = map.getParent();
            result.add(map);
            list.remove(i);
            this.recursive(list, result, parentId);
        }
    }

    @RequestMapping(value={"/resourceTree"})
    @ResponseBody
    public List<Map<String, Object>> resourceTree() {
        return this.iSysResTypeService.getResourceTree();
    }

    @RequestMapping(value={"/addRole"})
    @RequiresPermissions(value={"roleManager:addRole"})
    @BussinessLog(key="/roleManager/addRole", type="01", value="\u65b0\u589e\u89d2\u8272", pk="roleId", dict=RoleManagerDict.class)
    @ResponseBody
    public Object addRole() {
        ShiroUser currentUser = ShiroKit.getUser();
        String roleType = super.getPara("roleType");
        String roleName = super.getPara("roleName").trim();
        String roleYw = super.getPara("roleAlias") == null ? "" : super.getPara("roleAlias").trim();
        String checkNodeId = super.getPara("checkNodeId").trim();
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("roleName", roleName);
        map.put("roleYw", roleYw);
        map.put("checkNodeId", checkNodeId);
        if (currentUser.isGradeadmin() && "organRoleAdd".equals(roleType)) {
            map.put("isOrganRoleAdd", "true");
        } else {
            map.put("isOrganRoleAdd", "false");
        }
        String roleId = this.iSysRolesService.addRole(map);
        JSONObject result = new JSONObject();
        result.put("roleId", (Object)roleId);
        return result;
    }

    @RequestMapping(value={"/editRole"})
    @RequiresPermissions(value={"roleManager:editRole"})
    @BussinessLog(key="/roleManager/editRole", type="03", value="\u4fee\u6539\u89d2\u8272", pk="roleId", dict=RoleManagerDict.class)
    @ResponseBody
    public Tip editRole() {
        String roleId = super.getPara("roleId").trim();
        String roleName = super.getPara("roleName").trim();
        String roleYw = super.getPara("roleAlias") == null ? "" : super.getPara("roleAlias").trim();
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("roleId", roleId);
        map.put("roleName", roleName);
        map.put("roleYw", roleYw);
        Wrapper entityWrapper = (Wrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)roleId);
        List roleList = this.iSysRolesService.list(entityWrapper);
        LogObjectHolder.me().set(roleList.get(0));
        boolean flag = this.iSysRolesService.editRole(map);
        if (flag) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/roleView"})
    @ResponseBody
    public List<Object> roleView() {
        String id = super.getPara("id").trim();
        List<Object> list = this.iSysRolesService.getRoleView(id);
        return list;
    }

    @RequestMapping(value={"/delRole"})
    @RequiresPermissions(value={"roleManager:delRole"})
    @BussinessLog(key="/roleManager/delRole", type="02", value="\u5220\u9664\u89d2\u8272")
    @ResponseBody
    public Tip delRole() {
        String id = super.getPara("id").trim();
        List list = this.isConfRolesService.list((Wrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)id));
        if (list.size() > 0) {
            return new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u65e0\u6cd5\u5220\u9664\uff01\uff08\u89d2\u8272\u5df2\u5173\u8054\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\uff01\uff09");
        }
        int num = this.isAuditService.isDelete(id);
        if (num > 0) {
            return new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u65e0\u6cd5\u5220\u9664\uff01\uff08\u89d2\u8272\u5df2\u5173\u8054\u7528\u6237\uff01\uff09");
        }
        boolean flag = this.iSysRolesService.delRole(id);
        if (flag) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u5220\u9664\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"roleManager:saveResource"})
    @RequestMapping(value={"/saveResource"})
    @ResponseBody
    public Tip saveResource() {
        String ids = super.getPara("ids");
        String roId = super.getPara("roId");
        this.iSysRoleResourceService.saveResource(ids, roId);
        List<String> userIds = this.iSysRolesService.delCacheAuthInfo(roId);
        for (String userId : userIds) {
            this.iSysRolesService.delRedisAuthInfo(userId);
        }
        SuccessTip tip = new SuccessTip();
        tip.setMessage("\u89d2\u8272\u5173\u8054\u8d44\u6e90\u4fdd\u5b58\u6210\u529f\uff01");
        return tip;
    }

    @RequestMapping(value={"/reclaimPerm"})
    @RequiresPermissions(value={"roleManager:reclaimPerm"})
    @BussinessLog(key="/roleManager/reclaimPerm", type="02", value="\u89d2\u8272\u56de\u6536\u6743\u9650")
    @ResponseBody
    public Tip reclaimPerm() {
        String id = super.getPara("id").trim();
        this.iSysRoleResourceService.reclaimPerm(id);
        List<String> userIds = this.iSysRolesService.delCacheAuthInfo(id);
        for (String userId : userIds) {
            this.iSysRolesService.delRedisAuthInfo(userId);
        }
        return BaseController.SUCCESS_TIP;
    }

    @RequestMapping(value={"/queryPerm"})
    @ResponseBody
    public List<SysRoleResource> queryPerm() {
        String id = super.getPara("id").trim();
        return this.iSysRoleResourceService.queryPerm(id);
    }

    @RequestMapping(value={"/saveGroup"})
    @RequiresPermissions(value={"roleManager:saveGroup"})
    @BussinessLog(key="/roleManager/saveGroup", type="01", value="\u65b0\u589e\u89d2\u8272\u5206\u7ec4", pk="groupId", dict=RoleGroupDict.class)
    @ResponseBody
    public Tip saveGroup() {
        String groupName = super.getPara("groupName");
        String groupAlias = super.getPara("groupAlias");
        String checkId = super.getPara("checkId");
        boolean result = this.iSysRolesService.saveGroup(groupName, checkId, groupAlias);
        if (result) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/editGroup"})
    @RequiresPermissions(value={"roleManager:editGroup"})
    @BussinessLog(key="/roleManager/editGroup", type="03", value="\u4fee\u6539\u89d2\u8272\u5206\u7ec4", pk="groupId", dict=RoleGroupDict.class)
    @ResponseBody
    public Tip editGroup() {
        String groupName = super.getPara("groupName");
        String groupAlias = super.getPara("groupAlias");
        String checkId = super.getPara("checkId");
        boolean result = this.iSysRolesService.editGroup(groupName, checkId, groupAlias);
        SysRoleGroup group = (SysRoleGroup)((Object)this.sysRoleGroupMapper.selectById((Serializable)((Object)checkId)));
        groupName = group.getGroupName();
        groupAlias = group.getGroupAlias();
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("groupName", groupName);
        map.put("groupAlias", groupAlias);
        LogObjectHolder.me().set(map);
        if (result) {
            return BaseController.SUCCESS_TIP;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"roleManager:sameRoleName"})
    @RequestMapping(value={"/sameRoleName"})
    @ResponseBody
    public List<SysRoles> sameRoleName() {
        String name = super.getPara("sameRoleName");
        return this.iSysRolesService.list((Wrapper)new QueryWrapper().eq((Object)"ROLE_NAME", (Object)name));
    }

    @RequiresPermissions(value={"roleManager:sameGroupName"})
    @RequestMapping(value={"/sameGroupName"})
    @ResponseBody
    public List<SysRoleGroup> sameGroupName() {
        String name = super.getPara("sameGroupName");
        List list = this.sysRoleGroupMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"GROUP_NAME", (Object)name));
        return list;
    }

    @RequiresPermissions(value={"roleManager:searchRoleToGroup"})
    @RequestMapping(value={"/searchRoleToGroup"})
    @ResponseBody
    public List<SysRoles> searchRoleToGroup() {
        String id = super.getPara("id");
        return this.iSysRolesService.list((Wrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)id));
    }

    @RequestMapping(value={"/delGroup"})
    @RequiresPermissions(value={"roleManager:delGroup"})
    @BussinessLog(key="/roleManager/delGroup", type="02", value="\u5220\u9664\u89d2\u8272\u5206\u7ec4")
    @ResponseBody
    public Tip delGroup() {
        String id = super.getPara("id");
        Integer count = this.sysRoleGroupMapper.deleteById((Serializable)((Object)id));
        if (count == 1) {
            this.bpmAbstractPushMsgMatcher.delete("role", id, null);
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u5220\u9664\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"roleManager:roleViewPage"})
    @RequestMapping(value={"/roleViewPage"})
    @BussinessLog(key="/roleManager/roleViewPage", type="04", value="\u67e5\u770b\u89d2\u8272\u4fe1\u606f")
    public String roleViewPage(HttpServletRequest request) {
        SysRoleGroup group;
        String groupId;
        String nodeId = super.getPara("id");
        Wrapper entityWrapper = (Wrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)nodeId.split(",")[0]);
        List roleList = this.iSysRolesService.list(entityWrapper);
        String groupName = "";
        if (roleList.size() == 1 && (groupId = ((SysRoles)((Object)roleList.get(0))).getGroupId()) != null && (group = (SysRoleGroup)((Object)this.sysRoleGroupMapper.selectById((Serializable)((Object)groupId)))) != null) {
            groupName = group.getGroupName();
        }
        request.setAttribute("groupName", (Object)groupName);
        request.setAttribute("roleList", (Object)roleList);
        request.setAttribute("nodeId", (Object)nodeId);
        return "/bsp/permit/roleManage/roleViewPage.html";
    }

    @RequestMapping(value={"/roleGroupViewPage"})
    @BussinessLog(key="/roleManager/roleGroupViewPage", type="04", value="\u67e5\u770b\u89d2\u8272\u5206\u7ec4\u4fe1\u606f")
    @RequiresPermissions(value={"roleManager:roleGroupViewPage"})
    public String roleGroupViewPage(HttpServletRequest request) {
        String nodeId = super.getPara("id");
        SysRoleGroup group = (SysRoleGroup)((Object)this.sysRoleGroupMapper.selectById((Serializable)((Object)nodeId)));
        request.setAttribute("group", (Object)group);
        return "/bsp/permit/roleManage/roleGroupViewPage.html";
    }

    @RequiresPermissions(value={"roleManager:roleAddPage"})
    @RequestMapping(value={"/roleAddPage"})
    public String roleAddPage(HttpServletRequest request) {
        String nodeId = super.getPara("id");
        String type = super.getPara("type");
        if ("organRoleAdd".equals(type)) {
            request.setAttribute("type", (Object)type);
            SysStru stru = (SysStru)((Object)this.sysOrgManageService.getById((Serializable)((Object)nodeId)));
            String organAlias = stru.getOrganAlias();
            request.setAttribute("organAlias", (Object)organAlias);
            request.setAttribute("group", (Object)"");
        } else {
            SysRoleGroup group = (SysRoleGroup)((Object)this.sysRoleGroupMapper.selectById((Serializable)((Object)nodeId)));
            if (group != null) {
                request.setAttribute("group", (Object)group.getGroupName());
            } else {
                request.setAttribute("group", (Object)"");
            }
        }
        request.setAttribute("nodeId", (Object)nodeId);
        return "/bsp/permit/roleManage/roleAddPage.html";
    }

    @RequiresPermissions(value={"roleManager:roleEditPage"})
    @RequestMapping(value={"/roleEditPage"})
    public String roleEditPage(HttpServletRequest request) {
        String nodeId = super.getPara("id");
        String type = super.getPara("type");
        SysRoles currentRole = (SysRoles)((Object)this.iSysRolesService.getById((Serializable)((Object)nodeId)));
        if ("organRoleEdit".equals(type)) {
            request.setAttribute("type", (Object)type);
            String struId = currentRole.getCorporationId();
            SysStru stru = (SysStru)((Object)this.sysOrgManageService.getById((Serializable)((Object)struId)));
            String organAlias = stru.getOrganAlias();
            request.setAttribute("organAlias", (Object)organAlias);
            request.setAttribute("group", (Object)"");
        } else {
            SysRoleGroup group = (SysRoleGroup)((Object)this.sysRoleGroupMapper.selectById((Serializable)((Object)currentRole.getGroupId())));
            if (group != null) {
                request.setAttribute("group", (Object)group.getGroupName());
            } else {
                request.setAttribute("group", (Object)"");
            }
        }
        request.setAttribute("nodeId", (Object)nodeId);
        request.setAttribute("currentRole", (Object)currentRole);
        return "/bsp/permit/roleManage/roleEditPage.html";
    }

    @RequiresPermissions(value={"roleManager:roleAddGroupPage"})
    @RequestMapping(value={"/roleAddGroupPage"})
    public String roleAddGroupPage(HttpServletRequest request) {
        String nodeId = super.getPara("id");
        String type = super.getPara("type");
        String groupName = "";
        String groupAlias = "";
        if (ToolUtil.equals((Object)"edit", (Object)type)) {
            SysRoleGroup group = (SysRoleGroup)((Object)this.sysRoleGroupMapper.selectById((Serializable)((Object)nodeId)));
            groupName = group.getGroupName();
            groupAlias = group.getGroupAlias();
        }
        request.setAttribute("groupName", (Object)groupName);
        request.setAttribute("groupAlias", (Object)groupAlias);
        request.setAttribute("nodeId", (Object)nodeId);
        request.setAttribute("type", (Object)type);
        return "/bsp/permit/roleManage/roleAddGroupPage.html";
    }

    @RequiresPermissions(value={"roleManager:roleUserTreeView"})
    @RequestMapping(value={"/roleUserTreeView"})
    @ResponseBody
    public List<JSTreeModel> getRoleUserTreeView() {
        String roleId = super.getPara("roleId");
        List<JSTreeModel> result = this.userUtil.getUserByRole(roleId);
        JSTreeModel root = new JSTreeModel();
        root.setId("11");
        root.setCode("11");
        root.setText("\u5173\u8054\u7528\u6237");
        root.setParent("#");
        root.setType("isRoot");
        result.add(root);
        for (JSTreeModel model : result) {
            if ("USER".equals(model.getType())) {
                model.setState(true, false, true);
                continue;
            }
            model.setState(false, false, true);
        }
        return result;
    }

    @RequestMapping(value={"/lazyRoleUserTreeView"})
    @ResponseBody
    public List<JSTreeModel> getLazyRoleUserTreeView() {
        String roleId = super.getPara("roleId");
        String nodeId = super.getPara("nodeId");
        return this.userUtil.getLazyUserByRole(roleId, nodeId);
    }

    @RequestMapping(value={"/getRoleOrgUser"})
    @ResponseBody
    public JSONObject getRoleOrgUser(String roleId, String orgId, @RequestParam(value="page", defaultValue="1") int pageNo, @RequestParam(value="limit", defaultValue="20") int limit) {
        String name = super.getPara("name");
        String account = super.getPara("account");
        Page page = new Page((long)pageNo, (long)limit);
        List<Object> list = ToolUtil.isEmpty((Object)roleId) ? new ArrayList() : this.sysOrgManageService.getRoleOrgUser((Page<Object>)page, roleId, orgId, name, account);
        JSONObject json = new JSONObject();
        json.put("data", list);
        json.put("code", (Object)"0");
        json.put("msg", (Object)"");
        json.put("count", (Object)page.getTotal());
        return json;
    }

    @RequestMapping(value={"/addOrDelUserRole"})
    @ResponseBody
    public Tip getRoleOrgUser(String adds, String dels, String roleId) {
        List addList = JSONObject.parseArray((String)adds, RoleOrgUserVo.class);
        List delList = JSONObject.parseArray((String)dels, RoleOrgUserVo.class);
        return this.iSysUserRoleService.addOrDelUserRole(addList, delList, roleId);
    }

    @RequiresPermissions(value={"roleManager:roleUserTreeEdit"})
    @RequestMapping(value={"/roleUserTreeEdit"})
    @ResponseBody
    public List<JSTreeModel> getRoleUserTreeEdit() {
        String roleId = super.getPara("roleId");
        boolean isSysRole = false;
        String sysRoleGroup = "sys_role_group";
        SysRoles role = (SysRoles)((Object)this.iSysRolesService.getById((Serializable)((Object)roleId)));
        if (sysRoleGroup.equals(role.getGroupId())) {
            isSysRole = true;
        }
        List<JSTreeModel> result = this.sysOrgManageService.getUserTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId("11");
        jsTreeModel.setCode("11");
        jsTreeModel.setText("\u5173\u8054\u7528\u6237");
        jsTreeModel.setParent("#");
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        List<String> userRoles = this.iSysUserRoleService.selectUserIdByRoleId(roleId);
        for (JSTreeModel model : result) {
            model.setState(false, false, false);
            if (userRoles.contains(model.getId())) {
                model.setState(true, true, false);
            }
            if (isSysRole) {
                model.setState(model.getState().get("selected"), model.getState().get("checked"), true);
                continue;
            }
            if (!"USER".equals(model.getType()) || !"11".equals(model.getParent())) continue;
            model.setState(model.getState().get("selected"), model.getState().get("checked"), true);
        }
        return result;
    }

    @RequiresPermissions(value={"roleManager:roleUserTreeAdd"})
    @RequestMapping(value={"/roleUserTreeAdd"})
    @ResponseBody
    public List<JSTreeModel> getRoleUserTreeAdd() {
        List<JSTreeModel> result = this.sysOrgManageService.getUserTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId("11");
        jsTreeModel.setCode("11");
        jsTreeModel.setText("\u5173\u8054\u7528\u6237");
        jsTreeModel.setParent("#");
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        for (JSTreeModel model : result) {
            model.setState(false, false, false);
            if (!"USER".equals(model.getType()) || !"11".equals(model.getParent())) continue;
            model.setState(model.getState().get("selected"), model.getState().get("checked"), true);
        }
        return result;
    }

    @RequiresPermissions(value={"roleManager:saveRoleUserAdd"})
    @RequestMapping(value={"/saveRoleUserAdd"})
    @ResponseBody
    public Tip saveRoleUsersAdd() {
        String roleId = super.getPara("roleId");
        String userIds = super.getPara("userIds");
        List<String> ids = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)userIds)) {
            ids = Arrays.asList(userIds.split(","));
        }
        this.iSysRoleResourceService.saveRoleUserAdd(ids, roleId);
        SuccessTip tip = new SuccessTip();
        tip.setMessage("\u89d2\u8272\u5173\u8054\u7528\u6237\u4fdd\u5b58\u6210\u529f\uff01");
        return tip;
    }

    @RequiresPermissions(value={"roleManager:saveRoleUserEdit"})
    @RequestMapping(value={"/saveRoleUserEdit"})
    @ResponseBody
    public Tip saveRoleUsersEdit() {
        List confRolesList;
        String roleId = super.getPara("roleId");
        String userIds = super.getPara("userIds");
        List<Object> ids = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)userIds)) {
            ids = Arrays.asList(userIds.split(","));
        }
        if (ToolUtil.isNotEmpty((Object)(confRolesList = this.isConfRolesService.list((Wrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)roleId))))) {
            for (String string : ids) {
                List<String> rolesList = this.iSysUserRoleService.getRolesByUserId(string);
                if (!rolesList.contains(roleId)) {
                    rolesList.add(roleId);
                }
                if (!this.isConfRolesService.isIncludeConfRole(rolesList.toArray(new String[rolesList.size()]))) continue;
                SysUsers user = (SysUsers)((Object)this.sysUsersService.getById((Serializable)((Object)string)));
                return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01\uff08" + user.getUserName() + " \u8fdd\u53cd\u4e86\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u89c4\u5219\uff09");
            }
        }
        this.iSysRoleResourceService.saveRoleUserEdit(ids, roleId);
        SuccessTip tip = new SuccessTip();
        tip.setMessage("\u89d2\u8272\u5173\u8054\u7528\u6237\u4fdd\u5b58\u6210\u529f\uff01");
        return tip;
    }

    @RequiresPermissions(value={"roleManager:groupOrderTree"})
    @RequestMapping(value={"/groupOrderTree"})
    @ResponseBody
    public List<JSTreeModel> groupOrderTree() {
        return this.iSysRolesService.getGroupOrderTree();
    }

    @RequestMapping(value={"/saveGroupOrder"})
    @ResponseBody
    @RequiresPermissions(value={"roleManager:saveGroupOrder"})
    @BussinessLog(key="/roleManager/saveGroupOrder", type="03", value="\u89d2\u8272\u5206\u7ec4\u6392\u5e8f")
    public Tip saveGroupOrder() {
        String info = super.getPara("info");
        JSONArray treeArr = JSONArray.parseArray((String)info);
        this.iSysRolesService.saveGroupOrder(treeArr);
        return SUCCESS_TIP;
    }

    @RequiresPermissions(value={"roleManager:roleOrderTree"})
    @RequestMapping(value={"/roleOrderTree"})
    @ResponseBody
    public List<JSTreeModel> roleOrderTree() {
        String parent = super.getPara("parent");
        return this.iSysRolesService.getRoleOrderTree(parent);
    }

    @RequestMapping(value={"/saveRoleOrder"})
    @ResponseBody
    @RequiresPermissions(value={"roleManager:saveRoleOrder"})
    @BussinessLog(key="/roleManager/saveRoleOrder", type="03", value="\u89d2\u8272\u6392\u5e8f")
    public Tip saveRoleOrder() {
        String info = super.getPara("info");
        JSONArray treeArr = JSONArray.parseArray((String)info);
        this.iSysRolesService.saveRoleOrder(treeArr);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/exportData"})
    @RequiresPermissions(value={"roleManager:exportData"})
    @BussinessLog(key="/roleManager/exportData", type="04", value="\u89d2\u8272\u6570\u636e\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.iSysRolesService.exportData(idList, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @ResponseBody
    @RequiresPermissions(value={"roleManager:importData"})
    @BussinessLog(key="/roleManager/importData", type="03", value="\u89d2\u8272\u6570\u636e\u5bfc\u5165")
    public Tip importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return this.iSysRolesService.importData(content);
    }
}

