/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.permit.dictmap.IncompatibleRolesDict;
import com.jxdinfo.hussar.bsp.permit.model.SysConfRoles;
import com.jxdinfo.hussar.bsp.permit.model.SysConfRoleset;
import com.jxdinfo.hussar.bsp.permit.model.SysRoles;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesetService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/incompatibleRoles"})
public class IncompatibleRolesController
extends BaseController {
    @Resource
    private ISysConfRolesetService isConfRolesetService;
    @Resource
    private ISysConfRolesService isConfRolesService;

    @RequestMapping(value={"/view"})
    @RequiresPermissions(value={"incompatibleRoles:view"})
    @BussinessLog(key="/incompatibleRoles/view", type="04", value="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u9875\u9762")
    public String view() {
        return "/bsp/permit/roleManage/incompatibleRoles.html";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    @RequiresPermissions(value={"incompatibleRoles:list"})
    @BussinessLog(key="/incompatibleRoles/list", type="04", value="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u5217\u8868")
    public Map<String, Object> list() {
        String org = super.getPara("orgId");
        String name = super.getPara("rolesName");
        String page = super.getPara("page");
        String limit = super.getPara("limit");
        if (!StringUtils.isEmpty((String)name)) {
            name = name.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        Map<String, Object> result = this.isConfRolesetService.getRolesList(page, limit, name, org);
        return result;
    }

    @RequiresPermissions(value={"incompatibleRoles:selectInRoles"})
    @RequestMapping(value={"/selectInRoles"})
    @ResponseBody
    public List<SysRoles> selectInRoles() {
        String selectId = super.getPara("selectId");
        return this.isConfRolesService.getSelectInRoles(selectId);
    }

    @RequestMapping(value={"/addRole"})
    @RequiresPermissions(value={"incompatibleRoles:addRole"})
    @BussinessLog(key="/incompatibleRoles/addRole", type="01", pk="setId", value="\u6dfb\u52a0\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", dict=IncompatibleRolesDict.class)
    @ResponseBody
    public Tip addRole() {
        String rolesName = super.getPara("setName").trim();
        String count = super.getPara("cardinality").trim();
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("rolesName", rolesName);
        map.put("count", count);
        boolean flag = this.isConfRolesetService.addRole(map);
        if (flag) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"incompatibleRoles:selectInRole"})
    @RequestMapping(value={"selectInRole"})
    @ResponseBody
    public SysConfRoleset selectInRole() {
        String rolesId = super.getPara("setId");
        return (SysConfRoleset)((Object)this.isConfRolesetService.getById((Serializable)((Object)rolesId)));
    }

    @RequestMapping(value={"/editRole"})
    @RequiresPermissions(value={"incompatibleRoles:editRole"})
    @BussinessLog(key="/incompatibleRoles/editRole", type="03", pk="setId", value="\u4fee\u6539\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", dict=IncompatibleRolesDict.class)
    @ResponseBody
    public Object editRole() {
        String id = super.getPara("setId");
        String rolesName = super.getPara("setName").trim();
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("rolesName", rolesName);
        map.put("id", id);
        boolean flag = this.isConfRolesetService.editRole(map);
        if (flag) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
            return tip;
        }
        return BaseController.ERROR;
    }

    @RequestMapping(value={"/delRole"})
    @RequiresPermissions(value={"incompatibleRoles:delRole"})
    @BussinessLog(key="/incompatibleRoles/delRole", type="02", value="\u5220\u9664\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6")
    @ResponseBody
    public Object delRole() {
        String id = super.getPara("id").trim();
        this.isConfRolesetService.delRole(id);
        return BaseController.SUCCESS;
    }

    @RequiresPermissions(value={"incompatibleRoles:roleView"})
    @RequestMapping(value={"/roleView"})
    @ResponseBody
    public List<Object> roleView() {
        String id = super.getPara("id").trim();
        return this.isConfRolesetService.getRoleView(id);
    }

    @RequestMapping(value={"/saveInRoles"})
    @RequiresPermissions(value={"incompatibleRoles:saveInRoles"})
    @BussinessLog(key="/incompatibleRoles/saveInRoles", type="01", value="\u589e\u52a0\u4e0d\u76f8\u5bb9\u89d2\u8272")
    @ResponseBody
    public Tip saveInRoles() {
        String roIds = super.getPara("ids");
        String setId = super.getPara("setId");
        String[] ids = roIds.split(",");
        this.isConfRolesService.remove((Wrapper)new QueryWrapper().eq((Object)"SET_ID", (Object)setId));
        ArrayList<SysConfRoles> list = new ArrayList<SysConfRoles>();
        for (String id : ids) {
            SysConfRoles sysConfRoles = new SysConfRoles();
            sysConfRoles.setSetId(setId);
            sysConfRoles.setRoleId(id);
            list.add(sysConfRoles);
        }
        if (ToolUtil.isNotEmpty(list)) {
            this.isConfRolesService.saveBatch(list, list.size());
        }
        SuccessTip tip = new SuccessTip();
        tip.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
        return tip;
    }

    @RequiresPermissions(value={"incompatibleRoles:sameRolesName"})
    @RequestMapping(value={"/sameRolesName"})
    @ResponseBody
    public List<SysConfRoleset> sameRoleName() {
        String name = super.getPara("sameRolesName");
        return this.isConfRolesetService.list((Wrapper)new QueryWrapper().eq((Object)"set_name", (Object)name));
    }
}

