/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bsp.permit.model.SysIdtable;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.bsp.permit.service.TableService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/idtable"})
public class IdtableController
extends BaseController {
    @Resource
    ISysIdtableService sysIdtableService;
    @Resource
    private TableService tableService;
    @Autowired
    private DruidProperties druidProperties;

    @RequiresPermissions(value={"idtable:idtableManage"})
    @RequestMapping(value={"/idtableManage"})
    @BussinessLog(key="/idtable/idtableManage", type="04", value="\u6700\u5927\u53f7\u8868\u7ef4\u62a4\u9875\u9762")
    public String idtableManage(Model model) throws SQLException {
        List<Map<String, Object>> list = this.tableService.getTables();
        String dbUrl = this.druidProperties.getUrl();
        if (dbUrl.startsWith("jdbc:postgresql")) {
            ArrayList newList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                Set<String> se = list.get(i).keySet();
                for (String set : se) {
                    map.put(set.toUpperCase(), list.get(i).get(set).toString().toUpperCase());
                }
                newList.add(map);
            }
            model.addAttribute("tables", newList);
        } else {
            model.addAttribute("tables", list);
        }
        return "/bsp/permit/idtable/idtableManage.html";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    @BussinessLog(key="/idtable/list", type="04", value="\u6700\u5927\u53f7\u8868\u5217\u8868")
    @RequiresPermissions(value={"idtable:list"})
    public JSONObject list() {
        String serIdDesc = super.getPara("serIdDesc");
        String serFieldName = super.getPara("serFieldName");
        String serTableName = super.getPara("serTableName");
        if (ToolUtil.isNotEmpty((Object)serTableName)) {
            serTableName = serTableName.toLowerCase();
        }
        if (ToolUtil.isNotEmpty((Object)serIdDesc)) {
            serIdDesc = serIdDesc.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        if (ToolUtil.isNotEmpty((Object)serFieldName)) {
            serFieldName = serFieldName.replaceAll("%", "\\\\%");
        }
        String page = super.getPara("page");
        String limit = super.getPara("limit");
        JSONObject result = this.sysIdtableService.getList(page, limit, serIdDesc, serFieldName, serTableName);
        return result;
    }

    @BussinessLog(key="/idtable/addSave", type="01", value="\u6700\u5927\u53f7\u8868\u65b0\u589e\u4fdd\u5b58")
    @RequiresPermissions(value={"idtable:addSave"})
    @RequestMapping(value={"/addSave"})
    @ResponseBody
    public Tip addSave(SysIdtable sysIdtable) {
        String fieldName = sysIdtable.getFieldName();
        String tableName = sysIdtable.getTableName().toLowerCase();
        sysIdtable.setIsGlobal("0");
        sysIdtable.setTableName(tableName);
        sysIdtable.setFieldName(fieldName.toUpperCase());
        SysIdtable idtable = this.sysIdtableService.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)((Object)idtable))) {
            return new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u4e1a\u52a1\u540d\u79f0\u548c\u4e1a\u52a1\u8868\u540d\u5df2\u5b58\u5728\uff01");
        }
        if (this.sysIdtableService.saveIdtable(sysIdtable) == 1) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(500, "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @BussinessLog(key="/idtable/editSave", type="03", value="\u6700\u5927\u53f7\u8868\u4fee\u6539\u4fdd\u5b58")
    @RequiresPermissions(value={"idtable:editSave"})
    @RequestMapping(value={"/editSave"})
    @ResponseBody
    public Object editSave(SysIdtable sysIdtable) {
        String fieldName = sysIdtable.getFieldName();
        String tableName = sysIdtable.getTableName().toLowerCase();
        sysIdtable.setTableName(tableName);
        SysIdtable idtable = this.sysIdtableService.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)((Object)idtable)) && !idtable.getIdId().equals(sysIdtable.getIdId())) {
            return ERROR;
        }
        SysIdtable sysIdtable1 = (SysIdtable)((Object)this.sysIdtableService.getById((Serializable)((Object)sysIdtable.getIdId())));
        LogObjectHolder.me().set((Object)sysIdtable1);
        if (this.sysIdtableService.saveIdtable(sysIdtable) == 1) {
            return SUCCESS_TIP;
        }
        return new ErrorTip(500, "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @BussinessLog(key="/idtable/delByIds", type="02", value="\u6700\u5927\u53f7\u8868\u5220\u9664")
    @RequiresPermissions(value={"idtable:del"})
    @RequestMapping(value={"/delByIds"})
    @ResponseBody
    public Tip delByIds() {
        String[] ids = super.getPara("id").split(",");
        if (this.sysIdtableService.delByIds(Arrays.asList(ids))) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u5220\u9664\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(500, "\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/exportData"})
    @BussinessLog(key="/idtable/exportData", type="03", value="\u6700\u5927\u53f7\u8868\u5bfc\u51fa")
    @RequiresPermissions(value={"idtable:exportData"})
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.sysIdtableService.exportData(idList, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @ResponseBody
    @BussinessLog(key="/idtable/importData", type="03", value="\u6700\u5927\u53f7\u8868\u5bfc\u5165")
    @RequiresPermissions(value={"idtable:importData"})
    public Tip importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return this.sysIdtableService.importData(content);
    }
}

