/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.jxdinfo.hussar.bpm.messagepush.BpmAbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.audit.dao.SysUsersAuditMapper;
import com.jxdinfo.hussar.bsp.audit.model.SysOfficeAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysStruAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.bsp.audit.service.ISysOfficeAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysOrganAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.bsp.audit.util.CopyPropertieUtils;
import com.jxdinfo.hussar.bsp.bspinterface.service.ISysOrgEventService;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.organ.dao.SysOfficeMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysOffice;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysOrganType;
import com.jxdinfo.hussar.bsp.organ.model.SysStaff;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.model.SysStruRule;
import com.jxdinfo.hussar.bsp.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStaffService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.OrganInfoVo;
import com.jxdinfo.hussar.bsp.organ.vo.ProxyTreeVo;
import com.jxdinfo.hussar.bsp.organ.vo.SysOrganTypeVo;
import com.jxdinfo.hussar.bsp.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.bsp.permit.dao.SysConfRolesetMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruroleAuditMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.bsp.permit.model.SysStruRole;
import com.jxdinfo.hussar.bsp.permit.model.SysStruroleAudit;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.StruRoleStatus;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.DataExportUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysOrgManageServiceImpl
extends ServiceImpl<SysStruMapper, SysStru>
implements SysOrgManageService {
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private SysStruRuleMapper sysStruRuleMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysConfRolesetMapper sysConfRolesetMapper;
    @Resource
    private SysOfficeMapper sysOfficeMapper;
    @Autowired
    private ISysOfficeService iSysOfficeService;
    @Autowired
    private ISysOrgEventService iSysOrgEventService;
    @Resource
    private GlobalProperties globalProperties;
    @Autowired
    ISysOrganAuditService iSysOrganAuditService;
    @Autowired
    ISysStruAuditService iSysStruAuditService;
    @Autowired
    ISysStaffAuditService iSysStaffAuditService;
    @Autowired
    ISysUsersAuditService iSysUsersAuditService;
    @Autowired
    ISysOfficeAuditService iSysOfficeAuditService;
    @Resource
    private SysUsersAuditMapper sysUsersAuditMapper;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private BpmAbstractPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Autowired
    SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Resource
    @Lazy
    private ISysRolesService sysRolesService;
    @Resource
    private SysStruRoleMapper sysStruRoleMapper;
    @Autowired
    @Lazy
    private ISysStruRoleService sysStruRoleService;
    @Resource
    private SysStruroleAuditMapper sysStruroleAuditMapper;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    ISysStruAssistOrganService iSysStruAssistOrganService;

    @Override
    public List<JSTreeModel> getOrgTree(String isEmployee) {
        return this.sysStruMapper.getOrgTree(isEmployee);
    }

    @Override
    public SysOrganVo getOrgInfoById(String struId) {
        return this.sysStruMapper.getOrgInfoByOrgId(struId);
    }

    @Override
    public ArrayList<Object> getStruRole(String id) {
        ArrayList<Object> result = new ArrayList<Object>();
        List userRole = this.sysStruRoleMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)id));
        result.add(userRole);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject orgInfoSave(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, SysOffice sysOffice, Boolean isAdd) {
        String struId = sysStru.getStruId();
        String roleId = sysStru.getRoleIds().trim();
        String[] roleIds = roleId.split(",");
        JSONObject json = new JSONObject();
        Date date = new Date();
        String userId = ShiroKit.getUser().getId();
        if (isAdd.booleanValue()) {
            this.iSysOrgEventService.beforeAdd(sysStru, sysOrgan, sysOffice);
            sysOrgan.setCreateTime(date);
            sysOrgan.setCreator(userId);
            sysOrgan.setLastEditor(userId);
            sysOrgan.setLastTime(date);
            sysStru.setCreateTime(date);
            sysStru.setCreator(userId);
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
                this.auditAdd(sysOrgan, sysStru, sysStaff, sysOffice, ADD);
                json.put("code", (Object)HttpCode.OK.value());
                json.put("message", (Object)"\u65b0\u589e\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.sysOrganMapper.insert((Object)sysOrgan);
                sysStru.setOrganId(sysOrgan.getOrganId());
                this.sysStruMapper.insert((Object)sysStru);
                if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
                    sysStaff.setStruId(sysStru.getStruId());
                    this.sysStaffMapper.insert((Object)sysStaff);
                }
                if (ToolUtil.isNotEmpty((Object)((Object)sysOffice))) {
                    sysOffice.setStruId(sysStru.getStruId());
                    this.sysOfficeMapper.insert((Object)sysOffice);
                }
                json.put("code", (Object)HttpCode.OK.value());
                json.put("message", (Object)"\u65b0\u589e\u6210\u529f\uff01");
                JSONObject object = new JSONObject();
                object.put("sysOrgan", (Object)sysOrgan);
                object.put("sysStru", (Object)sysStru);
                if (ToolUtil.isNotEmpty((Object)((Object)sysOffice))) {
                    object.put("sysOffice", (Object)sysOffice);
                }
                if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
                    object.put("sysStaff", (Object)sysStaff);
                }
                this.abstractPushMsgMatcher.insertOperation("organ", "add", object, "");
                this.bpmAbstractPushMsgMatcher.pushOrgan(sysOrgan, sysStru, "add");
                String struId1 = sysStru.getStruId();
                this.sysStruRoleMapper.delete((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)struId1));
                ArrayList<SysStruRole> struRoleList = new ArrayList<SysStruRole>();
                for (String string : roleIds) {
                    if (ToolUtil.isEmpty((Object)string)) continue;
                    SysStruRole sysStruRole = new SysStruRole();
                    sysStruRole.setStruId(struId1);
                    sysStruRole.setGrantedRole(string);
                    sysStruRole.setCreateTime(date);
                    sysStruRole.setLastTime(date);
                    sysStruRole.setCreator(userId);
                    sysStruRole.setLastEditor(userId);
                    struRoleList.add(sysStruRole);
                }
                if (ToolUtil.isNotEmpty(struRoleList)) {
                    this.sysStruRoleService.saveBatch(struRoleList, struRoleList.size());
                    this.abstractPushMsgMatcher.insertOperation("struRole", "add", struRoleList, "");
                }
            }
            this.iSysOrgEventService.afterAdd(sysStru, sysOrgan, sysOffice);
        } else {
            this.iSysOrgEventService.beforeEdit(sysStru, sysOrgan, sysOffice);
            sysOrgan.setLastEditor(userId);
            sysOrgan.setLastTime(date);
            sysStru.setLastEditor(userId);
            sysStru.setLastTime(date);
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
                this.auditAdd(sysOrgan, sysStru, sysStaff, sysOffice, DELETE);
                json.put("code", (Object)HttpCode.OK.value());
                json.put("message", (Object)"\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.sysOrganMapper.updateById((Object)sysOrgan);
                this.sysStruMapper.updateById((Object)sysStru);
                if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
                    sysStaff.setName(sysOrgan.getOrganName());
                    this.sysStaffService.saveOrUpdate((Object)sysStaff);
                }
                if (ToolUtil.isNotEmpty((Object)((Object)sysOffice))) {
                    this.iSysOfficeService.saveOrUpdate((Object)sysOffice);
                }
                json.put("code", (Object)HttpCode.OK.value());
                json.put("message", (Object)"\u4fee\u6539\u6210\u529f\uff01");
                JSONObject object = new JSONObject();
                object.put("sysOrgan", (Object)sysOrgan);
                object.put("sysStru", (Object)sysStru);
                if (ToolUtil.isNotEmpty((Object)((Object)sysOffice))) {
                    object.put("sysOffice", (Object)sysOffice);
                }
                if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
                    object.put("sysStaff", (Object)sysStaff);
                }
                this.abstractPushMsgMatcher.insertOperation("organ", "update", object, "");
                this.bpmAbstractPushMsgMatcher.pushOrgan(sysOrgan, sysStru, "update");
            }
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isStruAudit()) {
                Object sysStruroleAudit;
                void var18_37;
                List<SysStruroleAudit> auditList = this.sysStruroleAuditMapper.getHasReviewList(struId);
                List connList = this.sysStruRoleMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"stru_id", (Object)struId));
                ArrayList<Object> adds = new ArrayList<Object>();
                ArrayList<String> dels = new ArrayList<String>();
                for (SysStruRole sysStruRole : connList) {
                    boolean bl = false;
                    for (String roleId1 : roleIds) {
                        if (ToolUtil.isEmpty((Object)roleId1) || !roleId1.equals(sysStruRole.getGrantedRole())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    dels.add(sysStruRole.getGrantedRole());
                }
                String[] stringArray = roleIds;
                int sysStruRole = stringArray.length;
                boolean bl = false;
                while (var18_37 < sysStruRole) {
                    String roleId1 = stringArray[var18_37];
                    if (!ToolUtil.isEmpty((Object)roleId1)) {
                        boolean isSame = false;
                        for (SysStruRole sysStruRole2 : connList) {
                            if (!roleId1.equals(sysStruRole2.getGrantedRole())) continue;
                            isSame = true;
                            break;
                        }
                        if (!isSame && !SysUserAndRole.PUBLIC_ROLE.getValue().equals(roleId1)) {
                            adds.add(roleId1);
                        }
                    }
                    ++var18_37;
                }
                if (ToolUtil.isNotEmpty(adds)) {
                    boolean isExist = false;
                    for (String string : adds) {
                        for (SysStruroleAudit sysStruroleAudit2 : auditList) {
                            if (!string.equals(sysStruroleAudit2.getRoleId())) continue;
                            isExist = true;
                            sysStruroleAudit2.setOperationType(ADD);
                            sysStruroleAudit2.setStatus(StruRoleStatus.LOCKED.getCode());
                            sysStruroleAudit2.setLastTime(new Date());
                            sysStruroleAudit2.setLastEditor(ShiroKit.getUser().getId());
                            this.sysStruroleAuditMapper.update((Object)sysStruroleAudit2, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"STRU_ID", (Object)struId)).eq((Object)"ROLE_ID", (Object)sysStruroleAudit2.getRoleId()));
                            break;
                        }
                        if (isExist) continue;
                        sysStruroleAudit = new SysStruroleAudit();
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setStruId(struId);
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setRoleId(string);
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setStatus(StruRoleStatus.LOCKED.getCode());
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setOperationType(ADD);
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setCreateTime(new Date());
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setLastTime(new Date());
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setCreator(ShiroKit.getUser().getId());
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setLastEditor(ShiroKit.getUser().getId());
                        this.sysStruroleAuditMapper.insert(sysStruroleAudit);
                    }
                }
                if (ToolUtil.isNotEmpty(dels)) {
                    boolean isExist = false;
                    for (String string : dels) {
                        for (SysStruroleAudit sysStruroleAudit3 : auditList) {
                            if (!string.equals(sysStruroleAudit3.getRoleId())) continue;
                            isExist = true;
                            sysStruroleAudit3.setOperationType(DELETE);
                            sysStruroleAudit3.setStatus(StruRoleStatus.LOCKED.getCode());
                            sysStruroleAudit3.setLastTime(new Date());
                            sysStruroleAudit3.setLastEditor(ShiroKit.getUser().getId());
                            this.sysStruroleAuditMapper.update((Object)sysStruroleAudit3, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)struId)).eq((Object)"ROLE_ID", (Object)sysStruroleAudit3.getRoleId()));
                            break;
                        }
                        if (isExist) continue;
                        sysStruroleAudit = new SysStruroleAudit();
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setStruId(struId);
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setRoleId(string);
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setStatus(StruRoleStatus.LOCKED.getCode());
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setOperationType(DELETE);
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setCreateTime(new Date());
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setLastTime(new Date());
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setCreator(ShiroKit.getUser().getId());
                        ((SysStruroleAudit)((Object)sysStruroleAudit)).setLastEditor(ShiroKit.getUser().getId());
                        this.sysStruroleAuditMapper.insert(sysStruroleAudit);
                    }
                }
            } else {
                this.sysRolesService.delRedisAuthInfo1(struId);
                if (ShiroKit.getUser().isGradeadmin()) {
                    this.sysStruRoleMapper.delOrganRoleIdByStruId(struId);
                    this.abstractPushMsgMatcher.insertOperation("struRole", "delete", struId, "");
                } else {
                    this.sysStruRoleMapper.delSysRolesByStruId(struId);
                    this.abstractPushMsgMatcher.insertOperation("struRole", "delete", struId, "");
                }
                this.bpmAbstractPushMsgMatcher.delete("struRole", struId, "deleteByStruId");
                ArrayList<SysStruRole> struRoleList = new ArrayList<SysStruRole>();
                for (String roleId1 : roleIds) {
                    if (ToolUtil.isEmpty((Object)roleId1)) continue;
                    SysStruRole sysStruRole = new SysStruRole();
                    sysStruRole.setStruId(struId);
                    sysStruRole.setGrantedRole(roleId1);
                    sysStruRole.setCreateTime(date);
                    sysStruRole.setLastTime(date);
                    sysStruRole.setCreator(userId);
                    sysStruRole.setLastEditor(userId);
                    struRoleList.add(sysStruRole);
                }
                if (ToolUtil.isNotEmpty(struRoleList)) {
                    this.sysStruRoleService.saveBatch(struRoleList, struRoleList.size());
                    this.abstractPushMsgMatcher.insertOperation("struRole", "add", struRoleList, "");
                }
            }
            this.iSysOrgEventService.afterEdit(sysStru, sysOrgan, sysOffice);
        }
        return json;
    }

    private void auditAdd(SysOrgan sysOrgan, SysStru sysStru, SysStaff sysStaff, SysOffice sysOffice, String flag) {
        SysOrganAudit sysOrganAudit = new SysOrganAudit();
        CopyPropertieUtils.copyProperties((Object)sysOrganAudit, (Object)sysOrgan);
        sysOrganAudit.setInUse(flag);
        if (DELETE.equals(flag)) {
            sysOrganAudit.setRealOrganId(sysOrgan.getOrganId());
            sysOrganAudit.setOrganId(null);
        }
        this.iSysOrganAuditService.save((Object)sysOrganAudit);
        SysStruAudit sysStruAudit = new SysStruAudit();
        CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
        sysStruAudit.setOrganId(sysOrganAudit.getOrganId());
        if (DELETE.equals(flag)) {
            sysStruAudit.setOrganId(sysOrganAudit.getOrganId());
            sysStruAudit.setRealStruId(sysStru.getStruId());
            sysStruAudit.setStruId(null);
            sysStruAudit.setLastTime(new Date());
        }
        sysStruAudit.setState("0");
        sysStruAudit.setInUse(flag);
        this.iSysStruAuditService.save((Object)sysStruAudit);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            SysStaffAudit sysStaffAudit = new SysStaffAudit();
            CopyPropertieUtils.copyProperties((Object)sysStaffAudit, (Object)sysStaff);
            sysStaffAudit.setStruId(sysStruAudit.getStruId());
            if (DELETE.equals(flag)) {
                sysStaffAudit.setStruId(sysStruAudit.getStruId());
                sysStaffAudit.setRealStaffId(sysStaff.getStaffId());
                sysStaffAudit.setStaffId(null);
            }
            this.iSysStaffAuditService.save((Object)sysStaffAudit);
        }
        if (ToolUtil.isNotEmpty((Object)((Object)sysOffice))) {
            SysOfficeAudit sysOfficeAudit = new SysOfficeAudit();
            CopyPropertieUtils.copyProperties((Object)sysOfficeAudit, (Object)sysOffice);
            sysOfficeAudit.setStruId(sysStruAudit.getStruId());
            if (DELETE.equals(flag)) {
                sysOfficeAudit.setStruId(sysStruAudit.getStruId());
                sysOfficeAudit.setRealOfficeId(sysOffice.getOfficeId());
                sysOfficeAudit.setOfficeId(null);
            }
            this.iSysOfficeAuditService.save((Object)sysOfficeAudit);
        }
    }

    @Override
    public List<SysStruRule> getOrgRoleByCode(String orgType, String isRoot) {
        return this.sysStruRuleMapper.getOrgRoleByCode(orgType, isRoot);
    }

    @Override
    public List<JSTreeModel> getOrgTreeById(String orgId, String isEmployee) {
        return this.sysStruMapper.getOrgTreeById(orgId, isEmployee);
    }

    @Override
    public List<JSTreeModel> selfRoleTree(String[] roleIds) {
        return this.sysStruMapper.selfRoleTree(roleIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrgTreeOrder(JSONArray treeArr) {
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = new JSONObject();
            json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("struOrder");
            this.sysStruMapper.updateOrderById(id, Integer.parseInt(order));
        }
        this.abstractPushMsgMatcher.insertOperation("organ", "update", treeArr, "");
        if (treeArr.size() != 0 && !ToolUtil.equals((Object)"9", (Object)((SysOrgan)((Object)this.sysOrganMapper.selectById((Serializable)((Object)((SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)treeArr.getJSONObject(0).getString("id"))))).getOrganId())))).getOrganType())) {
            this.bpmAbstractPushMsgMatcher.pushOrganSort(null, null, treeArr);
        }
    }

    @Override
    public List<JSTreeModel> getUserTree() {
        return this.sysStruMapper.getUserTree();
    }

    @Override
    public List<String> getEmpolyeeId(List<String> list6) {
        return this.sysStruMapper.getEmpolyeeId(list6);
    }

    @Override
    public List<ProxyTreeVo> getProxyTree(String[] proxys) {
        return this.sysStruMapper.getProxyTree(proxys);
    }

    @Override
    public List<JSTreeModel> getUserOrderTree(String orgId) {
        return this.sysStruMapper.getUserOrderTree(orgId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject delOrgById(String orgId) {
        this.iSysOrgEventService.beforeDel(orgId);
        List<Map<String, Object>> orgList = this.sysStruMapper.getOrgListByParentId(orgId);
        List<Map<String, Object>> userList = this.sysUsersMapper.getUsersByOrgId(orgId);
        List<Map<String, Object>> roleList = this.sysRolesMapper.getRolesByOrgId(orgId);
        List<Map<String, Object>> noRoleList = this.sysConfRolesetMapper.getRolesByOrgId(orgId);
        List<SysStruAssistOrgan> assistOrganChildrenList = this.iSysStruAssistOrganService.getAssistOrganByParent(orgId);
        Boolean isDel = true;
        StringBuffer msg = new StringBuffer();
        msg.append("\u65e0\u6cd5\u5220\u9664\uff01");
        StringBuffer reason = new StringBuffer();
        Boolean hasOther = false;
        if (ToolUtil.isNotEmpty(orgList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u6216\u4eba\u5458\uff01");
            hasOther = true;
        }
        if (ToolUtil.isNotEmpty(userList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u5173\u8054\u7528\u6237\uff01");
            hasOther = true;
        }
        if (ToolUtil.isNotEmpty(roleList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u5173\u8054\u89d2\u8272\uff01");
            hasOther = true;
        }
        if (ToolUtil.isNotEmpty(noRoleList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u5173\u8054\u4e0d\u76f8\u5bb9\u89d2\u8272\uff01");
            hasOther = true;
        }
        if (ToolUtil.isNotEmpty(assistOrganChildrenList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u4e0b\u7ea7\u517c\u4efb\u4eba\u5458\uff01");
            hasOther = true;
        }
        if (hasOther.booleanValue()) {
            msg.append("\uff08");
            msg.append(reason);
            msg.append("\uff09");
        }
        this.iSysOrgEventService.afterDel(orgId);
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        if (!this.iSysStruAuditService.checkCanOperate(orgId)) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
            return json;
        }
        if (isDel.booleanValue()) {
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
                SysStru sysStru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)orgId)));
                SysStruAudit sysStruAudit = new SysStruAudit();
                CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
                sysStruAudit.setStruId(null);
                sysStruAudit.setRealStruId(sysStru.getStruId());
                sysStruAudit.setState("0");
                sysStruAudit.setInUse("3");
                this.iSysStruAuditService.save((Object)sysStruAudit);
                json.put("msg", (Object)"\u5220\u9664\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.sysStruMapper.deleteByOrgId(orgId);
                this.abstractPushMsgMatcher.insertOperation("organ", "delete", orgId, "");
                if (!ToolUtil.equals((Object)"9", (Object)((SysOrgan)((Object)this.sysOrganMapper.selectById((Serializable)((Object)((SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)orgId)))).getOrganId())))).getOrganType())) {
                    this.bpmAbstractPushMsgMatcher.delete("organ", orgId, "");
                }
                json.put("msg", (Object)"\u5220\u9664\u6210\u529f\uff01");
            }
        } else {
            json.put("msg", (Object)msg);
        }
        return json;
    }

    @Override
    public Long getMaxOrderById(String parentId) {
        return this.sysStruMapper.getMaxOrderById(parentId);
    }

    @Override
    public Page<Map<String, Object>> getPageList(Page page, String string) {
        page.setRecords(this.sysOrganMapper.selectOrgList(page, "string"));
        return page;
    }

    @Override
    public Page getPrincipalSelectList(Page page, String userName, String departmentName) {
        page.setRecords(this.sysUsersMapper.getPrincipalSelectList(page, userName, departmentName));
        return page;
    }

    @Override
    public Page getPrincipalSelectList(Page page, String userName, String departmentName, String deptId) {
        page.setRecords(this.sysUsersMapper.getGrantPrincipalSelectList(page, userName, departmentName, deptId));
        return page;
    }

    @Override
    public List<JSTreeModel> orgChangeById(String orgId, String isEmployee) {
        return this.sysStruMapper.orgChangeById(orgId, isEmployee);
    }

    @Override
    @Transactional(rollbackFor={SQLException.class})
    public JSONObject orgTreeChange(String orgId, String parentId, String orgType, String isRoot, String changeLevel) {
        this.iSysOrgEventService.beforeOrgChange(orgId, parentId);
        List<Map<String, Object>> map = this.sysStruRuleMapper.getOrgRoleById(parentId, orgType);
        if (ToolUtil.isNotEmpty((Object)isRoot) && ADD.equals(isRoot)) {
            map = this.sysStruRuleMapper.getOrgTypeByType(orgType, isRoot);
        }
        JSONObject json = new JSONObject();
        if (!this.iSysStruAuditService.checkCanOperate(orgId)) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
            return json;
        }
        if (map.size() == 0) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u8f6c\u79fb\u5931\u8d25\uff01\uff08\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff01\uff09");
        } else {
            SysUsers user = null;
            if ("9".equals(orgType) && (user = (SysUsers)((Object)SqlHelper.getObject((Log)this.log, (List)this.sysUsersMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"EMPLOYEE_ID", (Object)orgId))))) != null) {
                if (this.iSysUsersAuditService.adjustEdit(user.getUserId())) {
                    json.put("success", (Object)false);
                    json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
                    return json;
                }
                user.setCorporationId(parentId);
                user.setDepartmentId(parentId);
            }
            Long orderTree = 1L;
            Long maxOrder = this.sysStruMapper.getMaxOrderById(parentId);
            if (ToolUtil.isNotEmpty((Object)maxOrder)) {
                orderTree = maxOrder + 1L;
            }
            BigDecimal struOrder = BigDecimal.valueOf(orderTree);
            Long level = Long.valueOf(changeLevel) + 1L;
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
                SysStru sysStru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)orgId)));
                SysStruAudit sysStruAudit = new SysStruAudit();
                CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
                sysStruAudit.setStruId(null);
                sysStruAudit.setInUse("4");
                sysStruAudit.setStruOrder(struOrder);
                sysStruAudit.setRealStruId(sysStru.getStruId());
                sysStruAudit.setState("0");
                sysStruAudit.setStruLevel(BigDecimal.valueOf(level));
                sysStruAudit.setParentId(parentId);
                this.iSysStruAuditService.save((Object)sysStruAudit);
                if (user != null) {
                    SysUsersAudit sysUsersAudit = new SysUsersAudit();
                    CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)user);
                    sysUsersAudit.setIsAudit("0");
                    sysUsersAudit.setCreateTime(new Date());
                    sysUsersAudit.setCurrentStatus("3");
                    this.sysUsersAuditMapper.insert((Object)sysUsersAudit);
                }
                json.put("success", (Object)true);
                json.put("msg", (Object)"\u8f6c\u79fb\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.sysStruMapper.orgTreeChange(orgId, parentId, struOrder, level);
                QueryWrapper wrapper = new QueryWrapper();
                ((QueryWrapper)wrapper.eq((Object)"stru_id", (Object)orgId)).eq((Object)"assist_parent_id", (Object)parentId);
                this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
                if (user != null) {
                    this.sysUsersMapper.updateById((Object)user);
                    this.bpmAbstractPushMsgMatcher.pushUser(user, "update", null);
                } else {
                    this.bpmAbstractPushMsgMatcher.pushOrgan((SysOrgan)((Object)this.sysOrganMapper.selectById((Serializable)((Object)orgId))), (SysStru)((Object)this.sysStruMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"organ_id", (Object)orgId))), "update");
                }
                json.put("success", (Object)true);
                json.put("msg", (Object)"\u8f6c\u79fb\u6210\u529f\uff01");
                SysStru sysStru = new SysStru();
                sysStru.setStruId(orgId);
                sysStru.setParentId(parentId);
                sysStru.setStruOrder(struOrder);
                sysStru.setStruLevel(new BigDecimal(level));
                JSONObject object = new JSONObject();
                object.put("sysStru", (Object)sysStru);
                this.abstractPushMsgMatcher.insertOperation("organ", "update", object, "");
            }
            this.iSysOrgEventService.afterOrgChange(orgId, parentId);
        }
        return json;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMoveNode(String orgId, boolean isUp) {
        SysStru thatStru;
        SysStru thisStru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)orgId)));
        QueryWrapper ew = (QueryWrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)thisStru.getParentId());
        if (isUp) {
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)ew.lt((Object)"STRU_ORDER", (Object)thisStru.getStruOrder())).eq((Object)"in_use", (Object)ADD)).ne((Object)"stru_type", (Object)"9")).orderByDesc((Object)"STRU_ORDER");
        } else {
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)ew.gt((Object)"STRU_ORDER", (Object)thisStru.getStruOrder())).eq((Object)"in_use", (Object)ADD)).ne((Object)"stru_type", (Object)"9")).orderByAsc((Object)"STRU_ORDER");
        }
        List thatStruList = this.sysStruMapper.selectList((Wrapper)ew);
        if (thatStruList.size() > 0 && (thatStru = (SysStru)((Object)thatStruList.get(0))) != null) {
            BigDecimal temp = thisStru.getStruOrder();
            thisStru.setStruOrder(thatStru.getStruOrder());
            thatStru.setStruOrder(temp);
            this.sysStruMapper.updateById((Object)thisStru);
            JSONObject object = new JSONObject();
            object.put("sysStru", (Object)thisStru);
            this.abstractPushMsgMatcher.insertOperation("organ", "update", object, "");
            this.sysStruMapper.updateById((Object)thatStru);
            JSONObject object1 = new JSONObject();
            object1.put("sysStru", (Object)thatStru);
            this.abstractPushMsgMatcher.insertOperation("organ", "update", object1, "");
            this.bpmAbstractPushMsgMatcher.pushOrganSort(thisStru, thatStru, null);
        }
    }

    @Override
    public List<JSTreeModel> getUserTree(String parentId) {
        return this.sysStruMapper.getLazyLoadingUserTree(parentId);
    }

    @Override
    public JSTreeModel getOneOrg(String struId) {
        return this.sysStruMapper.getOneOrg(struId);
    }

    @Override
    public List<JSTreeModel> getGradeStruTree(List<JSTreeModel> list1, int currentLevel) {
        ShiroUser shiroUser = ShiroKit.getUser();
        String currentStruId = shiroUser.getEmployeeId();
        String currentUserId = shiroUser.getId();
        String deptId = shiroUser.getDeptId();
        List<SysStru> list = this.sysStruMapper.getParentStruTree(currentLevel);
        List<SysStru> childList = this.sysStruMapper.getChildStruTree(currentLevel - 1);
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (SysStru sysStru : list) {
            String id = sysStru.getStruId();
            String parentId = sysStru.getParentId();
            idMap.put(id, parentId);
        }
        String struId = currentStruId;
        String parentId = currentStruId;
        ArrayList<String> idList = new ArrayList<String>();
        do {
            struId = parentId;
            parentId = (String)idMap.get(struId);
            idList.add(struId);
            idList.add(parentId);
        } while (idMap.containsKey(parentId));
        HashMap<String, String> childIdMap = new HashMap<String, String>();
        for (SysStru sysStru : childList) {
            String id = sysStru.getStruId();
            String parentId2 = sysStru.getParentId();
            childIdMap.put(id, parentId2);
        }
        ArrayList<String> childIdList = new ArrayList<String>();
        struId = deptId;
        this.getAllChilden(childIdMap, childIdList, struId);
        ArrayList<JSTreeModel> rtnList = new ArrayList<JSTreeModel>();
        for (JSTreeModel jsTreeModel : list1) {
            String type;
            String modelId = jsTreeModel.getId();
            String struLevelStr = jsTreeModel.getStruLevel();
            int struLevel = 0;
            if (struLevelStr != null) {
                struLevel = Integer.parseInt(struLevelStr);
            }
            if (struLevel == currentLevel - 1) {
                jsTreeModel.getState().put("changeDisabled", true);
            }
            if (struLevel < currentLevel) {
                if (!idList.contains(modelId)) continue;
                if (struLevel < currentLevel - 1) {
                    jsTreeModel.getState().put("gradeDisabled", true);
                }
                rtnList.add(jsTreeModel);
                continue;
            }
            if (struLevel == currentLevel) {
                String parent = jsTreeModel.getParent();
                if (!deptId.equals(parent)) continue;
                type = jsTreeModel.getType();
                rtnList.add(jsTreeModel);
                if ("ORGANROLE".equals(type)) {
                    jsTreeModel.getState().put("isOrganRoleNode", true);
                    continue;
                }
                if ("USER".equals(type)) {
                    if (!modelId.equals(currentUserId)) continue;
                    jsTreeModel.getState().put("currentUser", true);
                    continue;
                }
                if (!modelId.equals(currentStruId)) continue;
                jsTreeModel.getState().put("currentEmployee", true);
                continue;
            }
            String id = jsTreeModel.getId();
            type = jsTreeModel.getType();
            if ("ORGANROLE".equals(type)) {
                id = jsTreeModel.getParent();
                jsTreeModel.getState().put("isOrganRoleNode", true);
            }
            if ("USER".equals(type)) {
                id = jsTreeModel.getEmployeeId();
            }
            if (!childIdList.contains(id)) continue;
            rtnList.add(jsTreeModel);
        }
        return rtnList;
    }

    @Override
    public List<JSTreeModel> getOrgTree(String isEmployee, String parentId) {
        return this.sysStruMapper.getLazyLoadingOrgTree(isEmployee, parentId);
    }

    @Override
    public OrganInfoVo getOldOrgInfoById(String struId) {
        return this.sysStruMapper.getOldOrgInfoById(struId);
    }

    @Override
    public List<Object> getRoleOrgUser(Page<Object> page, String roleId, String orgId, String name, String account) {
        ShiroUser user = ShiroKit.getUser();
        if (user.isGradeadmin()) {
            String deptId = user.getDeptId();
            if (orgId == null) {
                return new ArrayList<Object>();
            }
            SysStru stru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)orgId)));
            if (stru == null) {
                return new ArrayList<Object>();
            }
            Integer checkResult = this.sysStruMapper.checkIsGradeStru(deptId, orgId);
            if (checkResult == 1) {
                return this.sysStruMapper.getRoleOrgUser(page, roleId, orgId, name, account);
            }
            return new ArrayList<Object>();
        }
        return this.sysStruMapper.getRoleOrgUser(page, roleId, orgId, name, account);
    }

    @Override
    public List<JSTreeModel> geOrganRoleTree() {
        return this.sysStruMapper.getOrganRoleTree();
    }

    @Override
    public List<JSTreeModel> geOrganRoleTree(String parentId) {
        return this.sysStruMapper.getLazyLoadingOrganRoleTree(parentId);
    }

    private List<String> getKey(Map<String, String> map, Object value) {
        Set<Map.Entry<String, String>> set = map.entrySet();
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!entry.getValue().equals(value)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    private void getAllChilden(Map<String, String> childIdMap, List<String> childIdList, String struId) {
        List<String> tmpList;
        if (childIdMap.containsValue(struId) && (tmpList = this.getKey(childIdMap, struId)).size() > 0) {
            for (String string : tmpList) {
                childIdList.add(string);
                this.getAllChilden(childIdMap, childIdList, string);
            }
        }
    }

    @Override
    public void exportData(List<String> idList, HttpServletResponse response) {
        List strus = this.sysStruMapper.selectBatchIds(idList);
        ArrayList<String> organIdList = new ArrayList<String>();
        ArrayList<String> struTypeList = new ArrayList<String>();
        for (SysStru sysStru : strus) {
            String organId = sysStru.getOrganId();
            String struType = sysStru.getStruType();
            organIdList.add(organId);
            struTypeList.add(struType);
        }
        List organs = this.sysOrganMapper.selectBatchIds(organIdList);
        List organTypes = this.sysOrganTypeMapper.selectBatchIds(struTypeList);
        List offices = this.sysOfficeMapper.selectList((Wrapper)new QueryWrapper().in((Object)"STRU_ID", idList));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("strus", strus);
        data.put("organs", organs);
        data.put("organTypes", organTypes);
        data.put("offices", offices);
        data.put("export_type", "organ");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "organ_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile(serializeData, fileName, response);
    }

    @Override
    @Transactional
    public Tip importData(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize(content);
        String export_type = (String)data.get("export_type");
        if (!"organ".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + Constants.EXPORT_MAP.get("organ"));
        }
        List strus = (List)data.get("strus");
        List organs = (List)data.get("organs");
        List organTypes = (List)data.get("organTypes");
        List offices = (List)data.get("offices");
        Map<String, Integer> struCount = this.insertOrUpdateList(strus);
        Map<String, Integer> organCount = this.insertOrUpdateList(organs);
        Map<String, Integer> organTypeCount = this.insertOrUpdateList(organTypes);
        Map<String, Integer> officeCount = this.insertOrUpdateList(offices);
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\u3002\u7ec4\u7ec7\u7ed3\u6784\u65b0\u589e\u6570\u636e" + struCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + struCount.get("update") + "\u6761\uff1b\u7ec4\u7ec7\u673a\u6784\u65b0\u589e\u6570\u636e" + organCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + organCount.get("update") + "\u6761\uff1b\u7ec4\u7ec7\u7c7b\u578b\u65b0\u589e\u6570\u636e" + organTypeCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + organTypeCount.get("update") + "\u6761\u3002");
        return success;
    }

    @Override
    public JSONObject getImgUrl(HttpServletRequest request) {
        List<SysOrganTypeVo> list = this.sysOrganTypeMapper.getOrganTypeList(new Page(0L, 99999L), null, null);
        JSONObject json = new JSONObject();
        for (SysOrganTypeVo sysOrganTypeVo : list) {
            JSONObject jsonObject = new JSONObject();
            if (request instanceof HttpServletRequest) {
                HttpServletRequest hreq = request;
                String contextPath = "";
                contextPath = hreq.getSession().getServletContext().getContextPath();
                jsonObject.put("icon", (Object)(contextPath + sysOrganTypeVo.getImgUrl()));
            } else {
                jsonObject.put("icon", (Object)(request.getServletContext().getContextPath() + sysOrganTypeVo.getImgUrl()));
            }
            json.put(sysOrganTypeVo.getOrganType(), (Object)jsonObject);
        }
        return json;
    }

    @Override
    public List<JSTreeModel> getOrgTreeById(String orgId, String isEmployee, String isHead) {
        Boolean isRoot = Boolean.valueOf(isHead);
        List<JSTreeModel> result = this.getOrgTreeById(orgId, isEmployee);
        if (isRoot.booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId("11");
            root.setCode("");
            root.setText("\u7ec4\u7ec7\u673a\u6784");
            root.setStruLevel("0");
            root.setParent("#");
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return result;
    }

    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                Object object = objects.get(i);
                if (object instanceof SysStru) {
                    SysStru stru = (SysStru)((Object)object);
                    if (this.updateById((Object)stru)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.save((Object)stru);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysOrgan) {
                    SysOrgan organ = (SysOrgan)((Object)object);
                    if (SqlHelper.retBool((Integer)this.sysOrganMapper.updateById((Object)organ))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysOrganMapper.insert((Object)organ);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysOffice) {
                    SysOffice office = (SysOffice)((Object)object);
                    if (SqlHelper.retBool((Integer)this.sysOfficeMapper.updateById((Object)office))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysOfficeMapper.insert((Object)office);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysOrganType) {
                    SysOrganType organType = (SysOrganType)((Object)object);
                    if (SqlHelper.retBool((Integer)this.sysOrganTypeMapper.updateById((Object)organType))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysOrganTypeMapper.insert((Object)organType);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }
}

