/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.jxdinfo.hussar.bpm.messagepush.BpmAbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysStruAudit;
import com.jxdinfo.hussar.bsp.audit.service.ISysOfficeAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysOrganAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.audit.service.impl.SysStruAssistOrganAuditServiceImpl;
import com.jxdinfo.hussar.bsp.audit.util.CopyPropertieUtils;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysStaff;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStaffService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.DataExportUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysEmployeeServiceImpl
extends ServiceImpl<SysStruMapper, SysStru>
implements ISysEmployeeService {
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private GlobalProperties globalProperties;
    @Autowired
    ISysOrganAuditService iSysOrganAuditService;
    @Autowired
    ISysStruAuditService iSysStruAuditService;
    @Autowired
    ISysStaffAuditService iSysStaffAuditService;
    @Autowired
    ISysOfficeAuditService iSysOfficeAuditService;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private BpmAbstractPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    ISysStruAssistOrganService iSysStruAssistOrganService;
    @Resource
    SysStruAssistOrganAuditServiceImpl sysStruAssistOrganAuditService;

    @Override
    public List<String> selectRole(String userId) {
        return this.sysStruMapper.selectRole(userId);
    }

    @Override
    public String selectStruLevel(String empolyeeId) {
        return this.sysStruMapper.selectStruLevel(empolyeeId);
    }

    @Override
    public List<String> selectGradeadminRole(String userId) {
        return this.sysStruMapper.selectGradeadminRole(userId);
    }

    @Override
    public List<JSTreeModel> getEmployeeTree(String isEmployee) {
        return this.sysStruMapper.getOrgTree(isEmployee);
    }

    @Override
    public List<JSTreeModel> getEmployeeTreeById(String orgId) {
        return this.sysStruMapper.getEmployeeTreeById(orgId, false);
    }

    @Override
    public List<JSTreeModel> getEmployeeTree(String isEmployee, String parentId) {
        return this.sysStruMapper.getLazyLoadingStfTree(isEmployee, parentId);
    }

    @Override
    public List<JSTreeModel> getEmployeeTreeById(String orgId, boolean isUserOnOneEmp) {
        return this.sysStruMapper.getEmployeeTreeById(orgId, isUserOnOneEmp);
    }

    @Override
    public void addStaff(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        Date date = new Date();
        String userId = ShiroKit.getUser().getId();
        sysOrgan.setInUse("1");
        sysOrgan.setCreateTime(date);
        sysOrgan.setCreator(userId);
        sysStru.setStruId(null);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setIsLeaf("0");
        sysStru.setInUse("1");
        sysStru.setStruPath("");
        sysStru.setStruLevel(sysStru.getStruLevel().add(new BigDecimal(1)));
        sysStru.setCreateTime(date);
        sysStru.setCreator(userId);
        Long struOrder = 1L;
        Long maxOrder = this.orgMaintenanceService.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            struOrder = maxOrder + 1L;
        }
        sysStru.setStruOrder(new BigDecimal(struOrder));
        this.sysOrganMapper.insert((Object)sysOrgan);
        sysStru.setOrganId(sysOrgan.getOrganId());
        this.sysStruMapper.insert((Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            sysStaff.setStruId(sysStru.getStruId());
            sysStaff.setName(sysOrgan.getOrganName());
            this.sysStaffMapper.insert((Object)sysStaff);
        }
        JSONObject object = new JSONObject();
        object.put("sysOrgan", (Object)sysOrgan);
        object.put("sysStru", (Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            object.put("sysStaff", (Object)sysStaff);
        }
        this.abstractPushMsgMatcher.insertOperation("person", "add", object, "");
    }

    @Override
    public Tip frontEditStaff(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String ids) {
        Date date = new Date();
        String userId = ShiroKit.getUser().getId();
        sysOrgan.setLastEditor(userId);
        sysOrgan.setLastTime(date);
        sysStru.setLastEditor(userId);
        sysStru.setLastTime(date);
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
            this.auditAdd(sysOrgan, sysStru, sysStaff, "2");
            this.sysStruAssistOrganAuditService.saveAssistOrganAudit(ids, sysStru.getStruId());
            return new ErrorTip(HttpCode.OK.value().intValue(), "\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
        }
        this.sysOrganMapper.updateById((Object)sysOrgan);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        this.sysStruMapper.updateById((Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            sysStaff.setName(sysOrgan.getOrganName());
            this.sysStaffService.saveOrUpdate((Object)sysStaff);
        }
        String sysStruId = sysStru.getStruId();
        Boolean saveAssistOrgan = this.iSysStruAssistOrganService.saveAssistOrgan(ids, sysStruId);
        JSONObject object = new JSONObject();
        object.put("sysOrgan", (Object)sysOrgan);
        object.put("sysStru", (Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            object.put("sysStaff", (Object)sysStaff);
        }
        this.abstractPushMsgMatcher.insertOperation("person", "update", object, "");
        return new ErrorTip(HttpCode.OK.value().intValue(), "\u4fee\u6539\u6210\u529f\uff01");
    }

    @Override
    public Tip editStaff(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        Date date = new Date();
        String userId = ShiroKit.getUser().getId();
        sysOrgan.setLastEditor(userId);
        sysOrgan.setLastTime(date);
        sysStru.setLastEditor(userId);
        sysStru.setLastTime(date);
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
            this.auditAdd(sysOrgan, sysStru, sysStaff, "2");
            return new ErrorTip(HttpCode.OK.value().intValue(), "\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
        }
        this.sysOrganMapper.updateById((Object)sysOrgan);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        this.sysStruMapper.updateById((Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            sysStaff.setName(sysOrgan.getOrganName());
            this.sysStaffService.saveOrUpdate((Object)sysStaff);
        }
        JSONObject object = new JSONObject();
        object.put("sysOrgan", (Object)sysOrgan);
        object.put("sysStru", (Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            object.put("sysStaff", (Object)sysStaff);
        }
        this.abstractPushMsgMatcher.insertOperation("person", "update", object, "");
        return new ErrorTip(HttpCode.OK.value().intValue(), "\u4fee\u6539\u6210\u529f\uff01");
    }

    private void auditAdd(SysOrgan sysOrgan, SysStru sysStru, SysStaff sysStaff, String flag) {
        SysOrganAudit sysOrganAudit = new SysOrganAudit();
        CopyPropertieUtils.copyProperties((Object)sysOrganAudit, (Object)sysOrgan);
        sysOrganAudit.setInUse(flag);
        if ("2".equals(flag)) {
            sysOrganAudit.setRealOrganId(sysOrgan.getOrganId());
            sysOrganAudit.setOrganId(null);
        }
        this.iSysOrganAuditService.save((Object)sysOrganAudit);
        SysStruAudit sysStruAudit = new SysStruAudit();
        CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
        sysStruAudit.setOrganId(sysOrganAudit.getOrganId());
        if ("2".equals(flag)) {
            sysStruAudit.setRealStruId(sysStru.getStruId());
            sysStruAudit.setStruId(null);
        }
        sysStruAudit.setState("0");
        sysStruAudit.setInUse(flag);
        this.iSysStruAuditService.save((Object)sysStruAudit);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            SysStaffAudit sysStaffAudit = new SysStaffAudit();
            CopyPropertieUtils.copyProperties((Object)sysStaffAudit, (Object)sysStaff);
            sysStaffAudit.setStruId(sysStruAudit.getStruId());
            if ("2".equals(flag)) {
                sysStaffAudit.setRealStaffId(sysStaff.getStaffId());
                sysStaffAudit.setStaffId(null);
            }
            this.iSysStaffAuditService.save((Object)sysStaffAudit);
        }
    }

    @Override
    public void exportData(List<String> idList, HttpServletResponse response) {
        List strus = this.sysStruMapper.selectBatchIds(idList);
        List staffs = this.sysStaffMapper.selectList((Wrapper)new QueryWrapper().in((Object)"STRU_ID", idList));
        List users = this.sysUsersMapper.selectList((Wrapper)new QueryWrapper().in((Object)"EMPLOYEE_ID", idList));
        ArrayList<String> organIdList = new ArrayList<String>();
        for (SysStru sysStru : strus) {
            String organId = sysStru.getOrganId();
            organIdList.add(organId);
        }
        List organs = this.sysOrganMapper.selectBatchIds(organIdList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("strus", strus);
        data.put("organs", organs);
        data.put("staffs", staffs);
        data.put("users", users);
        data.put("export_type", "employee");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "employee_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile(serializeData, fileName, response);
    }

    @Override
    @Transactional
    public Tip importData(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize(content);
        String export_type = (String)data.get("export_type");
        if (!"employee".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + Constants.EXPORT_MAP.get("employee"));
        }
        List strus = (List)data.get("strus");
        List organs = (List)data.get("organs");
        List staffs = (List)data.get("staffs");
        List users = (List)data.get("users");
        Map<String, Integer> struCount = this.insertOrUpdateList(strus);
        Map<String, Integer> organCount = this.insertOrUpdateList(organs);
        Map<String, Integer> staffsCount = this.insertOrUpdateList(staffs);
        Map<String, Integer> usersCount = this.insertOrUpdateList(users);
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\u3002\u4eba\u5458\u65b0\u589e\u6570\u636e" + struCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + struCount.get("update") + "\u6761\uff1b\u4eba\u5458\u8be6\u60c5\u65b0\u589e\u6570\u636e" + staffsCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + staffsCount.get("update") + "\u6761\u3002");
        return success;
    }

    @Override
    public List<JSTreeModel> getEmployeeTree(String isEmployee, String parentId, String isExport) {
        ShiroUser shiroUser = ShiroKit.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String empolyeeId = shiroUser.getEmployeeId();
            String struLevel = this.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId("11");
        root.setCode("11");
        root.setText("\u4eba\u5458\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent("#");
        root.setStruLevel("0");
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        List<Object> list = new ArrayList();
        ArrayList<JSTreeModel> list1 = new ArrayList();
        if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)parentId)) {
            if (ToolUtil.equals((Object)"#", (Object)parentId)) {
                parentId = "11";
                result.add(root);
            }
            list1 = this.getEmployeeTree(isEmployee, parentId);
        } else {
            result.add(root);
            list1 = this.getEmployeeTree(isEmployee);
        }
        list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(list1, level) : list1;
        result.addAll(list);
        if (Boolean.parseBoolean(isExport)) {
            for (JSTreeModel jsTreeModel : result) {
                if (jsTreeModel.getIsEmployee() == null) {
                    jsTreeModel.setState(false, false, true);
                    continue;
                }
                jsTreeModel.setState(false, false, false);
            }
        }
        return result;
    }

    @Transactional
    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                Object object = objects.get(i);
                if (object instanceof SysStru) {
                    SysStru stru = (SysStru)((Object)object);
                    if (this.updateById((Object)stru)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.save((Object)stru);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysOrgan) {
                    SysOrgan organ = (SysOrgan)((Object)object);
                    if (SqlHelper.retBool((Integer)this.sysOrganMapper.updateById((Object)organ))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysOrganMapper.insert((Object)organ);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysStaff) {
                    SysStaff sysStaff = (SysStaff)((Object)object);
                    if (SqlHelper.retBool((Integer)this.sysStaffMapper.updateById((Object)sysStaff))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysStaffMapper.insert((Object)sysStaff);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysUsers) {
                    SysUsers sysUsers = (SysUsers)((Object)object);
                    if (SqlHelper.retBool((Integer)this.sysUsersMapper.updateById((Object)sysUsers))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysUsersMapper.insert((Object)sysUsers);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }
}

