/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.messagepush.BpmAbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.organ.CreateUserSendMailUtil;
import com.jxdinfo.hussar.bsp.organ.dao.StaffUserMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysStaff;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.IStaffUserService;
import com.jxdinfo.hussar.bsp.permit.model.SysUserRole;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.encrypt.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.system.controller.util.GeneratePassword;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StaffUserServiceImpl
extends ServiceImpl<StaffUserMapper, SysStaff>
implements IStaffUserService {
    @Resource
    private StaffUserMapper staffUserMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Autowired
    ISysStruAuditService iSysStruAuditService;
    @Autowired
    ISysUsersAuditService iSysUsersAuditService;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private BpmAbstractPushMsgMatcher bpmAbstractPushMsgMatcher;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addStaffUser(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        Date date = new Date();
        String userId = ShiroKit.getUser().getId();
        sysOrgan.setInUse("1");
        sysOrgan.setCreateTime(date);
        sysOrgan.setCreator(userId);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setOrganId(null);
        sysStru.setIsLeaf("0");
        sysStru.setInUse("1");
        sysStru.setStruPath("");
        Long level = this.staffUserMapper.getMaxLevel(sysStru.getParentId());
        if (ToolUtil.isEmpty((Object)level)) {
            level = 1L;
        }
        sysStru.setStruLevel(new BigDecimal(level));
        Long order = 1L;
        Long maxOrder = this.staffUserMapper.getMaxOrderUnderParent(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            order = maxOrder + 1L;
        }
        sysStru.setStruOrder(new BigDecimal(order));
        sysStru.setCreateTime(date);
        sysStru.setCreator(userId);
        this.sysOrganMapper.insert((Object)sysOrgan);
        sysStru.setOrganId(sysOrgan.getOrganId());
        this.sysStruMapper.insert((Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            sysStaff.setName(sysOrgan.getOrganName());
            sysStaff.setStruId(sysStru.getStruId());
            this.staffUserMapper.insert((Object)sysStaff);
        }
        SysUsers user = new SysUsers();
        user.setUserAccount(sysOrgan.getOrganName());
        user.setUserName(sysOrgan.getOrganName());
        String pass = "";
        pass = this.globalProperties.getCreateUserSendEmail() != false && this.globalProperties.getCreateUserUseDefaultPass() == false ? GeneratePassword.generate(this.globalProperties.getPwdRule()) : this.globalProperties.getDefaultPassword();
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
        user.setPassword(pwd);
        user.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        user.setAccountStatus(UserStatus.OK.getCode());
        user.setSecurityLevel(new BigDecimal(1));
        user.setMaxSessions(new BigDecimal(-1));
        user.setLoginIpLimit("0");
        user.setLoginTimeLimit("0");
        user.setIsSys("0");
        user.setIsCpublic("0");
        user.setCreateTime(date);
        user.setCorporationId(sysStru.getParentId());
        user.setDepartmentId(sysStru.getParentId());
        user.setEmployeeId(sysStru.getStruId());
        Long userOrder = this.sysUsersService.getMaxOrder(user.getCorporationId());
        userOrder = ToolUtil.isEmpty((Object)userOrder) ? Long.valueOf(1L) : Long.valueOf(userOrder + 1L);
        user.setUserOrder(new BigDecimal(userOrder));
        this.sysUsersService.save((Object)user);
        if (this.globalProperties.getCreateUserSendEmail().booleanValue() && user.getEMail() != null) {
            CreateUserSendMailUtil.sendMail(user, pass);
        }
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(user.getUserId());
        userRole.setGrantedRole("public_role");
        userRole.setAdminOption("1");
        userRole.setCreateTime(date);
        userRole.setLastTime(date);
        userRole.setCreator(userId);
        userRole.setLastEditor(userId);
        this.sysUserRoleService.save((Object)userRole);
        JSONObject object = new JSONObject();
        object.put("sysOrgan", (Object)sysOrgan);
        object.put("sysStru", (Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            object.put("sysStaff", (Object)sysStaff);
        }
        object.put("sysUser", (Object)user);
        this.abstractPushMsgMatcher.insertOperation("person", "add", object, "");
        this.bpmAbstractPushMsgMatcher.pushUser(user, "add", sysOrgan.getOrganCode());
        ArrayList<SysUserRole> bpmUserRoleVoList = new ArrayList<SysUserRole>();
        bpmUserRoleVoList.add(userRole);
        this.bpmAbstractPushMsgMatcher.pushUserRole(bpmUserRoleVoList, "add");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editStaffUser(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        SysUsers user;
        Date date = new Date();
        String userId = ShiroKit.getUser().getId();
        sysOrgan.setLastEditor(userId);
        sysOrgan.setLastTime(date);
        this.sysOrganMapper.updateById((Object)sysOrgan);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setLastEditor(userId);
        sysStru.setLastTime(date);
        this.sysStruMapper.updateById((Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            sysStaff.setName(sysOrgan.getOrganName());
            super.saveOrUpdate((Object)sysStaff);
        }
        if (ToolUtil.isNotEmpty((Object)((Object)(user = (SysUsers)((Object)this.sysUsersService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"EMPLOYEE_ID", (Object)sysStru.getStruId())).ne((Object)"ACCOUNT_STATUS", (Object)UserStatus.DELETE.getCode()), false)))))) {
            user.setUserName(sysOrgan.getOrganName());
            this.sysUsersService.updateById((Object)user);
        }
        JSONObject object = new JSONObject();
        object.put("sysOrgan", (Object)sysOrgan);
        object.put("sysStru", (Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            object.put("sysStaff", (Object)sysStaff);
        }
        object.put("sysUser", (Object)user);
        this.abstractPushMsgMatcher.insertOperation("person", "update", object, "");
        this.bpmAbstractPushMsgMatcher.pushUser(user, "update", null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject deleteStaffUser(String struId) {
        JSONObject result = new JSONObject();
        if (!this.iSysStruAuditService.checkCanOperate(struId)) {
            result.put("success", (Object)false);
            result.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
            return result;
        }
        SysStru stru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)struId)));
        stru.setInUse("0");
        SysUsers user = (SysUsers)((Object)this.sysUsersService.getOne((Wrapper)new QueryWrapper().eq((Object)"employee_id", (Object)stru.getStruId()), false));
        if (ToolUtil.isNotEmpty((Object)((Object)user)) && this.iSysUsersAuditService.adjustEdit(user.getUserId())) {
            result.put("success", (Object)false);
            result.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
            return result;
        }
        this.sysStruMapper.updateById((Object)stru);
        SysOrgan organ = (SysOrgan)((Object)this.sysOrganMapper.selectById((Serializable)((Object)stru.getOrganId())));
        organ.setInUse("0");
        this.sysOrganMapper.updateById((Object)organ);
        if (ToolUtil.isNotEmpty((Object)((Object)user))) {
            user.setAccountStatus(UserStatus.DELETE.getCode());
            this.sysUsersService.updateById((Object)user);
        }
        result.put("success", (Object)true);
        result.put("msg", (Object)"\u5220\u9664\u6210\u529f\uff01");
        JSONObject object = new JSONObject();
        object.put("sysOrgan", (Object)organ);
        object.put("sysStru", (Object)stru);
        if (ToolUtil.isNotEmpty((Object)((Object)user))) {
            object.put("sysUser", (Object)user);
        }
        this.abstractPushMsgMatcher.insertOperation("person", "delete", object, "");
        if (ToolUtil.isNotEmpty((Object)((Object)user))) {
            this.bpmAbstractPushMsgMatcher.delete("organ", user.getUserId(), null);
            this.bpmAbstractPushMsgMatcher.delete("userRole", user.getUserId(), "deleteByUserId");
        }
        return result;
    }

    @Override
    public boolean isAccountExist(SysStru stru) {
        boolean flag = false;
        List list = this.sysUsersService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ACCOUNT", (Object)stru.getOrganAlias())).ne((Object)"ACCOUNT_STATUS", (Object)UserStatus.DELETE.getCode())).ne((Object)"EMPLOYEE_ID", (Object)stru.getStruId()));
        if (ToolUtil.isNotEmpty((Object)list)) {
            flag = true;
        }
        return flag;
    }
}

