/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.controller;

import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.organ.dictmap.SysOrganTypeDict;
import com.jxdinfo.hussar.bsp.organ.model.SysOrganType;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.aop.NoRepeatMethod;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/orgType"})
public class SysOrganTypeController
extends BaseController {
    @Resource
    private ISysOrganTypeService iSysOrganTypeService;
    @Resource
    private ISysStruRuleService isSysStruRuleService;

    @RequestMapping(value={"/view"})
    @RequiresPermissions(value={"orgType:view"})
    @BussinessLog(key="/orgType/view", type="04", value="\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u9875\u9762")
    public String view() {
        return "/bsp/organ/sysOrganType.html";
    }

    @RequestMapping(value={"/list"})
    @RequiresPermissions(value={"orgType:search"})
    @ResponseBody
    @NoRepeatMethod(timeout=50L, autoCompletion=false)
    public Map<String, Object> list() {
        String code = super.getPara("code");
        String name = super.getPara("name");
        String page = super.getPara("page");
        String limit = super.getPara("limit");
        if (!StringUtils.isEmpty((String)code)) {
            code = code.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        if (!StringUtils.isEmpty((String)name)) {
            name = name.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        Map<String, Object> result = this.iSysOrganTypeService.getOrganTypeList(page, limit, name, code);
        return result;
    }

    @RequiresPermissions(value={"orgType:orgTypeOption"})
    @RequestMapping(value={"/orgTypeOption"})
    @ResponseBody
    public List<SysOrganType> orgTypeOption() {
        return this.iSysOrganTypeService.getOrgTypeOption();
    }

    @RequiresPermissions(value={"orgType:selectOrg"})
    @RequestMapping(value={"selectOrg"})
    @ResponseBody
    public SysOrganType selectOrg(@RequestBody Map<String, String> map) {
        String orgCode = map.get("parentTypeCode");
        return (SysOrganType)((Object)this.iSysOrganTypeService.getById((Serializable)((Object)orgCode)));
    }

    @RequestMapping(value={"/add"})
    @RequiresPermissions(value={"orgType:add"})
    @BussinessLog(key="/orgType/add", type="01", value="\u6dfb\u52a0\u7ec4\u7ec7\u7c7b\u578b", pk="organType", dict=SysOrganTypeDict.class)
    @ResponseBody
    public Object add(@RequestBody Map<String, String> map) {
        String orgCode = map.get("organType");
        String orgName = map.get("typeName");
        String parentType = map.get("parentType");
        String imgUrl = map.get("imgUrl");
        SysOrganType org = (SysOrganType)((Object)this.iSysOrganTypeService.getById((Serializable)((Object)orgCode)));
        if (org != null) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u7ec4\u7ec7\u7c7b\u578b\u4ee3\u7801\u5df2\u5b58\u5728\uff01");
        }
        List orgList = this.iSysOrganTypeService.list((Wrapper)new QueryWrapper().eq((Object)"TYPE_NAME", (Object)orgName));
        if (orgList.size() != 0) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        Date nowTime = new Date();
        SysOrganType sysOrganType = new SysOrganType();
        sysOrganType.setTypeName(orgName);
        sysOrganType.setOrganType(orgCode);
        sysOrganType.setImgUrl(imgUrl);
        sysOrganType.setCreateTime(nowTime);
        sysOrganType.setLastTime(nowTime);
        sysOrganType.setParentType(parentType);
        sysOrganType.setInUse("1");
        sysOrganType.setIsSystem("0");
        sysOrganType.setCreator(ShiroKit.getUser().getId());
        sysOrganType.setLastEditor(ShiroKit.getUser().getId());
        Integer count = this.iSysOrganTypeService.add(sysOrganType);
        if (ToolUtil.equals((Object)count, (Object)1)) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/edit"})
    @RequiresPermissions(value={"orgType:edit"})
    @BussinessLog(key="/orgType/edit", type="03", value="\u4fee\u6539\u7ec4\u7ec7\u7c7b\u578b", pk="organType", dict=SysOrganTypeDict.class)
    @ResponseBody
    public Object edit(@RequestBody Map<String, String> map) {
        List orgList;
        String oldOrgName;
        String orgCode = map.get("organType");
        String orgName = map.get("typeName");
        if (!orgName.equals(oldOrgName = map.get("oldOrgName")) && (orgList = this.iSysOrganTypeService.list((Wrapper)new QueryWrapper().eq((Object)"TYPE_NAME", (Object)orgName))).size() != 0) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        SysOrganType before = (SysOrganType)((Object)this.iSysOrganTypeService.getById((Serializable)((Object)orgCode)));
        LogObjectHolder.me().set((Object)before);
        SysOrganType sysOrganType = new SysOrganType();
        sysOrganType.setTypeName(orgName);
        sysOrganType.setOrganType(orgCode);
        sysOrganType.setLastTime(new Date());
        sysOrganType.setLastEditor(ShiroKit.getUser().getId());
        Integer count = this.iSysOrganTypeService.edit(sysOrganType);
        if (ToolUtil.equals((Object)count, (Object)1)) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/delByIds"})
    @RequiresPermissions(value={"orgType:delete"})
    @BussinessLog(key="/orgType/delByIds", type="02", value="\u5220\u9664\u7ec4\u7ec7\u7c7b\u578b")
    @ResponseBody
    public Object delByIds(@RequestBody Map<String, String> map) {
        String idStr = map.get("ids");
        List<String> ids = Arrays.asList(idStr.split(","));
        List orgList = this.iSysOrganTypeService.list((Wrapper)new QueryWrapper().in((Object)"PARENT_TYPE", ids));
        List topOrg = this.isSysStruRuleService.list((Wrapper)new QueryWrapper().in((Object)"SYS_ORGAN_TYPE", ids));
        List dowOrg = this.isSysStruRuleService.list((Wrapper)new QueryWrapper().in((Object)"ORGAN_TYPE", ids));
        if (orgList.size() != 0 || topOrg.size() != 0 || dowOrg.size() != 0) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01\uff08\u7ec4\u7ec7\u7c7b\u578b\u5df2\u5e94\u7528\uff09");
        }
        boolean flag = this.iSysOrganTypeService.delByIds(ids);
        if (flag) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u5220\u9664\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01");
    }
}

