/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.bsp.organ.dictmap.StruDict;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysStaff;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.IStaffUserService;
import com.jxdinfo.hussar.bsp.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStaffService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.SysOrganTypeVo;
import com.jxdinfo.hussar.bsp.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/employee"})
public class SysEmployeeController
extends BaseController {
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private IStaffUserService staffUserService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private ISysDicRefService iSysDicRefService;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private GlobalProperties globalProperties;
    @Autowired
    ISysStruAuditService iSysStruAuditService;
    @Autowired
    ISysStruService iSysStruService;
    @Autowired
    ISysStruRuleService iSysStruRuleService;
    @Autowired
    private SysStruRuleMapper sysStruRuleMapper;

    @BussinessLog(key="/employee/employeeList", type="04", value="\u804c\u5de5\u7ef4\u62a4\u9875\u9762")
    @RequestMapping(value={"/employeeList"})
    @RequiresPermissions(value={"employee:employeeList"})
    public String employeeMaintenance(Model model, HttpServletRequest request) {
        JSONObject json = new JSONObject();
        List<SysOrganTypeVo> list = this.sysOrganTypeMapper.getOrganTypeList(new Page(0L, 99999L), null, null);
        for (SysOrganTypeVo sysOrganType : list) {
            JSONObject jsonObject = new JSONObject();
            if (request instanceof HttpServletRequest) {
                HttpServletRequest hreq = request;
                String contextPath = "";
                contextPath = hreq.getSession().getServletContext().getContextPath();
                jsonObject.put("icon", (Object)(contextPath + sysOrganType.getImgUrl()));
            } else {
                jsonObject.put("icon", (Object)(request.getServletContext().getContextPath() + sysOrganType.getImgUrl()));
            }
            json.put(sysOrganType.getOrganType(), (Object)jsonObject);
        }
        model.addAttribute("imgUrl", (Object)json);
        return "/bsp/organ/emplMaintenance.html";
    }

    @RequiresPermissions(value={"employee:employeeTree"})
    @RequestMapping(value={"/employeeTree"})
    @ResponseBody
    public List<JSTreeModel> employeeTree() {
        String isEmployee = super.getPara("isEmployee");
        String parentId = super.getPara("parentId");
        String isExport = super.getPara("isExport");
        return this.sysEmployeeService.getEmployeeTree(isEmployee, parentId, isExport);
    }

    @RequestMapping(value={"/employeeAdd"})
    @RequiresPermissions(value={"employee:add"})
    public String orgInfoAdd(Model model) {
        String parentType = super.getPara("parentType");
        String parentTypeCode = super.getPara("parentTypeCode");
        String orgType = super.getPara("orgType");
        String orgParentId = super.getPara("orgParentId");
        String orgParentCode = super.getPara("orgParentCode");
        String orgParentName = super.getPara("orgParentName");
        String struLevel = super.getPara("struLevel");
        String childNum = super.getPara("childNum");
        String filedName = "ORGAN_CODE_" + orgType;
        String currentCode = this.sysIdtableService.getCurrentCode(filedName, "sys_stru");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        if (parentType.equals(orgType)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.EMPLOYEE_CANNOT_HAVE_SUBORDINATES);
        }
        currentCode = orgParentCode + currentCode;
        parentTypeCode = orgParentCode;
        model.addAttribute("operation", this.iSysDicRefService.getDicListByType("staff_position"));
        model.addAttribute("currentCode", (Object)currentCode);
        model.addAttribute("parentTypeCode", (Object)parentTypeCode);
        model.addAttribute("orgInfo", null);
        model.addAttribute("orgType", (Object)orgType);
        model.addAttribute("orgParentId", (Object)orgParentId);
        model.addAttribute("orgParentCode", (Object)orgParentCode);
        model.addAttribute("orgParentName", (Object)orgParentName);
        model.addAttribute("struLevel", (Object)struLevel);
        model.addAttribute("childNum", (Object)childNum);
        return "/bsp/organ/employeeAdd.html";
    }

    @RequiresPermissions(value={"employee:view"})
    @RequestMapping(value={"/employeeInfo"})
    @BussinessLog(key="/employee/employeeInfo", type="04", value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u67e5\u770b")
    public String employeeInfo(Model model) {
        String struId = super.getPara("struId");
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(struId);
        SysStaff staff = (SysStaff)((Object)this.sysStaffService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)struId), false));
        if (ToolUtil.isEmpty((Object)((Object)staff))) {
            staff = new SysStaff();
        }
        model.addAttribute("orgInfo", (Object)orgInfo);
        model.addAttribute("staff", (Object)staff);
        return "/bsp/organ/employeeView.html";
    }

    @RequiresPermissions(value={"employee:edit"})
    @RequestMapping(value={"/employeeEdit"})
    public String employeeEdit(Model model) {
        String orgId = super.getPara("orgId");
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(orgId);
        SysStaff staff = (SysStaff)((Object)this.sysStaffService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)orgId), false));
        if (ToolUtil.isEmpty((Object)((Object)staff))) {
            staff = new SysStaff();
        }
        model.addAttribute("orgInfo", (Object)orgInfo);
        model.addAttribute("staff", (Object)staff);
        model.addAttribute("operation", this.iSysDicRefService.getDicListByType("staff_position"));
        return "/bsp/organ/employeeEdit.html";
    }

    @RequiresPermissions(value={"employee:save"})
    @RequestMapping(value={"/emplInfoSave"})
    @BussinessLog(key="/employee/employeeAdd", type="01", value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u65b0\u589e", dict=StruDict.class)
    @ResponseBody
    public Tip emplInfoSave(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        SysStru parent = (SysStru)((Object)this.iSysStruService.getById((Serializable)((Object)sysStru.getParentId())));
        List sysStruRules = this.sysStruRuleMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"SYS_ORGAN_TYPE", (Object)parent.getStruType())).eq((Object)"ORGAN_TYPE", (Object)"9"));
        if (sysStruRules == null || sysStruRules.size() < 1) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u65b0\u589e\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff09");
        }
        if (this.globalProperties.isOperateStaffWithUser()) {
            if (this.sysUsersService.isExistAccount(sysOrgan.getOrganName())) {
                return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\uff01\uff09");
            }
            this.staffUserService.addStaffUser(sysStru, sysOrgan, sysStaff);
        } else {
            this.sysEmployeeService.addStaff(sysStru, sysOrgan, sysStaff);
        }
        return SUCCESS_TIP;
    }

    @RequiresPermissions(value={"employee:editSave"})
    @RequestMapping(value={"/emplInfoEditSave"})
    @BussinessLog(key="/employee/employeeEdit", type="03", value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u4fee\u6539", pk="struId,organId", dict=StruDict.class)
    @ResponseBody
    public Tip emplInfoEditSave(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        if (!this.iSysStruAuditService.checkCanOperate(sysStru.getStruId())) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
        }
        if (!this.globalProperties.isOperateStaffWithUser()) {
            return this.sysEmployeeService.editStaff(sysStru, sysOrgan, sysStaff);
        }
        this.staffUserService.editStaffUser(sysStru, sysOrgan, sysStaff);
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(sysStru.getStruId());
        LogObjectHolder.me().set(orgInfo);
        return SUCCESS_TIP;
    }

    @RequiresPermissions(value={"employee:del"})
    @RequestMapping(value={"/delEmployeeById"})
    @ResponseBody
    @BussinessLog(key="/employee/delEmployeeById", type="02", value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u5220\u9664")
    public JSONObject delEmployeeById() {
        String struId = super.getPara("orgId");
        if (this.globalProperties.isOperateStaffWithUser()) {
            return this.staffUserService.deleteStaffUser(struId);
        }
        return this.orgMaintenanceService.delOrgById(struId);
    }

    @RequestMapping(value={"/staffTransfer"})
    @ResponseBody
    @RequiresPermissions(value={"employee:staffTransfer"})
    @BussinessLog(key="/employee/staffTransfer", type="03", value="\u4eba\u5458\u8f6c\u79fb")
    public JSONObject orgTreeChange() {
        String struId = super.getPara("orgId");
        String parentId = super.getPara("parentId");
        String orgType = super.getPara("orgType");
        String isRoot = super.getPara("isRoot");
        String changeLevel = super.getPara("changeLevel");
        return this.orgMaintenanceService.orgTreeChange(struId, parentId, orgType, isRoot, changeLevel);
    }

    @RequiresPermissions(value={"employee:employeeTreeById"})
    @RequestMapping(value={"/employeeTreeById"})
    @ResponseBody
    public List<JSTreeModel> employeeTreeById() {
        String orgId = super.getPara("orgId").trim();
        if (this.globalProperties.isUserOnOneEmp()) {
            return this.sysEmployeeService.getEmployeeTreeById(orgId, true);
        }
        return this.sysEmployeeService.getEmployeeTreeById(orgId);
    }

    @RequestMapping(value={"/exportData"})
    @RequiresPermissions(value={"employee:exportData"})
    @BussinessLog(key="/employee/exportData", type="04", value="\u4eba\u5458\u6570\u636e\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.sysEmployeeService.exportData(idList, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @ResponseBody
    @RequiresPermissions(value={"employee:importData"})
    @BussinessLog(key="/employee/importData", type="03", value="\u4eba\u5458\u6570\u636e\u5bfc\u5165")
    public Tip importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return this.sysEmployeeService.importData(content);
    }
}

