/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.menu.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.bsp.menu.model.MenuInfo;
import com.jxdinfo.hussar.bsp.menu.model.SysMenu;
import com.jxdinfo.hussar.bsp.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.cas.ShiroCasConfiguration;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.util.DataExportUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysMenuManageServiceImpl
extends ServiceImpl<SysMenuMapper, SysMenu>
implements ISysMenuManageService {
    @Resource
    SysMenuMapper sysMenuMapper;
    @Autowired
    private ShiroCasConfiguration casConf;

    @Override
    public List<JSTreeModel> getAllUserMenuTree(List<String> menuId) {
        return this.sysMenuMapper.getAllUserMenuTree(menuId);
    }

    @Override
    public List<JSTreeModel> getUserMenuTree(List<String> resourceIdList) {
        return this.sysMenuMapper.getUserMenuTree(resourceIdList);
    }

    @Override
    public List<JSTreeModel> getMenuTree() {
        return this.sysMenuMapper.getMenuTree();
    }

    @Override
    public void menuInfoSave(SysMenu sysMenu) {
        if (ToolUtil.isEmpty((Object)sysMenu.getMenuId())) {
            sysMenu.setMenuId(null);
            Long max = this.sysMenuMapper.getMaxOrderByParentId(sysMenu.getParentId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                BigDecimal num = new BigDecimal(1);
                BigDecimal order = BigDecimal.valueOf(max);
                sysMenu.setSeq(order.add(num));
            } else {
                sysMenu.setSeq(new BigDecimal(1));
            }
            this.sysMenuMapper.insert((Object)sysMenu);
        } else {
            this.sysMenuMapper.updateById((Object)sysMenu);
        }
    }

    @Override
    public SysMenu getMenuInfo(String menuId) {
        return this.sysMenuMapper.getMenuInfo(menuId);
    }

    @Override
    public JSONObject delMenuById(String menuId) {
        List<Map<String, Object>> menuResult = this.sysMenuMapper.getMenuByParentId(menuId);
        Boolean isDel = true;
        if (ToolUtil.isNotEmpty(menuResult)) {
            isDel = false;
        }
        if (isDel.booleanValue()) {
            this.sysMenuMapper.deleteById((Serializable)((Object)menuId));
        }
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        return json;
    }

    @Override
    public List<JSTreeModel> menuTreeById(String menuId) {
        return this.sysMenuMapper.menuTreeById(menuId);
    }

    @Override
    @Cacheable(value={"menu_info"}, key="'shiro_menus:'+#userId", condition="!'dev'.equals(#profiles)")
    public List<MenuInfo> getMenuByRoles(String userId, List<String> list, String profiles) {
        List<MenuInfo> totalResult = this.sysMenuMapper.getAllMenu();
        List<MenuInfo> lastResult = this.sysMenuMapper.getLastMenuByRoles(list);
        if (this.casConf.getActiveType().equals("CASClient")) {
            for (MenuInfo menuInfo2 : lastResult) {
                if (!menuInfo2.getMenuId().equals("31ad87d822be4b638198509f962dc1f9")) continue;
                lastResult.remove((Object)menuInfo2);
                break;
            }
            for (MenuInfo menuInfo3 : lastResult) {
                if (!menuInfo3.getMenuId().equals("61ab86ffac1840f6ab2476bd98a35e34")) continue;
                lastResult.remove((Object)menuInfo3);
                break;
            }
        }
        HashSet<MenuInfo> resultSet = new HashSet<MenuInfo>();
        for (MenuInfo menuInfo4 : lastResult) {
            this.getOwnMenus(menuInfo4, totalResult, resultSet);
        }
        ArrayList<MenuInfo> arrayList = new ArrayList<MenuInfo>(resultSet);
        arrayList.addAll(lastResult);
        for (MenuInfo menu : arrayList) {
            List<MenuInfo> l = arrayList.stream().filter(menuInfo -> menuInfo.getParentId().equals(menu.getMenuId())).collect(Collectors.toList());
            l.sort((m1, m2) -> m1.getSeq().compareTo(m2.getSeq()));
            menu.setChildMenus(l);
        }
        ArrayList arrayList2 = new ArrayList();
        List<MenuInfo> list2 = arrayList.stream().filter(menuInfo -> "1".equals(menuInfo.getParentId())).collect(Collectors.toList());
        list2.sort((m1, m2) -> m1.getSeq().compareTo(m2.getSeq()));
        return list2;
    }

    public void getOwnMenus(MenuInfo menuInfo, List<MenuInfo> total, Set<MenuInfo> result) {
        for (MenuInfo menu : total) {
            if (!menuInfo.getParentId().equals(menu.getMenuId())) continue;
            result.add(menu);
            if ("1".equals(menu.getMenuId())) break;
            this.getOwnMenus(menu, total, result);
            break;
        }
    }

    @Override
    public void menuTreeChange(String menuId, String parentId) {
        BigDecimal order = new BigDecimal(1);
        Long max = this.sysMenuMapper.getMaxOrderByParentId(parentId);
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            order = BigDecimal.valueOf(max);
            order = order.add(num);
        }
        this.sysMenuMapper.menuTreeChange(menuId, parentId, order);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMoveNode(String menuId, boolean isUp) {
        SysMenu thatMenu;
        SysMenu thisMenu = this.sysMenuMapper.getMenuInfo(menuId);
        List<Object> thatMenuList = new ArrayList();
        thatMenuList = isUp ? this.sysMenuMapper.seletListLt(thisMenu.getParentId(), thisMenu.getSeq()) : this.sysMenuMapper.seletListGt(thisMenu.getParentId(), thisMenu.getSeq());
        if (thatMenuList.size() > 0 && (thatMenu = (SysMenu)((Object)thatMenuList.get(0))) != null) {
            BigDecimal temp = thisMenu.getSeq();
            thisMenu.setSeq(thatMenu.getSeq());
            thatMenu.setSeq(temp);
            thisMenu.setParent(null);
            thisMenu.setResource(null);
            thatMenu.setResource(null);
            this.sysMenuMapper.updateById((Object)thisMenu);
            this.sysMenuMapper.updateById((Object)thatMenu);
        }
    }

    @Override
    public SysMenu getMenuById(String menuId) {
        return (SysMenu)((Object)this.sysMenuMapper.selectById((Serializable)((Object)menuId)));
    }

    @Override
    public void exportMenu(List<String> idList, HttpServletResponse response) {
        List menu = this.sysMenuMapper.selectBatchIds(idList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("menu", menu);
        data.put("export_type", "menu");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "menu_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile(serializeData, fileName, response);
    }

    @Override
    public Tip importMenu(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize(content);
        String export_type = (String)data.get("export_type");
        if (!"menu".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + Constants.EXPORT_MAP.get("menu"));
        }
        List menu = (List)data.get("menu");
        Map<String, Integer> count = this.insertOrUpdateList(menu);
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\uff0c\u65b0\u589e\u6570\u636e" + count.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + count.get("update") + "\u6761\u3002");
        return success;
    }

    @Override
    public Map<String, Integer> insertOrUpdateList(List<SysMenu> menuList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(menuList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = menuList.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                if (super.updateById((Object)menuList.get(i))) {
                    n2 = update;
                    n = update = Integer.valueOf(update + 1);
                } else {
                    super.save((Object)menuList.get(i));
                    n2 = insert;
                    n = insert = Integer.valueOf(insert + 1);
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }
}

