/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.audit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.jxdinfo.hussar.bpm.messagepush.BpmAbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.audit.dao.SysUsersAuditMapper;
import com.jxdinfo.hussar.bsp.audit.model.SysUserIpAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.bsp.audit.service.ISysUserIpAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.bsp.audit.util.CopyPropertieUtils;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.bsp.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUsersAuditServiceImpl
extends ServiceImpl<SysUsersAuditMapper, SysUsersAudit>
implements ISysUsersAuditService {
    @Resource
    private SysUsersAuditMapper sysUsersAuditMapper;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private ISysUserIpAuditService iSysUserIpAuditService;
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private BpmAbstractPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private SysOrganMapper sysOrganMapper;

    @Override
    public List<SysUsersAudit> pageUsersAudit(Page page) {
        return this.sysUsersAuditMapper.pageUsersAudit(page);
    }

    @Override
    public boolean adjust(String userAccount, String currentStatus) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"USER_ACCOUNT", (Object)userAccount)).eq((Object)"CURRENT_STATUS", (Object)currentStatus)).eq((Object)"IS_AUDIT", (Object)"0");
        List list = this.sysUsersAuditMapper.selectList((Wrapper)wrapper);
        return list.size() > 0;
    }

    @Override
    public boolean adjustEdit(String userId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"USER_ID", (Object)userId)).eq((Object)"IS_AUDIT", (Object)"0");
        List list = this.sysUsersAuditMapper.selectList((Wrapper)wrapper);
        return list.size() > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean passAdd(SysUsersAudit sysUsersAudit) {
        sysUsersAudit.setIsAudit("1");
        SysUsers sysUsers = new SysUsers();
        CopyPropertieUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit);
        if (this.sysUsersMapper.insert((Object)sysUsers) > 0 && this.sysUsersAuditMapper.updateById((Object)sysUsersAudit) > 0) {
            this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "add", ((SysOrgan)((Object)this.sysOrganMapper.selectById((Serializable)((Object)sysUsers.getEmployeeId())))).getOrganCode());
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean passEdit(String id) {
        SysUsersAudit sysUsersAudit = (SysUsersAudit)((Object)this.getById((Serializable)((Object)id)));
        SysUsers sysUsers = new SysUsers();
        CopyPropertieUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit);
        sysUsersAudit.setIsAudit("1");
        String ips = this.listAuditIps(sysUsersAudit.getUserId(), "1");
        this.iSysUserIpService.remove((Wrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysUsersAudit.getUserId()));
        this.saveUserIP(sysUsersAudit.getUserId(), ips);
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"USER_ID", (Object)sysUsersAudit.getUserId())).eq((Object)"IS_AUDIT", (Object)"0");
        SysUserIpAudit sysUserIpAudit = new SysUserIpAudit();
        sysUserIpAudit.setIsAudit("1");
        this.iSysUserIpAuditService.update((Object)sysUserIpAudit, (Wrapper)wrapper);
        SysUsers old = (SysUsers)((Object)this.sysUsersMapper.selectById((Serializable)((Object)sysUsers.getUserId())));
        sysUsers.setUserOrder(old.getUserOrder());
        if (!"1".equals(old.getAccountStatus()) && "1".equals(sysUsers.getAccountStatus())) {
            sysUsers.setLastLoginTime(new Date());
        }
        if (SqlHelper.retBool((Integer)this.sysUsersMapper.updateById((Object)sysUsers)) && this.updateById((Object)sysUsersAudit)) {
            this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "update", null);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean passDel(String id) {
        SysUsersAudit sysUsersAudit = (SysUsersAudit)((Object)this.getById((Serializable)((Object)id)));
        sysUsersAudit.setIsAudit("1");
        SysUsers sysUsers = new SysUsers();
        sysUsers.setUserId(sysUsersAudit.getUserId());
        sysUsers.setAccountStatus(UserStatus.DELETE.getCode());
        String employeeId = sysUsers.getEmployeeId();
        sysUsers.setEmployeeId("");
        this.sysStruMapper.updatePrincipal(sysUsers.getUserId());
        this.sysUserroleAuditMapper.delete((Wrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysUsers.getUserId()));
        this.iSysUserIpService.remove((Wrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysUsersAudit.getUserId()));
        if (SqlHelper.retBool((Integer)this.sysUsersMapper.updateById((Object)sysUsers)) && this.updateById((Object)sysUsersAudit)) {
            sysUsers.setEmployeeId(employeeId);
            this.bpmAbstractPushMsgMatcher.delete("organ", sysUsers.getUserId(), null);
            this.bpmAbstractPushMsgMatcher.delete("userRole", sysUsers.getUserId(), "deleteByUserId");
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean reject(String id) {
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        sysUsersAudit.setId(id);
        sysUsersAudit.setIsAudit("2");
        SysUserIpAudit sysUserIpAudit = new SysUserIpAudit();
        sysUserIpAudit.setIsAudit("1");
        return this.updateById((Object)sysUsersAudit);
    }

    @Override
    public String queryIp(String userId) {
        return this.listIps(userId);
    }

    @Override
    public String queryAuditIp(String userId, String status) {
        return this.listAuditIps(userId, status);
    }

    @Override
    public boolean passCalcel(String id) {
        SysUsersAudit sysUsersAudit = (SysUsersAudit)((Object)this.getById((Serializable)((Object)id)));
        sysUsersAudit.setIsAudit("1");
        SysUsers sysUsers = new SysUsers();
        sysUsers.setUserId(sysUsersAudit.getUserId());
        sysUsers.setAccountStatus(UserStatus.CANCEL.getCode());
        sysUsers.setEmployeeId("");
        this.sysUserroleAuditMapper.delete((Wrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysUsers.getUserId()));
        if (SqlHelper.retBool((Integer)this.sysUsersMapper.updateById((Object)sysUsers)) && this.updateById((Object)sysUsersAudit)) {
            this.bpmAbstractPushMsgMatcher.delete("organ", sysUsers.getUserId(), null);
            this.bpmAbstractPushMsgMatcher.delete("userRole", sysUsers.getUserId(), "deleteByUserId");
            return true;
        }
        return false;
    }

    private String listIps(String userId) {
        List<String> userIps = this.iSysUserIpService.selectUserIp(userId);
        String ips = "";
        if (userIps != null && userIps.size() > 0) {
            for (String sysUserIp : userIps) {
                ips = ips + sysUserIp + ",";
            }
            ips = ips.substring(0, ips.length() - 1);
        }
        return ips;
    }

    private String listAuditIps(String userId, String status) {
        List<String> userIps = this.iSysUserIpAuditService.selectUserIp(userId, status);
        String ips = "";
        if (userIps != null && userIps.size() > 0) {
            for (String sysUserIp : userIps) {
                ips = ips + sysUserIp + ",";
            }
            ips = ips.substring(0, ips.length() - 1);
        }
        return ips;
    }

    private boolean saveUserIP(String userId, String accessLoginIp) {
        boolean flag = false;
        ArrayList<SysUserIp> sysUserIps = new ArrayList<SysUserIp>();
        if (StringUtils.isNotEmpty((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String ip : list) {
                SysUserIp sysUserIp = new SysUserIp();
                sysUserIp.setUserId(userId);
                sysUserIp.setUserIp(ip);
                sysUserIps.add(sysUserIp);
            }
        }
        if (sysUserIps.size() > 0) {
            flag = this.iSysUserIpService.saveBatch(sysUserIps);
        }
        return flag;
    }
}

