/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.audit.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.audit.vo.SysStruAuditVo;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.OrganInfoVo;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sysStruAudit"})
public class SysStruAuditController
extends BaseController {
    private String PREFIX = "/bsp/audit/";
    @Autowired
    private ISysStruAuditService sysStruAuditService;
    @Resource
    private SysOrgManageService orgMaintenanceService;

    @RequestMapping(value={"/view"})
    @BussinessLog(key="/sysStruAudit/view", type="04", value="\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u5ba1\u6838\u9875\u9762")
    @RequiresPermissions(value={"sysStruAudit:view"})
    public String index() {
        return this.PREFIX + "sysOrganAudit.html";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    @RequiresPermissions(value={"sysStruAudit:list"})
    @BussinessLog(key="/sysStruAudit/list", type="04", value="\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u5ba1\u6838\u5217\u8868")
    public Object list(String organName, @RequestParam(defaultValue="0") String type) {
        int page = Integer.parseInt(super.getPara("page"));
        int limit = Integer.parseInt(super.getPara("limit"));
        Page pages = new Page((long)page, (long)limit);
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List<SysStruAuditVo> list = this.sysStruAuditService.queryOrganAudit(pages, organName, type);
        result.put("count", pages.getTotal());
        result.put("data", list);
        result.put("code", 0);
        result.put("msg", "success");
        return result;
    }

    @RequestMapping(value={"/verify"})
    @ResponseBody
    @BussinessLog(key="/sysStruAudit/verify", type="03", value="\u7ec4\u7ec7\u673a\u6784/\u4eba\u5458\u64cd\u4f5c\u5ba1\u6838")
    @RequiresPermissions(value={"sysStruAudit:verify"})
    public Object verify(@RequestParam String struId, @RequestParam String type, @RequestParam String inUse, @RequestParam(defaultValue="") String realStruId) {
        if (this.sysStruAuditService.verify(struId, type, inUse, realStruId)) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/detail"})
    @BussinessLog(key="/sysStruAudit/detail", type="04", value="\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u5ba1\u6838\u8be6\u60c5")
    @RequiresPermissions(value={"sysStruAudit:detail"})
    public String view(Model model) {
        String struId = super.getPara("struId");
        String type = super.getPara("type");
        String state = super.getPara("state");
        if ("1".equals(type)) {
            OrganInfoVo orgInfo = this.sysStruAuditService.getOrgInfoById(struId);
            model.addAttribute("orgInfo", (Object)orgInfo);
            return this.PREFIX + "addOrgInfoView.html";
        }
        if ("2".equals(type)) {
            String realStruId = super.getPara("realStruId");
            OrganInfoVo orgInfo = this.sysStruAuditService.getEditOrgInfoById(struId);
            OrganInfoVo oldOrgInfo = this.orgMaintenanceService.getOldOrgInfoById(realStruId);
            model.addAttribute("orgInfo", (Object)orgInfo);
            model.addAttribute("oldOrgInfo", (Object)oldOrgInfo);
            return this.PREFIX + "editOrgInfoView.html";
        }
        if ("3".equals(type)) {
            String realStruId = super.getPara("realStruId");
            OrganInfoVo orgInfo = this.orgMaintenanceService.getOldOrgInfoById(realStruId);
            model.addAttribute("orgInfo", (Object)orgInfo);
            return this.PREFIX + "addOrgInfoView.html";
        }
        String realStruId = super.getPara("realStruId");
        OrganInfoVo oldOrgInfo = this.orgMaintenanceService.getOldOrgInfoById(realStruId);
        String newParentName = this.sysStruAuditService.getNewParentName(struId);
        OrganInfoVo orgInfo = new OrganInfoVo();
        BeanUtils.copyProperties((Object)oldOrgInfo, (Object)orgInfo);
        orgInfo.setParentName(newParentName);
        model.addAttribute("orgInfo", (Object)orgInfo);
        model.addAttribute("oldOrgInfo", (Object)oldOrgInfo);
        return this.PREFIX + "editOrgInfoView.html";
    }
}

