layui.use(['Hussar', 'HussarAjax','layer','form','element','upload','jquery','table'], function () {
    var $ = layui.jquery
        , upload = layui.upload
        , element = layui.element
        , Hussar = layui.Hussar
        , table = layui.table
        , $ax = layui.HussarAjax;

    /**
     * 加载表格
     */
    table.render({
        elem:'#repeatDataTable',
        height : parseInt($('#jxd_ins_2_9').height()),
        data: [],
        cols: parent.importTableCols,
        page : false,
        id : 'testReload',
        even: true,
        limit: Number.MAX_VALUE // 数据表格默认全部显示
    });

    /**
     * 加载表格
     */
    table.render({
        elem:'#repeatTable',
        height : parseInt($('#jxd_ins_2_9_1').height()),
        data: [],
        cols: parent.importTableCols,
        page : false,
        id : 'testReloadFor',
        even: true,
        limit: Number.MAX_VALUE // 数据表格默认全部显示
    });

    /**
     * 导入
     */
    var loadingIndex = 0;
    upload.render({
        elem: '#test10'
        , url: Hussar.ctxPath + url
        , data: {
            dealtype: function() {
                return $('input[name="dealtype"]:checked').val();
            }
        }
        , auto: false
        , multiple: true
        , bindAction: '#test11'
        , before: function (obj) { //obj参数包含的信息，跟 choose回调完全一致，可参见上文。
            loadingIndex = layer.load(3); //上传loading
        }
        , page: false
        , done: function (res) {
            // 每次导入后清空数据
            reset();
            if (res.code === 0) {
                Hussar.error("数据导入失败!");
                $("#errormsg").val(res.errorInfo);
                layer.close(loadingIndex); //关闭loading
                return;
            }
            if (res.code === 1) {
                if (res.repeatList.length > 0 || res.repeatData.length > 0) {
                    Hussar.success("数据导入成功！");
                    $("#errormsg").val("成功新增" + res.successNumber + "条数据,更新" + res.updateNumber
                        + "条数据,excel内重复数据" + (res.repeatList.length)
                        + "条,excel重复数据处理后与源数据重复" + res.repeatData.length
                        + "条。");
                    table.reload('testReload', {
                        data: res.repeatList
                    });
                    table.reload('testReloadFor', {
                        data: res.repeatData
                    });
                    layer.close(loadingIndex); //关闭loading
                } else {
                    $("#errormsg").val("成功导入" + res.successNumber + "条数据");
                    Hussar.success("数据导入成功！");
                    layer.close(loadingIndex); //关闭loading
                }
            }
        },error: function(index, upload){
            layer.close(loadingIndex); //关闭loading
        }
        , accept: 'file'//允许上传的文件类型
    });

    function reset() {
        $("#errormsg").val('');
        table.reload('testReload', {
            data: []
        });
        table.reload('testReloadFor', {
            data: []
        });
    }
});