window.formCheckRule = function () {
    var $ = layui.jquery;
    $(".needCheck").on("input", function () {
        var dom = $(this);

        var parentDom = dom.parents(".layui-form-item");
        var errorDom = parentDom.find(".layui-clear");
        var labelDom = parentDom.find(".layui-form-label");

        var value = dom.val();
        var label = labelDom.html();
        // 必填校验
        if (dom[0].hasAttribute("require")) {
            if (!value || value.trim() == "") {
                if (dom[0].id == "jxdBpmSuggestionArea") {
                    dom.parent().addClass("error");
                    dom.parent().attr("title", "请填写必填字段！");
                    return;
                } else if (dom[0].parentNode.className.indexOf("layui-datapick") > -1) {
                    dom.parent().addClass("error");
                    dom.parent().attr("title", "请填写必填字段！");
                    return;
                } else {
                    dom.addClass("error");
                    dom.attr("title", "请填写必填字段！");
                    return;
                }
            }
        }

        // 固话验证
        if (dom[0].hasAttribute("fixAndMobile")) {
            if (!fixAndMobile(value)) {
                dom.addClass("error");
                dom.attr("title", "固话格式错误！");
                return;
            }
        }
        // 小数验证
        if (dom[0].hasAttribute("decimals")) {
            if (!isDecimals(value)) {
                dom.addClass("error");
                dom.attr("title", "小数格式错误！");
                return;
            }
        }
        // 数字验证且可为空
        if (dom[0].hasAttribute("number")) {
            if (!isNum(value)) {
                dom.addClass("error");
                dom.attr("title", "数字格式错误！");
                return;
            }
        }

        // 邮箱验证
        if (dom[0].hasAttribute("email")) {
            if (!emailValidation(value)) {
                dom.addClass("error");
                dom.attr("title", "邮箱格式错误！");
                return;
            }
        }
        // 长度验证
        if (dom[0].hasAttribute("checkForLength") && value) {
            var len = parseInt(dom.attr("checkForLength") ? dom.attr("checkForLength") : 0);
            if (value.length > len) {
                dom.addClass("error");
                dom.attr("title", "长度不能超过" + len + "!");
                return;
            }
        }

        // 身份证号验证
        if (dom[0].hasAttribute("identity") && value) {
            if (!identity(value)) {
                dom.addClass("error");
                dom.attr("title", "身份证号格式错误!");
                return;
            }
        }
        // 传真验证
        if (dom[0].hasAttribute("fix") && value) {
            if (!isFix(value)) {
                dom.addClass("error");
                dom.attr("title", "传真格式错误!");
                return;
            }
        }

        // 正整数验证
        if (dom[0].hasAttribute("positiveInteger") && value) {
            if (!isPositiveInteger(value)) {
                dom.addClass("error");
                dom.attr("title", "请输入正整数!");
                return;
            }
        }

        // 正数验证
        if (dom[0].hasAttribute("isInteger") && value) {
            if (!isInteger(value)) {
                dom.addClass("error");
                dom.attr("title", "请输入正数!");
                return;
            }
        }

        // 日期验证
        if (dom[0].hasAttribute("date") && value) {
            if (!isDate(value)) {
                dom.addClass("error");
                dom.attr("title", "请输入正确的日期格式!");
                return;
            }
        }
        // 网址验证
        if (dom[0].hasAttribute("url") && value) {
            if (!isUrl(value)) {
                dom.addClass("error");
                dom.attr("title", "请输入正确的网址格式!");
                return;
            }
        }
        // 手机号验证
        if (dom[0].hasAttribute("phone") && value) {
            if (!isPhone(value)) {
                dom.addClass("error");
                dom.attr("title", "请输入正确的手机号格式!");
                return;
            }
        }
        if (typeof dom.attr("isEnglish") != "undefined") {

            if (!isEnglish(value)) {
                dom.addClass("error");
                dom.attr("title", "请填入英文!");
                return;
            }
        }
        if (typeof dom.attr("isChinese") != "undefined") {
            if (!isChinese(value)) {
                dom.addClass("error");
                dom.attr("title", "请填入中文!");
                return;
            }
        }
        if (typeof dom.attr("requiredForRadioGroup") != "undefined") {
            var formElem = $(this).attr('lay-filter');
            var ss = "#" + formElem + " input:checked";
            var temp = $(ss);
            var tempValue = "";
            if (temp && temp.length > 0) {
                $("#" + formElem).removeClass("error");
                $("#" + formElem).removeAttr("title")
            } else {
                $("#" + formElem).addClass("error");
                $("#" + formElem).attr("title", "单选钮请选择其一");
                return;
            }
        }
        if (typeof dom.attr("requiredForCheckBox") != "undefined") {
            var formElem = $(this).attr('lay-filter');
            var ss = "#" + formElem + " input:checked";
            var temp = $(ss);
            if (!(temp && temp.length > 0)) {
                $("#" + formElem).addClass("error");
                dom.attr("title", "复选框至少选择一个");
                return;
            } else {
                $("#" + formElem).removeClass("error");
                $("#" + formElem).removeAttr("title")
            }
        }
        if (typeof dom.attr("requiredforselect") != "undefined") {
            var tempValue = dom.val();
            if (tempValue != null && tempValue != "") {
                dom.parent().removeClass("error");
                dom.parent().removeAttr("title")
            } else {
                dom.parent().addClass('error');
                dom.parent().attr("title", "请选择");
                return;
            }
        }
        if (typeof dom.attr("requiredfordate") != "undefined") {
            var formElem = $(this).attr('lay-filter');
            var ss = "#" + formElem + " option:checked";
            var temp = $(ss);
            var tempValue = dom.val();
            if (temp && tempValue != null && tempValue != "") {
                $("#" + formElem).removeClass("error");
                $("#" + formElem).removeAttr("title")
            } else {
                $("#" + formElem).addClass("error");
                $("#" + formElem).attr("title", "请选择");
                return;
            }
        }
        if (dom[0].id == "jxdBpmSuggestionArea") {
            dom.parent().removeClass("error");
            dom.parent().attr("title", value);
        } else {
            dom.removeClass("error");
            dom.attr("title", value);
        }


    });
    $(".needCheck").on("click", function () {
        var dom = $(this);
        if (typeof dom.attr("requiredForRadioGroup") != "undefined") {
            var formElem = $(this).attr('lay-filter');
            var ss = "#" + formElem + " input:checked";
            var temp = $(ss);
            var tempValue = "";
            if (temp && temp.length > 0) {
                $("#" + formElem).removeClass("error");
                $("#" + formElem).removeAttr("title")
            } else {
                $("#" + formElem).addClass("error");
                $("#" + formElem).attr("title", "单选钮请选择其一");
                return;
            }
        }
        if (typeof dom.attr("requiredForCheckBox") != "undefined") {
            var formElem = $(this).attr('lay-filter');
            var ss = "#" + formElem + " input:checked";
            var temp = $(ss);
            var tempValue = "";
            if (temp && temp.length > 0) {
                $("#" + formElem).removeClass("error");
                $("#" + formElem).removeAttr("title")
            } else {
                $("#" + formElem).addClass("error");
                $("#" + formElem).attr("title", "复选钮请选择其一");
                return;
            }
        }
        if (typeof dom.attr("requiredforselect") != "undefined") {
            var formElem = $(this).attr('id');
            var ss = "#" + formElem + " option:checked";
            var temp = $(ss);
            var tempValue = temp.val();
            if (temp && tempValue != "") {
                $("#" + formElem + "_select").removeClass("error");
                $("#" + formElem + "_select").removeAttr("title")
                $("#" + formElem + "_container").removeClass("error");
                $("#" + formElem + "_container").removeAttr("title")
            } else {
                $("#" + formElem + "_select").addClass("error");
                $("#" + formElem + "_select").attr("title", "请选择");
                $("#" + formElem + "_container").addClass("error");
                $("#" + formElem + "_container").attr("title", "请选择");
                return;
            }
        }
    });
    $(".needCheck").on("change", function () {
        var dom = $(this);

        var parentDom = dom.parents(".layui-form-item");
        var errorDom = parentDom.find(".layui-clear");
        var labelDom = parentDom.find(".layui-form-label");

        var value = dom.val();
        var label = labelDom.html();
        // 必填校验
        if (dom[0].hasAttribute("require")) {
            if (!!value && value.trim() !== "") {
                if (dom[0].parentNode.className.indexOf("layui-datapick") > -1) {
                    dom.parent().removeClass("error");
                    dom.parent().removeAttr("title");
                } else {
                    dom.removeClass("error");
                    dom.removeAttr("title");
                }
                return;
            }
        }
    });
}

/**
 * 固话和电话号码验证
 */
function fixAndMobile(val) {
    if (val == "" || val == undefined || val == null) {
        return true;
    }
    var reg = /^(0?(13[0-9]|15[012356789]|17[013678]|18[0-9]|14[57])[0-9]{8})|(400|800)([0-9\\-]{7,10})|(([0-9]{4}|[0-9]{3})(-| )?)?([0-9]{7,8})((-| |转)*([0-9]{1,4}))?$/;
    return reg.test(val);
}

/**
 * 邮箱验证
 */
function emailValidation(val) {
    if (val == "" || val == undefined || val == null) {
        return true;
    }
    var reg = /^([a-zA-Z]|[0-9])(\w|\-)+@[a-zA-Z0-9]+\.([a-zA-Z]{2,4})$/;
    return reg.test(val);
}

/**
 * 传真验证
 **/
function isFix(val) {
    if (val == "" || val == undefined || val == null) {
        return true;
    }
    var reg = /^(\(\d{3,4}\)|\d{3,4}-|\s)?\d{7,14}$/;
    return reg.test(val);
}

/**
 * 正整数验证
 **/
function isPositiveInteger(val) {
    if (val == "" || val == undefined || val == null) {
        return true;
    }
    var reg = /^[0-9]+$/;
    return reg.test(val);
}

/**
 * 正数验证
 */
function isInteger(val) {
    if (val == "" || val == undefined || val == null) {
        return true;
    }
    var reg = /^[+]{0,1}(\d+)$|^[+]{0,1}(\d+\.\d+)$/;
    return reg.test(val);
}

/**
 * 小数
 */
function isDecimals(val) {
    if (val == "" || val == undefined || val == null) {
        return true;
    }
    var reg = /^\d+(\.\d+)?$/;
    return reg.test(val);
};

/*数字*/
function isNum(val) {
    if (val == "" || val == undefined || val == null) {
        return true;
    }
    var reg = /^[0-9]*$/;
    return reg.test(val);
};

/**
 * 身份证号验证
 */
function identity(val) {
    if (val == "" || val == undefined || val == null) {
        return true;
    }
    var reg = /^[1-9]\d{5}(18|19|([23]\d))\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\d{3}[0-9Xx]$/;
    return reg.test(val);
}

/**
 * 英文验证
 */
function isEnglish(val) {
    if (val == "" || val == undefined || val == null) {
        return true;
    }
    var reg = /^[a-zA-Z0-9\s]+$/;
    return reg.test(val);
}

/**
 *是中文返回true
 */
function isChinese(val) {
    if (val == "" || val == undefined || val == null) {
        return true;
    }
    var reg = /^[\u4e00-\u9fa50-9\s]+$/;
    return reg.test(val);
}

/**
 * 日期
 */
function isDate(val) {
    if (val == "" || val == undefined || val == null) {
        return true;
    }
    var reg = /((^((1[8-9]\d{2})|([2-9]\d{3}))([-\/\._])(10|12|0?[13578])([-\/\._])(3[01]|[12][0-9]|0?[1-9])$)|(^((1[8-9]\d{2})|([2-9]\d{3}))([-\/\._])(11|0?[469])([-\/\._])(30|[12][0-9]|0?[1-9])$)|(^((1[8-9]\d{2})|([2-9]\d{3}))([-\/\._])(0?2)([-\/\._])(2[0-8]|1[0-9]|0?[1-9])$)|(^([2468][048]00)([-\/\._])(0?2)([-\/\._])(29)$)|(^([3579][26]00)([-\/\._])(0?2)([-\/\._])(29)$)|(^([1][89][0][48])([-\/\._])(0?2)([-\/\._])(29)$)|(^([2-9][0-9][0][48])([-\/\._])(0?2)([-\/\._])(29)$)|(^([1][89][2468][048])([-\/\._])(0?2)([-\/\._])(29)$)|(^([2-9][0-9][2468][048])([-\/\._])(0?2)([-\/\._])(29)$)|(^([1][89][13579][26])([-\/\._])(0?2)([-\/\._])(29)$)|(^([2-9][0-9][13579][26])([-\/\._])(0?2)([-\/\._])(29)$))/;
    return reg.test(val);
}

/**
 * 网址
 */
function isUrl(val) {
    if (val == "" || val == undefined || val == null) {
        return true;
    }
    var reg = /^http:\/\/([\w-]+\.)+[\w-]+(\/[\w-./?%&=]*)?$/;
    return reg.test(val);
}

/**
 * 手机号
 */
function isPhone(val) {
    if (val == "" || val == undefined || val == null) {
        return true;
    }
    var reg = /^(0|86|17951)?(13[0-9]|15[012356789]|17[678]|18[0-9]|14[57])[0-9]{8}$/;
    return reg.test(val);
}


