/**
 * js常用工具类
 */

var AxeTools = {

    jquery : function() {
        return layui.jquery;
    },

    /**
     * 转换日期对象为指定格式日期字符串
     * @param date 日期
     * @param pattern 格式字符串,例如：yyyy-MM-dd hh:mm:ss
     * @return 符合要求的日期时间字符串
     */
    getFormatDate: function (date, pattern) {
        if (!date) {
            return "";
        }
        if (!pattern) {
            return date;
        }

        if (typeof date === "string" || typeof date === "number") {
            date = new Date(date);
        }


        var o = {
            "M+": date.getMonth() + 1,
            "d+": date.getDate(),
            "h+": date.getHours(),
            "m+": date.getMinutes(),
            "s+": date.getSeconds(),
            "q+": Math.floor((date.getMonth() + 3) / 3),
            "S": date.getMilliseconds()
        };
        if (/(y+)/.test(pattern)) {
            pattern = pattern.replace(RegExp.$1, (date.getFullYear() + "").substr(4 - RegExp.$1.length));
        }

        for (var k in o) {
            if (new RegExp("(" + k + ")").test(pattern)) {
                pattern = pattern.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k] : ("00" + o[k]).substr(("" + o[k]).length));
            }
        }
        return pattern;
    },

    /**
     * 保留指定小数位数
     * @param number 当前数字
     * @param digits 保留小数位数
     * @return 符合要求的数字
     */
    getRound: function (number, digits) {
        var roundNum = "";
        if (digits === 0) {
            roundNum = number.toString().split(".")[0];
        } else {
            roundNum = Math.round(number * Math.pow(10, digits)) / Math.pow(10, digits);
            var roundNumArr = roundNum.toString().split(".");
            var dotLen = 0;
            if (roundNumArr.length === 2) {
                if (roundNumArr[1] !== "") {
                    dotLen = roundNumArr[1].length;
                    if (dotLen < digits) {
                        roundNum = roundNum.toFixed(digits)
                    }
                }
            } else {
                roundNum = roundNum.toFixed(digits);
            }
        }
        return roundNum;
    },

    /**
     * 添加千分符
     * @param number 当前数字
     * @return 添加千位分隔符的数字
     */
    getThousandBitSplit: function (number) {
        var newStr = "";
        var count = 0;
        var str = number.toString();

        if (str.indexOf(".") === -1) {
            for (var ii = str.length - 1; ii >= 0; ii--) {
                if (count % 3 === 0 && count !== 0) {
                    newStr = str.charAt(ii) + "," + newStr;
                } else {
                    newStr = str.charAt(ii) + newStr;
                }
                count++;
            }
            str = newStr;
        } else {
            for (var jj = str.indexOf(".") - 1; jj >= 0; jj--) {
                if (count % 3 === 0 && count !== 0) {
                    newStr = str.charAt(jj) + "," + newStr; //碰到3的倍数则加上“,”号
                } else {
                    newStr = str.charAt(jj) + newStr; //逐个字符相接起来
                }
                count++;
            }
            str = newStr + (str).substr((str).indexOf("."));
        }

        return str
    },

    /**
     * 获取表格某字段的和
     */
    getTableSum: function (data, sumField) {
        var sum = 0;
        for (var i = 0; i < data.length; i++) {
            if (data[i][sumField] != null && data[i][sumField] != "" && data[i][sumField] != undefined) {
                sum += parseFloat(data[i][sumField]);
            }
        }
        return sum;
    },

    //获取滚动条
    jxd_ins_getTableScroll: function (tbView) {
        var scrollTop = tbView.next('.layui-table-view').find('.layui-table-body').scrollTop();
        var scrollLeft = tbView.next('.layui-table-view').find('.layui-table-body').scrollLeft();
        return {
            scrollTop: scrollTop, scrollLeft: scrollLeft
        }
    },
    // 设置滚动条
    jxd_ins_setTableScoll: function (tbView, scroll) {
        if (!scroll) {
            scroll = {scrollTop: 0, scrollLeft: 0}
        }
        tbView.next('.layui-table-view').find('.layui-table-body').scrollTop(scroll.scrollTop);
        tbView.next('.layui-table-view').find('.layui-table-body').scrollLeft(scroll.scrollLeft);
        layui.table.resize(tbView[0].id); //重置表格尺寸
    },

    //判断是不是IE 11及以下或者其他（其他里包括IE edge）
    isIE : function () {
        if(!!window.ActiveXObject || "ActiveXObject" in window){
            return true;
        }else{
            return false;
        }
    },

    //判断是不是IE9及以下
    isIE9 : function () {
        if(navigator.appName == "Microsoft Internet Explorer" && parseInt(navigator.appVersion.split(";")[1].replace(/[ ]/g, "").replace("MSIE",""))<=9){
            return true;
        }else{
            return false;
        }
    },

    //IE浏览器红色必填项
    requiredContent : function () {
        if(AxeTools.isIE()){
            var label = this.jquery()(".layui-form-label.required");
            var text = this.jquery()(".layui-txt.required");
            var prependStr = "<span>*</span>";
            label.prepend(prependStr);
            text.prepend(prependStr);
        }
    },

    //IE浏览器表格内下拉框有时候不显示（因为没高度）
    IETableSelect : function (selectDom) {
        if(AxeTools.isIE()){
            var maxHeight = 300;
            var height = 0;
            for(var domIndex=0;domIndex<selectDom.length;domIndex++){
                if(selectDom[domIndex].scrollHeight > 0){
                    height = selectDom[domIndex].scrollHeight;
                    break;
                }
            }
            var resultHeight = height + 'px';
            if(height > maxHeight){
                resultHeight = maxHeight + 'px';
            }
            for(var i=0;i<selectDom.length;i++){
                selectDom[i].style.height = resultHeight;
            }
        }
    }
};

 