/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.xmlparser;

import com.jxdinfo.hussar.formdesign.xmlparser.DocumentFactoryWithLocator;
import com.jxdinfo.hussar.formdesign.xmlparser.XMLSAXContentHandler;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.ElementHandler;
import org.dom4j.io.SAXContentHandler;
import org.dom4j.io.SAXReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSAXReader
extends SAXReader {
    DocumentFactory docFactory;
    Locator locator;

    public XMLSAXReader(DocumentFactory docFactory) {
        super(docFactory);
        this.docFactory = docFactory;
    }

    public XMLSAXReader(DocumentFactory docFactory, Locator locator) {
        super(docFactory);
        this.locator = locator;
        this.docFactory = docFactory;
    }

    protected SAXContentHandler createContentHandler(XMLReader reader) {
        return new XMLSAXContentHandler(this.getDocumentFactory(), (ElementHandler)super.getDispatchHandler());
    }

    public Document read(InputSource in) throws DocumentException {
        try {
            XMLReader reader = this.getXMLReader();
            reader = this.installXMLFilter(reader);
            EntityResolver thatEntityResolver = super.getEntityResolver();
            if (thatEntityResolver == null) {
                thatEntityResolver = this.createDefaultEntityResolver(in.getSystemId());
                super.setEntityResolver(thatEntityResolver);
            }
            reader.setEntityResolver(thatEntityResolver);
            SAXContentHandler contentHandler = this.createContentHandler(reader);
            contentHandler.setEntityResolver(thatEntityResolver);
            contentHandler.setInputSource(in);
            boolean internal = this.isIncludeInternalDTDDeclarations();
            boolean external = this.isIncludeExternalDTDDeclarations();
            contentHandler.setIncludeInternalDTDDeclarations(internal);
            contentHandler.setIncludeExternalDTDDeclarations(external);
            contentHandler.setMergeAdjacentText(this.isMergeAdjacentText());
            contentHandler.setStripWhitespaceText(this.isStripWhitespaceText());
            contentHandler.setIgnoreComments(this.isIgnoreComments());
            reader.setContentHandler((ContentHandler)contentHandler);
            this.configureReader(reader, (DefaultHandler)contentHandler);
            ((XMLSAXContentHandler)contentHandler).setDocFactory((DocumentFactoryWithLocator)this.docFactory);
            contentHandler.setDocumentLocator(this.locator);
            reader.parse(in);
            return contentHandler.getDocument();
        }
        catch (Exception e) {
            if (e instanceof SAXParseException) {
                SAXParseException parseException = (SAXParseException)e;
                String systemId = parseException.getSystemId();
                if (systemId == null) {
                    systemId = "";
                }
                String message = "Error on line " + parseException.getLineNumber() + " of document " + systemId + " : " + parseException.getMessage();
                throw new DocumentException(message, (Throwable)e);
            }
            throw new DocumentException(e.getMessage(), (Throwable)e);
        }
    }
}

