/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.util;

import com.jxdinfo.hussar.formdesign.xmlparser.DocumentFactoryWithLocator;
import com.jxdinfo.hussar.formdesign.xmlparser.XMLSAXReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultAttribute;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.LocatorImpl;

public class XMLParserUtil {
    public static SAXReader getSAXReader() {
        LocatorImpl locator = new LocatorImpl();
        DocumentFactoryWithLocator documentFactory = new DocumentFactoryWithLocator(locator);
        XMLSAXReader reader = new XMLSAXReader(documentFactory, locator);
        reader.setEntityResolver(new IgnoreDTDEntityResolver());
        return reader;
    }

    public static Map<String, Element> readXMLElementsByFile(String filePath) throws DocumentException {
        LocatorImpl locator = new LocatorImpl();
        DocumentFactoryWithLocator documentFactory = new DocumentFactoryWithLocator(locator);
        XMLSAXReader reader = new XMLSAXReader(documentFactory, locator);
        File file = new File(filePath);
        reader.setEntityResolver(new IgnoreDTDEntityResolver());
        LinkedHashMap<String, Element> elementMap = new LinkedHashMap<String, Element>();
        Document document = reader.read(file);
        Element element = document.getRootElement();
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element itElement = (Element)it.next();
            itElement.attributes().forEach(attribute -> {
                if (((DefaultAttribute)attribute).getName().equals("id")) {
                    elementMap.put(((DefaultAttribute)attribute).getValue(), itElement);
                }
            });
        }
        return elementMap;
    }

    public static Map<String, Element> readXMLElementsByString(String in) {
        LocatorImpl locator = new LocatorImpl();
        DocumentFactoryWithLocator documentFactory = new DocumentFactoryWithLocator(locator);
        XMLSAXReader reader = new XMLSAXReader(documentFactory, locator);
        HashMap<String, Element> elementMap = new HashMap<String, Element>();
        reader.setEntityResolver(new IgnoreDTDEntityResolver());
        try {
            Document document = reader.read(new ByteArrayInputStream(in.getBytes(StandardCharsets.UTF_8)));
            Element element = document.getRootElement();
            Iterator it = element.elementIterator();
            while (it.hasNext()) {
                Element itElement = (Element)it.next();
                itElement.attributes().forEach(attribute -> {
                    if (((DefaultAttribute)attribute).getName().equals("id")) {
                        elementMap.put(((DefaultAttribute)attribute).getValue(), itElement);
                    }
                });
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return elementMap;
    }

    public static Document readXMLByString(String in) throws DocumentException {
        LocatorImpl locator = new LocatorImpl();
        DocumentFactoryWithLocator documentFactory = new DocumentFactoryWithLocator(locator);
        XMLSAXReader reader = new XMLSAXReader(documentFactory, locator);
        DOMDocument document = new DOMDocument();
        reader.setEntityResolver(new IgnoreDTDEntityResolver());
        document = reader.read(new ByteArrayInputStream(in.getBytes(StandardCharsets.UTF_8)));
        return document;
    }

    static class IgnoreDTDEntityResolver
    implements EntityResolver {
        IgnoreDTDEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String arg0, String arg1) {
            return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
        }
    }
}

