/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteOptions;
import org.iq80.leveldb.impl.Iq80DBFactory;
import org.springframework.context.ApplicationContext;

public class LevelDBUtils {
    private static ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
    private static final String PROJECT_STORE_PATH = applicationContext.getEnvironment().getProperty("form-design.project-store-path");
    private static final String PROJECT_PATH = applicationContext.getEnvironment().getProperty("form-design.project-path");
    private static final String LEVEL_DB_PREFIX = "\\levelDB";
    private static final String PATH = PROJECT_PATH + PROJECT_STORE_PATH + "\\levelDB";
    private static final File FILE = new File(PATH);
    private static final Charset CHARSET = Charset.forName("UTF-8");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void leaveDBInsert(String key, Object value) {
        Options options = new Options();
        Iq80DBFactory factory = Iq80DBFactory.factory;
        DB db = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            db = factory.open(FILE, options);
            WriteOptions writeOptions = new WriteOptions();
            writeOptions.snapshot(true);
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            db.put(key.getBytes(CHARSET), baos.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
                if (baos != null) {
                    baos.close();
                }
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObject(String key) {
        Options options = new Options();
        Iq80DBFactory factory = Iq80DBFactory.factory;
        DB db = null;
        ObjectInputStream ois = null;
        ByteArrayInputStream bais = null;
        try {
            db = factory.open(FILE, options);
            byte[] valueByte = db.get(key.getBytes(CHARSET));
            if (ToolUtil.isEmpty((Object)valueByte)) {
                Object var7_9 = null;
                return var7_9;
            }
            bais = new ByteArrayInputStream(valueByte);
            ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
                if (ois != null) {
                    ois.close();
                }
                if (bais != null) {
                    bais.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

