/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.util;

import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class JsoupHtmlUtil {
    private static String[] regs = new String[]{"@include", "<link", "<meta", "<style", "<!--[if lt IE 9]>"};

    public static boolean isConflict(Document document, Document documentGe, Document documentLevel) {
        Elements elements = document.getAllElements();
        Elements elementsGe = documentGe.getAllElements();
        Elements elementsLevel = documentLevel.getAllElements();
        for (Element element : elements) {
            String id = element.id();
            if (!ToolUtil.isNotEmpty((Object)id)) continue;
            Element elementGe = documentGe.getElementById(id);
            Element elementLevel = documentLevel.getElementById(id);
            if (!ToolUtil.isNotEmpty((Object)elementLevel) || !ToolUtil.isNotEmpty((Object)elementGe) || "link".equals(element.tag().toString())) continue;
            Attributes attributeGe = elementGe.attributes();
            Attributes attributeLevel = elementLevel.attributes();
            Attributes attribute = element.attributes();
            if (!JsoupHtmlUtil.isSameAttr(attribute, attributeGe, attributeLevel)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSameAttr(Attributes mapCurrent, Attributes mapGe, Attributes mapLevel) {
        for (Attribute attribute : mapLevel) {
            if (null == attribute.getValue() && "".equals(mapGe.get(attribute.getKey())) && "".equals(mapCurrent.get(attribute.getKey()))) {
                return false;
            }
            if (ToolUtil.equals((Object)attribute.getValue(), (Object)mapGe.get(attribute.getKey())) || ToolUtil.equals((Object)attribute.getValue(), (Object)mapCurrent.get(attribute.getKey()))) continue;
            return true;
        }
        return false;
    }

    public static void addElement(Document document, Document documentGe, Document documentLevel) {
        Elements eleCurrent = document.getAllElements();
        for (Element element : eleCurrent) {
            String id = element.id();
            if (!ToolUtil.isNotEmpty((Object)id)) continue;
            Element elementLevel = documentLevel.getElementById(id);
            Element elementGe = documentGe.getElementById(id);
            if (ToolUtil.isEmpty((Object)elementGe)) continue;
            Attributes attributes = element.attributes();
            Attributes attributesGe = elementGe.attributes();
            for (Attribute attribute : attributes) {
                if (ToolUtil.equals((Object)attribute.getValue(), (Object)attributesGe.get(attribute.getKey()))) continue;
                elementGe.attr(attribute.getKey(), attribute.getValue());
            }
        }
        JsoupHtmlUtil.rebuild(documentGe);
    }

    private static void rebuild(Document documentGe) {
        Elements heads = documentGe.getElementsByTag("head");
        Element head = (Element)heads.get(0);
        Elements bodies = documentGe.getElementsByTag("body");
        Element body = (Element)bodies.get(0);
        List bodyChildren = body.childNodes();
        JsoupHtmlUtil.rebuildBeetlContent(bodyChildren, head);
        JsoupHtmlUtil.rebuildJavaScript(documentGe);
    }

    private static void rebuildBeetlContent(List<Node> nodes, Element head) {
        ArrayList<Node> newList = new ArrayList<Node>(nodes);
        Iterator it = newList.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!JsoupHtmlUtil.containsHeadChild(node)) continue;
            head.appendChild((Node)new TextNode("\n"));
            head.appendChild(node);
            it.remove();
        }
    }

    private static boolean containsHeadChild(Node node) {
        String nodeString = node.toString();
        for (String reg : regs) {
            if (!nodeString.contains(reg)) continue;
            return true;
        }
        return false;
    }

    private static void rebuildJavaScript(Document documentGe) {
        Elements htmls = documentGe.getElementsByTag("html");
        Element html = (Element)htmls.get(0);
        Elements jsElements = documentGe.getElementsByTag("script");
        jsElements.forEach(element -> {
            html.appendChild((Node)element);
            element.parent().children().remove(element);
        });
    }

    private static void moveTag(Document documentGe, Element head, String tag) {
        Elements nodes = documentGe.getElementsByTag(tag);
        nodes.forEach(node -> {
            head.appendChild((Node)node);
            node.parent().children().remove(node);
        });
    }
}

