/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.util;

import com.jxdinfo.hussar.common.dicutil.DictionaryUtil;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExportExcelUtil<T> {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void exportExcelMap(HttpServletResponse response, List<Map> querys, List<Map<String, Object>> titles, String fileName) throws IOException {
        ServletOutputStream outputStream = null;
        response.setContentType("octets/stream");
        try {
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GB2312"), "ISO8859-1"));
            outputStream = response.getOutputStream();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int rowIndex = 0;
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
        Sheet sheet = xssfWorkbook.createSheet();
        sheet.createRow(rowIndex++);
        sheet.setDefaultColumnWidth(15);
        int leftInde = 0;
        ++leftInde;
        Row headRow = sheet.createRow(rowIndex++);
        for (int i = 0; i < titles.size(); ++i) {
            Map<String, Object> map = titles.get(i);
            Cell cell = headRow.createCell(leftInde + i);
            cell.setCellValue(String.valueOf(map.get("title")));
            CellStyle headCellStyle = xssfWorkbook.createCellStyle();
            headCellStyle.setAlignment(HorizontalAlignment.CENTER);
            headCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            Font font = xssfWorkbook.createFont();
            font.setBold(true);
            headCellStyle.setFont(font);
            headCellStyle.setBorderLeft(BorderStyle.THIN);
            headCellStyle.setBorderTop(BorderStyle.THIN);
            headCellStyle.setBorderRight(BorderStyle.THIN);
            headCellStyle.setBorderBottom(BorderStyle.THIN);
            cell.setCellStyle(headCellStyle);
        }
        HashMap<Integer, Integer> widthInfoMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < querys.size(); ++i) {
            Map map = querys.get(i);
            Row rowBody = sheet.createRow(rowIndex + i);
            for (int j = 0; j < titles.size(); ++j) {
                CellStyle bodyCellStyle = xssfWorkbook.createCellStyle();
                bodyCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                bodyCellStyle.setBorderLeft(BorderStyle.THIN);
                bodyCellStyle.setBorderTop(BorderStyle.THIN);
                bodyCellStyle.setBorderRight(BorderStyle.THIN);
                bodyCellStyle.setBorderBottom(BorderStyle.THIN);
                Map<String, Object> titlemap = titles.get(j);
                String textId = String.valueOf(titlemap.get("title_id"));
                String align = String.valueOf(titlemap.get("align"));
                Object dicName = titlemap.get("dicName");
                bodyCellStyle.setAlignment(this.setVerticalAlignment(align));
                Cell bodyCell = rowBody.createCell(j + leftInde);
                bodyCell.setCellStyle(bodyCellStyle);
                Object robj = map.get(textId);
                Object obj = null;
                obj = dicName != null && this.dicReplace(robj, String.valueOf(dicName)) != null ? this.dicReplace(robj, String.valueOf(dicName)) : (Object)robj;
                if (obj instanceof String) {
                    bodyCell.setCellValue((String)obj);
                } else if (obj instanceof Double) {
                    bodyCell.setCellValue(((Double)obj).doubleValue());
                } else if (obj instanceof Date) {
                    bodyCell.setCellValue(obj.toString().replace(".0", ""));
                } else if (obj instanceof Calendar) {
                    bodyCell.setCellValue((Calendar)obj);
                } else if (obj instanceof Boolean) {
                    bodyCell.setCellValue(((Boolean)obj).booleanValue());
                } else if (obj instanceof Integer) {
                    bodyCell.setCellValue((double)((Integer)obj).intValue());
                } else if (obj instanceof Float) {
                    bodyCell.setCellValue((double)((Float)obj).floatValue());
                } else {
                    bodyCell.setCellValue((String)obj);
                }
                if (widthInfoMap.get(j) == null && obj != null) {
                    widthInfoMap.put(j, String.valueOf(obj).length());
                }
                if (widthInfoMap.get(j) == null || (Integer)widthInfoMap.get(j) >= String.valueOf(obj).length()) continue;
                widthInfoMap.put(j, String.valueOf(obj).length());
            }
        }
        for (Map.Entry a : widthInfoMap.entrySet()) {
            if (5 <= (Integer)a.getValue() && (Integer)a.getValue() <= 15) {
                sheet.setColumnWidth((Integer)a.getKey() + 1, ((Integer)a.getValue() + 2) * 450);
                continue;
            }
            if (5 > (Integer)a.getValue()) {
                sheet.setColumnWidth((Integer)a.getKey() + 1, 3150);
                continue;
            }
            if ((Integer)a.getValue() <= 15) continue;
            sheet.setColumnWidth((Integer)a.getKey() + 1, 7650);
        }
        xssfWorkbook.write((OutputStream)outputStream);
        xssfWorkbook.close();
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private HorizontalAlignment setVerticalAlignment(String verticalAlignment) {
        if ("general".equals(verticalAlignment)) {
            return HorizontalAlignment.GENERAL;
        }
        if ("center".equals(verticalAlignment)) {
            return HorizontalAlignment.CENTER;
        }
        if ("left".equals(verticalAlignment)) {
            return HorizontalAlignment.LEFT;
        }
        if ("right".equals(verticalAlignment)) {
            return HorizontalAlignment.RIGHT;
        }
        if ("fill".equals(verticalAlignment)) {
            return HorizontalAlignment.FILL;
        }
        if ("justify".equals(verticalAlignment)) {
            return HorizontalAlignment.JUSTIFY;
        }
        if ("cnter_selection".equals(verticalAlignment)) {
            return HorizontalAlignment.CENTER_SELECTION;
        }
        if ("distributed".equals(verticalAlignment)) {
            return HorizontalAlignment.DISTRIBUTED;
        }
        return HorizontalAlignment.LEFT;
    }

    private VerticalAlignment setAlignment(String alignment) {
        if ("TOP".equals(alignment)) {
            return VerticalAlignment.CENTER;
        }
        if ("CENTER".equals(alignment)) {
            return VerticalAlignment.CENTER;
        }
        if ("BOTTOM".equals(alignment)) {
            return VerticalAlignment.BOTTOM;
        }
        if ("JUSTIFY".equals(alignment)) {
            return VerticalAlignment.JUSTIFY;
        }
        if ("DISTRIBUTED".equals(alignment)) {
            return VerticalAlignment.DISTRIBUTED;
        }
        return VerticalAlignment.CENTER;
    }

    private Object dicReplace(Object value, String dicName) {
        if (value != null) {
            DictionaryUtil dictionaryUtil = (DictionaryUtil)SpringContextHolder.getBean(DictionaryUtil.class);
            List dicList = dictionaryUtil.getDictByType(dicName);
            for (DicSingle dic : dicList) {
                if (!dic.getValue().equals(value)) continue;
                return dic.getLabel();
            }
        }
        return value;
    }
}

