/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.util;

import cn.hutool.core.io.FileUtil;
import com.jxdinfo.hussar.formdesign.generator.engine.base.GenEntityCode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class CompileUtil {
    private static String KEY_JAVA_FILE = "javaFile";
    private static String KEY_OTHER_FILE = "otherFile";

    public static void compileAndCopyFiles(String src, String dest, List<String> options, String charSet, String packagePath) throws Exception {
        System.out.println("start compile " + src + ".....");
        long start = System.currentTimeMillis();
        CompileUtil.mkDirs(dest);
        Map<String, List<File>> allFiles = CompileUtil.getFiles(src);
        List<File> files = allFiles.get(KEY_JAVA_FILE);
        List<File> otherFiles = allFiles.get(KEY_OTHER_FILE);
        JavaCompiler cmp = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = cmp.getStandardFileManager(null, null, Charset.forName(charSet));
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
        cmp.getTask(null, fileManager, null, options, null, compilationUnits).call();
        fileManager.close();
        System.out.println("end compileAndCopyFiles.Files amount:" + allFiles.size() + ".Total spend time : " + (System.currentTimeMillis() - start) / 1000L + " s");
    }

    private static void copyOtherFiles(List<File> files, String src, String dest, String packagePath) throws Exception {
        for (File file : files) {
            String fileAbsolutePath = file.getAbsolutePath();
            String destPath = dest + fileAbsolutePath.substring(packagePath.length());
            FileUtil.copy((String)fileAbsolutePath, (String)destPath, (boolean)true);
        }
    }

    private static Map<String, List<File>> getFiles(String src) {
        List<File> files = CompileUtil.getAllFiles(src);
        String suffix = ".java";
        HashMap<String, List<File>> map = new HashMap<String, List<File>>();
        ArrayList<File> javaFile = new ArrayList<File>();
        ArrayList<File> otherFile = new ArrayList<File>();
        for (File file : files) {
            String fileName = file.getName();
            if (fileName.endsWith(suffix)) {
                javaFile.add(file);
                continue;
            }
            otherFile.add(file);
        }
        map.put(KEY_JAVA_FILE, javaFile);
        map.put(KEY_OTHER_FILE, otherFile);
        return map;
    }

    public static List<File> getAllFiles(String path) {
        ArrayList<File> files = new ArrayList<File>();
        File file = new File(path);
        if (file.exists() && !file.isHidden()) {
            if (file.isDirectory()) {
                File[] fs;
                for (File f : fs = file.listFiles()) {
                    if (file.isHidden()) continue;
                    if (f.isDirectory()) {
                        files.addAll(CompileUtil.getAllFiles(path + File.separator + f.getName()));
                    }
                    if (!f.isFile()) continue;
                    files.add(f);
                }
            } else if (file.isFile()) {
                files.add(file);
            }
        }
        return files;
    }

    public static void copy(String from, String to) throws Exception {
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        byte[] buff = new byte[1024];
        int len = 0;
        while ((len = ((InputStream)in).read(buff)) != -1) {
            ((OutputStream)out).write(buff, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static void mkDirs(String path) {
        File destFile = new File(path);
        if (!destFile.exists()) {
            destFile.mkdirs();
        }
    }

    public static void compile(GenEntityCode genEntityCode) {
        String path = genEntityCode.getProjectPath() + "\\src\\main\\java\\" + genEntityCode.getProPackage().replaceAll("\\.", "\\\\");
        String dest = genEntityCode.getProjectPath() + "\\target\\classes\\";
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(dest);
        try {
            CompileUtil.compileAndCopyFiles(path, dest, options, "UTF-8", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

