/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.util;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.jxdinfo.hussar.core.util.MD5Util;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.contant.CodeVersionConstant;
import com.jxdinfo.hussar.formdesign.generator.model.DeclarationContainer;
import com.jxdinfo.hussar.formdesign.store.StoreFactory;
import java.util.ArrayList;
import java.util.List;

public class CodeCompareUtil {
    public static List<ImportDeclaration> getOriginImports(List<Node> childNodes) {
        ArrayList<ImportDeclaration> importDeclarations = new ArrayList<ImportDeclaration>();
        childNodes.forEach(child -> {
            if (child instanceof ImportDeclaration) {
                importDeclarations.add((ImportDeclaration)child);
            }
            if (child.getChildNodes().size() > 0) {
                importDeclarations.addAll(CodeCompareUtil.getOriginImports(child.getChildNodes()));
            }
        });
        return importDeclarations;
    }

    public static List<FieldDeclaration> getOriginField(List<Node> childNodes) {
        ArrayList<FieldDeclaration> fieldDeclarations = new ArrayList<FieldDeclaration>();
        childNodes.forEach(child -> {
            if (child instanceof FieldDeclaration) {
                fieldDeclarations.add((FieldDeclaration)child);
            }
            if (child.getChildNodes().size() > 0) {
                fieldDeclarations.addAll(CodeCompareUtil.getOriginField(child.getChildNodes()));
            }
        });
        return fieldDeclarations;
    }

    public static List<MethodDeclaration> getOriginMethods(List<Node> childNodes) {
        ArrayList<MethodDeclaration> methodDeclarationsOrigin = new ArrayList<MethodDeclaration>();
        childNodes.forEach(child -> {
            if (child instanceof MethodDeclaration) {
                methodDeclarationsOrigin.add((MethodDeclaration)child);
            }
            if (child.getChildNodes().size() > 0) {
                methodDeclarationsOrigin.addAll(CodeCompareUtil.getOriginMethods(child.getChildNodes()));
            }
        });
        return methodDeclarationsOrigin;
    }

    public static DeclarationContainer transDeclarationFromNodes(List<Node> childNodes) {
        DeclarationContainer declarationContainer = new DeclarationContainer();
        childNodes.forEach(child -> {
            if (child instanceof MethodDeclaration) {
                declarationContainer.getMethodDeclarationList().add((MethodDeclaration)child);
            }
            if (child instanceof FieldDeclaration) {
                declarationContainer.getFieldDeclarationList().add((FieldDeclaration)child);
            }
            if (child instanceof ImportDeclaration) {
                declarationContainer.getImportDeclarationList().add((ImportDeclaration)child);
            }
            if (child.getChildNodes().size() > 0 && !(child instanceof MethodDeclaration)) {
                DeclarationContainer childDeclarationContainer = CodeCompareUtil.transDeclarationFromNodes(child.getChildNodes());
                declarationContainer.getMethodDeclarationList().addAll(childDeclarationContainer.getMethodDeclarationList());
                declarationContainer.getImportDeclarationList().addAll(childDeclarationContainer.getImportDeclarationList());
                declarationContainer.getFieldDeclarationList().addAll(childDeclarationContainer.getFieldDeclarationList());
            }
        });
        return declarationContainer;
    }

    public static boolean isTheSameMethodExist(List<Node> cuNewNodes, MethodDeclaration methodDeclaration) {
        for (Node newNode : cuNewNodes) {
            MethodDeclaration newNodeDeclaration;
            if (newNode instanceof MethodDeclaration && CodeCompareUtil.isTheSameMethod(methodDeclaration, newNodeDeclaration = (MethodDeclaration)newNode)) {
                return true;
            }
            if (newNode.getChildNodes().size() <= 0) continue;
            CodeCompareUtil.isTheSameMethodExist(newNode.getChildNodes(), methodDeclaration);
        }
        return false;
    }

    public static boolean isTheSameMethod(MethodDeclaration methodDeclaration, MethodDeclaration newNodeDeclaration) {
        return ToolUtil.equals((Object)methodDeclaration.getType(), (Object)newNodeDeclaration.getType()) && ToolUtil.equals((Object)methodDeclaration.getParameters(), (Object)newNodeDeclaration.getParameters()) && ToolUtil.equals((Object)methodDeclaration.getName(), (Object)newNodeDeclaration.getName());
    }

    public static boolean isExistConflictMethod(List<Node> cuNewNodes, MethodDeclaration methodDeclaration, String path) {
        for (Node newNode : cuNewNodes) {
            boolean flag;
            MethodDeclaration newNodeDeclaration;
            if (newNode instanceof MethodDeclaration && CodeCompareUtil.isTheSameMethod(methodDeclaration, newNodeDeclaration = (MethodDeclaration)newNode) && CodeCompareUtil.isConflictMethod(methodDeclaration, newNodeDeclaration, path)) {
                return true;
            }
            if (newNode.getChildNodes().size() <= 0 || !(flag = CodeCompareUtil.isExistConflictMethod(newNode.getChildNodes(), methodDeclaration, path))) continue;
            return true;
        }
        return false;
    }

    private static boolean isConflictMethod(MethodDeclaration methodDeclaration, MethodDeclaration newNodeDeclaration, String path) {
        String md5M = MD5Util.encrypt((String)methodDeclaration.getBody().toString());
        String md5N = MD5Util.encrypt((String)newNodeDeclaration.getBody().toString());
        Object o = StoreFactory.readFileByVersion(path, CodeVersionConstant.currentVersion);
        CompilationUnit cuVersion = new CompilationUnit();
        if (ToolUtil.isNotEmpty((Object)o)) {
            cuVersion = JavaParser.parse((String)o.toString());
        }
        if (ToolUtil.isNotEmpty((Object)cuVersion)) {
            MethodDeclaration m = CodeCompareUtil.getSameMethodDeclaration(cuVersion.getChildNodes(), methodDeclaration);
            if (ToolUtil.isNotEmpty((Object)m)) {
                String md5L = MD5Util.encrypt((String)m.getBody().toString());
                return !ToolUtil.equals((Object)md5M, (Object)md5L) && !ToolUtil.equals((Object)md5L, (Object)md5N);
            }
            return false;
        }
        return false;
    }

    private static MethodDeclaration getSameMethodDeclaration(List<Node> nodes, MethodDeclaration methodDeclaration) {
        for (Node node : nodes) {
            MethodDeclaration m;
            boolean notEmpty;
            MethodDeclaration nowM;
            if (node instanceof MethodDeclaration && CodeCompareUtil.isTheSameMethod(nowM = (MethodDeclaration)node, methodDeclaration)) {
                return nowM;
            }
            if (!ToolUtil.isNotEmpty((Object)node.getChildNodes()) || !(notEmpty = ToolUtil.isNotEmpty((Object)(m = CodeCompareUtil.getSameMethodDeclaration(node.getChildNodes(), methodDeclaration))))) continue;
            return m;
        }
        return null;
    }
}

