/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.store;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.springframework.context.ApplicationContext;

public class StoreFactory {
    private static ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
    private static String projectPath = applicationContext.getEnvironment().getProperty("form-design.project-path");
    private static String moduleStorePath = applicationContext.getEnvironment().getProperty("form-design.module-store-path");
    private static String fileVersionPath = applicationContext.getEnvironment().getProperty("form-design.file-version-path");

    public static void createFileVersion(String key, String version, Object value) {
        String thisPath = projectPath + moduleStorePath + fileVersionPath;
        File fileVersion = new File(thisPath);
        if (!fileVersion.exists()) {
            fileVersion.mkdirs();
        }
        JSONObject jsonObject = new JSONObject();
        File thisVersion = new File(thisPath + "/" + version + ".fv");
        try {
            if (thisVersion.exists()) {
                String fileString = FileUtils.readFileToString((File)thisVersion, (String)"utf-8");
                jsonObject = JSON.parseObject((String)fileString);
            }
            jsonObject.put(StoreFactory.getRelativePath(key), JSON.toJSON((Object)value));
            if (ToolUtil.isEmpty((Object)jsonObject)) {
                FileUtils.writeStringToFile((File)thisVersion, (String)"", (String)"UTF-8", (boolean)false);
            } else {
                FileUtils.writeStringToFile((File)thisVersion, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8", (boolean)false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Object readFileByVersion(String key, String version) {
        StringBuilder filePath = new StringBuilder();
        filePath.append(projectPath).append(moduleStorePath).append(fileVersionPath).append(File.separator).append(version).append(".fv");
        File fileVersion = new File(String.valueOf(filePath));
        if (fileVersion.exists()) {
            String fileString = "";
            try {
                fileString = FileUtils.readFileToString((File)fileVersion, (String)"utf-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            JSONObject fileStringToJson = JSON.parseObject((String)fileString);
            Map fvMap = (Map)JSON.toJavaObject((JSON)fileStringToJson, Map.class);
            if (ToolUtil.isNotEmpty((Object)fvMap)) {
                return fvMap.get(StoreFactory.getRelativePath(key));
            }
            return null;
        }
        return null;
    }

    private static String getRelativePath(String absolutePath) {
        String path = projectPath;
        return absolutePath.replace(path.replace("/", File.separator).replace("\\", File.separator), "");
    }
}

