/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jsparser.es5.visitor;

import com.jxdinfo.hussar.formdesign.jsparser.common.utils.SourcePrinter;
import com.jxdinfo.hussar.formdesign.jsparser.es5.AllocationExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ArrayAccessExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ArrayLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.AssignmentExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.BinaryExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Block;
import com.jxdinfo.hussar.formdesign.jsparser.es5.BlockComment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.BooleanLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.BreakStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CallExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CaseBlock;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CaseClause;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CatchClause;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CompilationUnit;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ConditionalExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ConstantStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ContinueStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.DebuggerStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.DecimalLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.DefaultClause;
import com.jxdinfo.hussar.formdesign.jsparser.es5.DoWhileStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.EmptyLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.EmptyStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.EnclosedExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Expression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ExpressionStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.FieldAccessExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.FloatLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ForStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ForeachStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.FunctionDeclaration;
import com.jxdinfo.hussar.formdesign.jsparser.es5.FunctionExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.GetAssignment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.HexIntegerLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.IdentifierName;
import com.jxdinfo.hussar.formdesign.jsparser.es5.IfStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ImportStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.JSDocComment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.LabelledStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.LetDefinition;
import com.jxdinfo.hussar.formdesign.jsparser.es5.LetExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.LetStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.LineComment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.NewExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Node;
import com.jxdinfo.hussar.formdesign.jsparser.es5.NodeList;
import com.jxdinfo.hussar.formdesign.jsparser.es5.NullLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ObjectLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.OctalLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Parameter;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Project;
import com.jxdinfo.hussar.formdesign.jsparser.es5.PropertyAssignment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.PutAssignment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.RegexpLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ReturnStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.SequenceExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.SetAssignment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Statement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.StringLiteralDouble;
import com.jxdinfo.hussar.formdesign.jsparser.es5.StringLiteralSingle;
import com.jxdinfo.hussar.formdesign.jsparser.es5.SuperExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.SwitchStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ThisExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ThrowStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.TryStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.UnaryExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.VariableDeclaration;
import com.jxdinfo.hussar.formdesign.jsparser.es5.VariableExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.VariableStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.WhileStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.WithStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.visitor.VoidVisitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class TracePrinter
implements VoidVisitor<SourcePrinter> {
    private void printInlineJSDoc(JSDocComment jsDocComment, SourcePrinter printer) throws Exception {
        String content;
        if (jsDocComment != null && (content = jsDocComment.getContent()) != null) {
            content = content.replaceAll("\t", " ");
            content = content.replaceAll("\n", " ");
            content = content.replaceAll("\r", " ");
            printer.print("/**");
            printer.print(content);
            printer.print("*/");
            printer.print(" ");
        }
    }

    private void printExpressions(List<Expression> expressions, SourcePrinter printer) throws Exception, IOException {
        Iterator<Expression> i = expressions.iterator();
        while (i.hasNext()) {
            Expression expression = i.next();
            if (expression != null) {
                expression.accept(this, printer);
            }
            if (!i.hasNext()) continue;
            printer.print(", ");
        }
    }

    private void printStatements(List<Statement> statements, SourcePrinter printer) throws Exception, IOException {
        Iterator<Statement> i = statements.iterator();
        while (i.hasNext()) {
            Statement statement = i.next();
            statement.accept(this, printer);
            if (!i.hasNext()) continue;
        }
    }

    private void printVariableDeclarations(List<VariableDeclaration> decls, SourcePrinter printer) throws Exception, IOException {
        Iterator<VariableDeclaration> i = decls.iterator();
        while (i.hasNext()) {
            VariableDeclaration expression = i.next();
            expression.accept(this, printer);
            if (!i.hasNext()) continue;
            printer.print(", ");
        }
    }

    @Override
    public void visit(AllocationExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("new ");
        if (n.getBody() != null) {
            n.getBody().accept(this, printer);
        }
    }

    @Override
    public void visit(ArrayAccessExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getName() != null) {
            n.getName().accept(this, printer);
        }
        printer.print("[");
        if (n.getIndex() != null) {
            n.getIndex().accept(this, printer);
        }
        printer.print("]");
    }

    @Override
    public void visit(ArrayLiteral n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("[");
        NodeList<Expression> expressions = n.getExpressions();
        if (expressions != null) {
            this.printExpressions(expressions, printer);
        }
        printer.print("]");
    }

    @Override
    public void visit(AssignmentExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getTarget() != null) {
            n.getTarget().accept(this, printer);
        }
        if (n.getAssignOperator() != null) {
            n.getAssignOperator().accept(this, printer);
        }
        if (n.getValue() != null) {
            n.getValue().accept(this, printer);
        }
    }

    @Override
    public void visit(AssignmentExpression.AssignOperator n, SourcePrinter printer) throws Exception {
        printer.print(((Object)((Object)n)).getClass().getName());
        printer.print(":->");
        switch (n) {
            case and: {
                printer.print("&=");
                break;
            }
            case lShift: {
                printer.print("<<=");
                break;
            }
            case assign: {
                printer.print("=");
                break;
            }
            case minus: {
                printer.print("-=");
                break;
            }
            case or: {
                printer.print("|=");
                break;
            }
            case plus: {
                printer.print("+=");
                break;
            }
            case rem: {
                printer.print("%=");
                break;
            }
            case rSignedShift: {
                printer.print(">>=");
                break;
            }
            case rUnsignedShift: {
                printer.print(">>>=");
                break;
            }
            case slash: {
                printer.print("/=");
                break;
            }
            case star: {
                printer.print("*=");
                break;
            }
            case xor: {
                printer.print("^=");
            }
        }
    }

    @Override
    public void visit(BinaryExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getLeft() != null) {
            n.getLeft().accept(this, printer);
        }
        if (n.getBinaryOperator() != null) {
            n.getBinaryOperator().accept(this, printer);
        }
        if (n.getRight() != null) {
            n.getRight().accept(this, printer);
        }
    }

    @Override
    public void visit(BinaryExpression.BinaryOperator n, SourcePrinter printer) throws Exception {
        printer.print(((Object)((Object)n)).getClass().getName());
        printer.print(":->");
        switch (n) {
            case and: {
                printer.print("&&");
                break;
            }
            case binAnd: {
                printer.print("&");
                break;
            }
            case binOr: {
                printer.print("|");
                break;
            }
            case divide: {
                printer.print("/");
                break;
            }
            case equals: {
                printer.print("==");
                break;
            }
            case greater: {
                printer.print(">");
                break;
            }
            case greaterEquals: {
                printer.print(">=");
                break;
            }
            case identity: {
                printer.print("===");
                break;
            }
            case in: {
                printer.print("in");
                break;
            }
            case lShift: {
                printer.print("<<");
                break;
            }
            case less: {
                printer.print("<");
                break;
            }
            case lessEquals: {
                printer.print("<=");
                break;
            }
            case minus: {
                printer.print("-");
                break;
            }
            case notEquals: {
                printer.print("!=");
                break;
            }
            case notIdentity: {
                printer.print("!==");
                break;
            }
            case opInstanceof: {
                printer.print("instanceof");
                break;
            }
            case or: {
                printer.print("||");
                break;
            }
            case plus: {
                printer.print("+");
                break;
            }
            case rSignedShift: {
                printer.print(">>");
                break;
            }
            case rUnsignedShift: {
                printer.print(">>>");
                break;
            }
            case remainder: {
                printer.print("%");
                break;
            }
            case times: {
                printer.print("*");
                break;
            }
            case xor: {
                printer.print("^");
            }
        }
    }

    @Override
    public void visit(Block n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("{");
        if (n.getStatements() != null) {
            for (Statement item : n.getStatements()) {
                if (item == null) continue;
                item.accept(this, printer);
            }
        }
        printer.print("}");
    }

    @Override
    public void visit(BooleanLiteral n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print(n.isValue() ? "true" : "false");
    }

    @Override
    public void visit(BreakStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("break");
        if (n.getIdentifier() != null) {
            printer.print(" ");
            printer.print(n.getIdentifier());
        }
        printer.print(";");
    }

    @Override
    public void visit(CallExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getScope() != null) {
            n.getScope().accept(this, printer);
        }
        printer.print("(");
        if (n.getArgs() != null) {
            this.printExpressions(n.getArgs(), printer);
        }
        printer.print(")");
    }

    @Override
    public void visit(CaseBlock n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print(" {");
        if (n.getCaseClauses() != null) {
            for (CaseClause item : n.getCaseClauses()) {
                if (item == null) continue;
                item.accept(this, printer);
            }
        }
        if (n.getDefaultClause() != null) {
            n.getDefaultClause().accept(this, printer);
        }
        printer.print("}");
    }

    @Override
    public void visit(CaseClause n, SourcePrinter printer) throws Exception {
        NodeList<Statement> statements;
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getExpression() != null) {
            printer.print("case ");
            n.getExpression().accept(this, printer);
            printer.print(":");
        }
        if ((statements = n.getStatements()) != null) {
            this.printStatements(statements, printer);
        }
    }

    @Override
    public void visit(CatchClause n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print(" catch ( ");
        printer.print(n.getString());
        printer.print(" ) ");
        if (n.getBlock() != null) {
            n.getBlock().accept(this, printer);
        }
    }

    @Override
    public void visit(CompilationUnit n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getElements() != null) {
            for (Statement item : n.getElements()) {
                if (item == null) continue;
                item.accept(this, printer);
            }
        }
    }

    @Override
    public void visit(ConditionalExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getCondition() != null) {
            n.getCondition().accept(this, printer);
        }
        printer.print(" ? ");
        if (n.getThenExpr() != null) {
            n.getThenExpr().accept(this, printer);
        }
        printer.print(" : ");
        if (n.getElseExpr() != null) {
            n.getElseExpr().accept(this, printer);
        }
    }

    @Override
    public void visit(ConstantStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("const ");
        NodeList<VariableDeclaration> decls = n.getVariableDeclarations();
        if (decls != null) {
            this.printVariableDeclarations(decls, printer);
        }
        printer.print(";");
    }

    @Override
    public void visit(ContinueStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("continue");
        if (n.getIdentifier() != null) {
            printer.print(" ");
            printer.print(n.getIdentifier());
        }
        printer.print(";");
    }

    @Override
    public void visit(DebuggerStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.printLn("debugger;");
    }

    @Override
    public void visit(DecimalLiteral n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print(n.getValue());
    }

    @Override
    public void visit(DefaultClause n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("default:");
        NodeList<Statement> statements = n.getStatements();
        if (statements != null) {
            this.printStatements(statements, printer);
        }
    }

    @Override
    public void visit(DoWhileStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getBody() != null) {
            printer.print("do ");
            n.getBody().accept(this, printer);
        }
        if (n.getCondition() != null) {
            printer.print(" while (");
            n.getCondition().accept(this, printer);
            printer.print(")");
        }
    }

    @Override
    public void visit(EmptyLiteral n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
    }

    @Override
    public void visit(EmptyStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print(";");
    }

    @Override
    public void visit(EnclosedExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("(");
        if (n.getInner() != null) {
            n.getInner().accept(this, printer);
        }
        printer.print(")");
    }

    @Override
    public void visit(ExpressionStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getExpression() != null) {
            n.getExpression().accept(this, printer);
        }
        printer.print(";");
    }

    @Override
    public void visit(FieldAccessExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getScope() != null) {
            n.getScope().accept(this, printer);
        }
        if (n.getField() != null) {
            printer.print(".");
            n.getField().accept(this, printer);
        }
    }

    @Override
    public void visit(FloatLiteral n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print(n.getValue());
    }

    @Override
    public void visit(ForeachStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("for (");
        if (n.getVariable() != null) {
            n.getVariable().accept(this, printer);
        }
        printer.print(" in ");
        if (n.getExpression() != null) {
            n.getExpression().accept(this, printer);
        }
        printer.print(") ");
        if (n.getBody() != null) {
            n.getBody().accept(this, printer);
        }
    }

    @Override
    public void visit(ForStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("for (");
        if (n.getVariable() != null) {
            n.getVariable().accept(this, printer);
        }
        printer.print("; ");
        if (n.getCondition() != null) {
            n.getCondition().accept(this, printer);
        }
        printer.print("; ");
        if (n.getExpr() != null) {
            n.getExpr().accept(this, printer);
        }
        printer.print(") ");
        if (n.getBody() != null) {
            n.getBody().accept(this, printer);
        }
    }

    @Override
    public void visit(FunctionDeclaration n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("function ");
        printer.print(n.getName());
        printer.print("(");
        NodeList<Parameter> args = n.getParameters();
        if (args != null) {
            Iterator i = args.iterator();
            while (i.hasNext()) {
                Parameter e = (Parameter)i.next();
                e.accept(this, printer);
                if (!i.hasNext()) continue;
                printer.print(", ");
            }
        }
        printer.print(") ");
        if (n.getBody() != null) {
            n.getBody().accept(this, printer);
        }
    }

    @Override
    public void visit(FunctionExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("function");
        if (n.getName() != null) {
            printer.print(" ");
            printer.print(n.getName());
        }
        printer.print("(");
        if (n.getParameters() != null) {
            Iterator<Parameter> i = n.getParameters().iterator();
            while (i.hasNext()) {
                i.next().accept(this, printer);
                if (!i.hasNext()) continue;
                printer.print(", ");
            }
        }
        printer.print(") ");
        if (n.getBody() != null) {
            n.getBody().accept(this, printer);
        }
    }

    @Override
    public void visit(GetAssignment n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("get ");
        if (n.getPropertyName() != null) {
            n.getPropertyName().accept(this, printer);
        }
        printer.print("() ");
        if (n.getBlock() != null) {
            n.getBlock().accept(this, printer);
        }
    }

    @Override
    public void visit(HexIntegerLiteral n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print(n.getValue());
    }

    @Override
    public void visit(IdentifierName n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print(n.getValue());
    }

    @Override
    public void visit(IfStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("if (");
        if (n.getCondition() != null) {
            n.getCondition().accept(this, printer);
        }
        printer.print(") ");
        if (n.getThenStatement() != null) {
            n.getThenStatement().accept(this, printer);
        }
        if (n.getElseStatement() != null) {
            printer.print(" else ");
            n.getElseStatement().accept(this, printer);
        }
    }

    @Override
    public void visit(ImportStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("import ");
        if (n.getName() != null) {
            n.getName().accept(this, printer);
        }
        printer.printLn(";");
    }

    @Override
    public void visit(LabelledStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print(n.getLabel());
        printer.print(":");
        if (n.getStatement() != null) {
            n.getStatement().accept(this, printer);
        }
    }

    @Override
    public void visit(LetDefinition n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("let ");
        NodeList<VariableDeclaration> decls = n.getVariableDeclarations();
        if (decls != null) {
            this.printVariableDeclarations(decls, printer);
        }
        printer.print(";");
    }

    @Override
    public void visit(LetExpression n, SourcePrinter printer) throws Exception {
        NodeList<VariableDeclaration> decls;
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("let ");
        if (n.getExpression() != null) {
            printer.print("(");
        }
        if ((decls = n.getVariableDeclarations()) != null) {
            this.printVariableDeclarations(decls, printer);
        }
        if (n.getExpression() != null) {
            printer.print(") ");
            n.getExpression().accept(this, printer);
        }
    }

    @Override
    public void visit(LetStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("let (");
        NodeList<VariableDeclaration> decls = n.getVariableDeclarations();
        if (decls != null) {
            this.printVariableDeclarations(decls, printer);
        }
        printer.print(") ");
        if (n.getStatement() != null) {
            n.getStatement().accept(this, printer);
        }
        printer.print(";");
    }

    @Override
    public void visit(NewExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("new ");
        if (n.getExpression() != null) {
            n.getExpression().accept(this, printer);
        }
        if (n.getInitializer() != null) {
            n.getInitializer().accept(this, printer);
        }
    }

    @Override
    public void visit(NullLiteral n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("null");
    }

    @Override
    public void visit(ObjectLiteral n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("{");
        NodeList<PropertyAssignment> propertyAssignments = n.getPropertyAssignments();
        if (propertyAssignments != null) {
            Iterator i = propertyAssignments.iterator();
            while (i.hasNext()) {
                PropertyAssignment propertyAssignment = (PropertyAssignment)i.next();
                propertyAssignment.accept(this, printer);
                if (!i.hasNext()) continue;
                printer.print(",");
            }
        }
        printer.print("}");
    }

    @Override
    public void visit(OctalLiteral n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print(n.getValue());
    }

    @Override
    public void visit(Parameter n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print(n.getName());
    }

    @Override
    public void visit(Project n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getCompilationUnits() != null) {
            for (CompilationUnit item : n.getCompilationUnits()) {
                if (item == null) continue;
                item.accept(this, printer);
            }
        }
    }

    @Override
    public void visit(PutAssignment n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getPropertyName() != null) {
            n.getPropertyName().accept(this, printer);
        }
        printer.print(" : ");
        if (n.getPropertyValue() != null) {
            n.getPropertyValue().accept(this, printer);
        }
    }

    @Override
    public void visit(RegexpLiteral n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print(n.getValue());
    }

    @Override
    public void visit(ReturnStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("return");
        if (n.getExpression() != null) {
            printer.print(" ");
            n.getExpression().accept(this, printer);
        }
        printer.print(";");
    }

    @Override
    public void visit(SequenceExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getExpressions() != null) {
            Iterator<Expression> i = n.getExpressions().iterator();
            while (i.hasNext()) {
                Expression arg = i.next();
                if (arg == null) continue;
                arg.accept(this, printer);
                if (!i.hasNext()) continue;
                printer.print(", ");
            }
        }
    }

    @Override
    public void visit(SetAssignment n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("set ");
        if (n.getPropertyName() != null) {
            n.getPropertyName().accept(this, printer);
        }
        printer.print("(");
        printer.print(n.getIdentifier());
        printer.print(") ");
        if (n.getBlock() != null) {
            n.getBlock().accept(this, printer);
        }
    }

    @Override
    public void visit(StringLiteralSingle n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("'");
        printer.print(n.getValue());
        printer.print("'");
    }

    @Override
    public void visit(StringLiteralDouble n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("\"");
        printer.print(n.getValue());
        printer.print("\"");
    }

    @Override
    public void visit(SuperExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("super");
    }

    @Override
    public void visit(SwitchStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getExpression() != null) {
            printer.print("switch (");
            n.getExpression().accept(this, printer);
            printer.print(")");
        }
        if (n.getBlock() != null) {
            n.getBlock().accept(this, printer);
        } else {
            printer.print("{}");
        }
    }

    @Override
    public void visit(ThisExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("this");
    }

    @Override
    public void visit(ThrowStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("throw ");
        if (n.getExpression() != null) {
            n.getExpression().accept(this, printer);
        }
        printer.print(";");
    }

    @Override
    public void visit(TryStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getTryBlock() != null) {
            printer.print("try ");
            n.getTryBlock().accept(this, printer);
        }
        if (n.getCatchClause() != null) {
            n.getCatchClause().accept(this, printer);
        }
        if (n.getFinallyBlock() != null) {
            printer.print(" finally ");
            n.getFinallyBlock().accept(this, printer);
        }
    }

    @Override
    public void visit(UnaryExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        switch (n.getUnaryOperator()) {
            case delete: {
                printer.print(" delete ");
                break;
            }
            case inverse: {
                printer.print(" ~");
                break;
            }
            case negative: {
                printer.print(" -");
                break;
            }
            case not: {
                printer.print(" !");
                break;
            }
            case opVoid: {
                printer.print(" void ");
                break;
            }
            case positive: {
                printer.print(" +");
                break;
            }
            case preDecrement: {
                printer.print(" --");
                break;
            }
            case preIncrement: {
                printer.print(" ++");
                break;
            }
            case typeof: {
                printer.print(" typeof ");
                break;
            }
            case rem: {
                printer.print(" %");
                break;
            }
        }
        if (n.getExpression() != null) {
            n.getExpression().accept(this, printer);
        }
        switch (n.getUnaryOperator()) {
            case posDecrement: {
                printer.print("-- ");
                break;
            }
            case posIncrement: {
                printer.print("++ ");
                break;
            }
        }
    }

    @Override
    public void visit(UnaryExpression.UnaryOperator n, SourcePrinter printer) throws Exception {
        printer.print(((Object)((Object)n)).getClass().getName());
        printer.print(":->");
        switch (n) {
            case delete: {
                printer.print("delete ");
                break;
            }
            case inverse: {
                printer.print("~");
                break;
            }
            case negative: {
                printer.print("-");
                break;
            }
            case not: {
                printer.print("!");
                break;
            }
            case opVoid: {
                printer.print("void ");
                break;
            }
            case positive: {
                printer.print("+");
                break;
            }
            case preDecrement: {
                printer.print("--");
                break;
            }
            case preIncrement: {
                printer.print("++");
                break;
            }
            case typeof: {
                printer.print("typeof ");
                break;
            }
            case posDecrement: {
                printer.print("--");
                break;
            }
            case posIncrement: {
                printer.print("++");
                break;
            }
            case rem: {
                printer.print("%");
                break;
            }
        }
    }

    @Override
    public void visit(VariableDeclaration n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print(n.getName());
        if (n.getExpression() != null) {
            printer.print("=");
            n.getExpression().accept(this, printer);
        }
    }

    @Override
    public void visit(VariableExpression n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("var ");
        NodeList<VariableDeclaration> decls = n.getVariableDeclarations();
        if (decls != null) {
            this.printVariableDeclarations(decls, printer);
        }
    }

    @Override
    public void visit(VariableStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("var ");
        NodeList<VariableDeclaration> decls = n.getVariableDeclarations();
        if (decls != null) {
            this.printVariableDeclarations(decls, printer);
        }
        printer.print(";");
    }

    @Override
    public void visit(WhileStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("while (");
        if (n.getCondition() != null) {
            n.getCondition().accept(this, printer);
        }
        printer.print(") ");
        if (n.getBody() != null) {
            n.getBody().accept(this, printer);
        }
    }

    @Override
    public void visit(WithStatement n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        if (n.getExpression() != null) {
            printer.print("with (");
            n.getExpression().accept(this, printer);
            printer.print(")");
        }
        if (n.getStatement() != null) {
            n.getStatement().accept(this, printer);
        }
    }

    @Override
    public void visit(BlockComment n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("/*");
        printer.print(n.getContent().replaceAll("\t", "    "));
        printer.printLn("*/");
    }

    @Override
    public void visit(JSDocComment n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("/**");
        printer.print(n.getContent().replaceAll("\t", "    "));
        printer.printLn("*/");
    }

    @Override
    public void visit(LineComment n, SourcePrinter printer) throws Exception {
        printer.print(n.getClass().getName());
        printer.print(":->");
        this.printInlineJSDoc(n.getJsDocComment(), printer);
        printer.print("//");
        printer.printLn(n.getContent());
    }

    @Override
    public <E extends Node> void visit(NodeList<E> n, SourcePrinter printer) throws Exception {
    }
}

