/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jsparser.es5.visitor;

import com.jxdinfo.hussar.formdesign.jsparser.es5.AllocationExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ArrayAccessExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ArrayLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.AssignmentExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.BinaryExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Block;
import com.jxdinfo.hussar.formdesign.jsparser.es5.BlockComment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.BooleanLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.BreakStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CallExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CaseBlock;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CaseClause;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CatchClause;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CompilationUnit;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ConditionalExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ConstantStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ContinueStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.DebuggerStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.DecimalLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.DefaultClause;
import com.jxdinfo.hussar.formdesign.jsparser.es5.DoWhileStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.EmptyLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.EmptyStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.EnclosedExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ExpressionStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.FieldAccessExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.FloatLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ForStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ForeachStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.FunctionDeclaration;
import com.jxdinfo.hussar.formdesign.jsparser.es5.FunctionExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.GetAssignment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.HexIntegerLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.IdentifierName;
import com.jxdinfo.hussar.formdesign.jsparser.es5.IfStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ImportStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.JSDocComment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.LabelledStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.LetDefinition;
import com.jxdinfo.hussar.formdesign.jsparser.es5.LetExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.LetStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.LineComment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.NewExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Node;
import com.jxdinfo.hussar.formdesign.jsparser.es5.NodeList;
import com.jxdinfo.hussar.formdesign.jsparser.es5.NullLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ObjectLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.OctalLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Parameter;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Project;
import com.jxdinfo.hussar.formdesign.jsparser.es5.PutAssignment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.RegexpLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ReturnStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.SequenceExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.SetAssignment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.StringLiteralDouble;
import com.jxdinfo.hussar.formdesign.jsparser.es5.StringLiteralSingle;
import com.jxdinfo.hussar.formdesign.jsparser.es5.SuperExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.SwitchStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ThisExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ThrowStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.TryStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.UnaryExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.VariableDeclaration;
import com.jxdinfo.hussar.formdesign.jsparser.es5.VariableExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.VariableStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.WhileStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.WithStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.visitor.GenericVisitor;
import java.util.List;

public class EqualsVisitor
implements GenericVisitor<Boolean, Node> {
    private static final EqualsVisitor SINGLETON = new EqualsVisitor();

    public static boolean equals(Node n1, Node n2) throws Exception {
        return SINGLETON.nodeEquals(n1, n2);
    }

    protected <T extends Node> boolean nodeEquals(T n1, T n2) throws Exception {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null) {
            return n2 == null;
        }
        if (n2 == null) {
            return false;
        }
        if (n1.getClass() != n2.getClass()) {
            return false;
        }
        return n1.accept(this, n2);
    }

    protected <T extends Node> boolean nodesEquals(List<T> nodes1, List<T> nodes2) throws Exception {
        if (nodes1 == null) {
            return nodes2 == null;
        }
        if (nodes2 == null) {
            return false;
        }
        if (nodes1.size() != nodes2.size()) {
            return false;
        }
        for (int i = 0; i < nodes1.size(); ++i) {
            if (this.nodeEquals((Node)nodes1.get(i), (Node)nodes2.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean objEquals(Object n1, Object n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null) {
            return n2 == null;
        }
        if (n2 == null) {
            return false;
        }
        return n1.equals(n2);
    }

    @Override
    public Boolean visit(AllocationExpression n, Node ctx) throws Exception {
        AllocationExpression x = (AllocationExpression)ctx;
        if (!this.nodeEquals(n.getBody(), x.getBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ArrayAccessExpression n, Node ctx) throws Exception {
        ArrayAccessExpression x = (ArrayAccessExpression)ctx;
        if (!this.nodeEquals(n.getName(), x.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getIndex(), x.getIndex())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ArrayLiteral n, Node ctx) throws Exception {
        ArrayLiteral x = (ArrayLiteral)ctx;
        if (!this.nodeEquals(n.getExpressions(), x.getExpressions())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(AssignmentExpression n, Node ctx) throws Exception {
        AssignmentExpression x = (AssignmentExpression)ctx;
        if (!this.nodeEquals(n.getTarget(), x.getTarget())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getValue(), x.getValue())) {
            return Boolean.FALSE;
        }
        if (n.getAssignOperator() != x.getAssignOperator()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(AssignmentExpression.AssignOperator n, Node ctx) throws Exception {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(BinaryExpression n, Node ctx) throws Exception {
        BinaryExpression x = (BinaryExpression)ctx;
        if (!this.nodeEquals(n.getLeft(), x.getLeft())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getRight(), x.getRight())) {
            return Boolean.FALSE;
        }
        if (n.getBinaryOperator() != x.getBinaryOperator()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(BinaryExpression.BinaryOperator n, Node ctx) throws Exception {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(Block n, Node ctx) throws Exception {
        Block x = (Block)ctx;
        if (!this.nodeEquals(n.getStatements(), x.getStatements())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(BlockComment n, Node ctx) throws Exception {
        BlockComment x = (BlockComment)ctx;
        if (!this.objEquals(n.getContent(), x.getContent())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(BooleanLiteral n, Node ctx) throws Exception {
        BooleanLiteral x = (BooleanLiteral)ctx;
        if (n.isValue() != x.isValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(BreakStatement n, Node ctx) throws Exception {
        BreakStatement x = (BreakStatement)ctx;
        if (!this.objEquals(n.getIdentifier(), x.getIdentifier())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(CallExpression n, Node ctx) throws Exception {
        CallExpression x = (CallExpression)ctx;
        if (!this.nodeEquals(n.getScope(), x.getScope())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getArgs(), x.getArgs())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(CaseBlock n, Node ctx) throws Exception {
        CaseBlock x = (CaseBlock)ctx;
        if (!this.nodeEquals(n.getDefaultClause(), x.getDefaultClause())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getCaseClauses(), x.getCaseClauses())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(CaseClause n, Node ctx) throws Exception {
        CaseClause x = (CaseClause)ctx;
        if (!this.nodeEquals(n.getExpression(), x.getExpression())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getStatements(), x.getStatements())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(CatchClause n, Node ctx) throws Exception {
        CatchClause x = (CatchClause)ctx;
        if (!this.objEquals(n.getString(), x.getString())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getBlock(), x.getBlock())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(CompilationUnit n, Node ctx) throws Exception {
        CompilationUnit x = (CompilationUnit)ctx;
        if (!this.objEquals(n.getName(), x.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getElements(), x.getElements())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ConditionalExpression n, Node ctx) throws Exception {
        ConditionalExpression x = (ConditionalExpression)ctx;
        if (!this.nodeEquals(n.getCondition(), x.getCondition())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getThenExpr(), x.getThenExpr())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getElseExpr(), x.getElseExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ConstantStatement n, Node ctx) throws Exception {
        ConstantStatement x = (ConstantStatement)ctx;
        if (!this.nodeEquals(n.getVariableDeclarations(), x.getVariableDeclarations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ContinueStatement n, Node ctx) throws Exception {
        ContinueStatement x = (ContinueStatement)ctx;
        if (!this.objEquals(n.getIdentifier(), x.getIdentifier())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(DebuggerStatement n, Node ctx) throws Exception {
        return ctx instanceof DebuggerStatement;
    }

    @Override
    public Boolean visit(DecimalLiteral n, Node ctx) throws Exception {
        DecimalLiteral x = (DecimalLiteral)ctx;
        if (!this.objEquals(n.getValue(), x.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(DefaultClause n, Node ctx) throws Exception {
        DefaultClause x = (DefaultClause)ctx;
        if (!this.nodeEquals(n.getStatements(), x.getStatements())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(DoWhileStatement n, Node ctx) throws Exception {
        DoWhileStatement x = (DoWhileStatement)ctx;
        if (!this.nodeEquals(n.getCondition(), x.getCondition())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getBody(), x.getBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(EmptyLiteral n, Node ctx) throws Exception {
        return ctx instanceof EmptyLiteral;
    }

    @Override
    public Boolean visit(EmptyStatement n, Node ctx) throws Exception {
        return ctx instanceof EmptyStatement;
    }

    @Override
    public Boolean visit(EnclosedExpression n, Node ctx) throws Exception {
        EnclosedExpression x = (EnclosedExpression)ctx;
        if (!this.nodeEquals(n.getInner(), x.getInner())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ExpressionStatement n, Node ctx) throws Exception {
        ExpressionStatement x = (ExpressionStatement)ctx;
        if (!this.nodeEquals(n.getExpression(), x.getExpression())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(FieldAccessExpression n, Node ctx) throws Exception {
        FieldAccessExpression x = (FieldAccessExpression)ctx;
        if (!this.nodeEquals(n.getScope(), x.getScope())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getField(), x.getField())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(FloatLiteral n, Node ctx) throws Exception {
        FloatLiteral x = (FloatLiteral)ctx;
        if (!this.objEquals(n.getValue(), x.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ForeachStatement n, Node ctx) throws Exception {
        ForeachStatement x = (ForeachStatement)ctx;
        if (!this.nodeEquals(n.getVariable(), x.getVariable())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getExpression(), x.getExpression())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getBody(), x.getBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ForStatement n, Node ctx) throws Exception {
        ForStatement x = (ForStatement)ctx;
        if (!this.nodeEquals(n.getVariable(), x.getVariable())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getCondition(), x.getCondition())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getExpr(), x.getExpr())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getBody(), x.getBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(FunctionDeclaration n, Node ctx) throws Exception {
        FunctionDeclaration x = (FunctionDeclaration)ctx;
        if (!this.objEquals(n.getName(), x.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getParameters(), x.getParameters())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getBody(), x.getBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(FunctionExpression n, Node ctx) throws Exception {
        FunctionExpression x = (FunctionExpression)ctx;
        if (!this.objEquals(n.getName(), x.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getParameters(), x.getParameters())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getBody(), x.getBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(GetAssignment n, Node ctx) throws Exception {
        GetAssignment x = (GetAssignment)ctx;
        if (!this.nodeEquals(n.getBlock(), x.getBlock())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getPropertyName(), x.getPropertyName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getComment(), x.getComment())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(HexIntegerLiteral n, Node ctx) throws Exception {
        HexIntegerLiteral x = (HexIntegerLiteral)ctx;
        if (!this.objEquals(n.getValue(), x.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(IdentifierName n, Node ctx) throws Exception {
        IdentifierName x = (IdentifierName)ctx;
        if (!this.objEquals(n.getValue(), x.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(IfStatement n, Node ctx) throws Exception {
        IfStatement x = (IfStatement)ctx;
        if (!this.nodeEquals(n.getCondition(), x.getCondition())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getThenStatement(), x.getThenStatement())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getElseStatement(), x.getElseStatement())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ImportStatement n, Node ctx) throws Exception {
        ImportStatement x = (ImportStatement)ctx;
        if (!this.nodeEquals(n.getName(), x.getName())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(JSDocComment n, Node ctx) throws Exception {
        JSDocComment x = (JSDocComment)ctx;
        if (!this.objEquals(n.getContent(), x.getContent())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(LabelledStatement n, Node ctx) throws Exception {
        LabelledStatement x = (LabelledStatement)ctx;
        if (!this.objEquals(n.getLabel(), x.getLabel())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getStatement(), x.getStatement())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(LetDefinition n, Node ctx) throws Exception {
        LetDefinition x = (LetDefinition)ctx;
        if (!this.nodeEquals(n.getVariableDeclarations(), x.getVariableDeclarations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(LetExpression n, Node ctx) throws Exception {
        LetExpression x = (LetExpression)ctx;
        if (!this.nodeEquals(n.getVariableDeclarations(), x.getVariableDeclarations())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getExpression(), x.getExpression())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(LetStatement n, Node ctx) throws Exception {
        LetStatement x = (LetStatement)ctx;
        if (!this.nodeEquals(n.getVariableDeclarations(), x.getVariableDeclarations())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getStatement(), x.getStatement())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(LineComment n, Node ctx) throws Exception {
        LineComment x = (LineComment)ctx;
        if (!this.objEquals(n.getContent(), x.getContent())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(NewExpression n, Node ctx) throws Exception {
        NewExpression x = (NewExpression)ctx;
        if (!this.nodeEquals(n.getExpression(), x.getExpression())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getInitializer(), x.getInitializer())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public <E extends Node> Boolean visit(NodeList<E> n, Node ctx) throws Exception {
        NodeList x = (NodeList)ctx;
        if (!this.nodesEquals(n.getNodes(), x.getNodes())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(NullLiteral n, Node ctx) throws Exception {
        return ctx instanceof NullLiteral;
    }

    @Override
    public Boolean visit(ObjectLiteral n, Node ctx) throws Exception {
        ObjectLiteral x = (ObjectLiteral)ctx;
        if (!this.nodeEquals(n.getPropertyAssignments(), x.getPropertyAssignments())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(OctalLiteral n, Node ctx) throws Exception {
        OctalLiteral x = (OctalLiteral)ctx;
        if (!this.objEquals(n.getValue(), x.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(Parameter n, Node ctx) throws Exception {
        Parameter x = (Parameter)ctx;
        if (!this.objEquals(n.getName(), x.getName())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(Project n, Node ctx) throws Exception {
        Project x = (Project)ctx;
        if (!this.nodeEquals(n.getCompilationUnits(), x.getCompilationUnits())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(PutAssignment n, Node ctx) throws Exception {
        PutAssignment x = (PutAssignment)ctx;
        if (!this.nodeEquals(n.getPropertyValue(), x.getPropertyValue())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getPropertyName(), x.getPropertyName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getComment(), x.getComment())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(RegexpLiteral n, Node ctx) throws Exception {
        RegexpLiteral x = (RegexpLiteral)ctx;
        if (!this.objEquals(n.getValue(), x.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ReturnStatement n, Node ctx) throws Exception {
        ReturnStatement x = (ReturnStatement)ctx;
        if (!this.nodeEquals(n.getExpression(), x.getExpression())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SequenceExpression n, Node ctx) throws Exception {
        SequenceExpression x = (SequenceExpression)ctx;
        if (!this.nodeEquals(n.getExpressions(), x.getExpressions())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SetAssignment n, Node ctx) throws Exception {
        SetAssignment x = (SetAssignment)ctx;
        if (!this.objEquals(n.getIdentifier(), x.getIdentifier())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getBlock(), x.getBlock())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getPropertyName(), x.getPropertyName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getComment(), x.getComment())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(StringLiteralDouble n, Node ctx) throws Exception {
        StringLiteralDouble x = (StringLiteralDouble)ctx;
        if (!this.objEquals(n.getValue(), x.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(StringLiteralSingle n, Node ctx) throws Exception {
        StringLiteralSingle x = (StringLiteralSingle)ctx;
        if (!this.objEquals(n.getValue(), x.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SuperExpression n, Node ctx) throws Exception {
        return ctx instanceof SuperExpression;
    }

    @Override
    public Boolean visit(SwitchStatement n, Node ctx) throws Exception {
        SwitchStatement x = (SwitchStatement)ctx;
        if (!this.nodeEquals(n.getExpression(), x.getExpression())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getBlock(), x.getBlock())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ThisExpression n, Node ctx) throws Exception {
        return ctx instanceof ThisExpression;
    }

    @Override
    public Boolean visit(ThrowStatement n, Node ctx) throws Exception {
        ThrowStatement x = (ThrowStatement)ctx;
        if (!this.nodeEquals(n.getExpression(), x.getExpression())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(TryStatement n, Node ctx) throws Exception {
        TryStatement x = (TryStatement)ctx;
        if (!this.nodeEquals(n.getTryBlock(), x.getTryBlock())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getCatchClause(), x.getCatchClause())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getFinallyBlock(), x.getFinallyBlock())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(UnaryExpression n, Node ctx) throws Exception {
        UnaryExpression x = (UnaryExpression)ctx;
        if (!this.nodeEquals(n.getExpression(), x.getExpression())) {
            return Boolean.FALSE;
        }
        if (n.getUnaryOperator() != x.getUnaryOperator()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(UnaryExpression.UnaryOperator n, Node ctx) throws Exception {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(VariableDeclaration n, Node ctx) throws Exception {
        VariableDeclaration x = (VariableDeclaration)ctx;
        if (!this.objEquals(n.getName(), x.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getExpression(), x.getExpression())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(VariableExpression n, Node ctx) throws Exception {
        VariableExpression x = (VariableExpression)ctx;
        if (!this.nodeEquals(n.getVariableDeclarations(), x.getVariableDeclarations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(VariableStatement n, Node ctx) throws Exception {
        VariableStatement x = (VariableStatement)ctx;
        if (!this.nodeEquals(n.getVariableDeclarations(), x.getVariableDeclarations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(WhileStatement n, Node ctx) throws Exception {
        WhileStatement x = (WhileStatement)ctx;
        if (!this.nodeEquals(n.getCondition(), x.getCondition())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getBody(), x.getBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(WithStatement n, Node ctx) throws Exception {
        WithStatement x = (WithStatement)ctx;
        if (!this.nodeEquals(n.getExpression(), x.getExpression())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n.getStatement(), x.getStatement())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

