/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jsparser.es5.tools;

import com.jxdinfo.hussar.formdesign.jsparser.es5.AllocationExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ArrayAccessExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ArrayLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.AssignmentExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.BinaryExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Block;
import com.jxdinfo.hussar.formdesign.jsparser.es5.BlockComment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.BooleanLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.BreakStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CallExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CaseBlock;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CaseClause;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CatchClause;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CompilationUnit;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ConditionalExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ConstantStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ContinueStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.DebuggerStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.DecimalLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.DefaultClause;
import com.jxdinfo.hussar.formdesign.jsparser.es5.DoWhileStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.EmptyLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.EmptyStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.EnclosedExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Expression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ExpressionStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.FieldAccessExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.FloatLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ForStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ForeachStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.FunctionDeclaration;
import com.jxdinfo.hussar.formdesign.jsparser.es5.FunctionExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.GetAssignment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.HexIntegerLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.IdentifierName;
import com.jxdinfo.hussar.formdesign.jsparser.es5.IfStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ImportStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.LabelledStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.LetDefinition;
import com.jxdinfo.hussar.formdesign.jsparser.es5.LetExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.LetStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.NewExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Node;
import com.jxdinfo.hussar.formdesign.jsparser.es5.NodeFacade;
import com.jxdinfo.hussar.formdesign.jsparser.es5.NullLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ObjectLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.OctalLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Parameter;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Project;
import com.jxdinfo.hussar.formdesign.jsparser.es5.PutAssignment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.RegexpLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ReturnStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.SequenceExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.SetAssignment;
import com.jxdinfo.hussar.formdesign.jsparser.es5.StringLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.StringLiteralDouble;
import com.jxdinfo.hussar.formdesign.jsparser.es5.StringLiteralSingle;
import com.jxdinfo.hussar.formdesign.jsparser.es5.SuperExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.SwitchStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ThisExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ThrowStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.TryStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.UnaryExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.VariableDeclaration;
import com.jxdinfo.hussar.formdesign.jsparser.es5.VariableExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.VariableStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.WhileStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.WithStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.parser.ASTParser;
import com.jxdinfo.hussar.formdesign.jsparser.es5.tools.DefaultErrorManager;
import com.jxdinfo.hussar.formdesign.jsparser.es5.tools.IErrorManager;
import com.jxdinfo.hussar.formdesign.jsparser.es5.visitor.VoidVisitorAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class NamespaceOrganizer
extends VoidVisitorAdapter<Node> {
    private IErrorManager errorManager;
    private TreeMap<String, Node> nodes = new TreeMap();
    private String output;
    private String path;
    private Map<String, String> browsers;
    private Map<String, List<String>> libraries;
    private static final String JS_EXT = "js";
    private static final String JS_EXT_DOTTED = ".js";
    private String copyright;
    private String defaultNamespace = "globals";

    public static void main(String[] args) {
        String src0 = null;
        String dst0 = null;
        String copy0 = null;
        String defaultNamespace0 = null;
        ArrayList<String> libs0 = new ArrayList<String>();
        ArrayList<String> browsers0 = new ArrayList<String>();
        Status status = Status.NONE;
        for (int i = 0; i < args.length; ++i) {
            if ("-src".equals(args[i])) {
                status = Status.SRC;
                continue;
            }
            if (status == Status.SRC) {
                src0 = args[i];
                status = Status.NONE;
                continue;
            }
            if ("-dst".equals(args[i])) {
                status = Status.DST;
                continue;
            }
            if (status == Status.DST) {
                dst0 = args[i];
                status = Status.NONE;
                continue;
            }
            if ("-defaultClass".equals(args[i])) {
                status = Status.DEFAULT_NAMESPACE;
                continue;
            }
            if (status == Status.DEFAULT_NAMESPACE) {
                defaultNamespace0 = args[i];
                status = Status.NONE;
                continue;
            }
            if ("-copyright".equals(args[i])) {
                status = Status.COPYRIGHT;
                continue;
            }
            if (status == Status.COPYRIGHT) {
                copy0 = args[i];
                status = Status.NONE;
                continue;
            }
            if ("-browser".equals(args[i])) {
                status = Status.BROWSER;
                continue;
            }
            if (status == Status.BROWSER) {
                browsers0.add(args[i]);
                status = Status.NONE;
                continue;
            }
            if ("-lib".equals(args[i])) {
                status = Status.LIB;
                continue;
            }
            if (status != Status.LIB) continue;
            libs0.add(args[i]);
            status = Status.NONE;
        }
        String src = src0;
        String dst = dst0;
        final NamespaceOrganizer namespaceOgranizer = new NamespaceOrganizer(new DefaultErrorManager());
        namespaceOgranizer.setLibraries(NamespaceOrganizer.prepareLibraries(libs0));
        namespaceOgranizer.setBrowsers(NamespaceOrganizer.prepareBrowsers(browsers0));
        namespaceOgranizer.setOutput(dst);
        namespaceOgranizer.setCopyright(copy0);
        if (defaultNamespace0 != null) {
            namespaceOgranizer.setDefaultNamespace(defaultNamespace0);
        }
        if (src == null || dst == null) {
            System.out.println("Usage:");
            System.out.println("com.jxdinfo.hussar.formdesign.jsparser.es5.tools.NamespaceOrganizer\n -src          : JavaScript externs (*.js) input folder\n -dst          : output folder path\n -lib          : to organize externs by library. If no -lib flags are specified, externs will be organized by namespace.\n                 Usage example:\n                 -lib DomAPI:Attr,Document,DocumentFragment\n -browser      : (optional) to specify browser-specific JavaScript externs.\n                 Usage example:\n                 -browser ie:ie_event.js,ie_dom.js\n -defaultClass : (optional) file name to save variables and functions without any namespace when externs are organized by namespace. Default value is \"globals\"\n                 Usage example:\n                 -defaultClass globals\n -copyright    : (optional) copyright notice for generated files\n");
            System.exit(1);
        }
        Path p = Paths.get(src, new String[0]);
        SimpleFileVisitor<Path> fv = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                try {
                    if (file.toString().endsWith(NamespaceOrganizer.JS_EXT)) {
                        FileInputStream stream = new FileInputStream(file.toFile());
                        CompilationUnit unit = new ASTParser(stream, "UTF-8").CompilationUnit(null);
                        namespaceOgranizer.setPath(file.getFileName().toString());
                        unit.accept(namespaceOgranizer, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(p, (FileVisitor<? super Path>)fv);
            if (!libs0.isEmpty()) {
                namespaceOgranizer.byLibrary();
            } else {
                namespaceOgranizer.byClass();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<String, String> prepareBrowsers(List<String> browsers) {
        HashMap<String, String> resultBrowsers = new HashMap<String, String>();
        for (String browser : browsers) {
            String[] pieces = browser.split(":");
            if (pieces.length == 2) {
                String browserName = pieces[0];
                for (String name : pieces[1].split(",")) {
                    if (name.isEmpty()) continue;
                    resultBrowsers.put(name, browserName);
                }
                continue;
            }
            throw new IllegalArgumentException("Invalid Browser definition: " + browser);
        }
        return resultBrowsers;
    }

    private static Map<String, List<String>> prepareLibraries(List<String> libraries) {
        HashMap<String, List<String>> resultLibraries = new HashMap<String, List<String>>();
        for (String library : libraries) {
            String[] pieces = library.split(":");
            if (pieces.length == 2) {
                ArrayList<String> namespaces = new ArrayList<String>();
                for (String name : pieces[1].split(",")) {
                    if (name.isEmpty()) continue;
                    namespaces.add(name.trim());
                }
                resultLibraries.put(pieces[0].trim(), namespaces);
                continue;
            }
            throw new IllegalArgumentException("Invalid Library definition: " + library);
        }
        return resultLibraries;
    }

    public NamespaceOrganizer(IErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setBrowsers(Map<String, String> browsers) {
        this.browsers = browsers;
    }

    public void setLibraries(Map<String, List<String>> libraries) {
        this.libraries = libraries;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void byClass() throws Exception {
        TreeMap<String, Node> finalNodes = new TreeMap<String, Node>(new SymbolComparator());
        finalNodes.putAll(this.nodes);
        TreeMap<String, Node> myNodes = new TreeMap<String, Node>(new AlphabetComparator());
        myNodes.putAll(finalNodes);
        Set set = myNodes.keySet();
        ArrayList<Node> globals = new ArrayList<Node>();
        while (!myNodes.isEmpty()) {
            String name = null;
            Iterator itr = set.iterator();
            ArrayList<Node> finalNode = new ArrayList<Node>();
            ArrayList<String> names = new ArrayList<String>();
            while (itr.hasNext()) {
                String o = (String)itr.next();
                if (name == null) {
                    if (o.contains(".")) {
                        int index = o.indexOf(".");
                        name = o.substring(0, index);
                    } else {
                        name = o;
                    }
                }
                if (!o.toLowerCase().startsWith(name.toLowerCase() + ".") && !o.equalsIgnoreCase(name)) continue;
                finalNode.add((Node)myNodes.get(o));
                itr.remove();
                names.add(o);
            }
            if (finalNode.size() > 1 || this.canBeClassDecl((Node)finalNode.get(0))) {
                this.createFile(finalNode, name);
                continue;
            }
            globals.addAll(finalNode);
        }
        if (!globals.isEmpty()) {
            this.createFile(globals, this.defaultNamespace);
        }
    }

    private boolean canBeClassDecl(Node node) {
        boolean canBe = false;
        canBe = node instanceof FunctionDeclaration && Character.isUpperCase(((FunctionDeclaration)node).getName().charAt(0)) || node instanceof VariableStatement && ((VariableStatement)node).getVariableDeclarations().size() == 1 && Character.isUpperCase(((VariableDeclaration)((VariableStatement)node).getVariableDeclarations().get(0)).getName().charAt(0));
        return canBe;
    }

    public void byOneUnit() throws Exception {
    }

    public void byLibrary() throws IOException {
        if (this.libraries != null && !this.libraries.isEmpty()) {
            TreeMap<String, Node> myNodes = new TreeMap<String, Node>((SortedMap<String, Node>)this.nodes);
            for (String library : this.libraries.keySet()) {
                List<String> namespaces = this.libraries.get(library);
                ArrayList<Node> libraryNodes = new ArrayList<Node>();
                for (String string : namespaces) {
                    libraryNodes.addAll(this.pollNodes(myNodes, string));
                }
                this.createFile(libraryNodes, library);
            }
            if (!myNodes.isEmpty()) {
                this.createFile(new ArrayList<Node>(myNodes.values()), "DefaultLibrary");
            }
        }
    }

    public List<Node> pollNodes(Map<String, Node> nodes, String prefix) {
        Set<String> set = nodes.keySet();
        ArrayList<Node> poll = new ArrayList<Node>();
        Iterator<String> itr = set.iterator();
        while (itr.hasNext()) {
            String o = itr.next();
            if (!o.startsWith(prefix + ".") && !o.equals(prefix)) continue;
            poll.add(nodes.get(o));
            itr.remove();
        }
        return poll;
    }

    private void createFile(Collection<Node> nodes, String name) throws IOException {
        Path path = Paths.get(this.output, name + JS_EXT_DOTTED);
        CompilationUnit result = NodeFacade.CompilationUnit(null, (List)nodes, name);
        File output = path.toFile();
        if (!output.exists()) {
            output.createNewFile();
        } else {
            this.errorManager.report(IErrorManager.ErrorType.WARNING, "FILE WILL BE OVERRIDDEN: " + output.getAbsolutePath());
        }
        FileOutputStream stream = new FileOutputStream(output);
        String content = result.toString();
        if (this.copyright != null) {
            content = this.copyright + "\n\n" + result.toString();
        }
        stream.write(content.getBytes());
        stream.close();
    }

    public Map<String, Node> getNodes() {
        return this.nodes;
    }

    @Override
    public void visit(ExpressionStatement n, Node ctx) throws Exception {
        Expression expression = n.getExpression();
        if (expression instanceof AssignmentExpression || expression instanceof IdentifierName || expression instanceof FieldAccessExpression || expression instanceof ArrayAccessExpression) {
            n.getExpression().accept(this, n);
        } else {
            this.warnUnknown(expression);
        }
    }

    @Override
    public void visit(AllocationExpression n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(ArrayAccessExpression n, Node ctx) throws Exception {
        Expression index = n.getIndex();
        Expression name = n.getName();
        if ((name instanceof FieldAccessExpression || name instanceof IdentifierName) && index instanceof StringLiteral) {
            String realName = name.toString() + "." + ((StringLiteral)index).getValue();
            this.put(realName, ctx);
        } else {
            this.warnUnknown(n);
        }
    }

    @Override
    public void visit(ArrayLiteral n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(AssignmentExpression n, Node ctx) throws Exception {
        Expression expression = n.getTarget();
        if (expression instanceof IdentifierName || expression instanceof FieldAccessExpression || expression instanceof ArrayAccessExpression) {
            expression.accept(this, ctx);
        } else {
            this.warnUnknown(expression);
        }
    }

    @Override
    public void visit(BinaryExpression n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(Block n, Node ctx) throws Exception {
        super.visit(n, ctx);
    }

    @Override
    public void visit(BlockComment n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(BooleanLiteral n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(BreakStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(CallExpression n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(CaseBlock n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(CaseClause n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(CatchClause n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(ConditionalExpression n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(ConstantStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(ContinueStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(DebuggerStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(DecimalLiteral n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(DefaultClause n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(DoWhileStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(EmptyLiteral n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(EmptyStatement n, Node ctx) throws Exception {
        super.visit(n, ctx);
    }

    @Override
    public void visit(EnclosedExpression n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(FieldAccessExpression n, Node ctx) throws Exception {
        String name = n.toString();
        this.put(name, ctx);
    }

    @Override
    public void visit(FloatLiteral n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(ForeachStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(ForStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(FunctionDeclaration n, Node ctx) throws Exception {
        this.put(n.getName(), n);
    }

    @Override
    public void visit(FunctionExpression n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(GetAssignment n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(HexIntegerLiteral n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(IdentifierName n, Node ctx) throws Exception {
        String name = n.toString();
        this.put(name, ctx);
    }

    @Override
    public void visit(IfStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(ImportStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(LabelledStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(LetDefinition n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(LetExpression n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(LetStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(NewExpression n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(NullLiteral n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(ObjectLiteral n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(OctalLiteral n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(Parameter n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(Project n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(PutAssignment n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(RegexpLiteral n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(ReturnStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(SequenceExpression n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(SetAssignment n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(StringLiteralDouble n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(StringLiteralSingle n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(SuperExpression n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(SwitchStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(ThisExpression n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(ThrowStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(TryStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(UnaryExpression n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(VariableDeclaration n, Node ctx) throws Exception {
        String realName = n.getName();
        this.put(realName, ctx);
    }

    @Override
    public void visit(VariableExpression n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(VariableStatement n, Node ctx) throws Exception {
        super.visit(n, n);
    }

    @Override
    public void visit(WhileStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    @Override
    public void visit(WithStatement n, Node ctx) throws Exception {
        this.warnUnknown(n);
        super.visit(n, ctx);
    }

    private void warnUnknown(Node node) {
        this.errorManager.report(IErrorManager.ErrorType.ERROR, "UNKNOWN NODE:  " + node.getClass().getName() + " " + node.toString());
    }

    private void warnDuplicate(Node node, String name) {
        this.errorManager.report(IErrorManager.ErrorType.WARNING, "DUPLICATE NODE: " + node.getClass().getName() + " " + this.nodes.get(name).toString() + ". NODES WILL BE MERGED");
    }

    private void put(String name, Node node) {
        if (this.nodes.containsKey(name)) {
            String browser;
            this.warnDuplicate(node, name);
            Node existingNode = this.nodes.get(name);
            String finalComment = "";
            if (existingNode.getJsDocComment() != null && existingNode.getJsDocComment().getContent() != null) {
                finalComment = finalComment + existingNode.getJsDocComment().getContent();
            }
            if (this.browsers != null && (browser = this.browsers.get(this.path)) != null) {
                finalComment = finalComment + "\n * @browser " + browser + "\n";
            }
            if (!finalComment.isEmpty()) {
                existingNode.setJsDocComment(NodeFacade.JSDocComment(finalComment));
            }
        } else {
            String browser;
            this.nodes.put(name, node);
            String finalComment = "";
            if (node.getJsDocComment() != null && node.getJsDocComment().getContent() != null) {
                finalComment = finalComment + node.getJsDocComment().getContent();
            }
            if (this.browsers != null && (browser = this.browsers.get(this.path)) != null) {
                finalComment = finalComment + "\n * @browser " + browser + "\n";
            }
            if (!finalComment.isEmpty()) {
                node.setJsDocComment(NodeFacade.JSDocComment(finalComment));
            }
        }
    }

    public class AlphabetComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    }

    public class SymbolComparator
    implements Comparator<String> {
        @Override
        public int compare(String key1, String key2) {
            if (key1.length() <= key2.length()) {
                return -1;
            }
            return 1;
        }
    }

    public static enum Status {
        SRC,
        DST,
        LIB,
        COPYRIGHT,
        BROWSER,
        DEFAULT_NAMESPACE,
        NONE;

    }
}

