/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jsparser.es5.io;

import com.jxdinfo.hussar.formdesign.jsparser.common.utils.FileExtensions;
import com.jxdinfo.hussar.formdesign.jsparser.common.utils.SourcePrinter;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CompilationUnit;
import com.jxdinfo.hussar.formdesign.jsparser.es5.NodeList;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Project;
import com.jxdinfo.hussar.formdesign.jsparser.es5.visitor.PrinterVisitor;
import java.io.File;
import java.io.FileOutputStream;

public class Output
implements Runnable {
    private static final String ENCODING = "UTF-8";
    private static final String EXT = FileExtensions.JS.END;
    private String encoding = null;
    private String path = null;
    private Project project = null;

    public Output() {
    }

    public Output(String encoding, String path, Project project) {
        this.encoding = encoding == null ? ENCODING : encoding;
        this.path = path;
        this.project = project;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public void run() {
        NodeList<CompilationUnit> compilationUnits = this.project.getCompilationUnits();
        if (compilationUnits != null) {
            for (CompilationUnit unit : compilationUnits) {
                String dir = this.getPath(this.path, this.getName(unit));
                File distFile = new File(dir);
                distFile.getParentFile().mkdirs();
                try {
                    FileOutputStream out = new FileOutputStream(distFile);
                    Throwable throwable = null;
                    try {
                        unit.accept(new PrinterVisitor(), new SourcePrinter(out, this.encoding));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Exception e) {
                    throw new Error(e.getMessage());
                }
            }
        }
    }

    private String getName(CompilationUnit unit) {
        return unit.getName();
    }

    private String getPath(String path, String name) {
        return path + Output.createPathFromQName(name) + EXT;
    }

    private static String createPathFromQName(String name) {
        String[] split = name.split("\\.");
        String ret = File.separatorChar + split[0];
        for (int i = 1; i < split.length; ++i) {
            ret = ret + File.separatorChar + split[i];
        }
        return ret;
    }
}

