/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jsparser.es5.io;

import com.jxdinfo.hussar.formdesign.jsparser.common.utils.FileExtensions;
import com.jxdinfo.hussar.formdesign.jsparser.es5.NodeFacade;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Project;
import com.jxdinfo.hussar.formdesign.jsparser.es5.parser.ASTParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;

public class Input
implements Runnable {
    private static final String ENCODING = "UTF-8";
    private static final String EXT = FileExtensions.JS.END;
    private String encoding = null;
    private boolean recursive = false;
    private String path = null;
    private Project project = null;

    public Input() {
    }

    public Input(String encoding, boolean recursive, String path, Project project) {
        this.encoding = encoding == null ? ENCODING : encoding;
        this.recursive = recursive;
        this.path = path;
        this.project = project;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public void run() {
        final ArrayList compilationUnits = new ArrayList();
        Path p = Paths.get(this.path, new String[0]);
        SimpleFileVisitor<Path> fv = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path item, BasicFileAttributes attrs) throws IOException {
                File file = item.toFile();
                if (file.isDirectory()) {
                    return Input.this.recursive ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
                }
                if (item.toString().endsWith(EXT)) {
                    try (FileInputStream stream = new FileInputStream(file);){
                        compilationUnits.add(new ASTParser(stream, Input.this.encoding).CompilationUnit(item.getFileName().toString()));
                        stream.close();
                    }
                    catch (Exception e) {
                        throw new Error(e.getMessage());
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(p, (FileVisitor<? super Path>)fv);
        }
        catch (Exception e) {
            throw new Error(e.getMessage());
        }
        this.project.setCompilationUnits(NodeFacade.NodeList(compilationUnits, null, 0, 0));
    }
}

