/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jsparser.common.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class SourcePrinter {
    private int level = 0;
    private boolean indented = false;
    public static final String INDENT = "    ";
    public static final String NEWLINE = "\n";
    private String res = "";
    private byte[] indent;
    private byte[] newline;
    private Charset charset;
    private final OutputStream out;

    public SourcePrinter(OutputStream out, String encoding) {
        this.out = out;
        this.charset = encoding != null && Charset.isSupported(encoding) ? Charset.forName(encoding) : Charset.forName("UTF-8");
        this.indent = INDENT.getBytes(this.charset);
        this.newline = NEWLINE.getBytes(this.charset);
    }

    public void indent() {
        ++this.level;
    }

    public void unindent() {
        --this.level;
    }

    private void makeIndent() throws IOException {
        for (int i = 0; i < this.level; ++i) {
            this.res = this.res + INDENT;
            this.out.write(this.indent);
        }
    }

    public void print(String arg) throws IOException {
        if (!this.indented) {
            this.makeIndent();
            this.indented = true;
        }
        this.res = this.res + arg;
        this.out.write(arg.getBytes(this.charset));
    }

    public void printLn(String arg) throws IOException {
        this.print(arg);
        this.printLn();
    }

    public void printLn() throws IOException {
        this.res = this.res + NEWLINE;
        if (!this.out.toString().endsWith(NEWLINE)) {
            this.out.write(this.newline);
        }
        this.indented = false;
    }

    public String getOutput() {
        return this.res;
    }
}

