/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.engine.config;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import com.jxdinfo.hussar.core.constant.IsMenu;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.generator.action.model.FDGeneratorProperties;
import com.jxdinfo.hussar.formdesign.generator.engine.config.ContextConfig;
import com.jxdinfo.hussar.formdesign.generator.engine.config.Menu;
import com.jxdinfo.hussar.formdesign.jsparser.common.utils.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@DependsOn(value={"springContextHolder"})
public class SqlConfig {
    SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)SpringContextHolder.getBean(SqlSessionFactory.class);
    private Environment env = (Environment)SpringContextHolder.getBean(Environment.class);
    private String sqlPathTemplate;
    private ContextConfig contextConfig;
    private Connection connection;
    private String parentMenuName;
    private List<Menu> menus = new ArrayList<Menu>(6);
    private FDGeneratorProperties hussarProperties = (FDGeneratorProperties)SpringContextHolder.getBean(FDGeneratorProperties.class);

    public void init() {
        String environment = this.hussarProperties.getEnvironment();
        String pageLocal = "";
        pageLocal = "dyna".equals(environment) ? "\\src\\" : "\\src\\main\\java\\";
        this.sqlPathTemplate = pageLocal + "{}.sql";
        if (this.parentMenuName == null) {
            return;
        }
        String[] pcodeAndPcodes = this.getPcodeAndPcodes();
        if (pcodeAndPcodes == null) {
            System.err.println("\u7236\u7ea7\u83dc\u5355\u540d\u79f0\u8f93\u5165\u6709\u8bef!!!!");
            return;
        }
        Menu menu = new Menu();
        menu.setId(IdWorker.getId());
        menu.setCode(this.contextConfig.getBizEnName());
        menu.setPcode(pcodeAndPcodes[0]);
        menu.setPcodes(pcodeAndPcodes[1] + "[" + pcodeAndPcodes[0] + "],");
        menu.setName(this.contextConfig.getBizChName());
        menu.setIcon("");
        menu.setUrl("/" + this.contextConfig.getBizEnName());
        menu.setNum(99);
        if ("\u9876\u7ea7".equals(this.parentMenuName)) {
            menu.setLevels(1);
        } else {
            menu.setLevels(2);
        }
        menu.setIsmenu(IsMenu.YES.getCode());
        menu.setStatus(1);
        menu.setIsopen(0);
        this.menus.add(menu);
        Menu list = this.createSubMenu(menu);
        list.setCode(this.contextConfig.getBizEnName() + "_list");
        list.setName(this.contextConfig.getBizChName() + "\u5217\u8868");
        list.setUrl("/" + this.contextConfig.getBizEnName() + "/list");
        this.menus.add(list);
        Menu add = this.createSubMenu(menu);
        add.setCode(this.contextConfig.getBizEnName() + "_add");
        add.setName(this.contextConfig.getBizChName() + "\u6dfb\u52a0");
        add.setUrl("/" + this.contextConfig.getBizEnName() + "/add");
        this.menus.add(add);
        Menu update = this.createSubMenu(menu);
        update.setCode(this.contextConfig.getBizEnName() + "_update");
        update.setName(this.contextConfig.getBizChName() + "\u66f4\u65b0");
        update.setUrl("/" + this.contextConfig.getBizEnName() + "/update");
        this.menus.add(update);
        Menu delete = this.createSubMenu(menu);
        delete.setCode(this.contextConfig.getBizEnName() + "_delete");
        delete.setName(this.contextConfig.getBizChName() + "\u5220\u9664");
        delete.setUrl("/" + this.contextConfig.getBizEnName() + "/delete");
        this.menus.add(delete);
        Menu detail = this.createSubMenu(menu);
        detail.setCode(this.contextConfig.getBizEnName() + "_detail");
        detail.setName(this.contextConfig.getBizChName() + "\u8be6\u60c5");
        detail.setUrl("/" + this.contextConfig.getBizEnName() + "/detail");
        this.menus.add(detail);
    }

    private Menu createSubMenu(Menu parentMenu) {
        Menu menu = new Menu();
        menu.setId(IdWorker.getId());
        menu.setPcode(parentMenu.getCode());
        menu.setPcodes(parentMenu.getPcodes() + "[" + parentMenu.getCode() + "],");
        menu.setIcon("");
        menu.setNum(99);
        menu.setLevels(parentMenu.getLevels() + 1);
        menu.setIsmenu(IsMenu.NO.getCode());
        menu.setStatus(1);
        menu.setIsopen(0);
        return menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPcodeAndPcodes() {
        if ("\u9876\u7ea7".equals(this.parentMenuName)) {
            return new String[]{"0", ""};
        }
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        try {
            preparedStatement = this.connection.prepareStatement("select * from sys_menu where name like ?");
            preparedStatement.setString(1, "%" + this.parentMenuName + "%");
            results = preparedStatement.executeQuery();
            if (results.next()) {
                String pcode = results.getString("code");
                String pcodes = results.getString("pcodes");
                if (ToolUtil.isNotEmpty((Object)pcode) && ToolUtil.isNotEmpty((Object)pcodes)) {
                    String[] strings;
                    String[] stringArray = strings = new String[]{pcode, pcodes};
                    return stringArray;
                }
                String[] stringArray = null;
                return stringArray;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ContextConfig getContextConfig() {
        return this.contextConfig;
    }

    public void setContextConfig(ContextConfig contextConfig) {
        this.contextConfig = contextConfig;
    }

    public String getParentMenuName() {
        return this.parentMenuName;
    }

    public void setParentMenuName(String parentMenuName) {
        this.parentMenuName = parentMenuName;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getSqlPathTemplate() {
        return this.sqlPathTemplate;
    }

    public void setSqlPathTemplate(String sqlPathTemplate) {
        this.sqlPathTemplate = sqlPathTemplate;
    }

    public List<Menu> getMenus() {
        return this.menus;
    }

    public void setMenus(List<Menu> menus) {
        this.menus = menus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(String addSql) {
        SqlSession sqlSession = this.sqlSessionFactory.openSession();
        Connection connection = sqlSession.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(addSql);
            preparedStatement.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delField(String delSql) {
        SqlSession sqlSession = this.sqlSessionFactory.openSession();
        Connection connection = sqlSession.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(delSql);
            preparedStatement.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExist(String tableName) {
        boolean isExist = false;
        String dbName = this.env.getProperty("spring.datasource.db-name");
        SqlSession sqlSession = this.sqlSessionFactory.openSession();
        Connection connection = sqlSession.getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("select TABLE_NAME from information_schema.tables where table_schema = ? and table_name = ?;");
            preparedStatement.setString(1, dbName);
            preparedStatement.setString(2, tableName);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                isExist = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(JSONArray tableFields, String tableName) {
        StringBuilder createSql = new StringBuilder();
        String priSql = "";
        createSql.append("CREATE TABLE `").append(tableName).append("` (\n");
        for (Object obj : tableFields) {
            Map thisField = (Map)obj;
            String fieldName = StringUtils.camelCaseToUnderscore((String)thisField.get("name"));
            createSql.append("`").append(fieldName).append("` ").append((String)thisField.get("type")).append(" ");
            if (ToolUtil.isNotEmpty(thisField.get("primarys")) && "PRI".equals(thisField.get("primarys"))) {
                priSql = ",PRIMARY KEY ( `" + fieldName + "` )\n ";
                createSql.append("NOT NULL ");
            } else {
                createSql.append(" ");
            }
            createSql.append("COMMENT '").append((String)thisField.get("comment")).append("',\n");
        }
        if (tableFields.size() > 0) {
            createSql.deleteCharAt(createSql.length() - 2);
        }
        if (ToolUtil.isNotEmpty((Object)priSql)) {
            createSql.append(priSql);
        } else {
            createSql.substring(0, createSql.length() - 3);
        }
        createSql.append(" ) ENGINE = INNODB DEFAULT CHARSET = utf8;");
        SqlSession sqlSession = this.sqlSessionFactory.openSession();
        Connection connection = sqlSession.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(createSql.toString());
            preparedStatement.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTableRelate(String path) {
        String createSql = "create table if not exists `table_relate`(\n`relate_id` int NOT NULL auto_increment COMMENT '\u9875\u9762\u5173\u8054\u8868\u7684id',\n`table_name` varchar(80) DEFAULT NULL COMMENT '\u9875\u9762\u5173\u8054\u8868\u7684\u540d\u79f0',\n`page_path` varchar(500) DEFAULT NULL COMMENT '\u9875\u9762\u7684\u8def\u5f84',\n`default_field` varchar(500) DEFAULT NULL COMMENT '\u9875\u9762\u5173\u8054\u8868\u7684\u5b57\u6bb5\u9ed8\u8ba4\u503c',\n`main_table` varchar(80) DEFAULT NULL COMMENT '\u4e3b\u8868\u540d\u79f0',\n`main_field` varchar(80) DEFAULT NULL COMMENT '\u4ece\u8868\u5173\u8054\u7684\u4e3b\u8868\u5b57\u6bb5',\n`sub_field` varchar(80) DEFAULT NULL COMMENT '\u5173\u8054\u4e3b\u8868\u7684\u4ece\u8868\u5b57\u6bb5',\n`flow_field` text(5000) DEFAULT NULL COMMENT '\u5de5\u4f5c\u6d41\u9700\u8981\u67e5\u8be2\u7684\u8868\u53ca\u5176\u5b57\u6bb5',\n`comment_maps` varchar(200) DEFAULT NULL COMMENT '\u5ba1\u6279\u610f\u89c1\u4fe1\u606f\u5b57\u6bb5',\n`comment_time` varchar(200) DEFAULT NULL COMMENT '\u5ba1\u6279\u65f6\u95f4\u5b57\u6bb5\u53ca\u5176\u7c7b\u578b',\n`auditor` varchar(200) DEFAULT NULL COMMENT '\u5ba1\u6279\u4ebaid\u5b57\u6bb5',\n`auditor_name` varchar(200) DEFAULT NULL COMMENT '\u5ba1\u6279\u4eba\u540d\u79f0\u5b57\u6bb5',\n PRIMARY KEY (`relate_id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        SqlSession sqlSession = this.sqlSessionFactory.openSession();
        Connection connection = sqlSession.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(createSql);
            preparedStatement.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTableQuery(String path) {
        String createSql = "create table if not exists `table_query`(\n`query_id` int NOT NULL auto_increment COMMENT '\u67e5\u8be2\u6761\u4ef6id',\n`table_name` varchar(80) DEFAULT NULL COMMENT '\u9875\u9762\u5173\u8054\u8868\u7684\u540d\u79f0',\n`page_path` varchar(80) DEFAULT NULL COMMENT '\u9875\u9762\u7684\u8def\u5f84',\n`order` int DEFAULT NULL COMMENT '\u67e5\u8be2\u6761\u4ef6\u5e8f\u53f7',\n`variable` varchar(80) DEFAULT NULL COMMENT '\u67e5\u8be2\u6761\u4ef6\u5b57\u6bb5',\n`var_connect` varchar(80) DEFAULT NULL COMMENT '\u6761\u4ef6\u7b26\u53f7',\n`var_limit` varchar(80) DEFAULT NULL COMMENT '\u6761\u4ef6\u503c',\n`condition_connect` varchar(80) DEFAULT NULL COMMENT '\u4e0e\u4e0b\u4e00\u4e2a\u6761\u4ef6\u7684\u8fde\u63a5\u7b26',\n`child_start` varchar(80) DEFAULT NULL COMMENT '\u5b50\u6761\u4ef6\u5f00\u59cb',\n`child_end` varchar(80) DEFAULT NULL COMMENT '\u5b50\u6761\u4ef6\u7ed3\u675f',\n`required` int DEFAULT NULL COMMENT '\u662f\u5426\u5fc5\u67e5\uff0c1:\u5fc5\u67e5\uff0c0:\u975e\u5fc5\u67e5',\n`join_table` varchar(80) DEFAULT NULL COMMENT '\u5de6\u8fde\u63a5\u8868\u540d',\n`alias` varchar(80) DEFAULT NULL COMMENT '\u5de6\u8fde\u63a5\u8868\u522b\u540d',\n`main_field` varchar(80) DEFAULT NULL COMMENT '\u8fde\u63a5\u6761\u4ef6\uff1a\u4e3b\u8868\u5b57\u6bb5\u540d',\n`sub_field` varchar(80) DEFAULT NULL COMMENT '\u8fde\u63a5\u6761\u4ef6\uff1a\u6b21\u8868\u5b57\u6bb5\u540d',\n`return_field` varchar(5000) DEFAULT NULL COMMENT '\u8fd4\u56de\u7684\u5b57\u6bb5',\n PRIMARY KEY (`query_id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        SqlSession sqlSession = this.sqlSessionFactory.openSession();
        Connection connection = sqlSession.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(createSql);
            preparedStatement.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

