/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.engine.config;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.generator.action.model.FDGeneratorProperties;
import com.jxdinfo.hussar.formdesign.generator.engine.config.ContextConfig;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class PageConfig {
    private ContextConfig contextConfig;
    private String pagePathTemplate;
    private String pageAddPathTemplate;
    private String pageEditPathTemplate;
    private String pageJsPathTemplate;
    private String pageInfoJsPathTemplate;
    private FDGeneratorProperties hussarProperties = (FDGeneratorProperties)SpringContextHolder.getBean(FDGeneratorProperties.class);

    public void init() {
        String environment = this.hussarProperties.getEnvironment();
        String pageLocal = "";
        pageLocal = "dyna".equals(environment) ? "\\resources\\WEB-INF\\view\\" : "\\src\\main\\webapp\\WEB-INF\\view\\";
        String JsLocal = "";
        JsLocal = "dyna".equals(environment) ? "\\resources\\static\\" : "\\src\\main\\webapp\\static\\";
        this.pagePathTemplate = pageLocal + this.contextConfig.getModuleName() + "\\{}\\{}.html";
        this.pageAddPathTemplate = pageLocal + this.contextConfig.getModuleName() + "\\{}\\{}_add.html";
        this.pageEditPathTemplate = pageLocal + this.contextConfig.getModuleName() + "\\{}\\{}_edit.html";
        this.pageJsPathTemplate = JsLocal + this.contextConfig.getModuleName() + "\\{}\\{}.js";
        this.pageInfoJsPathTemplate = JsLocal + this.contextConfig.getModuleName() + "\\{}\\{}_info.js";
    }

    public String getPagePathTemplate() {
        return this.pagePathTemplate;
    }

    public void setPagePathTemplate(String pagePathTemplate) {
        this.pagePathTemplate = pagePathTemplate;
    }

    public String getPageJsPathTemplate() {
        return this.pageJsPathTemplate;
    }

    public void setPageJsPathTemplate(String pageJsPathTemplate) {
        this.pageJsPathTemplate = pageJsPathTemplate;
    }

    public String getPageAddPathTemplate() {
        return this.pageAddPathTemplate;
    }

    public void setPageAddPathTemplate(String pageAddPathTemplate) {
        this.pageAddPathTemplate = pageAddPathTemplate;
    }

    public String getPageEditPathTemplate() {
        return this.pageEditPathTemplate;
    }

    public void setPageEditPathTemplate(String pageEditPathTemplate) {
        this.pageEditPathTemplate = pageEditPathTemplate;
    }

    public String getPageInfoJsPathTemplate() {
        return this.pageInfoJsPathTemplate;
    }

    public void setPageInfoJsPathTemplate(String pageInfoJsPathTemplate) {
        this.pageInfoJsPathTemplate = pageInfoJsPathTemplate;
    }

    public ContextConfig getContextConfig() {
        return this.contextConfig;
    }

    public void setContextConfig(ContextConfig contextConfig) {
        this.contextConfig = contextConfig;
    }
}

