/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.engine.config;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.generator.action.model.FDGeneratorProperties;
import com.jxdinfo.hussar.formdesign.generator.engine.config.ContextConfig;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class DaoConfig {
    private ContextConfig contextConfig;
    private String daoPathTemplate;
    private String xmlPathTemplate;
    private String packageName;
    private FDGeneratorProperties hussarProperties = (FDGeneratorProperties)SpringContextHolder.getBean(FDGeneratorProperties.class);

    public void init() {
        String environment = this.hussarProperties.getEnvironment();
        String packLocal = "";
        packLocal = "dyna".equals(environment) ? "\\src\\" : "\\src\\main\\java\\";
        this.daoPathTemplate = packLocal + this.contextConfig.getProPackage().replaceAll("\\.", "\\\\") + "\\" + this.contextConfig.getModuleName() + "\\dao\\{}Dao.java";
        this.xmlPathTemplate = packLocal + this.contextConfig.getProPackage().replaceAll("\\.", "\\\\") + "\\" + this.contextConfig.getModuleName() + "\\dao\\mapping\\{}Dao.xml";
        this.packageName = this.contextConfig.getProPackage() + "." + this.contextConfig.getModuleName() + ".dao";
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getDaoPathTemplate() {
        return this.daoPathTemplate;
    }

    public void setDaoPathTemplate(String daoPathTemplate) {
        this.daoPathTemplate = daoPathTemplate;
    }

    public String getXmlPathTemplate() {
        return this.xmlPathTemplate;
    }

    public void setXmlPathTemplate(String xmlPathTemplate) {
        this.xmlPathTemplate = xmlPathTemplate;
    }

    public ContextConfig getContextConfig() {
        return this.contextConfig;
    }

    public void setContextConfig(ContextConfig contextConfig) {
        this.contextConfig = contextConfig;
    }
}

