/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.engine.base;

import com.jxdinfo.hussar.formdesign.contant.GodAxeExceptionType;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import com.jxdinfo.hussar.formdesign.generator.engine.base.FDTemplateEngine;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ArrayLiteral;
import com.jxdinfo.hussar.formdesign.jsparser.es5.BinaryExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CallExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.CompilationUnit;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Expression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.ExpressionStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.FunctionDeclaration;
import com.jxdinfo.hussar.formdesign.jsparser.es5.FunctionExpression;
import com.jxdinfo.hussar.formdesign.jsparser.es5.IfStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Node;
import com.jxdinfo.hussar.formdesign.jsparser.es5.NodeList;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Project;
import com.jxdinfo.hussar.formdesign.jsparser.es5.Statement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.VariableStatement;
import com.jxdinfo.hussar.formdesign.jsparser.es5.arrow.Parser;
import com.jxdinfo.hussar.formdesign.jsparser.es5.parser.ParserFacade;
import com.jxdinfo.hussar.formdesign.result.ConflictDetail;
import com.jxdinfo.hussar.formdesign.result.GenCodeResult;
import com.jxdinfo.hussar.formdesign.store.StoreFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jsoup.nodes.Element;

public class GenJavaScriptCode
extends FDTemplateEngine {
    private String javaScriptPath;
    private Element element;
    private Project javascript;
    private String newJavaScriptCode;
    private GenCodeResult genCodeResult;
    private String pageName;

    public GenJavaScriptCode(String javaScriptPath, Element element) {
        this(javaScriptPath, element.text());
    }

    public GenJavaScriptCode(String javaScriptPath, String jsCode) {
        this.newJavaScriptCode = jsCode;
        this.javaScriptPath = javaScriptPath;
        this.genCodeResult = new GenCodeResult();
        this.genCodeResult.setType("javascript");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        this.genCodeResult.setStartTime(System.currentTimeMillis());
        Project originProject = new Project();
        try {
            originProject = this.getProjectFromJavaScript();
        }
        catch (Exception e) {
            throw new GodAxeException(GodAxeExceptionType.PARSE_JS_ERR, this.javaScriptPath);
        }
        String originProjectToString = originProject.toString();
        Project newProject = new Project();
        try {
            newProject = this.getNodeFromNewElement();
            if (newProject.toString().equals(";\n")) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new GodAxeException(GodAxeExceptionType.PUBLISH_JS_ERR, this.newJavaScriptCode);
        }
        try {
            boolean isExistConflict;
            this.genCodeResult.setFilePath(this.javaScriptPath);
            this.javascript = this.mergeJavaScript(originProject, newProject);
            this.writeCodeToFile(this.javascript.toString(), this.javaScriptPath);
            boolean bl = isExistConflict = this.genCodeResult.getConflictDetails().size() > 0;
            if (isExistConflict) {
                this.genCodeResult.setExistConflict(true);
                this.genCodeResult.setNewCode(newProject.toString());
                this.genCodeResult.setOriginCode(originProjectToString);
                this.genCodeResult.setMergeCode(this.javascript.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.genCodeResult.setEndTime(System.currentTimeMillis());
        }
    }

    private Project getProjectFromJavaScript() throws Exception {
        Project project = new Project();
        File file = new File(this.javaScriptPath);
        if (file.exists()) {
            Parser parser = new Parser("UTF-8", false, this.javaScriptPath);
            parser.setProject(project);
            try {
                parser.run();
            }
            catch (Exception e) {
                throw new Exception();
            }
        }
        return project;
    }

    private Project getNodeFromNewElement() throws Exception {
        Project project = new Project();
        String js = this.newJavaScriptCode;
        try {
            CompilationUnit compilationUnit = new CompilationUnit();
            NodeList<Statement> statements = new NodeList<Statement>();
            ExpressionStatement expressionStatement = (ExpressionStatement)ParserFacade.parse(js);
            statements.add(expressionStatement);
            compilationUnit.setElements(statements);
            project.addCompilationUnit(compilationUnit);
        }
        catch (Exception e) {
            throw new Exception();
        }
        return project;
    }

    private Project mergeJavaScript(Project originProject, Project newProject) {
        Project finalProject;
        FunctionExpression originFunctionExpression;
        boolean versionProjectIsNotNull;
        HashMap<String, String> nameTraceOfNew = new HashMap<String, String>();
        Map<String, Statement> newElements = null;
        if (null != newProject.getCompilationUnits()) {
            newElements = this.getNameElementOfUnitForNew((CompilationUnit)newProject.getCompilationUnits().get(0));
        }
        boolean originProjectIsNotNull = originProject.getCompilationUnits() != null;
        boolean bl = versionProjectIsNotNull = this.getNameTraceOfVersion() != null;
        if (originProjectIsNotNull && versionProjectIsNotNull) {
            Map<String, Statement> originElements = this.getNameElementOfUnitForOrigin((CompilationUnit)originProject.getCompilationUnits().get(0));
            CallExpression callExpression = this.getCallExpressionFromProject(originProject);
            NodeList<Statement> statements = this.mergeJavaScript(originElements, newElements);
            if (null != callExpression && callExpression.getArgs().size() > 1) {
                originFunctionExpression = (FunctionExpression)callExpression.getArgs().get(1);
                originFunctionExpression.getBody().setStatements(statements);
                ArrayLiteral originArrayLiteral = (ArrayLiteral)callExpression.getArgs().get(0);
                CallExpression newCallExpression = this.getCallExpressionFromProject(newProject);
                ArrayLiteral newArrayLiteral = (ArrayLiteral)newCallExpression.getArgs().get(0);
                newArrayLiteral.getExpressions().forEach(node -> {
                    if (!originArrayLiteral.getExpressions().contains(node)) {
                        originArrayLiteral.getExpressions().add((Expression)node);
                    }
                });
            }
            finalProject = originProject;
        } else {
            NodeList<Statement> newNodeList = new NodeList<Statement>();
            Collection<Statement> newList = newElements.values();
            for (Statement statement : newList) {
                newNodeList.add(statement);
            }
            newNodeList = this.changeOrder(newNodeList);
            CallExpression callExpression = this.getCallExpressionFromProject(newProject);
            if (null != callExpression && callExpression.getArgs().size() > 1) {
                originFunctionExpression = (FunctionExpression)callExpression.getArgs().get(1);
                originFunctionExpression.getBody().setStatements(newNodeList);
            }
            finalProject = newProject;
        }
        if (null != newProject) {
            Map<String, Statement> finalMap = this.getNameElementOfUnitForNew((CompilationUnit)newProject.getCompilationUnits().get(0));
            Set<String> keysOfNewElements = finalMap.keySet();
            for (String key : keysOfNewElements) {
                nameTraceOfNew.put(key, finalMap.get(key).trace());
            }
        }
        StoreFactory.createFileVersion(this.javaScriptPath, this.getPagePath(), nameTraceOfNew);
        return finalProject;
    }

    private NodeList<Statement> changeOrder(NodeList<Statement> elements) {
        NodeList<Statement> nodeList = new NodeList<Statement>();
        NodeList<Statement> renderStatements = new NodeList<Statement>();
        Iterator<Statement> it = elements.iterator();
        while (it.hasNext()) {
            Statement statement = it.next();
            boolean isExpressionStatement = statement.getClass().getName().equals(ExpressionStatement.class.getName());
            if (isExpressionStatement) {
                ExpressionStatement expressionStatement = (ExpressionStatement)statement;
                if (expressionStatement.getExpression() instanceof CallExpression) {
                    CallExpression callExpression = (CallExpression)expressionStatement.getExpression();
                    String callName = callExpression.getScope().toString();
                    if ("$".equals(callName) || callName.contains("_render")) {
                        it.remove();
                        renderStatements.add(statement);
                        continue;
                    }
                    nodeList.add(statement);
                    continue;
                }
                nodeList.add(statement);
                continue;
            }
            nodeList.add(statement);
        }
        nodeList.addAll(renderStatements);
        return nodeList;
    }

    private CallExpression getCallExpressionFromProject(Project originProject) {
        CallExpression res = null;
        for (Statement element : ((CompilationUnit)originProject.getCompilationUnits().get(0)).getElements()) {
            try {
                ExpressionStatement expression = (ExpressionStatement)element;
                try {
                    CallExpression tempCallExpression = (CallExpression)expression.getExpression();
                    if (!"layui.use".equals(tempCallExpression.getScope().toString())) continue;
                    res = tempCallExpression;
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {}
        }
        return res;
    }

    private NodeList<Statement> mergeJavaScript(Map<String, Statement> originElements, Map<String, Statement> newElements) {
        NodeList<Statement> nodeNodeList = new NodeList<Statement>();
        Map<String, Statement> elementsToAddOfOrigin = this.getToMergeElementOfOrigin(originElements, newElements);
        nodeNodeList.addAll(this.keepPosition(originElements, elementsToAddOfOrigin));
        NodeList<Statement> elementsToAddOfNewElements = this.getToMergeElementOfNew(originElements, newElements);
        nodeNodeList.addAll(elementsToAddOfNewElements);
        nodeNodeList = this.changeOrder(nodeNodeList);
        return nodeNodeList;
    }

    private NodeList<Statement> keepPosition(Map<String, Statement> originStatement, Map<String, Statement> addOfOrigin) {
        NodeList<Statement> finalNodeList = new NodeList<Statement>();
        Set<String> addKeys = addOfOrigin.keySet();
        for (String originKey : originStatement.keySet()) {
            if (!addKeys.contains(originKey)) continue;
            finalNodeList.add((Statement)((Node)addOfOrigin.get(originKey)));
        }
        return finalNodeList;
    }

    private NodeList<Statement> getToMergeElementOfNew(Map<String, Statement> originElements, Map<String, Statement> newElements) {
        NodeList<Statement> toAddList = new NodeList<Statement>();
        Set<String> keySetOfOrigin = originElements.keySet();
        Set<String> keySetOfNew = newElements.keySet();
        Map<String, String> nameTraceOfVersion = this.getNameTraceOfVersion();
        Set<String> keySetOfVersion = nameTraceOfVersion.keySet();
        for (String key : keySetOfNew) {
            Statement toAddNode = newElements.get(key);
            boolean isContainsInVersion = keySetOfVersion.contains(key);
            boolean isContainsInOrigin = keySetOfOrigin.contains(key);
            String traceOfVersion = nameTraceOfVersion.get(key);
            String traceOfNew = newElements.get(key).trace();
            String string = traceOfNew = traceOfNew == null ? "" : traceOfNew;
            if (isContainsInVersion) {
                boolean isGodAxeNotChangeThisElement = traceOfVersion.equals(traceOfNew);
                if (isContainsInOrigin || isGodAxeNotChangeThisElement) continue;
                toAddList.add(toAddNode);
                this.genCodeResult.putConflictDetail(key, new ConflictDetail("delete", "\u7528\u6237\u5220\u9664\u7684\u5143\u7d20\u4e0e\u5929\u65a7\u8981\u4fee\u6539\u7684\u5143\u7d20\u76f8\u540c\uff0c\u5b58\u5728\u51b2\u7a81", "", toAddNode.toString()));
                continue;
            }
            if (isContainsInOrigin) continue;
            toAddList.add(toAddNode);
        }
        return toAddList;
    }

    private Map<String, Statement> getToMergeElementOfOrigin(Map<String, Statement> originElements, Map<String, Statement> newElements) {
        LinkedHashMap<String, Statement> toAddMap = new LinkedHashMap<String, Statement>();
        Set<String> keySetOfOrigin = originElements.keySet();
        Set<String> keySetOfNew = newElements.keySet();
        Map<String, String> nameTraceOfVersion = this.getNameTraceOfVersion();
        Set<String> keySetOfVersion = nameTraceOfVersion.keySet();
        for (String key : keySetOfOrigin) {
            boolean isUserNotChangeThisElement;
            Statement toAddNode = originElements.get(key);
            boolean isExistInNew = keySetOfNew.contains(key);
            boolean isExistInVersion = keySetOfVersion.contains(key);
            String traceOfVersion = nameTraceOfVersion.get(key);
            String traceOfNew = newElements.get(key) == null ? "" : newElements.get(key).trace();
            String traceOfOrigin = toAddNode.trace();
            if (isExistInNew && isExistInVersion) {
                isUserNotChangeThisElement = traceOfVersion.equals(traceOfOrigin);
                boolean isGodAxeNotChangeThisElement = traceOfNew.equals(traceOfVersion);
                if (isGodAxeNotChangeThisElement) {
                    toAddMap.put(key, toAddNode);
                    continue;
                }
                if (isUserNotChangeThisElement) {
                    toAddMap.put(key, newElements.get(key));
                    continue;
                }
                toAddMap.put(key, newElements.get(key));
                this.genCodeResult.putConflictDetail(key, new ConflictDetail("change", "\u5929\u65a7\u8981\u4fee\u6539\u7684\u5143\u7d20\u88ab\u7528\u6237\u4fee\u6539\u8fc7", toAddNode.toString(), newElements.get(key).toString()));
                continue;
            }
            if (isExistInVersion) {
                isUserNotChangeThisElement = traceOfVersion.equals(traceOfOrigin);
                if (isUserNotChangeThisElement) continue;
                this.genCodeResult.putConflictDetail(key, new ConflictDetail("delete", "\u7528\u6237\u4fee\u6539\u8fc7\u5929\u65a7\u8981\u5220\u9664\u7684\u4ee3\u7801\uff0c\u4e14\u5728\u5f53\u524d\u7248\u672c\u4e2d\u8be5\u5143\u7d20\u4e0d\u5b58\u5728", toAddNode.toString(), ""));
                continue;
            }
            if (isExistInNew) {
                boolean isTheSameElementInToAddAndNew = traceOfNew.equals(traceOfOrigin);
                if (isTheSameElementInToAddAndNew) {
                    toAddMap.put(key, toAddNode);
                    continue;
                }
                toAddMap.put(key, toAddNode);
                this.genCodeResult.putConflictDetail(key, new ConflictDetail("add", "\u7528\u6237\u624b\u5199\u7684\u65b9\u6cd5\u4e0e\u5929\u65a7\u65b0\u589e\u7684\u65b9\u6cd5\u5b58\u5728\u51b2\u7a81\uff0c\u60c5\u51b5\u63cf\u8ff0\uff1a\u5b58\u5728\u540c\u540dJavaScript\u5143\u7d20\uff0c\u4e14\u5143\u7d20\u5185\u5bb9\u4e0d\u540c", toAddMap.values().toString(), newElements.get(key).toString()));
                continue;
            }
            toAddMap.put(key, toAddNode);
        }
        return toAddMap;
    }

    private Map<String, Statement> getNameElementOfUnitForOrigin(CompilationUnit unit) {
        NodeList<Statement> nodeList = null;
        for (Statement element : unit.getElements()) {
            try {
                ExpressionStatement expression = (ExpressionStatement)element;
                try {
                    CallExpression callExpression = (CallExpression)expression.getExpression();
                    if (!"layui.use".equals(String.valueOf(callExpression.getScope()))) continue;
                    nodeList = ((FunctionExpression)callExpression.getArgs().get(1)).getBody().getStatements();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LinkedHashMap<String, Statement> nameTraceOfUnit = new LinkedHashMap<String, Statement>();
        if (null != nodeList) {
            nodeList.forEach(newElement -> {
                if (this.getVariableStatements((Map<String, Statement>)nameTraceOfUnit, (Statement)newElement)) {
                    return;
                }
                if (this.getFunctionDeclaration((Map<String, Statement>)nameTraceOfUnit, (Statement)newElement)) {
                    return;
                }
                if (this.getExpressionStatement((Map<String, Statement>)nameTraceOfUnit, (Statement)newElement)) {
                    return;
                }
                if (this.getIfStatement((Map<String, Statement>)nameTraceOfUnit, (Statement)newElement)) {
                    return;
                }
                nameTraceOfUnit.put(newElement.trace(), (Statement)newElement);
            });
        }
        return nameTraceOfUnit;
    }

    private Map<String, Statement> getNameElementOfUnitForNew(CompilationUnit unit) {
        NodeList<Statement> nodeList = null;
        for (Statement element : unit.getElements()) {
            try {
                ExpressionStatement expression = (ExpressionStatement)element;
                try {
                    CallExpression callExpression = (CallExpression)expression.getExpression();
                    if (!"layui.use".equals(String.valueOf(callExpression.getScope()))) continue;
                    nodeList = ((FunctionExpression)callExpression.getArgs().get(1)).getBody().getStatements();
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {}
        }
        LinkedHashMap<String, Statement> nameTraceOfUnit = new LinkedHashMap<String, Statement>();
        if (null != nodeList) {
            nodeList.forEach(newElement -> {
                if (this.getVariableStatements((Map<String, Statement>)nameTraceOfUnit, (Statement)newElement)) {
                    return;
                }
                if (this.getFunctionDeclaration((Map<String, Statement>)nameTraceOfUnit, (Statement)newElement)) {
                    return;
                }
                if (this.getExpressionStatement((Map<String, Statement>)nameTraceOfUnit, (Statement)newElement)) {
                    return;
                }
                if (this.getIfStatement((Map<String, Statement>)nameTraceOfUnit, (Statement)newElement)) {
                    return;
                }
            });
        }
        return nameTraceOfUnit;
    }

    private Map<String, String> getNameTraceOfVersion() {
        return (Map)this.getObjectFromVersion();
    }

    private Object getObjectFromVersion() {
        return StoreFactory.readFileByVersion(this.javaScriptPath, this.getPagePath());
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public Project getJavascript() {
        return this.javascript;
    }

    public GenCodeResult getGenCodeResult() {
        return this.genCodeResult;
    }

    private boolean getVariableStatements(Map<String, Statement> nameTraceOfUnit, Statement newElement) {
        try {
            VariableStatement variableStatement = (VariableStatement)newElement;
            variableStatement.getVariableDeclarations().forEach(variableDeclaration -> {
                String name = variableDeclaration.getName();
                nameTraceOfUnit.put("variable:" + name, newElement);
            });
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getFunctionDeclaration(Map<String, Statement> nameTraceOfUnit, Statement newElement) {
        try {
            FunctionDeclaration functionDeclaration = (FunctionDeclaration)newElement;
            String name = functionDeclaration.getName();
            nameTraceOfUnit.put("function:" + name, newElement);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getExpressionStatement(Map<String, Statement> nameTraceOfUnit, Statement newElement) {
        try {
            ExpressionStatement expressionStatement = (ExpressionStatement)newElement;
            CallExpression callExpression = (CallExpression)expressionStatement.getExpression();
            if (callExpression.getScope() != null) {
                Object identify;
                String name = callExpression.getScope().toString();
                if (name.contains("form.") && (identify = callExpression.getArgs().get(0)) != null) {
                    name = name + "(" + identify.toString() + ")";
                }
                nameTraceOfUnit.put("expression:" + name, newElement);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getIfStatement(Map<String, Statement> nameTraceOfUnit, Statement newElement) {
        try {
            IfStatement ifStatement = (IfStatement)newElement;
            BinaryExpression binaryExpression = (BinaryExpression)ifStatement.getCondition();
            if (binaryExpression != null) {
                String name = binaryExpression.toString();
                nameTraceOfUnit.put("ifStatement:" + name, newElement);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }
}

