/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.engine.base;

import com.baomidou.mybatisplus.generator.formdesign.config.po.TableInfo;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.RequestData;
import com.jxdinfo.hussar.formdesign.desgin.cellconfig.JsTreeConfig;
import com.jxdinfo.hussar.formdesign.desgin.cellconfig.SelectConfig;
import com.jxdinfo.hussar.formdesign.generator.engine.base.FDTemplateEngine;
import com.jxdinfo.hussar.formdesign.result.GenCodeResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.core.Template;
import org.springframework.context.ApplicationContext;

public class GenControllerCode
extends FDTemplateEngine {
    private List<TableInfo> tableInfoList;
    private String projectPath;
    private String proPackage;
    private String modulePath;
    private String moduleName;
    private String pageName;
    private String pageDesc;
    private List<String> workFlow;
    private List<RequestData> requestDataList;
    private List<JsTreeConfig> jsTreeConfigs;
    private List<SelectConfig> selectConfigs;
    private Map<String, String> autoData;
    private Map<String, Boolean> workFlowControl;

    @Override
    protected void configTemplate(Template template) {
        template.binding("imports", this.controllerImports());
        template.binding("package", this.controllerPackage());
        template.binding("modulePath", (Object)this.modulePath);
        template.binding("tables", this.tableInfoList);
        template.binding("workFlow", this.workFlow);
        template.binding("pageDesc", (Object)this.pageDesc);
        template.binding("controllerName", (Object)this.getControllerName());
        template.binding("pageName", (Object)this.pageName);
        template.binding("requestDataList", this.requestDataList);
        template.binding("jsTreeConfigs", this.jsTreeConfigs);
        template.binding("selectConfigs", this.selectConfigs);
        template.binding("workFlowControl", this.workFlowControl);
        template.binding("autoData", this.autoData);
    }

    public GenCodeResult genCode() throws Exception {
        GenCodeResult genCodeResult = new GenCodeResult();
        super.initBeetlEngine();
        String templatePath = super.getContextConfig().getTemplatePrefixPath() + "/GodAxeController.java.btl";
        Template template = this.groupTemplate.getTemplate(templatePath);
        if (!this.modulePath.endsWith("/")) {
            this.modulePath = this.modulePath + "/";
        }
        if (!this.moduleName.endsWith(".")) {
            this.moduleName = this.moduleName + ".";
        }
        this.configTemplate(template);
        String type = "controller";
        String filePath = this.filePath();
        ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
        boolean isCheckConflict = Boolean.valueOf(applicationContext.getEnvironment().getProperty("form-design.is-check-conflict-controller"));
        if (isCheckConflict) {
            genCodeResult = super.generateFileForJava(template, filePath);
            genCodeResult.setType(type);
        } else {
            super.generateFileForCommon(template, filePath);
        }
        return genCodeResult;
    }

    private String filePath() {
        return this.projectPath + "\\src\\main\\java\\" + this.proPackage.replaceAll("\\.", "\\\\") + this.modulePath.replaceAll("/", "\\\\").toLowerCase() + "controller\\" + this.getControllerName() + ".java";
    }

    private Map<String, String> controllerPackage() {
        HashMap<String, String> thePackage = new HashMap<String, String>();
        String controllerPackage = this.proPackage + this.moduleName.toLowerCase() + "controller";
        thePackage.put("Controller", controllerPackage);
        return thePackage;
    }

    private String getControllerName() {
        return ToolUtil.firstLetterToUpper((String)this.pageName) + "Controller";
    }

    private List<String> controllerImports() {
        String coreBasePackage = "com.jxdinfo.hussar.core";
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("com.jxdinfo.hussar.core.page.HussarPager");
        imports.add("com.baomidou.mybatisplus.mapper.EntityWrapper");
        imports.add("com.baomidou.mybatisplus.mapper.Wrapper");
        imports.add("com.baomidou.mybatisplus.plugins.Page");
        imports.add(coreBasePackage + ".base.controller.BaseController");
        imports.add("org.springframework.stereotype.Controller");
        imports.add("org.springframework.web.bind.annotation.RequestMapping");
        imports.add("org.springframework.web.bind.annotation.ResponseBody");
        imports.add("org.springframework.ui.Model");
        imports.add("org.springframework.web.bind.annotation.PathVariable");
        imports.add("org.springframework.beans.factory.annotation.Autowired");
        imports.add("org.springframework.web.bind.annotation.RequestParam");
        imports.add("java.util.HashMap");
        imports.add("java.util.List");
        imports.add("java.util.ArrayList");
        imports.add("java.util.Map");
        imports.add("org.springframework.web.bind.annotation.RequestBody");
        imports.add("java.util.Arrays");
        imports.add("org.springframework.transaction.annotation.Transactional");
        imports.add("com.alibaba.fastjson.JSON");
        imports.add("com.alibaba.fastjson.JSONArray");
        imports.add("com.jxdinfo.hussar.bpm.engine.service.InstanceEngineService");
        imports.add("com.jxdinfo.hussar.bpm.common.utils.BpmConstant");
        imports.add("com.jxdinfo.hussar.core.util.ToolUtil");
        return imports;
    }

    public List<TableInfo> getTableInfoList() {
        return this.tableInfoList;
    }

    public void setTableInfoList(List<TableInfo> tableInfoList) {
        this.tableInfoList = tableInfoList;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public void setProPackage(String proPackage) {
        this.proPackage = proPackage;
    }

    public void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public String getPageDesc() {
        return this.pageDesc;
    }

    public void setPageDesc(String pageDesc) {
        this.pageDesc = pageDesc;
    }

    public List<String> getWorkFlow() {
        return this.workFlow;
    }

    public void setWorkFlow(List<String> workFlow) {
        this.workFlow = workFlow;
    }

    public List<RequestData> getRequestDataList() {
        return this.requestDataList;
    }

    public void setRequestDataList(List<RequestData> requestDataList) {
        this.requestDataList = requestDataList;
    }

    public List<JsTreeConfig> getJsTreeConfigs() {
        return this.jsTreeConfigs;
    }

    public void setJsTreeConfigs(List<JsTreeConfig> jsTreeConfigs) {
        this.jsTreeConfigs = jsTreeConfigs;
    }

    public List<SelectConfig> getSelectConfigs() {
        return this.selectConfigs;
    }

    public void setSelectConfigs(List<SelectConfig> selectConfigs) {
        this.selectConfigs = selectConfigs;
    }

    public Map<String, Boolean> getWorkFlowControl() {
        return this.workFlowControl;
    }

    public void setWorkFlowControl(Map<String, Boolean> workFlowControl) {
        this.workFlowControl = workFlowControl;
    }

    public Map<String, String> getAutoData() {
        return this.autoData;
    }

    public void setAutoData(Map<String, String> autoData) {
        this.autoData = autoData;
    }
}

