/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.engine.base;

import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.github.javaparser.JavaParser;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.jxdinfo.hussar.core.util.MD5Util;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.contant.GodAxeExceptionType;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import com.jxdinfo.hussar.formdesign.generator.engine.base.FDAbstractTemplateEngine;
import com.jxdinfo.hussar.formdesign.generator.model.DeclarationContainer;
import com.jxdinfo.hussar.formdesign.result.ConflictDetail;
import com.jxdinfo.hussar.formdesign.result.GenCodeResult;
import com.jxdinfo.hussar.formdesign.result.LineNumber;
import com.jxdinfo.hussar.formdesign.store.StoreFactory;
import com.jxdinfo.hussar.formdesign.util.CodeCompareUtil;
import com.jxdinfo.hussar.formdesign.util.XMLParserUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultAttribute;
import org.dom4j.tree.DefaultDocument;

public abstract class FDTemplateEngine
extends FDAbstractTemplateEngine {
    protected GroupTemplate groupTemplate;
    private String entityPackage;
    private String pagePath;
    private GenCodeResult genCodeResult = new GenCodeResult();
    private Map<String, String> packageInfo;
    protected Map<String, String> pathInfo;
    private String tableModuleName = "leave";
    private String modulePath;

    public FDTemplateEngine() {
        this.initBeetlEngine();
    }

    protected void initBeetlEngine() {
        Properties properties = new Properties();
        properties.put("RESOURCE.root", "");
        properties.put("DELIMITER_STATEMENT_START", "<%");
        properties.put("DELIMITER_STATEMENT_END", "%>");
        properties.put("HTML_TAG_FLAG", "##");
        Configuration cfg = null;
        try {
            cfg = new Configuration(properties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader();
        this.groupTemplate = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
        this.groupTemplate.registerFunctionPackage("tool", (Object)new ToolUtil());
    }

    protected void configTemplate(Template template) {
        template.binding("controller", (Object)this.controllerConfig);
        template.binding("modulePath", (Object)this.modulePath);
        template.binding("context", (Object)this.contextConfig);
        template.binding("dao", (Object)this.daoConfig);
        template.binding("service", (Object)this.serviceConfig);
        template.binding("sqls", (Object)this.sqlConfig);
        template.binding("table", (Object)this.tableInfo);
        template.binding("entityPackage", (Object)this.entityPackage);
        template.binding("activeRecord", (Object)this.activeRecord);
        template.binding("workFlow", (Object)this.workflowInfo);
        template.binding("package", this.packageInfo);
        template.binding("entity", (Object)this.tableInfo.getEntityName());
        template.binding("superServiceImplClassPackage", (Object)"com.baomidou.mybatisplus.service.impl.ServiceImpl");
        template.binding("superServiceImplClass", (Object)this.getSuperClassName("com.baomidou.mybatisplus.service.impl.ServiceImpl"));
        template.binding("superServiceClassPackage", (Object)"com.baomidou.mybatisplus.service.IService");
        template.binding("superServiceClass", (Object)this.getSuperClassName("com.baomidou.mybatisplus.service.IService"));
        template.binding("superMapperClassPackage", (Object)"com.baomidou.mybatisplus.mapper.BaseMapper");
        template.binding("superMapperClass", (Object)this.getSuperClassName("com.baomidou.mybatisplus.mapper.BaseMapper"));
        template.binding("baseResultMap", (Object)true);
        template.binding("baseColumnList", (Object)true);
        template.binding("pageName", (Object)this.contextConfig.getPageName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateFileForCommon(Template pageTemplate, String filePath) {
        filePath = ToolUtil.isWinOs() != false ? filePath.replaceAll("/+|\\\\+", "\\\\") : filePath.replaceAll("/+|\\\\+", "/");
        File file = new File(filePath);
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            pageTemplate.renderTo((OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected GenCodeResult generateXML(Template pageTemplate, String filePath) throws Exception {
        this.genCodeResult.setStartTime(System.currentTimeMillis());
        this.genCodeResult.setFilePath(filePath);
        filePath = ToolUtil.isWinOs() != false ? filePath.replaceAll("/+|\\\\+", "\\\\") : filePath.replaceAll("/+|\\\\+", "/");
        try {
            Map<String, Element> elementsOrigin = null;
            SAXReader read = XMLParserUtil.getSAXReader();
            DefaultDocument xmlOrigin = new DefaultDocument();
            if (new File(filePath).exists()) {
                try {
                    xmlOrigin = read.read(filePath);
                    elementsOrigin = XMLParserUtil.readXMLElementsByFile(filePath);
                }
                catch (Exception e) {
                    throw new GodAxeException(GodAxeExceptionType.PARSE_XML_ERR, filePath);
                }
            }
            DefaultDocument xmlCurrent = new DefaultDocument();
            String xmlContent = "";
            try {
                xmlContent = pageTemplate.render();
                xmlCurrent = XMLParserUtil.readXMLByString(xmlContent);
            }
            catch (Exception e) {
                throw new GodAxeException(GodAxeExceptionType.PUBLISH_XML_ERR, xmlContent);
            }
            String xmlCurrentToString = this.documentToString((Document)xmlCurrent);
            Element rootElement = xmlCurrent.getRootElement();
            Iterator itElement = rootElement.elementIterator();
            HashMap<String, String> xmlValues = new HashMap<String, String>();
            while (itElement.hasNext()) {
                Element nodeElement = (Element)itElement.next();
                xmlValues.put(((DefaultAttribute)nodeElement.attributes().get(0)).getValue(), MD5Util.encrypt((String)this.documentToString(nodeElement, true)));
            }
            if (null != elementsOrigin) {
                List<Element> toAddOriginList = this.compareXMLGetOrigin(elementsOrigin, (Document)xmlCurrent, filePath);
                List<Element> toAddNewList = this.compareXMLGetNew(elementsOrigin, (Document)xmlCurrent, filePath);
                ArrayList originElements = new ArrayList();
                toAddOriginList.forEach(element -> originElements.add(element));
                toAddNewList.forEach(element -> originElements.add(element));
                rootElement.clearContent();
                rootElement.setContent((List)originElements);
            }
            String xmlFinalToString = this.documentToString((Document)xmlCurrent);
            this.writeCodeToFile(xmlFinalToString, filePath);
            StoreFactory.createFileVersion(filePath, this.pagePath, xmlValues);
            this.genCodeResult.setNewCode(xmlCurrentToString);
            this.genCodeResult.setMergeCode(xmlFinalToString);
            this.genCodeResult.setOriginCode(this.documentToString((Document)xmlOrigin));
            this.genCodeResult.setEndTime(System.currentTimeMillis());
            String type = "xml";
            this.genCodeResult.setType(type);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.genCodeResult;
    }

    private String documentToString(Document xmlCurrent) throws IOException {
        StringWriter out = new StringWriter();
        OutputFormat formater = OutputFormat.createPrettyPrint();
        XMLWriter xmlWriter = new XMLWriter((Writer)out, formater);
        formater.setEncoding("UTF-8");
        xmlWriter.write(xmlCurrent);
        xmlWriter.close();
        return out.toString();
    }

    private String documentToString(Element element, boolean flag) throws IOException {
        StringWriter out = new StringWriter();
        OutputFormat formater = OutputFormat.createPrettyPrint();
        XMLWriter xmlWriter = new XMLWriter((Writer)out, formater);
        formater.setEncoding("UTF-8");
        xmlWriter.write(element);
        xmlWriter.close();
        if (flag) {
            return out.toString().replace(" ", "");
        }
        return out.toString();
    }

    protected CompilationUnit mergeProject(CompilationUnit cuOrigin, CompilationUnit cuNew, String filePath) {
        CompilationUnit finalCompilationUnit;
        if (null == cuOrigin) {
            finalCompilationUnit = cuNew;
            this.writeInFormationToVersion(filePath, cuNew);
        } else {
            List originChildNodes = cuOrigin.getChildNodes();
            List newChildNodes = cuNew.getChildNodes();
            DeclarationContainer originDeclarationContainer = CodeCompareUtil.transDeclarationFromNodes(originChildNodes);
            DeclarationContainer newDeclarationContainer = CodeCompareUtil.transDeclarationFromNodes(newChildNodes);
            List<ImportDeclaration> originImportDeclarations = originDeclarationContainer.getImportDeclarationList();
            List<FieldDeclaration> originFieldDeclarations = originDeclarationContainer.getFieldDeclarationList();
            List<MethodDeclaration> originMethodDeclarations = originDeclarationContainer.getMethodDeclarationList();
            List<ImportDeclaration> newImportDeclarations = newDeclarationContainer.getImportDeclarationList();
            List<MethodDeclaration> newMethodDeclarations = newDeclarationContainer.getMethodDeclarationList();
            List<FieldDeclaration> newFieldDeclarations = newDeclarationContainer.getFieldDeclarationList();
            Map<String, String> informationOfVersion = this.informationOfVersion(filePath);
            this.writeInFormationToVersion(filePath, newDeclarationContainer);
            NodeList<ImportDeclaration> finalImportDeclarations = this.mergeProjectImports(newImportDeclarations, originImportDeclarations);
            NodeList<FieldDeclaration> finalFieldDeclarations = this.mergeProjectFields(newFieldDeclarations, originFieldDeclarations, informationOfVersion);
            NodeList<MethodDeclaration> finalMethodDeclarations = this.mergeProjectMethods(newMethodDeclarations, originMethodDeclarations, informationOfVersion);
            NodeList childNodes = new NodeList();
            for (Node childNode : cuNew.getChildNodes()) {
                int lastNodeIndex;
                if (!(childNode instanceof ClassOrInterfaceDeclaration)) continue;
                ClassOrInterfaceDeclaration body = (ClassOrInterfaceDeclaration)childNode;
                List bodyNodes = body.getChildNodes();
                Node lastNode = (Node)bodyNodes.get(lastNodeIndex = bodyNodes.size() - 1);
                if (lastNode.toString().contains("\u4e3b\u952e")) {
                    lastNode.remove();
                }
                body.getMembers().forEach(classNode -> {
                    if (classNode instanceof MethodDeclaration) {
                        return;
                    }
                    if (classNode instanceof FieldDeclaration) {
                        return;
                    }
                    childNodes.add((Node)classNode);
                });
                childNodes.addAll(finalFieldDeclarations);
                childNodes.addAll(finalMethodDeclarations);
                body.setMembersExt(childNodes);
            }
            cuNew.setImports(finalImportDeclarations);
            finalCompilationUnit = cuNew;
        }
        return finalCompilationUnit;
    }

    private void writeInFormationToVersion(String filePath, CompilationUnit cuNew) {
        DeclarationContainer declarationContainer = CodeCompareUtil.transDeclarationFromNodes(cuNew.getChildNodes());
        List<MethodDeclaration> finalMethods = declarationContainer.getMethodDeclarationList();
        List<FieldDeclaration> finalFields = declarationContainer.getFieldDeclarationList();
        HashMap informationForVersion = new HashMap();
        finalMethods.forEach(methodDeclaration -> {
            String name = methodDeclaration.getDeclarationAsString(false, false, false);
            informationForVersion.put(name, methodDeclaration.toString());
        });
        finalFields.forEach(fieldDeclaration -> fieldDeclaration.getVariables().forEach(variableDeclarator -> {
            String name = variableDeclarator.getNameAsString();
            informationForVersion.put(name, fieldDeclaration.toString());
        }));
        StoreFactory.createFileVersion(filePath, this.pagePath, informationForVersion);
    }

    private void writeInFormationToVersion(String filePath, DeclarationContainer declarationContainer) {
        List<MethodDeclaration> finalMethods = declarationContainer.getMethodDeclarationList();
        List<FieldDeclaration> finalFields = declarationContainer.getFieldDeclarationList();
        HashMap informationForVersion = new HashMap();
        finalMethods.forEach(methodDeclaration -> {
            String name = methodDeclaration.getDeclarationAsString(false, false, false);
            informationForVersion.put(name, methodDeclaration.toString());
        });
        finalFields.forEach(fieldDeclaration -> fieldDeclaration.getVariables().forEach(variableDeclarator -> {
            String name = variableDeclarator.getNameAsString();
            informationForVersion.put(name, fieldDeclaration.toString());
        }));
        StoreFactory.createFileVersion(filePath, this.pagePath, informationForVersion);
    }

    private NodeList<MethodDeclaration> mergeProjectMethods(List<MethodDeclaration> newMethodDeclarations, List<MethodDeclaration> originMethodDeclarations, Map<String, String> informationOfVersion) {
        NodeList resMethods = new NodeList();
        List<MethodDeclaration> toAddMethodOfOrigin = this.getToAddMethodsOfOrigin(originMethodDeclarations, informationOfVersion, newMethodDeclarations);
        List<MethodDeclaration> toAddMethodOfNew = this.getToAddMethodsOfNew(originMethodDeclarations, informationOfVersion, newMethodDeclarations);
        toAddMethodOfOrigin = this.keepMethodPosition(originMethodDeclarations, toAddMethodOfOrigin);
        resMethods.addAll(toAddMethodOfOrigin);
        resMethods.addAll(toAddMethodOfNew);
        return resMethods;
    }

    private List<MethodDeclaration> keepMethodPosition(List<MethodDeclaration> originMethod, List<MethodDeclaration> addMethodOfOrigin) {
        ArrayList<MethodDeclaration> finalMethod = new ArrayList<MethodDeclaration>();
        LinkedHashMap<String, MethodDeclaration> originMethodMap = new LinkedHashMap<String, MethodDeclaration>();
        for (MethodDeclaration originM : originMethod) {
            String thisName = originM.getDeclarationAsString(false, false, false);
            originMethodMap.put(thisName, originM);
        }
        LinkedHashMap<String, MethodDeclaration> addMethodMap = new LinkedHashMap<String, MethodDeclaration>();
        for (MethodDeclaration addM : addMethodOfOrigin) {
            String thisName = addM.getDeclarationAsString(false, false, false);
            addMethodMap.put(thisName, addM);
        }
        for (String methodName : originMethodMap.keySet()) {
            if (!addMethodMap.keySet().contains(methodName)) continue;
            finalMethod.add((MethodDeclaration)addMethodMap.get(methodName));
        }
        return finalMethod;
    }

    private List<MethodDeclaration> getToAddMethodsOfNew(List<MethodDeclaration> originMethodDeclarations, Map<String, String> informationOfVersion, List<MethodDeclaration> newMethodDeclarations) {
        ArrayList<MethodDeclaration> resMethods = new ArrayList<MethodDeclaration>();
        HashSet nameSetOfOrigin = new HashSet();
        originMethodDeclarations.forEach(originMethodDeclaration -> {
            String name = originMethodDeclaration.getDeclarationAsString(false, false, false);
            nameSetOfOrigin.add(name);
        });
        Set<String> nameSetOfVersion = informationOfVersion.keySet();
        for (MethodDeclaration newMethodDeclaration : newMethodDeclarations) {
            String name = newMethodDeclaration.getDeclarationAsString(false, false, false);
            boolean isExistInOrigin = nameSetOfOrigin.contains(name);
            boolean isExistInVersion = nameSetOfVersion.contains(name);
            if (isExistInOrigin) continue;
            if (isExistInVersion) {
                boolean isGodAxeChangeMe = !informationOfVersion.get(name).equals(newMethodDeclaration.toString());
                if (!isGodAxeChangeMe) continue;
                ConflictDetail conflictDetail = new ConflictDetail("delete", "\u5929\u65a7\u8981\u4fee\u6539\u7684\u65b9\u6cd5\u5df2\u88ab\u7528\u6237\u5220\u9664\uff0c\u5b58\u5728\u51b2\u7a81", "", newMethodDeclaration.toString());
                this.setConflictDetail(conflictDetail, null, newMethodDeclaration);
                this.genCodeResult.putConflictDetail(name, conflictDetail);
                continue;
            }
            resMethods.add(newMethodDeclaration);
        }
        return resMethods;
    }

    private List<MethodDeclaration> getToAddMethodsOfOrigin(List<MethodDeclaration> originMethodDeclarations, Map<String, String> informationOfVersion, List<MethodDeclaration> newMethodDeclarations) {
        ArrayList<MethodDeclaration> resMethods = new ArrayList<MethodDeclaration>();
        HashMap methodDeclarationMapOfNew = new HashMap();
        newMethodDeclarations.forEach(methodDeclaration -> {
            String name = methodDeclaration.getDeclarationAsString(false, false, false);
            methodDeclarationMapOfNew.put(name, methodDeclaration);
        });
        Set nameSetOfNew = methodDeclarationMapOfNew.keySet();
        Set<String> nameSetOfVersion = informationOfVersion.keySet();
        for (MethodDeclaration originMethodDeclaration : originMethodDeclarations) {
            boolean isUserChangeMe;
            String name = originMethodDeclaration.getDeclarationAsString(false, false, false);
            boolean isExistInNew = nameSetOfNew.contains(name);
            boolean isExistInVersion = nameSetOfVersion.contains(name);
            if (isExistInVersion && isExistInNew) {
                boolean isConflict;
                isUserChangeMe = !originMethodDeclaration.toString().equals(informationOfVersion.get(name));
                boolean isGodAxeChangeMe = !((MethodDeclaration)methodDeclarationMapOfNew.get(name)).toString().equals(informationOfVersion.get(name));
                boolean bl = isConflict = isUserChangeMe && isGodAxeChangeMe;
                if (isConflict) {
                    resMethods.add((MethodDeclaration)methodDeclarationMapOfNew.get(name));
                    ConflictDetail conflictDetail = new ConflictDetail("change", "java\u6587\u4ef6\u4e2d\u5929\u65a7\u8981\u4fee\u6539\u7684\u65b9\u6cd5\u5df2\u88ab\u7528\u6237\u4fee\u6539\uff0c\u5b58\u5728\u51b2\u7a81", originMethodDeclaration.toString(), ((MethodDeclaration)methodDeclarationMapOfNew.get(name)).toString());
                    this.setConflictDetail(conflictDetail, originMethodDeclaration, (MethodDeclaration)methodDeclarationMapOfNew.get(name));
                    this.genCodeResult.putConflictDetail(name, conflictDetail);
                    continue;
                }
                if (isGodAxeChangeMe) {
                    resMethods.add((MethodDeclaration)methodDeclarationMapOfNew.get(name));
                    continue;
                }
                resMethods.add(originMethodDeclaration);
                continue;
            }
            if (isExistInVersion) {
                isUserChangeMe = !originMethodDeclaration.toString().equals(informationOfVersion.get(name));
                if (!isUserChangeMe) continue;
                resMethods.add(originMethodDeclaration);
                ConflictDetail conflictDetail = new ConflictDetail("change", "java\u6587\u4ef6\u4e2d\u5929\u65a7\u8981\u4fee\u6539\u7684\u65b9\u6cd5\u5df2\u88ab\u7528\u6237\u4fee\u6539\uff0c\u5b58\u5728\u51b2\u7a81", originMethodDeclaration.toString(), "");
                this.setConflictDetail(conflictDetail, originMethodDeclaration, null);
                this.genCodeResult.putConflictDetail(name, conflictDetail);
                continue;
            }
            if (isExistInNew) {
                boolean isTheSameMethod = ((MethodDeclaration)methodDeclarationMapOfNew.get(name)).toString().equals(originMethodDeclaration.toString());
                if (isTheSameMethod) {
                    resMethods.add(originMethodDeclaration);
                    continue;
                }
                resMethods.add(originMethodDeclaration);
                ConflictDetail conflictDetail = new ConflictDetail("add", "java\u6587\u4ef6\u4e2d\u5929\u65a7\u8981\u65b0\u589e\u7684\u65b9\u6cd5\u548c\u7528\u6237\u65b0\u589e\u7684\u540c\u540d\u65b9\u6cd5\u51b2\u7a81", originMethodDeclaration.toString(), ((MethodDeclaration)methodDeclarationMapOfNew.get(name)).toString());
                this.setConflictDetail(conflictDetail, originMethodDeclaration, (MethodDeclaration)methodDeclarationMapOfNew.get(name));
                this.genCodeResult.putConflictDetail(name, conflictDetail);
                continue;
            }
            resMethods.add(originMethodDeclaration);
        }
        return resMethods;
    }

    private void setConflictDetail(ConflictDetail conflictDetail, MethodDeclaration oldMethodDeclaration, MethodDeclaration newMethodDeclaration) {
        conflictDetail.setOldLineNumber(this.setLineNumber(oldMethodDeclaration));
        conflictDetail.setNewLineNumber(this.setLineNumber(newMethodDeclaration));
    }

    private LineNumber setLineNumber(MethodDeclaration methodDeclaration) {
        Optional range;
        LineNumber lineNumber = new LineNumber();
        if (ToolUtil.isNotEmpty((Object)methodDeclaration) && ToolUtil.isNotEmpty((Object)(range = methodDeclaration.getRange())) && range.isPresent()) {
            lineNumber.setStartLineNumber(((Range)range.get()).begin.line);
            lineNumber.setEndLineNumber(((Range)range.get()).end.line);
        }
        return lineNumber;
    }

    private NodeList<FieldDeclaration> mergeProjectFields(List<FieldDeclaration> newFieldDeclarations, List<FieldDeclaration> originFieldDeclarations, Map<String, String> informationOfVersion) {
        NodeList resFields = new NodeList();
        List<FieldDeclaration> toAddFieldOfOrigin = this.getToAddFieldsOfOrigin(originFieldDeclarations, informationOfVersion, newFieldDeclarations);
        List<FieldDeclaration> toAddFieldOfNew = this.getToAddFieldsOfNew(originFieldDeclarations, informationOfVersion, newFieldDeclarations);
        toAddFieldOfOrigin = this.keepFieldPosition(originFieldDeclarations, toAddFieldOfOrigin);
        resFields.addAll(toAddFieldOfOrigin);
        resFields.addAll(toAddFieldOfNew);
        return resFields;
    }

    private List<FieldDeclaration> keepFieldPosition(List<FieldDeclaration> originField, List<FieldDeclaration> addFieldOfOrigin) {
        ArrayList<FieldDeclaration> finalField = new ArrayList<FieldDeclaration>();
        LinkedHashMap originFieldMap = new LinkedHashMap();
        for (FieldDeclaration originF : originField) {
            originF.getVariables().forEach(variableDeclarator -> originFieldMap.put(variableDeclarator.getNameAsString(), originF));
        }
        LinkedHashMap addFieldMap = new LinkedHashMap();
        for (FieldDeclaration addF : addFieldOfOrigin) {
            addF.getVariables().forEach(variableDeclarator -> addFieldMap.put(variableDeclarator.getNameAsString(), addF));
        }
        for (String fieldName : originFieldMap.keySet()) {
            if (!addFieldMap.keySet().contains(fieldName)) continue;
            finalField.add((FieldDeclaration)addFieldMap.get(fieldName));
        }
        return finalField;
    }

    private List<FieldDeclaration> getToAddFieldsOfNew(List<FieldDeclaration> originFieldDeclarations, Map<String, String> informationOfVersion, List<FieldDeclaration> newFieldDeclarations) {
        ArrayList<FieldDeclaration> resFields = new ArrayList<FieldDeclaration>();
        Set<String> nameOfVersion = informationOfVersion.keySet();
        HashSet nameOfOrigin = new HashSet();
        originFieldDeclarations.forEach(originFieldDeclaration -> originFieldDeclaration.getVariables().forEach(variableDeclarator -> nameOfOrigin.add(variableDeclarator.getNameAsString())));
        for (FieldDeclaration newFieldDeclaration : newFieldDeclarations) {
            for (VariableDeclarator variableDeclarator : newFieldDeclaration.getVariables()) {
                boolean isGodAxeChangeMe;
                boolean isAddMe;
                String name = variableDeclarator.getNameAsString();
                boolean isExistInOrigin = nameOfOrigin.contains(name);
                boolean isExistInVersion = nameOfVersion.contains(name);
                boolean isUserDeleteMe = !isExistInOrigin && isExistInVersion;
                boolean bl = isAddMe = !isExistInOrigin && !isExistInVersion;
                if (isAddMe) {
                    if (resFields.contains(newFieldDeclaration)) continue;
                    resFields.add(newFieldDeclaration);
                    continue;
                }
                if (!isUserDeleteMe) continue;
                boolean bl2 = isGodAxeChangeMe = !newFieldDeclaration.toString().equals(informationOfVersion.get(name));
                if (isGodAxeChangeMe) {
                    resFields.add(newFieldDeclaration);
                    this.genCodeResult.putConflictDetail(name, new ConflictDetail("delete", "\u5929\u65a7\u8981\u4fee\u6539\u7684\u5143\u7d20\u7528\u6237\u5df2\u5220\u9664", "", newFieldDeclaration.toString()));
                    continue;
                }
                resFields.add(newFieldDeclaration);
            }
        }
        return resFields;
    }

    private List<FieldDeclaration> getToAddFieldsOfOrigin(List<FieldDeclaration> originFieldDeclarations, Map<String, String> informationOfVersion, List<FieldDeclaration> newFieldDeclarations) {
        ArrayList<FieldDeclaration> resFields = new ArrayList<FieldDeclaration>();
        Set<String> namesOfVersion = informationOfVersion.keySet();
        HashMap nameFieldOfNew = new HashMap();
        newFieldDeclarations.forEach(newFieldDeclaration -> newFieldDeclaration.getVariables().forEach(variableDeclarator -> {
            String name = variableDeclarator.getNameAsString();
            nameFieldOfNew.put(name, newFieldDeclaration);
        }));
        Set namesOfNew = nameFieldOfNew.keySet();
        for (FieldDeclaration originFieldDeclaration : originFieldDeclarations) {
            for (VariableDeclarator variableDeclarator : originFieldDeclaration.getVariables()) {
                String name = variableDeclarator.getNameAsString();
                boolean isExistInVersion = namesOfVersion.contains(name);
                boolean isExistInNew = namesOfNew.contains(name);
                if (isExistInVersion && isExistInNew) {
                    boolean isConflict;
                    boolean isUserChange = !originFieldDeclaration.toString().equals(informationOfVersion.get(name));
                    boolean isGodAxeChange = !informationOfVersion.get(name).equals(((FieldDeclaration)nameFieldOfNew.get(name)).toString());
                    boolean isTheSameElement = originFieldDeclaration.toString().equals(((FieldDeclaration)nameFieldOfNew.get(name)).toString());
                    boolean bl = isConflict = isUserChange && isGodAxeChange && !isTheSameElement;
                    if (isConflict) {
                        resFields.add((FieldDeclaration)nameFieldOfNew.get(name));
                        this.genCodeResult.putConflictDetail(name, new ConflictDetail("change", "\u751f\u6210java\u6587\u4ef6\u65f6\u5b58\u5728\u51b2\u7a81\uff0c\u5929\u65a7\u9700\u8981\u4fee\u6539\u7684\u4ee3\u7801\u88ab\u7528\u6237\u4fee\u6539\u8fc7", originFieldDeclaration.toString(), ((FieldDeclaration)nameFieldOfNew.get(name)).toString()));
                        continue;
                    }
                    if (isGodAxeChange) {
                        if (resFields.contains(nameFieldOfNew.get(name))) continue;
                        resFields.add((FieldDeclaration)nameFieldOfNew.get(name));
                        continue;
                    }
                    if (resFields.contains(originFieldDeclaration)) continue;
                    resFields.add(originFieldDeclaration);
                    continue;
                }
                if (isExistInNew) {
                    boolean isTheSameElement = originFieldDeclaration.toString().equals(((FieldDeclaration)nameFieldOfNew.get(name)).toString());
                    if (!isTheSameElement) {
                        resFields.add(originFieldDeclaration);
                        this.genCodeResult.putConflictDetail(name, new ConflictDetail("add", "java\u6587\u4ef6\u4e2d\uff0c\u7528\u6237\u548c\u5929\u65a7\u65b0\u589e\u4e86\u540c\u540d\u53c2\u6570\uff0c\u4e14\u5185\u5bb9\u4e0d\u540c", originFieldDeclaration.toString(), ((FieldDeclaration)nameFieldOfNew.get(name)).toString()));
                        continue;
                    }
                    resFields.add(originFieldDeclaration);
                    continue;
                }
                boolean originOfVersion = originFieldDeclaration.toString().equals(informationOfVersion.get(name));
                if (originOfVersion) continue;
                resFields.add(originFieldDeclaration);
            }
        }
        return resFields;
    }

    private NodeList<ImportDeclaration> mergeProjectImports(List<ImportDeclaration> newImportDeclarations, List<ImportDeclaration> originImportDeclarations) {
        NodeList resImports = new NodeList();
        newImportDeclarations.forEach(newImportDeclaration -> {
            if (!resImports.contains((Node)newImportDeclaration)) {
                resImports.add((Node)newImportDeclaration);
            }
        });
        originImportDeclarations.forEach(originImportDeclaration -> {
            if (!resImports.contains((Node)originImportDeclaration)) {
                resImports.add((Node)originImportDeclaration);
            }
        });
        return resImports;
    }

    private Map<String, String> informationOfVersion(String filePath) {
        Map<String, String> mapOfVersion = new HashMap<String, String>();
        Object obj = StoreFactory.readFileByVersion(filePath, this.pagePath);
        if (null != obj && obj instanceof Map) {
            mapOfVersion = (Map)obj;
        }
        return mapOfVersion;
    }

    protected GenCodeResult generateFileForJava(Template pageTemplate, String filePath) throws Exception {
        boolean isExistConflict;
        this.genCodeResult.setStartTime(System.currentTimeMillis());
        filePath = ToolUtil.isWinOs() != false ? filePath.replaceAll("/+|\\\\+", "\\\\") : filePath.replaceAll("/+|\\\\+", "/");
        CompilationUnit cuOrigin = null;
        try {
            if (new File(filePath).exists()) {
                FileInputStream in = new FileInputStream(filePath);
                cuOrigin = JavaParser.parse((InputStream)in);
            }
        }
        catch (Exception e) {
            throw new GodAxeException(GodAxeExceptionType.PARSE_JAVA_ERR, filePath);
        }
        CompilationUnit cuNew = new CompilationUnit();
        String fileContent = "";
        try {
            fileContent = pageTemplate.render();
            cuNew = JavaParser.parse((String)fileContent);
        }
        catch (Exception e) {
            throw new GodAxeException(GodAxeExceptionType.PUBLISH_JAVA_ERR, fileContent);
        }
        this.genCodeResult.setNewCode(cuNew.toString());
        CompilationUnit compilationUnit = this.mergeProject(cuOrigin, cuNew, filePath);
        this.writeCodeToFile(compilationUnit, filePath);
        if (cuOrigin != null) {
            this.genCodeResult.setOriginCode(cuOrigin.toString());
        }
        boolean bl = isExistConflict = this.genCodeResult.getConflictDetails().size() > 0;
        if (isExistConflict) {
            this.genCodeResult.setExistConflict(true);
            this.genCodeResult.setMergeCode(String.valueOf(compilationUnit));
            CompilationUnit newMerge = JavaParser.parse((String)String.valueOf(compilationUnit));
            for (Map.Entry<String, ConflictDetail> map : this.genCodeResult.getConflictDetails().entrySet()) {
                String name = map.getKey();
                ConflictDetail conflictDetail = map.getValue();
                List<MethodDeclaration> list = CodeCompareUtil.transDeclarationFromNodes(newMerge.getChildNodes()).getMethodDeclarationList();
                for (MethodDeclaration methodDeclaration : list) {
                    if (!methodDeclaration.getDeclarationAsString(false, false, false).equals(name)) continue;
                    conflictDetail.setMergeLineNumber(this.setLineNumber(methodDeclaration));
                }
            }
        }
        this.genCodeResult.setFilePath(filePath);
        this.genCodeResult.setEndTime(System.currentTimeMillis());
        return this.genCodeResult;
    }

    public List<Map<String, String>> start() {
        super.initConfig();
        this.preHandler();
        ArrayList<Map<String, String>> conflictList = new ArrayList<Map<String, String>>();
        return conflictList;
    }

    private void preHandler() {
        this.configClassInfo();
        this.configPackageInfo();
        this.configPathInfo();
    }

    private void configClassInfo() {
        String moduleName = this.contextConfig.getModuleName();
        StringBuilder moduleNameToUpper = new StringBuilder();
        if (null != moduleName && moduleName.contains(".")) {
            String[] arr;
            for (String anArr : arr = moduleName.split("\\.")) {
                moduleNameToUpper.append(ToolUtil.firstLetterToUpper((String)anArr));
            }
        } else if (null != moduleName && !moduleName.contains(".")) {
            moduleNameToUpper = new StringBuilder(ToolUtil.firstLetterToUpper((String)moduleName));
        }
        this.tableInfo.setControllerName(moduleNameToUpper + "Controller");
    }

    private void configPathInfo() {
        this.pathInfo = new HashMap<String, String>();
        this.modulePath = this.contextConfig.getModuleName().replaceAll("\\.", "/");
        String controllerPath = super.getContextConfig().getProjectPath() + "\\src\\main\\java\\" + this.contextConfig.getProPackage().replaceAll("\\.", "\\\\") + "\\" + this.contextConfig.getModuleName().replaceAll("\\.", "\\\\") + "\\controller\\" + this.tableInfo.getControllerName() + ".java";
        String servicePath = super.getContextConfig().getProjectPath() + "\\src\\main\\java\\" + this.contextConfig.getProPackage().replaceAll("\\.", "\\\\") + "\\" + this.tableModuleName + "\\service\\" + this.tableInfo.getServiceName() + ".java";
        String serviceImplPath = super.getContextConfig().getProjectPath() + "\\src\\main\\java\\" + this.contextConfig.getProPackage().replaceAll("\\.", "\\\\") + "\\" + this.tableModuleName + "\\service\\impl\\" + this.tableInfo.getServiceImplName() + ".java";
        String entityPath = super.getContextConfig().getProjectPath() + "\\src\\main\\java\\" + this.contextConfig.getProPackage().replaceAll("\\.", "\\\\") + "\\" + this.tableModuleName + "\\model\\" + this.tableInfo.getEntityName() + ".java";
        String xmlPath = super.getContextConfig().getProjectPath() + "\\src\\main\\java\\" + this.contextConfig.getProPackage().replaceAll("\\.", "\\\\") + "\\" + this.tableModuleName + "\\dao\\mapping\\" + this.tableInfo.getMapperName() + ".xml";
        String mapperPath = super.getContextConfig().getProjectPath() + "\\src\\main\\java\\" + this.contextConfig.getProPackage().replaceAll("\\.", "\\\\") + "\\" + this.tableModuleName + "\\dao\\" + this.tableInfo.getMapperName() + ".java";
        this.pathInfo.put("Controller", controllerPath);
        this.pathInfo.put("Service", servicePath);
        this.pathInfo.put("ServiceImpl", serviceImplPath);
        this.pathInfo.put("Entity", entityPath);
        this.pathInfo.put("Mapper", mapperPath);
        this.pathInfo.put("Xml", xmlPath);
    }

    private void configPackageInfo() {
        String proPackage = this.contextConfig.getProPackage();
        String moduleName = this.contextConfig.getModuleName();
        String parentWithModuleName = this.joinPackage(proPackage, moduleName);
        String parentWithTableModule = this.joinPackage(proPackage, this.tableModuleName);
        this.packageInfo = new HashMap<String, String>();
        this.packageInfo.put("ModuleName", moduleName);
        this.packageInfo.put("Entity", this.joinPackage(parentWithTableModule, this.entityInfo()));
        this.packageInfo.put("Mapper", this.joinPackage(parentWithTableModule, this.mapperInfo()));
        this.packageInfo.put("Service", this.joinPackage(parentWithTableModule, this.serviceInfo()));
        this.packageInfo.put("ServiceImpl", this.joinPackage(parentWithTableModule, this.serviceImplInfo()));
        this.packageInfo.put("Controller", this.joinPackage(parentWithModuleName, this.controllerInfo()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCodeToFile(CompilationUnit cu, String targetFilePath) {
        FileOutputStream fos = null;
        PrintWriter pw = null;
        try {
            File file = new File(targetFilePath);
            if (!file.exists()) {
                FileUtils.touch((File)file);
            }
            fos = new FileOutputStream(file);
            pw = new PrintWriter(fos);
            pw.write(cu.toString().toCharArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != pw) {
                pw.flush();
            }
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void writeCodeToFile(String cu, String targetFilePath) throws IOException {
        File file = new File(targetFilePath);
        if (!file.exists()) {
            FileUtils.touch((File)file);
        }
        FileOutputStream fos = new FileOutputStream(file);
        PrintWriter pw = new PrintWriter(fos);
        pw.write(cu.toCharArray());
        pw.flush();
        fos.close();
    }

    private List<Element> compareXMLGetNew(Map<String, Element> elementsOrigin, Document xmlCurrent, String filePath) {
        Element rootElement = xmlCurrent.getRootElement();
        Iterator itElement = rootElement.elementIterator();
        Set<String> originElementIds = elementsOrigin.keySet();
        Map infoOfVersion = (Map)StoreFactory.readFileByVersion(filePath, this.pagePath);
        Set<Object> versionElementIds = new HashSet();
        if (ToolUtil.isNotEmpty((Object)infoOfVersion)) {
            versionElementIds = infoOfVersion.keySet();
        }
        ArrayList<Element> toAddList = new ArrayList<Element>();
        while (itElement.hasNext()) {
            Element nodeElement = (Element)itElement.next();
            Set<Object> finalVersionElementIds = versionElementIds;
            nodeElement.attributes().forEach(attribute -> {
                if ("id".equals(((DefaultAttribute)attribute).getName())) {
                    String nodeId = ((DefaultAttribute)attribute).getValue();
                    boolean isContainsInVersion = finalVersionElementIds.contains(nodeId);
                    boolean isContainsInOrigin = originElementIds.contains(nodeId);
                    String md5OfVersion = infoOfVersion == null ? "" : (String)infoOfVersion.get(nodeId);
                    String md5OfCurrent = MD5Util.encrypt((String)nodeElement.asXML().replace(" ", ""));
                    if (!isContainsInOrigin) {
                        if (isContainsInVersion) {
                            if (!md5OfCurrent.equals(md5OfVersion)) {
                                this.genCodeResult.setExistConflict(true);
                                try {
                                    this.genCodeResult.putConflictDetail(nodeId, new ConflictDetail("delete", "\u5929\u65a7\u8981\u4fee\u6539\u7684\u65b9\u6cd5\u5df2\u88ab\u7528\u6237\u5220\u9664\uff0c\u5b58\u5728\u51b2\u7a81", "", this.documentToString(nodeElement, false)));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        } else {
                            toAddList.add(nodeElement);
                        }
                    }
                }
            });
        }
        return toAddList;
    }

    private List<Element> compareXMLGetOrigin(Map<String, Element> elementsOrigin, Document xmlCurrent, String filePath) throws IOException {
        Element rootElement = xmlCurrent.getRootElement();
        Iterator itElement = rootElement.elementIterator();
        Set<String> originElementIds = elementsOrigin.keySet();
        Map infoOfVersion = (Map)StoreFactory.readFileByVersion(filePath, this.pagePath);
        Set<Object> versionElementIds = new HashSet();
        if (ToolUtil.isNotEmpty((Object)infoOfVersion)) {
            versionElementIds = infoOfVersion.keySet();
        }
        HashMap infoOfCurrent = new HashMap();
        ArrayList<Element> toAddList = new ArrayList<Element>();
        while (itElement.hasNext()) {
            Element nodeElement = (Element)itElement.next();
            nodeElement.attributes().forEach(attribute -> {
                if ("id".equals(((DefaultAttribute)attribute).getName())) {
                    String nodeId = ((DefaultAttribute)attribute).getValue();
                    infoOfCurrent.put(nodeId, nodeElement);
                }
            });
        }
        Set currentElementIds = infoOfCurrent.keySet();
        for (String key : originElementIds) {
            Element toAddElement = elementsOrigin.get(key);
            boolean isContainsInVersion = versionElementIds.contains(key);
            boolean isContainsInCurrent = currentElementIds.contains(key);
            String md5OfVersion = infoOfVersion == null ? "" : (String)infoOfVersion.get(key);
            Element elementOfCurrent = (Element)infoOfCurrent.get(key);
            String md5OfCurrent = elementOfCurrent == null ? "" : MD5Util.encrypt((String)this.documentToString(elementOfCurrent, true));
            String md5OfOrigin = MD5Util.encrypt((String)this.documentToString(elementsOrigin.get(key), true));
            if (isContainsInVersion && isContainsInCurrent) {
                boolean isGodAxeNotChangeThisElement = md5OfVersion.equals(md5OfCurrent);
                boolean isUserNotChangeThisElement = md5OfVersion.equals(md5OfOrigin);
                if (isGodAxeNotChangeThisElement) {
                    toAddList.add(toAddElement);
                    continue;
                }
                if (isUserNotChangeThisElement) {
                    toAddList.add((Element)infoOfCurrent.get(key));
                    continue;
                }
                toAddList.add((Element)infoOfCurrent.get(key));
                this.genCodeResult.setExistConflict(true);
                this.genCodeResult.putConflictDetail(key, new ConflictDetail("change", "\u5929\u65a7\u8981\u4fee\u6539\u7684\u5143\u7d20\u88ab\u7528\u6237\u4fee\u6539\u8fc7", this.documentToString(toAddElement, false), this.documentToString((Element)infoOfCurrent.get(key), false)));
                continue;
            }
            if (isContainsInVersion) {
                boolean isUserNotChangeThisElement = md5OfVersion.equals(md5OfOrigin);
                if (!isUserNotChangeThisElement) {
                    this.genCodeResult.putConflictDetail(key, new ConflictDetail("change", "\u7528\u6237\u4fee\u6539\u8fc7\u5929\u65a7\u8981\u5220\u9664\u7684\u4ee3\u7801\uff0c\u4e14\u5728\u5f53\u524d\u7248\u672c\u4e2d\u8be5\u5143\u7d20\u4e0d\u5b58\u5728", this.documentToString(toAddElement, false), ""));
                    continue;
                }
                toAddList.add(toAddElement);
                continue;
            }
            if (isContainsInCurrent) {
                boolean isTheSameElementInToAddAndNew = md5OfCurrent.equals(md5OfOrigin);
                if (isTheSameElementInToAddAndNew) {
                    toAddList.add(toAddElement);
                    continue;
                }
                toAddList.add(toAddElement);
                this.genCodeResult.putConflictDetail(key, new ConflictDetail("add", "\u7528\u6237\u624b\u5199\u7684\u65b9\u6cd5\u4e0e\u5929\u65a7\u65b0\u589e\u7684\u65b9\u6cd5\u5b58\u5728\u51b2\u7a81\uff0c\u60c5\u51b5\u63cf\u8ff0\uff1a\u5b58\u5728id\u76f8\u540c\u7684XML\u5143\u7d20\uff0c\u4e14\u5143\u7d20\u5185\u5bb9\u4e0d\u540c", this.documentToString(toAddElement, false), this.documentToString((Element)infoOfCurrent.get(key), false)));
                continue;
            }
            toAddList.add(toAddElement);
        }
        return toAddList;
    }

    private String joinPackage(String parent, String subPackage) {
        if (StringUtils.isEmpty((CharSequence)parent)) {
            return subPackage;
        }
        return parent + "." + subPackage;
    }

    protected String getSuperClassName(String classPath) {
        if (StringUtils.isEmpty((CharSequence)classPath)) {
            return null;
        }
        return classPath.substring(classPath.lastIndexOf(".") + 1);
    }

    private String entityInfo() {
        return "model";
    }

    private String serviceInfo() {
        return "service";
    }

    private String serviceImplInfo() {
        return "service.impl";
    }

    private String mapperInfo() {
        return "dao";
    }

    private String mapperXmlInfo() {
        return "dao.mapping";
    }

    private String controllerInfo() {
        return "controller";
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public void setPagePath(String pagePath) {
        this.pagePath = pagePath;
    }
}

