/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.generator.action.config;

import com.baomidou.mybatisplus.generator.formdesign.config.rules.DbType;
import com.baomidou.mybatisplus.generator.formdesign.config.rules.NamingStrategy;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.generator.action.config.FDAbstractGeneratorConfig;
import com.jxdinfo.hussar.formdesign.generator.action.config.FormDesignGenQo;
import com.jxdinfo.hussar.formdesign.generator.action.model.FDGeneratorProperties;
import java.io.File;
import org.springframework.core.env.Environment;

public class FormDesignGeneratorConfig
extends FDAbstractGeneratorConfig {
    public static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    public static final String ORACLE_DRIVER = "oracle.jdbc.OracleDriver";
    public static final String DM_DRIVER = "dm.jdbc.driver.DmDriver";
    public static final String OSCAR_DRIVER = "com.oscar.Driver";
    public static final String KINGBASE_DRIVER = "com.kingbase.Driver";
    private FormDesignGenQo genQo;
    private Environment env = (Environment)SpringContextHolder.getBean(Environment.class);
    private FDGeneratorProperties hussarProperties = (FDGeneratorProperties)SpringContextHolder.getBean(FDGeneratorProperties.class);

    public FormDesignGeneratorConfig(FormDesignGenQo genQo, boolean activeRecord) {
        this.genQo = genQo;
        this.activeRecord = activeRecord;
    }

    @Override
    protected void config() {
        String dbDriver = this.env.getProperty("spring.datasource.driverClassName");
        this.workflowInfo = this.genQo.getWorkFlowInfo();
        this.dataSourceConfig.setDbType(DbType.MYSQL);
        this.dataSourceConfig.setDriverName(dbDriver);
        this.dataSourceConfig.setUsername(this.genQo.getUserName());
        this.dataSourceConfig.setPassword(this.genQo.getPassword());
        this.dataSourceConfig.setUrl(this.genQo.getUrl());
        String environment = this.hussarProperties.getEnvironment();
        String pageLocal = "";
        pageLocal = "dyna".equals(environment) ? this.genQo.getProjectPath() + File.separator + "src" : this.genQo.getProjectPath() + File.separator + "src" + File.separator + "main" + File.separator + "java";
        this.globalConfig.setOutputDir(pageLocal);
        this.globalConfig.setFileOverride(true);
        this.globalConfig.setEnableCache(false);
        this.globalConfig.setBaseResultMap(true);
        this.globalConfig.setBaseColumnList(true);
        this.globalConfig.setOpen(false);
        this.globalConfig.setAuthor(this.genQo.getAuthor());
        this.contextConfig.setProPackage(this.genQo.getProjectPackage());
        this.contextConfig.setCoreBasePackage(this.genQo.getCorePackage());
        this.contextConfig.setModuleName(this.genQo.getModuleName());
        if (this.genQo.getIgnoreTabelPrefix() != null) {
            this.strategyConfig.setTablePrefix(new String[]{this.genQo.getIgnoreTabelPrefix()});
        }
        this.strategyConfig.setInclude(new String[]{this.genQo.getTableName()});
        this.strategyConfig.setNaming(NamingStrategy.underline_to_camel);
        this.strategyConfig.entityTableFieldAnnotationEnable(true);
        this.packageConfig.setParent(null);
        this.packageConfig.setEntity(this.genQo.getProjectPackage() + "." + this.contextConfig.getModuleName() + ".model");
        this.packageConfig.setMapper(this.genQo.getProjectPackage() + "." + this.contextConfig.getModuleName() + ".dao");
        this.packageConfig.setXml(this.genQo.getProjectPackage() + "." + this.contextConfig.getModuleName() + ".dao.mapping");
        this.contextConfig.setBizChName(this.genQo.getBizName());
        this.contextConfig.setModuleName(this.genQo.getModuleName());
        this.contextConfig.setPageName(this.genQo.getPageName());
        this.contextConfig.setProjectPath(this.genQo.getProjectPath());
        this.contextConfig.setAuthor(this.genQo.getAuthor());
        this.sqlConfig.setParentMenuName(this.genQo.getParentMenuName());
        this.contextConfig.setEntitySwitch(this.genQo.getEntitySwitch());
        this.contextConfig.setDaoSwitch(this.genQo.getDaoSwitch());
        this.contextConfig.setServiceSwitch(this.genQo.getServiceSwitch());
        this.contextConfig.setControllerSwitch(this.genQo.getControllerSwitch());
        this.contextConfig.setIndexPageSwitch(this.genQo.getIndexPageSwitch());
        this.contextConfig.setAddPageSwitch(this.genQo.getAddPageSwitch());
        this.contextConfig.setEditPageSwitch(this.genQo.getEditPageSwitch());
        this.contextConfig.setJsSwitch(this.genQo.getJsSwitch());
        this.contextConfig.setInfoJsSwitch(this.genQo.getInfoJsSwitch());
        this.contextConfig.setSqlSwitch(this.genQo.getSqlSwitch());
        if (ORACLE_DRIVER.equals(dbDriver)) {
            this.dataSourceConfig.setDbType(DbType.ORACLE);
            this.strategyConfig.setCapitalMode(true);
            this.strategyConfig.entityTableFieldAnnotationEnable(true);
        }
        if (DM_DRIVER.equals(dbDriver)) {
            this.dataSourceConfig.setDbType(DbType.DM);
            this.strategyConfig.setCapitalMode(true);
            this.strategyConfig.entityTableFieldAnnotationEnable(true);
        }
        if (OSCAR_DRIVER.equals(dbDriver)) {
            this.dataSourceConfig.setDbType(DbType.OSCAR);
            this.strategyConfig.setCapitalMode(true);
            this.strategyConfig.entityTableFieldAnnotationEnable(true);
        }
        if (KINGBASE_DRIVER.equals(dbDriver)) {
            this.dataSourceConfig.setDbType(DbType.KINGBASE);
            this.strategyConfig.setCapitalMode(true);
            this.strategyConfig.entityTableFieldAnnotationEnable(true);
        }
    }
}

