/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.excel.sheetHandler;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.jxdinfo.hussar.common.dicutil.DictionaryUtil;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.util.List;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.util.CellRangeAddressList;

public class CustomSheetWriteHandler
implements SheetWriteHandler {
    private DictionaryUtil dictionaryUtil = (DictionaryUtil)SpringContextHolder.getBean(DictionaryUtil.class);
    private String type;
    private String value;
    private int index;

    public CustomSheetWriteHandler(String type, String value, int index) {
        this.type = type;
        this.value = value;
        this.index = index;
    }

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        List dicSingles;
        if ("dict".equals(this.type) && (dicSingles = this.dictionaryUtil.getDictByType(this.value)) != null && dicSingles.size() > 0) {
            CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(1, 100, this.index, this.index);
            DataValidationHelper helper = writeSheetHolder.getSheet().getDataValidationHelper();
            DataValidationConstraint constraint = helper.createExplicitListConstraint((String[])dicSingles.stream().map(DicSingle::getLabel).toArray(String[]::new));
            DataValidation dataValidation = helper.createValidation(constraint, cellRangeAddressList);
            writeSheetHolder.getSheet().addValidationData(dataValidation);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

