/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.tableinfo.service.impl;

import com.baomidou.mybatisplus.generator.formdesign.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.mapper.SqlRunner;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.desgin.tableinfo.config.ReadTablesConfig;
import com.jxdinfo.hussar.formdesign.desgin.tableinfo.rules.TableQuery;
import com.jxdinfo.hussar.formdesign.desgin.tableinfo.service.TableInfoService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TableInfoServiceImpl
implements TableInfoService {
    @Autowired
    private DruidProperties druidProperties;
    @Autowired
    private ReadTablesConfig readTablesConfig;

    @Override
    public List<Map<String, Object>> getAllTablesBySchema() {
        List<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
        String dbUrl = this.druidProperties.getUrl();
        for (TableQuery tmp : TableQuery.values()) {
            if (!dbUrl.startsWith(tmp.getStartURL())) continue;
            retList = this.dealTableInfo(tmp, this.druidProperties.getDbName());
            break;
        }
        return retList;
    }

    @Override
    public List<Map<String, Object>> getAllTablesByTableName() {
        String dbUrl;
        List<String> notLikeList = this.readTablesConfig.getNotLikePrefix();
        List<String> notInList = this.readTablesConfig.getNotIn();
        ArrayList<String> newList = new ArrayList<String>();
        for (String s : notInList) {
            s = "'" + s + "'";
            newList.add(s);
        }
        String tables = StringUtils.strip((String)((Object)newList).toString(), (String)"[]");
        if (ToolUtil.isEmpty((Object)tables)) {
            tables = "''";
        }
        if ((dbUrl = this.druidProperties.getUrl()).startsWith("jdbc:mysql")) {
            return this.tableInfoWithMysql(notLikeList, tables);
        }
        if (dbUrl.startsWith("jdbc:dm")) {
            return this.tableInfoWithDM(notLikeList, tables);
        }
        return new ArrayList<Map<String, Object>>();
    }

    private List<Map<String, Object>> tableInfoWithMysql(List<String> notLikeList, String tables) {
        String dbName = this.druidProperties.getDbName();
        StringBuilder stringBuilder = new StringBuilder();
        notLikeList.forEach(m -> stringBuilder.append(" TABLE_NAME NOT LIKE '").append((String)m).append("%'").append(" AND "));
        String stringBuilderTable = "SELECT TABLE_NAME AS name, TABLE_COMMENT AS comment, TABLE_TYPE AS type FROM INFORMATION_SCHEMA.TABLES WHERE " + stringBuilder.toString() + "TABLE_SCHEMA = {0} AND TABLE_NAME NOT IN (" + tables + ") ORDER BY TABLE_NAME";
        List tableList = SqlRunner.db().selectList(stringBuilderTable, new Object[]{dbName});
        String stringBuilderColumn = "SELECT TABLE_NAME AS tablename,COLUMN_NAME AS name,COLUMN_COMMENT AS comment,COLUMN_TYPE AS type,COLUMN_KEY AS primarys FROM INFORMATION_SCHEMA.COLUMNS WHERE " + stringBuilder.toString() + "TABLE_SCHEMA = {0} AND TABLE_NAME NOT IN (" + tables + ") ORDER BY TABLE_NAME,ORDINAL_POSITION ASC";
        List columnList = SqlRunner.db().selectList(stringBuilderColumn, new Object[]{dbName});
        return this.dealTableInfoExtra(tableList, columnList);
    }

    private List<Map<String, Object>> tableInfoWithDM(List<String> notLikeList, String notInTables) {
        String dbName = this.druidProperties.getDbName();
        StringBuilder stringBuilder = new StringBuilder();
        notLikeList.forEach(m -> stringBuilder.append("and t.TABLE_NAME not like '").append(m.toUpperCase().replace("_", "/_")).append("%'").append(" escape '/' "));
        String tables = "SELECT\n        t.TABLE_NAME as name,\n        f.COMMENTS   as tcomment,\n'BASE_TABLE' as tableType from\n        all_tables t\ninner join all_tab_comments f\non\n        t.table_name = f.table_name\nWHERE\n        t.owner='$OWNER'\n    $NOT_LIKE_TABLE\n    and t.TABLE_NAME not in ($NOT_IN_TABLE)\n    and t.TABLESPACE_NAME != 'TEMP' union all\n\nselect\n        v.VIEW_NAME AS name    ,\n        f.COMMENTS  as tcomment,\n        'VIEW'      as tableType\nfrom\n        all_views v\ninner join user_tab_comments f\non\n        v.view_NAME = f.table_name\nwhere\n        v.owner = '$OWNER';";
        String columns = "select\n        t.TABLE_NAME  AS tableName ,\n        t.COLUMN_NAME AS columnName,\n        t.DATA_TYPE   AS ttype,\n        act.COMMENTS   AS comments,\ncase when (\n                                select\n                                        count(*)\n                                from\n                                        all_cons_columns\n                                where\n                                        constraint_name =\n                                        (\n                                                select\n                                                        constraint_name\n                                                from\n                                                        all_constraints\n                                                where\n                                                        table_name = t.TABLE_NAME and constraint_type = 'P' and OWNER='$OWNER'\n                                        ) AND COLUMN_NAME          = t.COLUMN_NAME\n                        )\n                        > 0 THEN 'PRI' ELSE '' END AS primarys from\n        all_tab_columns t\nLEFT JOIN all_col_comments act\nON\n        t.OWNER       = act.OWNER\n    AND t.TABLE_NAME  = act.TABLE_NAME\n    AND t.COLUMN_NAME = act.COLUMN_NAME\nwhere\n        t.OWNER='$OWNER'\n        $NOT_LIKE_TABLE\n        and t.TABLE_NAME not in ($NOT_IN_TABLE)";
        List tableList = SqlRunner.db().selectList(tables.replace("$OWNER", dbName.toUpperCase()).replace("$NOT_LIKE_TABLE", stringBuilder.toString()).replace("$NOT_IN_TABLE", notInTables), new Object[]{dbName});
        List columnList = SqlRunner.db().selectList(columns.replace("$OWNER", dbName.toUpperCase()).replace("$NOT_LIKE_TABLE", stringBuilder.toString()).replace("$NOT_IN_TABLE", notInTables), new Object[]{dbName});
        return this.dealTableInfoExtraDM(tableList, columnList);
    }

    private List<Map<String, Object>> dealTableInfo(TableQuery tableQuery, String schema) {
        List tableList = SqlRunner.db().selectList(tableQuery.getTableSQL(), new Object[]{schema});
        List columnList = SqlRunner.db().selectList(tableQuery.getColumnSQL(), new Object[]{schema});
        return this.dealTableInfoExtra(tableList, columnList);
    }

    private List<Map<String, Object>> dealTableInfoExtra(List<Map<String, Object>> tableList, List<Map<String, Object>> columnList) {
        for (Map<String, Object> column : columnList) {
            String tableNmae_col = (String)column.get("tablename");
            for (Map<String, Object> table : tableList) {
                String tableNmae_tab = (String)table.get("name");
                if (!tableNmae_col.equals(tableNmae_tab)) continue;
                if (null != table.get("fields")) {
                    String columnName = (String)column.get("name");
                    column.put("name", NamingStrategy.underlineToCamel((String)columnName));
                    column.put("realName", columnName);
                    ((List)table.get("fields")).add(column);
                    continue;
                }
                ArrayList<Map<String, Object>> fieldList = new ArrayList<Map<String, Object>>();
                String columnName = (String)column.get("name");
                column.put("name", NamingStrategy.underlineToCamel((String)columnName));
                column.put("realName", columnName);
                fieldList.add(column);
                table.put("fields", fieldList);
            }
        }
        return tableList;
    }

    private List<Map<String, Object>> dealTableInfoExtraDM(List<Map<String, Object>> tableList, List<Map<String, Object>> columnList) {
        for (Map<String, Object> column : columnList) {
            String tableNmae_col = (String)column.get("TABLENAME");
            for (Map<String, Object> table : tableList) {
                String tableNmae_tab = (String)table.get("NAME");
                if (!tableNmae_col.equals(tableNmae_tab)) continue;
                HashMap<String, Object> newColumn = new HashMap<String, Object>();
                String columnName = (String)column.get("COLUMNNAME");
                newColumn.put("name", NamingStrategy.underlineToCamel((String)columnName));
                newColumn.put("realName", columnName);
                newColumn.put("comment", column.get("COMMENTS"));
                newColumn.put("type", column.get("TTYPE"));
                newColumn.put("tablename", column.get("TABLENAME"));
                newColumn.put("primarys", column.get("PRIMARYS"));
                if (null != table.get("fields")) {
                    ((List)table.get("fields")).add(newColumn);
                    continue;
                }
                ArrayList<HashMap<String, Object>> fieldList = new ArrayList<HashMap<String, Object>>();
                fieldList.add(newColumn);
                table.put("fields", fieldList);
                table.put("name", tableNmae_tab);
                table.put("comment", table.get("TCOMMENT"));
            }
        }
        return tableList;
    }
}

