/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.tableinfo.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.formdesign.contant.CodeVersionConstant;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.desgin.publish.service.PublishService;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import com.jxdinfo.hussar.formdesign.store.StoreFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/generator"})
public class GeneratorController
extends BaseController {
    @Autowired
    private PublishService publishService;
    @Value(value="${form-design.project-path}")
    private String projectPath;
    @Value(value="${form-design.module-store-path}")
    private String rootPath;
    @Value(value="${form-design.project-name}")
    private String projectName;

    @RequestMapping(value={"/genPageCode"})
    public FormDesignResponse<Map<String, Object>> generatorPageCode(@RequestBody JSONObject jsonObject) {
        String path = jsonObject.get((Object)"path").toString();
        String projectPath = jsonObject.get((Object)"projectPath").toString();
        FormDesignResponse<Map<String, Object>> formDesignResponse = new FormDesignResponse<Map<String, Object>>();
        try {
            formDesignResponse = this.publishService.publishCode(path, projectPath);
        }
        catch (GodAxeException e) {
            e.printInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formDesignResponse;
    }

    @RequestMapping(value={"/writeCodeToFile"})
    public boolean writeCodeToFile(@RequestBody List<Map<String, Object>> conflictList) throws IOException {
        for (Map<String, Object> map : conflictList) {
            String filePath = map.get("filePath").toString();
            String code = map.get("mergeCode").toString();
            String type = map.get("type").toString();
            File file = new File(filePath);
            FileUtils.writeStringToFile((File)file, (String)code, (String)"UTF-8");
            if (!"html".equals(type)) continue;
            StoreFactory.createFileVersion(file.getAbsolutePath(), CodeVersionConstant.currentVersion, code);
        }
        return true;
    }
}

