/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.SqlLike;
import com.baomidou.mybatisplus.generator.formdesign.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.formdesign.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.formdesign.config.designvo.DelRelateInfo;
import com.baomidou.mybatisplus.generator.formdesign.config.designvo.LogicalDeletionInfo;
import com.baomidou.mybatisplus.generator.formdesign.config.po.TableField;
import com.baomidou.mybatisplus.generator.formdesign.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.formdesign.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.configration.DesignConfig;
import com.jxdinfo.hussar.formdesign.contant.GodAxeExceptionType;
import com.jxdinfo.hussar.formdesign.contant.PackageMapType;
import com.jxdinfo.hussar.formdesign.contant.TableNameType;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.ComponentPageDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventActionsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConditionsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.EventConfigsDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.GenCodePreData;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.TableDto;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.GenPreDataUtil;
import com.jxdinfo.hussar.formdesign.desgin.form.model.Page;
import com.jxdinfo.hussar.formdesign.desgin.form.service.CodeGenService;
import com.jxdinfo.hussar.formdesign.desgin.form.service.PageService;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.TableTreeNode;
import com.jxdinfo.hussar.formdesign.desgin.publish.model.PublishTableModel;
import com.jxdinfo.hussar.formdesign.desgin.publish.service.DatabaseInfoService;
import com.jxdinfo.hussar.formdesign.desgin.publish.service.PublishService;
import com.jxdinfo.hussar.formdesign.desgin.tableinfo.model.GodTableData;
import com.jxdinfo.hussar.formdesign.desgin.tableinfo.model.GodTableField;
import com.jxdinfo.hussar.formdesign.desgin.tablerelate.model.TableQueryCondition;
import com.jxdinfo.hussar.formdesign.desgin.tablerelate.model.TableRelate;
import com.jxdinfo.hussar.formdesign.desgin.tablerelate.service.ITableQueryService;
import com.jxdinfo.hussar.formdesign.desgin.tablerelate.service.ITableRealteService;
import com.jxdinfo.hussar.formdesign.excel.template.ExcelConverterTem;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import com.jxdinfo.hussar.formdesign.generator.action.config.FormCrudUrl;
import com.jxdinfo.hussar.formdesign.generator.action.config.FormDesignGenQo;
import com.jxdinfo.hussar.formdesign.generator.action.config.FormDesignGeneratorConfig;
import com.jxdinfo.hussar.formdesign.generator.engine.base.GenControllerCode;
import com.jxdinfo.hussar.formdesign.generator.engine.base.GenEntityCode;
import com.jxdinfo.hussar.formdesign.generator.engine.base.GenExcelConverterCode;
import com.jxdinfo.hussar.formdesign.generator.engine.base.GenMapperCode;
import com.jxdinfo.hussar.formdesign.generator.engine.base.GenMapperXmlCode;
import com.jxdinfo.hussar.formdesign.generator.engine.base.GenServiceCode;
import com.jxdinfo.hussar.formdesign.generator.engine.base.GenServiceImplCode;
import com.jxdinfo.hussar.formdesign.generator.engine.base.GenWorkFlowListener;
import com.jxdinfo.hussar.formdesign.generator.engine.base.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.generator.engine.config.SqlConfig;
import com.jxdinfo.hussar.formdesign.result.GenCodeResult;
import com.jxdinfo.hussar.formdesign.util.CompileUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.stereotype.Service;

@Service
public class PublishServiceImpl
implements PublishService {
    @Value(value="${form-design.page-store-path}")
    private String pagePath;
    @Autowired
    private DataSourceProperties druidProperties;
    @Value(value="${form-design.project-path}")
    private String projectPath;
    @Autowired
    private CodeGenService service;
    @Autowired
    private PageService pageService;
    @Autowired
    private DatabaseInfoService databaseInfoService;
    @Autowired
    private ITableRealteService tableRealteService;
    @Autowired
    private ITableQueryService tableQueryService;
    @Autowired
    private DesignConfig designConfig;
    @Value(value="${form-design.page-store-path}")
    private String pageStorePath;
    @Value(value="${form-design.std-out-cost-time}")
    private boolean stdOutCostTime;

    @Override
    public FormDesignResponse<Map<String, Object>> publishCode(String path, String projectPath) throws Exception {
        long startTime = System.currentTimeMillis();
        FormDesignResponse<Map<String, Object>> response = new FormDesignResponse<Map<String, Object>>();
        response.setErrorCode("200");
        HashMap<String, Cloneable> retMap = new HashMap<String, Cloneable>();
        GenCodePreData genCodePreData = this.preHandler(path, projectPath);
        boolean isDynamic = this.designConfig.isDynamic();
        if (isDynamic) {
            SqlConfig sqlConfig = new SqlConfig();
            sqlConfig.createTableRelate(path.replace(".vpd", ""));
            sqlConfig.createTableQuery(path);
            this.getRelateTableInfo(path, projectPath);
        }
        GenCodeResult genFrontCodeResult = this.publishFrontCode(path, projectPath, genCodePreData);
        ArrayList<GenCodeResult> genCodeResults = new ArrayList<GenCodeResult>();
        if (!isDynamic) {
            genCodeResults.addAll(this.publishBackCode(genCodePreData));
        }
        genCodeResults.add(genFrontCodeResult);
        if (this.stdOutCostTime) {
            System.out.println("\u751f\u6210\u4ee3\u7801\u65f6\u957f\u7edf\u8ba1\uff1a");
        }
        Iterator itGenCodeResults = genCodeResults.iterator();
        HashMap<String, Long> costTime = new HashMap<String, Long>();
        long totalTime = 0L;
        while (itGenCodeResults.hasNext()) {
            GenCodeResult current = (GenCodeResult)itGenCodeResults.next();
            long timeSpend = current.getEndTime() - current.getStartTime();
            if (this.stdOutCostTime) {
                System.out.println(current.getType() + ":" + current.getFilePath() + ":");
                System.out.println(current.getEndTime() - current.getStartTime());
            }
            costTime.put(current.getType(), timeSpend);
            totalTime += timeSpend;
            if (current.isExistConflict()) continue;
            itGenCodeResults.remove();
        }
        long endTime = System.currentTimeMillis();
        long htmlTime = endTime - startTime - totalTime;
        costTime.put("total", totalTime);
        if (genCodeResults.size() > 0) {
            retMap.put("conflictList", genCodeResults);
            response.setErrorCode("201");
        }
        if (this.stdOutCostTime) {
            System.out.println("html:" + htmlTime);
            System.out.println("\u751f\u6210\u4ee3\u7801\u82b1\u8d39\u603b\u65f6\u957f\u4e3a\uff1a" + (endTime - startTime));
        }
        retMap.put("costTime", costTime);
        response.setData(retMap);
        GenEntityCode genEntityCode = new GenEntityCode();
        genEntityCode.setProjectPath(this.projectPath);
        genEntityCode.setProPackage(genCodePreData.getProPackage());
        CompileUtil.compile(genEntityCode);
        return response;
    }

    private GenCodePreData getRelateTableInfo(String path, String rootPath) {
        try {
            EntityWrapper relateEntityWrapper = new EntityWrapper();
            relateEntityWrapper.like("page_path", path.replace(".vpd", "").concat("-"), SqlLike.RIGHT);
            List relateList = this.tableRealteService.selectList((Wrapper)relateEntityWrapper);
            if (relateList.size() != 0) {
                for (TableRelate relate : relateList) {
                    this.tableRealteService.deleteById(Integer.valueOf(relate.getRelateId()));
                }
            }
            EntityWrapper queryEntityWrapper = new EntityWrapper();
            queryEntityWrapper.like("page_path", path.replace(".vpd", "").concat("-"), SqlLike.RIGHT);
            List conditionList = this.tableQueryService.selectList((Wrapper)queryEntityWrapper);
            if (conditionList.size() != 0) {
                for (TableQueryCondition condition : conditionList) {
                    this.tableQueryService.deleteById(Integer.valueOf(condition.getQueryId()));
                }
            }
            ComponentPageDto componentPageDto = this.pageService.readPageVPD(rootPath + this.pageStorePath + path);
            List<Map<String, String>> eventList = componentPageDto.getEventsList();
            for (Map<String, String> event : eventList) {
                String eventInsKey = event.get("instanceKey");
                if (!componentPageDto.getInstances().containsKey(eventInsKey)) continue;
                List<EventConfigsDto> eventConfigsDtos = componentPageDto.getInstances().get(eventInsKey).getEventConfigs();
                for (EventConfigsDto eventConfig : eventConfigsDtos) {
                    List<EventConditionsDto> eventConditionsDtos = eventConfig.getConditions();
                    for (EventConditionsDto eventConditions : eventConditionsDtos) {
                        for (EventActionsDto eventActionsDto : eventConditions.getActions()) {
                            if (!"submit-form".equals(eventActionsDto.getHandler()) && !"delete-list".equals(eventActionsDto.getHandler()) && !"submit-flow-form".equals(eventActionsDto.getHandler()) || eventActionsDto.getParams().size() == 0) continue;
                            String formKey = eventActionsDto.getParams().get(0).get("value");
                            JSONObject relateTableJO = componentPageDto.getInstances().get(formKey).getDatas().getJSONObject("relateTable");
                            if (relateTableJO == null) continue;
                            List tableNames = new ArrayList();
                            if (!relateTableJO.containsKey((Object)"tableName") || (tableNames = relateTableJO.getJSONArray("tableName").toJavaList(String.class)).size() == 0) continue;
                            String tableName = (String)tableNames.get(0);
                            JSONArray tableFields = this.databaseInfoService.getTableFields("", tableName);
                            StringBuilder defaultFields = new StringBuilder();
                            String addStr = "";
                            String editStr = "";
                            for (Object obj : tableFields) {
                                Map fieldMap = (Map)obj;
                                if (!ToolUtil.isNotEmpty(fieldMap.get("relationFieldType"))) continue;
                                if ("createUserId".equals(fieldMap.get("relationFieldType")) || "createTime".equals(fieldMap.get("relationFieldType"))) {
                                    addStr = addStr + "\"" + (String)fieldMap.get("name") + "\":\"" + (String)fieldMap.get("relationFieldType") + "\",";
                                    continue;
                                }
                                if (!"updateUserId".equals(fieldMap.get("relationFieldType")) && !"updateTime".equals(fieldMap.get("relationFieldType"))) continue;
                                editStr = editStr + "\"" + (String)fieldMap.get("name") + "\":\"" + (String)fieldMap.get("relationFieldType") + "\",";
                            }
                            defaultFields.append("{");
                            if (ToolUtil.isNotEmpty((Object)addStr)) {
                                defaultFields.append("\"add\":{").append(addStr.substring(0, addStr.length() - 1)).append("}");
                            }
                            if (ToolUtil.isNotEmpty((Object)editStr)) {
                                if (ToolUtil.isNotEmpty((Object)addStr)) {
                                    defaultFields.append(",");
                                }
                                defaultFields.append("\"edit\":{").append(editStr.substring(0, editStr.length() - 1)).append("}");
                            }
                            defaultFields.append("}");
                            if (!ToolUtil.isNotEmpty((Object)tableName)) continue;
                            TableRelate tableRelate = new TableRelate();
                            tableRelate.setTableName(tableName);
                            tableRelate.setPagePath(path.replace(".vpd", "").concat("-" + formKey));
                            tableRelate.setMainTable(path.replace(".vpd", "").concat("_main"));
                            tableRelate.setDefaultField(defaultFields.toString());
                            this.tableRealteService.insertOrUpdate((Object)tableRelate);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new GenCodePreData();
    }

    @Override
    public FormDesignResponse<Map<String, Object>> publishWorkFlowListener(String xml, Page meta) throws Exception {
        JSONArray arr;
        JSONObject rootIns;
        JSONObject props;
        JSONObject jsonObject = JSONObject.parseObject((String)xml);
        String relativePath = meta.getPath();
        relativePath = ToolUtil.isEmpty((Object)relativePath) ? jsonObject.getString("flowIdentity").replace("-", "") : relativePath.replace("/", "\\").replace(".wfd", "");
        Object ob = jsonObject.get((Object)"instances");
        Map allMap = (Map)JSONObject.parseObject((String)ob.toString(), (TypeReference)new TypeReference<Map<String, JSONObject>>(){}, (Feature[])new Feature[0]);
        String rootInsId = jsonObject.getString("rootInstanceKey");
        JSONArray totalTodoArr = new JSONArray();
        if (ToolUtil.isNotEmpty((Object)rootInsId) && ToolUtil.isNotEmpty((Object)(props = (rootIns = (JSONObject)allMap.get(rootInsId)).getJSONObject("props"))) && ToolUtil.isNotEmpty((Object)(arr = props.getJSONArray("useVariables")))) {
            totalTodoArr = arr;
        }
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry entry : allMap.entrySet()) {
            JSONArray varArray;
            boolean isCommentOther;
            String currentKey = (String)entry.getKey();
            JSONObject currentValue = (JSONObject)entry.getValue();
            if (currentKey.contains("path") || currentKey.equals(rootInsId)) continue;
            JSONObject props2 = (JSONObject)currentValue.get((Object)"props");
            HashSet<Map<String, String>> importList = new HashSet<Map<String, String>>();
            HashSet<Map<String, String>> beanList = new HashSet<Map<String, String>>();
            HashSet<Map<String, String>> tableFieldList = new HashSet<Map<String, String>>();
            HashMap<String, String> comment = new HashMap<String, String>();
            HashMap<String, String> commentTime = new HashMap<String, String>();
            HashMap<String, String> auditor = new HashMap<String, String>();
            HashMap<String, String> auditorName = new HashMap<String, String>();
            String useTableComment = currentValue.getString("useTableComment");
            if (ToolUtil.isNotEmpty((Object)useTableComment) && (isCommentOther = Boolean.valueOf(useTableComment).booleanValue())) {
                JSONObject nodeCommentAuditorName;
                JSONObject nodeCommentAuditor;
                JSONObject nodeCommentTime;
                JSONObject nodeComment = currentValue.getJSONObject("tableFieldComment");
                if (ToolUtil.isNotEmpty((Object)nodeComment)) {
                    this.genWorkFlowPreInfo(this.getTableInfo(nodeComment), importList, beanList, tableFieldList, set, comment, PackageMapType.COMMENT.getType(), meta);
                }
                if (ToolUtil.isNotEmpty((Object)(nodeCommentTime = currentValue.getJSONObject("tableFieldCommentTime")))) {
                    this.genWorkFlowPreInfo(this.getTableInfo(nodeCommentTime), importList, beanList, tableFieldList, set, commentTime, PackageMapType.COMMENT_TIME.getType(), meta);
                }
                if (ToolUtil.isNotEmpty((Object)(nodeCommentAuditor = currentValue.getJSONObject("tableFieldCommentAuditor")))) {
                    this.genWorkFlowPreInfo(this.getTableInfo(nodeCommentAuditor), importList, beanList, tableFieldList, set, auditor, PackageMapType.AUDITOR.getType(), meta);
                }
                if (ToolUtil.isNotEmpty((Object)(nodeCommentAuditorName = currentValue.getJSONObject("tableFieldCommentAuditorName")))) {
                    this.genWorkFlowPreInfo(this.getTableInfo(nodeCommentAuditorName), importList, beanList, tableFieldList, set, auditorName, PackageMapType.AUDITOR_NAME.getType(), meta);
                }
            }
            if (ToolUtil.isNotEmpty((Object)(varArray = props2.getJSONArray("useVariables")))) {
                varArray.addAll((Collection)totalTodoArr);
                this.handleBusinessVar(varArray, importList, beanList, tableFieldList, set, meta);
            }
            if (tableFieldList.size() <= 0 && !ToolUtil.isNotEmpty(comment) && !ToolUtil.isNotEmpty(commentTime) && !ToolUtil.isNotEmpty(auditor) && !ToolUtil.isNotEmpty(auditorName)) continue;
            boolean isDynamic = this.designConfig.isDynamic();
            if (isDynamic) {
                EntityWrapper eW = new EntityWrapper();
                eW.eq("page_path", (Object)jsonObject.getString("flowIdentity").concat("-").concat(currentKey));
                TableRelate relate = (TableRelate)((Object)this.tableRealteService.selectOne((Wrapper)eW));
                TableRelate tableRelate = new TableRelate();
                tableRelate.setPagePath(jsonObject.getString("flowIdentity").concat("-").concat(currentKey));
                StringBuilder fieldSbd = new StringBuilder();
                for (Map map : tableFieldList) {
                    if (!ToolUtil.isNotEmpty(map.get("tableName"))) continue;
                    fieldSbd.append((String)map.get("tableName")).append(":").append((String)map.get("tableField")).append(";");
                }
                if (ToolUtil.isNotEmpty((Object)fieldSbd.toString())) {
                    tableRelate.setFlowField(fieldSbd.toString());
                }
                if (comment.size() != 0) {
                    tableRelate.setTableName((String)comment.get("tableName"));
                    tableRelate.setCommentMaps((String)comment.get("tableField"));
                }
                StringBuilder commentTimeSbd = new StringBuilder();
                if (commentTime.size() != 0) {
                    tableRelate.setTableName((String)commentTime.get("tableName"));
                    commentTimeSbd.append((String)commentTime.get("tableField")).append(":").append((String)commentTime.get("fieldType"));
                    tableRelate.setCommentTime(commentTimeSbd.toString());
                }
                if (auditor.size() != 0) {
                    tableRelate.setTableName((String)auditor.get("tableName"));
                    tableRelate.setAuditor((String)auditor.get("tableField"));
                }
                if (auditorName.size() != 0) {
                    tableRelate.setTableName((String)auditorName.get("tableName"));
                    tableRelate.setAuditorName((String)auditorName.get("tableField"));
                }
                if (relate != null) {
                    this.tableRealteService.update((Object)tableRelate, (Wrapper)eW);
                    continue;
                }
                this.tableRealteService.insert((Object)tableRelate);
                continue;
            }
            this.genWorkFlowListener(relativePath.toLowerCase(), StringUtils.capitalize((String)StringUtils.underlineToCamel((String)currentKey)), importList, beanList, tableFieldList, comment, commentTime, auditor, auditorName);
        }
        return null;
    }

    private void genWorkFlowPreInfo(Map<String, String> tableInfoMap, Set<Map<String, String>> importList, Set<Map<String, String>> beanList, Set<Map<String, String>> tableFieldList, Set<String> set, Map<String, String> single, String isComment, Page meta) throws Exception {
        String tableName = tableInfoMap.get("tableName");
        String path = tableInfoMap.get("path");
        String field = tableInfoMap.get("fieldName");
        GenCodePreData genCodePreData = new GenCodePreData();
        ArrayList<TableDto> tableDtos = new ArrayList<TableDto>();
        TableDto tableDto = new TableDto();
        tableDto.setName(tableName);
        tableDto.setTablePath(path);
        tableDtos.add(tableDto);
        HashMap<String, TableInfo> list = new HashMap<String, TableInfo>();
        TableInfo tableInfo = this.getTableInfo(tableDto, meta);
        String pPath = tableDto.getTablePath().replace(".dbd", "");
        tableInfo.setParentTablePath(pPath.substring(0, pPath.lastIndexOf("/")).toLowerCase().replace("/", "\\"));
        list.put(tableInfo.getName(), tableInfo);
        genCodePreData.setTableInfos(list);
        genCodePreData.setModuleName(tableName.replace(".dbd", "").replace("/", "."));
        genCodePreData.setModulePath(path.replace("/" + tableName, ""));
        genCodePreData.setTableDtos(tableDtos);
        genCodePreData.setProPackage(meta.getProPackagePath());
        boolean isDynamic = this.designConfig.isDynamic();
        HashMap<String, String> importMap = new HashMap<String, String>();
        HashMap<String, String> beanMap = new HashMap<String, String>();
        HashMap<String, String> tableFieldMap = new HashMap<String, String>();
        String serviceName = genCodePreData.getTableInfos().get(tableName).getServiceName();
        String serviceLowerName = StringUtils.firstCharToLower((String)genCodePreData.getTableInfos().get(tableName).getServiceName());
        String modalName = genCodePreData.getTableInfos().get(tableName).getEntityName();
        String modalLowerName = genCodePreData.getTableInfos().get(tableName).getEnName();
        String entityPath = (String)genCodePreData.getTableInfos().get(tableName).getPackageInfo().get("Entity");
        String key = genCodePreData.getTableInfos().get(tableName).getPrimaryKeyFirstToUpper();
        String capitalName = GenPreDataUtil.getCapitalName(field);
        if (PackageMapType.COMMENT.getType().equals(isComment)) {
            single.put("tableField", field);
            single.put("tableFieldCapitalize", capitalName);
            single.put("serviceLowerName", serviceLowerName);
            if (isDynamic) {
                single.put("tableName", tableName);
            }
        } else if (PackageMapType.BUSINESS_VAR.getType().equals(isComment)) {
            tableFieldMap.put("tableField", field);
            tableFieldMap.put("tableFieldCapitalize", capitalName);
            tableFieldMap.put("serviceLowerName", serviceLowerName);
            tableFieldMap.put("tableName", tableName);
        } else if (PackageMapType.COMMENT_TIME.getType().equals(isComment) || PackageMapType.AUDITOR.getType().equals(isComment) || PackageMapType.AUDITOR_NAME.getType().equals(isComment)) {
            single.put("tableField", field);
            single.put("tableFieldCapitalize", capitalName);
            single.put("serviceLowerName", serviceLowerName);
            single.put("entityName", modalName);
            single.put("entityLowerName", modalLowerName);
            single.put("entityPath", entityPath);
            single.put("key", key);
            if (isDynamic) {
                single.put("tableName", tableName);
            }
            List tableFields = genCodePreData.getTableInfos().get(tableName).getFields();
            TableField tableField = new TableField();
            for (TableField t : tableFields) {
                if (!field.equals(t.getPropertyName())) continue;
                tableField = t;
            }
            single.put("fieldType", tableField.getPropertyCap());
        }
        importMap.put("serviceName", serviceName);
        importMap.put("servicePackagePath", (String)genCodePreData.getTableInfos().get(tableName).getPackageInfo().get("Service"));
        beanMap.put("serviceName", serviceName);
        beanMap.put("serviceLowerName", serviceLowerName);
        importList.add(importMap);
        beanList.add(beanMap);
        if (ToolUtil.isNotEmpty(tableFieldMap.get("tableField"))) {
            tableFieldList.add(tableFieldMap);
        }
        if (!set.contains(tableName)) {
            this.genMvcCode(genCodePreData, tableInfo);
        }
        set.add(tableName);
    }

    private GenCodePreData preHandler(String path, String rootPath) throws GodAxeException {
        try {
            TableInfo tableInfo;
            ComponentPageDto componentPageDto = this.pageService.readPageVPD(rootPath + this.pageStorePath + path);
            HashSet<String> set = new HashSet<String>();
            Map<String, ComponentDto> instances = componentPageDto.getInstances();
            boolean isFormCheck = false;
            boolean isCustomRule = false;
            boolean isAddTreeSelect = false;
            Date date = new Date();
            HashMap<String, String> autoDataConfigs = new HashMap<String, String>();
            HashSet autoDataTableSet = new HashSet();
            for (Map.Entry<String, ComponentDto> map : instances.entrySet()) {
                JSONObject dataS;
                ComponentDto currentComponentDto = map.getValue();
                if (ToolUtil.isNotEmpty(currentComponentDto.getProps())) {
                    Map customRule;
                    if (currentComponentDto.getProps().containsKey("customRule") && ToolUtil.isNotEmpty((Object)currentComponentDto.getProps().get("customRule")) && Boolean.valueOf((customRule = (Map)currentComponentDto.getProps().get("customRule")).get("isCustomRule").toString()).booleanValue()) {
                        isCustomRule = true;
                    }
                    if (currentComponentDto.getProps().containsKey("checkedType") && ToolUtil.isNotEmpty((Object)currentComponentDto.getProps().get("checkedType"))) {
                        isFormCheck = true;
                    }
                    if (currentComponentDto.getProps().containsKey("isChecked") && ToolUtil.isNotEmpty((Object)currentComponentDto.getProps().get("isChecked"))) {
                        List checked = (List)currentComponentDto.getProps().get("isChecked");
                        for (Map check : checked) {
                            if (!Boolean.valueOf(String.valueOf(check.get("checked"))).booleanValue()) continue;
                            isFormCheck = true;
                        }
                    }
                }
                if (ToolUtil.isNotEmpty((Object)(dataS = currentComponentDto.getDatas()))) {
                    String type;
                    JSONObject objectRelateTable;
                    if ("layForm".equals(currentComponentDto.getName()) || "layTable".equals(currentComponentDto.getName()) || "layTree".equals(currentComponentDto.getName())) {
                        Map fieldsRelate;
                        if (dataS.containsKey((Object)"autoDataRelate")) {
                            String type2 = dataS.getJSONObject("autoDataRelate").getString("relateType");
                            if ("table".equals(type2)) {
                                autoDataTableSet.addAll(dataS.getJSONObject("autoDataRelate").getJSONArray("tableName").toJavaList(String.class));
                            }
                            this.handleAutoData(autoDataConfigs, dataS, currentComponentDto, path);
                        }
                        if (ToolUtil.isNotEmpty((Object)(objectRelateTable = dataS.getJSONObject("relateTable")))) {
                            type = objectRelateTable.getString("relateType");
                            if ("table".equals(type)) {
                                set.addAll(objectRelateTable.getJSONArray("tableName").toJavaList(String.class));
                            }
                            this.addTableOrView(type, set);
                        }
                        if (ToolUtil.isNotEmpty((Object)(fieldsRelate = (Map)dataS.getObject("fieldsRelate", (TypeReference)new TypeReference<Map<String, JSONObject>>(){})))) {
                            for (JSONObject fieldMap : fieldsRelate.values()) {
                                String type3 = fieldMap.getString("relateType");
                                if ("table".equals(type3)) {
                                    set.add(fieldMap.getJSONObject("relateTable").getString("tableName"));
                                }
                                this.addTableOrView(type3, set);
                            }
                        }
                    } else {
                        objectRelateTable = dataS.getJSONObject("relateTable");
                        if (ToolUtil.isNotEmpty((Object)objectRelateTable)) {
                            type = objectRelateTable.getString("relateType");
                            if ("table".equals(type)) {
                                set.add(objectRelateTable.getString("tableName"));
                            }
                            this.addTableOrView(type, set);
                        }
                    }
                }
                if (!"layTreeSelect".equals(currentComponentDto.getName())) continue;
                isAddTreeSelect = true;
            }
            ArrayList<TableDto> list = new ArrayList<TableDto>();
            PublishTableModel dataBaseInfo = this.databaseInfoService.getAllDatabaseInfoPath();
            Page page = componentPageDto.getPage();
            String vpdPath = page.getPath();
            String modulePath = page.getParentPath();
            String pagePath = "";
            if (vpdPath != null) {
                pagePath = vpdPath.replace(".vpd", "");
            }
            for (Map.Entry<String, TableTreeNode> tableTreeNodeEntry : dataBaseInfo.getTableInfo().entrySet()) {
                TableTreeNode tableTreeNode = tableTreeNodeEntry.getValue();
                Iterator<Object> tableDto = new TableDto();
                ((TableDto)((Object)tableDto)).setName(tableTreeNode.getName());
                ((TableDto)((Object)tableDto)).setTablePath(tableTreeNode.getPath());
                if (ToolUtil.isNotEmpty(dataBaseInfo.getMidTables()) && ToolUtil.isNotEmpty((Object)dataBaseInfo.getMidTables().get(tableTreeNode.getName()))) {
                    ((TableDto)((Object)tableDto)).setMidTable(true);
                }
                list.add((TableDto)((Object)tableDto));
            }
            Map<String, TableInfo> tableInfos = this.getTableInfos(list, page.getProPackagePath(), pagePath, page.getParentPath(), dataBaseInfo);
            HashMap<String, TableInfo> needTables = new HashMap<String, TableInfo>();
            HashSet<String> childTableInfo = new HashSet<String>();
            for (String string : autoDataTableSet) {
                tableInfo = tableInfos.get(string);
                if (ToolUtil.isEmpty((Object)tableInfo)) {
                    throw new GodAxeException(GodAxeExceptionType.TABLE_INFO_NOT_FOUND, string);
                }
                tableInfo.setAutoDataTable(true);
                needTables.put(string, tableInfo);
            }
            for (String string : set) {
                List<String> childTables;
                tableInfo = tableInfos.get(string);
                if (ToolUtil.isEmpty((Object)tableInfo)) {
                    throw new GodAxeException(GodAxeExceptionType.TABLE_INFO_NOT_FOUND, string);
                }
                needTables.put(string, tableInfo);
                Map<String, List<String>> mainRelateTableInfo = dataBaseInfo.getMainRelateTableInfo();
                if (ToolUtil.isNotEmpty(mainRelateTableInfo) && ToolUtil.isNotEmpty(childTables = mainRelateTableInfo.get(string))) {
                    for (String child : childTables) {
                        TableInfo childInfo = tableInfos.get(child);
                        GodTableData godTableData = (GodTableData)JSON.parseObject((String)dataBaseInfo.getTableInfo().get(child).getData(), GodTableData.class);
                        DelRelateInfo delRelateInfo = new DelRelateInfo();
                        boolean flag = false;
                        for (GodTableField godTableField : godTableData.getTable().getFields()) {
                            flag = godTableField.isRelateDelete();
                            if (flag && ToolUtil.isNotEmpty((Object)godTableField.getRelationTableName()) && ToolUtil.isNotEmpty((Object)godTableField.getRelationship()) && godTableField.getRelationTableName().equals(string)) {
                                delRelateInfo.setRelateIService(childInfo.getServiceName());
                                delRelateInfo.setRelateService(StringUtils.firstCharToLower((String)childInfo.getEntityName()) + "Service");
                                delRelateInfo.setRelateEntity(childInfo.getEntityName());
                                delRelateInfo.setRelateServicePath((page.getProPackagePath() + StringUtils.underlineToCamel((String)tableInfo.getParentTablePath()).toLowerCase() + "\\service\\" + tableInfo.getServiceName()).replace("\\", ".").replace("..", "."));
                                delRelateInfo.setMainRelateField(GenPreDataUtil.getCapitalName(godTableField.getRelationship().toString()));
                                delRelateInfo.setRelateField(GenPreDataUtil.getCapitalName(godTableField.getName()));
                                delRelateInfo.setRelateBaseField(godTableField.getRealName());
                                delRelateInfo.setChildTableInfo(childInfo);
                            }
                            if (!flag) continue;
                            tableInfo.addDelReInfo(delRelateInfo);
                            childTableInfo.add(child);
                        }
                    }
                }
                Map<String, String> logicalInfo = dataBaseInfo.getLogicalInfo();
                this.handleLogical(tableInfo, string, logicalInfo);
            }
            for (String string : childTableInfo) {
                if (set.contains(string)) continue;
                tableInfo = tableInfos.get(string);
                if (ToolUtil.isEmpty((Object)tableInfo)) {
                    throw new GodAxeException(GodAxeExceptionType.TABLE_INFO_NOT_FOUND, string);
                }
                Map<String, String> logicalInfo = dataBaseInfo.getLogicalInfo();
                this.handleLogical(tableInfo, string, logicalInfo);
                needTables.put(string, tableInfo);
            }
            if (ToolUtil.isNotEmpty(dataBaseInfo.getMidTables())) {
                for (Map.Entry entry : dataBaseInfo.getMidTables().entrySet()) {
                    needTables.put((String)entry.getKey(), tableInfos.get(entry.getKey()));
                }
            }
            GenCodePreData genCodePreData = new GenCodePreData();
            genCodePreData.setTableInfos(needTables);
            genCodePreData.setModuleName(modulePath.replace(".dbd", "").replace("/", "."));
            genCodePreData.setModulePath(modulePath);
            genCodePreData.setPageName(page.getName());
            genCodePreData.setTableDtos(list);
            genCodePreData.setProPackage(page.getProPackagePath());
            genCodePreData.setTablesData(dataBaseInfo.getTableInfo());
            genCodePreData.setCustomRule(isCustomRule);
            genCodePreData.setFormCheck(isFormCheck);
            genCodePreData.setAddTreeSelect(isAddTreeSelect);
            if (ToolUtil.isNotEmpty(autoDataConfigs)) {
                genCodePreData.setAutoDataConfigs(autoDataConfigs);
            }
            return genCodePreData;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new GenCodePreData();
        }
    }

    private void handleLogical(TableInfo tableInfo, String tableName, Map<String, String> logicalInfo) {
        String field;
        if (ToolUtil.isNotEmpty(logicalInfo) && ToolUtil.isNotEmpty((Object)(field = logicalInfo.get(tableName)))) {
            LogicalDeletionInfo logicalDeletionInfo = new LogicalDeletionInfo();
            logicalDeletionInfo.setCapitalName(tableInfo.getFieldCapitalName(field));
            logicalDeletionInfo.setBaseName(tableInfo.getFieldBaseName(field));
            logicalDeletionInfo.setLogicalDelete(true);
            tableInfo.setLogicalDeletionInfo(logicalDeletionInfo);
        }
    }

    private TableInfo getTableInfo(TableDto tableDto, Page meta) throws IOException, GodAxeException {
        PublishTableModel dataBaseInfo = this.databaseInfoService.getAllDatabaseInfoPath();
        ArrayList<TableDto> tableDtos = new ArrayList<TableDto>();
        tableDtos.add(tableDto);
        Map<String, TableInfo> tableInfos = this.getTableInfos(tableDtos, meta.getProPackagePath(), this.pagePath, meta.getParentPath(), dataBaseInfo);
        return tableInfos.get(tableDto.getName());
    }

    private Map<String, TableInfo> getTableInfos(List<TableDto> list, String proPackage, String pagePath, String preFixPath, PublishTableModel publishTableModel) throws GodAxeException {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setDriverName(this.druidProperties.getDriverClassName());
        HashMap<String, TableInfo> tableInfos = new HashMap<String, TableInfo>();
        for (TableDto tableDto : list) {
            TableTreeNode tableTreeNode;
            String tableName = tableDto.getName();
            Map<String, TableTreeNode> tableTreeNodes = publishTableModel.getTableInfo();
            TableTreeNode tableTreeNodeGod = tableTreeNodes.get(tableName);
            if (ToolUtil.isEmpty((Object)tableDto.getTablePath()) || ToolUtil.isEmpty((Object)tableTreeNodes.get(tableName))) {
                throw new GodAxeException(GodAxeExceptionType.TABLE_INFO_NOT_FOUND, tableName);
            }
            GodTableData godTableData = (GodTableData)JSON.parseObject((String)tableTreeNodeGod.getData(), GodTableData.class);
            TableInfo tableInfo = new TableInfo();
            tableInfo.setConvert(true);
            tableInfo.setName(tableName);
            tableInfo.setComment(godTableData.getTable().getComment());
            tableInfo.setEntityName(new StrategyConfig(), NamingStrategy.capitalFirst((String)this.processName(tableInfo.getName(), NamingStrategy.underline_to_camel, null)));
            tableInfo.setMapperName(tableInfo.getEntityName() + "Mapper");
            tableInfo.setXmlName(tableInfo.getEntityName() + "Mapper");
            tableInfo.setServiceName("I" + tableInfo.getEntityName() + "Service");
            tableInfo.setServiceImplName(tableInfo.getEntityName() + "ServiceImpl");
            tableInfo.setControllerName(tableInfo.getEntityName() + "Controller");
            tableInfo.setModuleName(tableDto.getTablePath().replace(".dbd", "").replace("/", "."));
            tableInfo.setTablePath(tableDto.getTablePath());
            String pPath = tableDto.getTablePath().replace(".dbd", "");
            tableInfo.setParentTablePath(pPath.substring(0, pPath.lastIndexOf("/")).toLowerCase().replace("/", "\\"));
            List<GodTableField> godTableFields = godTableData.getTable().getFields();
            ArrayList<TableField> tableFields = new ArrayList<TableField>();
            for (GodTableField godTableField : godTableFields) {
                TableField tableField2 = new TableField();
                String key = godTableField.getPrimarys();
                if (ToolUtil.isNotEmpty((Object)key) && key.toUpperCase().equals("PRI")) {
                    tableField2.setKeyFlag(true);
                    tableField2.setKeyIdentityFlag(false);
                }
                tableField2.setConvert(true);
                tableField2.setName(godTableField.getRealName());
                if (ToolUtil.isEmpty((Object)godTableField.getRealName())) {
                    throw new GodAxeException(GodAxeExceptionType.TABLE_INFO_NEED_REFER, tableName);
                }
                tableField2.setPropertyName(new StrategyConfig(), godTableField.getName());
                tableField2.setComment(godTableField.getComment());
                tableField2.setFill(null);
                tableField2.setType(godTableField.getType());
                tableField2.setColumnType(dataSourceConfig.getTypeConvert().processTypeConvert(godTableField.getType()));
                tableFields.add(tableField2);
            }
            tableInfo.setFields(tableFields);
            tableInfo.setImportPackages(Model.class.getCanonicalName());
            tableInfo.setImportPackages(TableName.class.getCanonicalName());
            tableInfo.setImportPackages(Serializable.class.getCanonicalName());
            Map<String, String> packageInfo = this.getPackageInfo(proPackage, tableInfo);
            tableInfo.setPackageInfo(packageInfo);
            Map<String, List<String>> relationRes = this.getGodFieldType(godTableFields);
            if (ToolUtil.isNotEmpty(relationRes)) {
                if (relationRes.get("add").size() != 0) {
                    tableInfo.setAddFieldType(relationRes.get("add"));
                } else {
                    tableInfo.setAddFieldType(null);
                }
                if (relationRes.get("edit").size() != 0) {
                    tableInfo.setEditFieldType(relationRes.get("edit"));
                } else {
                    tableInfo.setEditFieldType(null);
                }
                List<String> arr = relationRes.get("auditNode");
                if (arr.size() > 0) {
                    tableInfo.setAuditNode(arr.get(0));
                }
            }
            if (ToolUtil.isNotEmpty((Object)(tableTreeNode = publishTableModel.getTableInfo().get(tableDto.getName()))) && tableTreeNode.isImportAndExportTable()) {
                String arr = ((JSONObject)JSON.parseObject((String)tableTreeNode.getData(), JSONObject.class)).getJSONObject("table").getString("fields");
                List fields = JSONObject.parseArray((String)arr, GodTableField.class);
                HashMap<String, Integer> dicColumnIndex = new HashMap<String, Integer>();
                int index = 0;
                for (GodTableField field : fields) {
                    if (!field.isImportAndExport()) continue;
                    dicColumnIndex.put(field.getName(), index);
                    ++index;
                }
                tableInfo.getExcelInfo().setDicColumnIndex(dicColumnIndex);
                tableInfo.getFields().forEach(tableField -> {
                    for (GodTableField godTableField : fields) {
                        if (!tableField.getPropertyName().equals(godTableField.getName())) continue;
                        tableField.setExportOrNot(godTableField.isImportAndExport());
                        if (godTableField.isImportAndExportRepeat() || !godTableField.isImportAndExport()) continue;
                        tableInfo.getExcelInfo().addNotRepeatFields(tableField);
                        if (!ToolUtil.isEmpty((Object)tableInfo.getExcelInfo().getTableInfo())) continue;
                        tableInfo.getExcelInfo().setTableInfo(tableInfo);
                    }
                });
                tableInfo.setExportOrNot(tableTreeNode.isImportAndExportTable());
            }
            HashMap<String, Boolean> tableMethodControl = new HashMap<String, Boolean>();
            tableMethodControl.put("isDeleteFlow", false);
            tableMethodControl.put("isListDelete", false);
            tableMethodControl.put("isExportData", false);
            tableMethodControl.put("isExportDataEntity", false);
            tableMethodControl.put("isExportTemplate", false);
            tableMethodControl.put("isImportData", false);
            tableMethodControl.put("isSearchExportData", false);
            tableInfo.setTableMethodControl(tableMethodControl);
            if (tableDto.isMidTable()) {
                tableInfo.setMidTable(true);
            }
            tableInfos.put(tableDto.getName(), tableInfo);
            String mappingBase = pagePath + "/" + StringUtils.underlineToCamel((String)tableDto.getName()) + "/";
            String mapping = preFixPath + "/" + StringUtils.underlineToCamel((String)tableDto.getName());
            FormCrudUrl formCrudUrl = new FormCrudUrl();
            formCrudUrl.setDelete(mappingBase + "delete");
            formCrudUrl.setDetail(mappingBase + "detail");
            formCrudUrl.setRetrieve(mappingBase + "list");
            formCrudUrl.setUpdate(mappingBase + "update");
            formCrudUrl.setView(mappingBase + "view");
            formCrudUrl.setEditView(mapping + "_update");
            formCrudUrl.setPagePath(pagePath);
            tableDto.setFormCrudUrl(formCrudUrl);
            tableDto.setFields(tableInfo.getFields());
            tableDto.setTableInfo(tableInfo);
        }
        return tableInfos;
    }

    private void tableOpera(String tableName, FormDesignGeneratorConfig webGeneratorConfig) {
        JSONArray dbdTableFields = this.databaseInfoService.getTableFields("", tableName);
        SqlConfig sqlConfig = new SqlConfig();
        if (!webGeneratorConfig.isTableExist(tableName)) {
            webGeneratorConfig.createTable(dbdTableFields, tableName);
        } else {
            ArrayList dbdTableFieldNames = new ArrayList();
            for (Object obj : dbdTableFields) {
                Map thisField = (Map)obj;
                dbdTableFieldNames.add(thisField.get("name"));
            }
            webGeneratorConfig.doMpGeneration();
            List oldTableField = webGeneratorConfig.getTableInfo().getFields();
            ArrayList<String> oldTableFieldNames = new ArrayList<String>();
            for (Object tableField : oldTableField) {
                oldTableFieldNames.add(tableField.getPropertyName());
            }
            StringBuilder addSqlStr = new StringBuilder();
            for (Object obj : dbdTableFields) {
                Map thisField = (Map)obj;
                if (oldTableFieldNames.contains(thisField.get("name"))) continue;
                String fieldName = StringUtils.camelToUnderline((String)((String)thisField.get("name")));
                addSqlStr.append(fieldName).append(" ").append((String)thisField.get("type")).append(" ").append("null ").append("comment '").append((String)thisField.get("comment")).append("',");
            }
            StringBuilder addFinalSql = new StringBuilder();
            if (ToolUtil.isNotEmpty((Object)addSqlStr.toString())) {
                addFinalSql.append("alter table ").append(tableName).append(" add (").append(addSqlStr.substring(0, addSqlStr.length() - 1)).append(");");
                webGeneratorConfig.addTableField(addFinalSql.toString());
            }
            String delSqlStr = "";
            String delFinalSql = "";
            for (String fieldName : oldTableFieldNames) {
                if (dbdTableFieldNames.contains(fieldName)) continue;
                fieldName = StringUtils.camelToUnderline((String)fieldName);
                delSqlStr = delSqlStr + "DROP COLUMN " + fieldName + ",";
            }
            if (ToolUtil.isNotEmpty((Object)delSqlStr)) {
                delFinalSql = delFinalSql + "alter table " + tableName + " " + delSqlStr.substring(0, delSqlStr.length() - 1);
                webGeneratorConfig.delTableField(delFinalSql);
            }
        }
    }

    private Map<String, String> getPackageInfo(String proPackage, TableInfo tableInfo) {
        HashMap<String, String> packageInfo = new HashMap<String, String>();
        String moduleName = tableInfo.getModuleName().replace(".", "/");
        String parentWithTableModule = proPackage + moduleName.substring(0, moduleName.lastIndexOf("/")).toLowerCase().replace("/", ".");
        packageInfo.put("Entity", this.joinPackage(parentWithTableModule, this.entityInfo()));
        packageInfo.put("Mapper", this.joinPackage(parentWithTableModule, this.mapperInfo()));
        packageInfo.put("Service", this.joinPackage(parentWithTableModule, this.serviceInfo()));
        packageInfo.put("ServiceImpl", this.joinPackage(parentWithTableModule, this.serviceImplInfo()));
        return packageInfo;
    }

    private GenCodeResult publishFrontCode(String path, String projectPath, GenCodePreData genCodePreData) throws Exception {
        GenCodeResult genCodeResult = new GenCodeResult();
        genCodeResult = this.service.generateCode(path, this.pagePath, projectPath, genCodePreData);
        return genCodeResult;
    }

    private List<GenCodeResult> publishBackCode(GenCodePreData genCodePreData) throws Exception {
        ArrayList<GenCodeResult> genCodeResults = new ArrayList<GenCodeResult>();
        for (Map.Entry<String, TableInfo> map : genCodePreData.getTableInfos().entrySet()) {
            TableInfo tableInfo = map.getValue();
            if (tableInfo.isMidTable() && !tableInfo.isUseMidTable() || tableInfo.isAutoDataTable()) continue;
            List<GenCodeResult> genMvcResults = this.genMvcCode(genCodePreData, tableInfo);
            genCodeResults.addAll(genMvcResults);
        }
        genCodeResults.add(this.genControllerCode(genCodePreData));
        genCodeResults.addAll(this.genOtherCode(genCodePreData));
        return genCodeResults;
    }

    private List<GenCodeResult> genMvcCode(GenCodePreData genCodePreData, TableInfo tableInfo) throws Exception {
        ArrayList<GenCodeResult> genMvcResults = new ArrayList<GenCodeResult>();
        GenCodeResult genEntityResult = this.genEntityCode(genCodePreData, tableInfo);
        genMvcResults.add(genEntityResult);
        GenCodeResult genXmlCodeResult = this.genXmlCode(genCodePreData, tableInfo);
        genMvcResults.add(genXmlCodeResult);
        GenCodeResult genMapperResult = this.genMapperCode(genCodePreData, tableInfo);
        genMvcResults.add(genMapperResult);
        GenCodeResult genServiceImplResult = this.genServiceImplCode(genCodePreData, tableInfo);
        genMvcResults.add(genServiceImplResult);
        GenCodeResult genServiceResult = this.genServiceCode(genCodePreData, tableInfo);
        genMvcResults.add(genServiceResult);
        return genMvcResults;
    }

    private GenCodeResult genControllerCode(GenCodePreData genCodePreData) throws Exception {
        GenControllerCode genControllerCode = new GenControllerCode();
        genControllerCode.setModuleName(genCodePreData.getModuleName());
        genControllerCode.setModulePath(genCodePreData.getModulePath());
        genControllerCode.setProjectPath(this.projectPath);
        genControllerCode.setTableInfoList(new ArrayList<TableInfo>(genCodePreData.getTableInfos().values()));
        genControllerCode.setProPackage(genCodePreData.getProPackage().toLowerCase());
        genControllerCode.setPageName(genCodePreData.getPageName());
        genControllerCode.setPageDesc(genCodePreData.getPageDesc());
        String pagePath = genCodePreData.getModulePath() + genCodePreData.getPageName();
        genControllerCode.setPagePath(pagePath.replace("/", ""));
        genControllerCode.setJsTreeConfigs(genCodePreData.getJsTreeConfigs());
        genControllerCode.setSelectConfigs(genCodePreData.getSelectConfigs());
        genControllerCode.setRequestDataList(genCodePreData.getRequestDataList());
        genControllerCode.setWorkFlow(genCodePreData.getWorkFlowKeyWithTable());
        genControllerCode.setWorkFlowControl(genCodePreData.getWorkFlowControl());
        genControllerCode.setAutoData(genCodePreData.getAutoDataConfigs());
        return genControllerCode.genCode();
    }

    private GenCodeResult genServiceCode(GenCodePreData genCodePreData, TableInfo tableInfo) throws Exception {
        GenServiceCode genServiceCode = new GenServiceCode();
        genServiceCode.setModuleName(genCodePreData.getModuleName());
        genServiceCode.setModulePath(genCodePreData.getModulePath());
        genServiceCode.setAutoDataConfig(genCodePreData.getAutoDataConfigs());
        String pagePath = genCodePreData.getModulePath() + genCodePreData.getPageName();
        genServiceCode.setPagePath(pagePath.replace("/", ""));
        genServiceCode.setProjectPath(this.projectPath);
        genServiceCode.setTableInfo(tableInfo);
        genServiceCode.setProPackage(genCodePreData.getProPackage().toLowerCase());
        genServiceCode.setPageName(genCodePreData.getPageName());
        genServiceCode.setWorkFlowControl(genCodePreData.getWorkFlowControl());
        boolean workFlowMap = false;
        for (String tableName : genCodePreData.getWorkFlowKeyWithTable()) {
            workFlowMap = tableName.equals(tableInfo.getName());
        }
        genServiceCode.setWorkFlow(workFlowMap);
        return genServiceCode.genCode();
    }

    private GenCodeResult genServiceImplCode(GenCodePreData genCodePreData, TableInfo tableInfo) throws Exception {
        GenServiceImplCode genServiceImplCode = new GenServiceImplCode();
        genServiceImplCode.setTableInfo(tableInfo);
        genServiceImplCode.setProjectPath(this.projectPath);
        genServiceImplCode.setAutoDataConfig(genCodePreData.getAutoDataConfigs());
        String pagePath = genCodePreData.getModulePath() + genCodePreData.getPageName();
        genServiceImplCode.setPagePath(pagePath.replace("/", ""));
        genServiceImplCode.setProPackage(genCodePreData.getProPackage().toLowerCase());
        genServiceImplCode.setWorkFlowControl(genCodePreData.getWorkFlowControl());
        boolean workFlowMap = false;
        for (String tableName : genCodePreData.getWorkFlowKeyWithTable()) {
            workFlowMap = tableName.equals(tableInfo.getName());
        }
        genServiceImplCode.setWorkFlow(workFlowMap);
        return genServiceImplCode.genCode();
    }

    private GenCodeResult genEntityCode(GenCodePreData genCodePreData, TableInfo tableInfo) throws Exception {
        GenEntityCode genEntityCode = new GenEntityCode();
        genEntityCode.setTableInfo(tableInfo);
        genEntityCode.setProjectPath(this.projectPath);
        String pagePath = genCodePreData.getModulePath() + genCodePreData.getPageName();
        genEntityCode.setPagePath(pagePath.replace("/", ""));
        genEntityCode.setProPackage(genCodePreData.getProPackage().toLowerCase());
        return genEntityCode.genCode();
    }

    private GenCodeResult genMapperCode(GenCodePreData genCodePreData, TableInfo tableInfo) throws Exception {
        GenMapperCode genMapperCode = new GenMapperCode();
        genMapperCode.setTableInfo(tableInfo);
        genMapperCode.setProjectPath(this.projectPath);
        genMapperCode.setAutoDataConfig(genCodePreData.getAutoDataConfigs());
        String pagePath = genCodePreData.getModulePath() + genCodePreData.getPageName();
        genMapperCode.setPagePath(pagePath.replace("/", ""));
        genMapperCode.setProPackage(genCodePreData.getProPackage().toLowerCase());
        return genMapperCode.genCode();
    }

    private GenCodeResult genXmlCode(GenCodePreData genCodePreData, TableInfo tableInfo) throws Exception {
        GenMapperXmlCode genMapperXmlCode = new GenMapperXmlCode();
        genMapperXmlCode.setTableInfo(tableInfo);
        genMapperXmlCode.setProjectPath(this.projectPath);
        genMapperXmlCode.setProPackage(genCodePreData.getProPackage().toLowerCase());
        genMapperXmlCode.setAutoDataConfig(genCodePreData.getAutoDataConfigs());
        String pagePath = genCodePreData.getModulePath() + genCodePreData.getPageName();
        genMapperXmlCode.setPagePath(pagePath.replace("/", ""));
        return genMapperXmlCode.genCode();
    }

    private void genWorkFlowListener(String packageName, String className, Set<Map<String, String>> maps, Set<Map<String, String>> beans, Set<Map<String, String>> fields, Map<String, String> comment, Map<String, String> commentTime, Map<String, String> auditor, Map<String, String> auditorName) {
        GenWorkFlowListener genWorkFlowListener = new GenWorkFlowListener();
        genWorkFlowListener.setProjectPath(this.projectPath);
        genWorkFlowListener.setPackageName(packageName);
        genWorkFlowListener.setClassName(className);
        genWorkFlowListener.genCode(maps, beans, fields, comment, commentTime, auditor, auditorName);
    }

    private List<GenCodeResult> genOtherCode(GenCodePreData genCodePreData) throws Exception {
        ArrayList<GenCodeResult> genCodeResults = new ArrayList<GenCodeResult>();
        if (ToolUtil.isNotEmpty(genCodePreData.getExcelConverters())) {
            for (ExcelConverterTem excelConverterTem : genCodePreData.getExcelConverters()) {
                GenExcelConverterCode genExcelConverterCode = new GenExcelConverterCode();
                genExcelConverterCode.setModulePath(genCodePreData.getModulePath());
                genExcelConverterCode.setProjectPath(this.projectPath);
                genExcelConverterCode.setJavaName(excelConverterTem.getJavaName());
                genExcelConverterCode.setConverterType(excelConverterTem.getConverterType());
                genExcelConverterCode.setProPackage(genCodePreData.getProPackage().toLowerCase());
                genExcelConverterCode.setDictType(excelConverterTem.getDictValue());
                genCodeResults.add(genExcelConverterCode.genCode());
            }
        }
        return genCodeResults;
    }

    private Map<String, String> getTableInfo(JSONObject tableObject) {
        HashMap<String, String> map = new HashMap<String, String>();
        String tableName = tableObject.getString("tableName");
        map.put("tableName", tableName);
        String path = tableObject.getString("path");
        map.put("path", path);
        String field = tableObject.getString("fieldName");
        map.put("fieldName", field);
        return map;
    }

    private Map<String, String> getTableInfoDif(JSONObject tableObject) {
        HashMap<String, String> map = new HashMap<String, String>();
        String tableName = tableObject.getString("name");
        map.put("tableName", tableName);
        String path = tableObject.getString("path").replace(".dbd", "");
        map.put("path", path);
        String field = tableObject.getString("field");
        map.put("fieldName", field);
        return map;
    }

    private void handleAutoData(Map<String, String> autoDataConfigs, JSONObject datas, ComponentDto currentDto, String path) {
        JSONObject autoRelateData = datas.getJSONObject("autoDataRelate");
        if (ToolUtil.isNotEmpty((Object)autoRelateData.getJSONArray("tableName"))) {
            String tableName = autoRelateData.getJSONArray("tableName").get(0).toString();
            autoDataConfigs.put("requestMapping", "/" + tableName + "/autoData/" + currentDto.getInstanceKey());
            String serviceName = autoDataConfigs.put("serviceName", NamingStrategy.underlineToCamel((String)this.processName(datas.getJSONObject("relateTable").getJSONArray("tableName").get(0).toString(), NamingStrategy.underline_to_camel, null)));
            autoDataConfigs.put("methodName", NamingStrategy.capitalFirst((String)this.processName(path.substring(1, path.length()).replace(".vpd", "").replace("/", "_") + currentDto.getInstanceKey(), NamingStrategy.underline_to_camel, null)));
        }
    }

    private void handleBusinessVar(JSONArray flowArray, Set<Map<String, String>> importList, Set<Map<String, String>> beanList, Set<Map<String, String>> tableFieldList, Set<String> set, Page meta) throws Exception {
        if (ToolUtil.isNotEmpty((Object)flowArray)) {
            List flowConditions = flowArray.toJavaList(JSONObject.class);
            for (JSONObject flowCondition : flowConditions) {
                HashMap<String, String> elseMap;
                HashMap<String, String> beanMap;
                String varForm = flowCondition.getString("varFrom");
                String variable = flowCondition.getString("variable");
                String varType = flowCondition.getString("varType");
                if ("businessVar".equals(varForm)) {
                    this.genWorkFlowPreInfo(this.getTableInfoDif(flowCondition), importList, beanList, tableFieldList, set, null, "businessVar", meta);
                    continue;
                }
                if ("UserOrgLevel".equals(varType)) {
                    beanMap = new HashMap<String, String>();
                    beanMap.put("serviceName", "WorkFlowListenService");
                    beanMap.put("serviceLowerName", "workFlowListenService");
                    beanMap.put("servicePackagePath", "com.jxdinfo.hussar.workflow.service");
                    importList.add(beanMap);
                    beanList.add(beanMap);
                    elseMap = new HashMap<String, String>();
                    elseMap.put("tableField", variable);
                    elseMap.put("serviceName", "workFlowListenService.getUserOrgLevel()");
                    tableFieldList.add(elseMap);
                    continue;
                }
                if ("UserSubsidiary".equals(varType)) {
                    beanMap = new HashMap();
                    beanMap.put("serviceName", "WorkFlowListenService");
                    beanMap.put("serviceLowerName", "workFlowListenService");
                    beanMap.put("servicePackagePath", "com.jxdinfo.hussar.workflow.service");
                    importList.add(beanMap);
                    beanList.add(beanMap);
                    elseMap = new HashMap();
                    elseMap.put("tableField", variable);
                    elseMap.put("serviceName", "workFlowListenService.getUserSubsidiary()");
                    tableFieldList.add(elseMap);
                    continue;
                }
                if (!"customVar".equals(varForm) && !ToolUtil.isEmpty((Object)varForm)) continue;
                HashMap<String, String> elseMap2 = new HashMap<String, String>();
                elseMap2.put("tableField", variable);
                tableFieldList.add(elseMap2);
            }
        }
    }

    private void updateWorkflowKey(FormDesignGenQo genQo) {
        String workflowKey = genQo.getWorkflowKey();
        if (null != workflowKey) {
            WorkflowInfo workFlowInfo = new WorkflowInfo();
            workFlowInfo.setDefinitionKey(workflowKey);
            genQo.setWorkFlowInfo(workFlowInfo);
        }
    }

    public void setDBConnInfo(FormDesignGenQo o) {
        o.setUrl(this.druidProperties.getUrl());
        o.setUserName(this.druidProperties.getUsername());
        o.setPassword(this.druidProperties.getPassword());
    }

    private String joinPackage(String parent, String subPackage) {
        if (StringUtils.isEmpty((CharSequence)parent)) {
            return subPackage.toLowerCase();
        }
        return parent.toLowerCase() + "." + subPackage.toLowerCase();
    }

    private void addTableOrView(String type, Set<String> set) {
        if ("user".equals(type)) {
            set.add(TableNameType.SYS_USERS.getType());
        }
        if ("organ".equals(type)) {
            set.add(TableNameType.SYS_ORGAN.getType());
        }
    }

    private String processName(String name, NamingStrategy strategy, String[] prefix) {
        boolean removePrefix = false;
        if (prefix != null && prefix.length >= 1) {
            removePrefix = true;
        }
        String propertyName = removePrefix ? (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.removePrefixAndCamel((String)name, (String[])prefix) : NamingStrategy.removePrefix((String)name, (String[])prefix)) : (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.underlineToCamel((String)name) : name);
        return propertyName;
    }

    private Map<String, List<String>> getGodFieldType(List<GodTableField> godTableFields) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        ArrayList<String> addList = new ArrayList<String>();
        ArrayList<String> editList = new ArrayList<String>();
        ArrayList<String> auditNodeList = new ArrayList<String>();
        for (GodTableField godTableField : godTableFields) {
            String definedStr = "";
            String addStr = "";
            String editStr = "";
            String relationFieldType = godTableField.getRelationFieldType();
            if (!ToolUtil.isNotEmpty((Object)relationFieldType)) continue;
            String fieldName = godTableField.getName();
            switch (relationFieldType) {
                case "createUserId": {
                    addStr = "ShiroKit.getUser().getId()";
                    break;
                }
                case "createTime": {
                    addStr = "new Date()";
                    break;
                }
                case "updateUserId": {
                    editStr = "ShiroKit.getUser().getId()";
                    break;
                }
                case "updateTime": {
                    editStr = "new Date()";
                    break;
                }
                case "auditNode": {
                    auditNodeList.add(GenPreDataUtil.getCapitalName(fieldName));
                }
            }
            definedStr = StringUtils.capitalize((String)fieldName) + "(";
            if (ToolUtil.isNotEmpty((Object)addStr)) {
                definedStr = definedStr + addStr + ")";
                addList.add(definedStr);
                continue;
            }
            if (!ToolUtil.isNotEmpty((Object)editStr)) continue;
            definedStr = definedStr + editStr + ")";
            editList.add(definedStr);
        }
        res.put("add", addList);
        res.put("edit", editList);
        res.put("auditNode", auditNodeList);
        return res;
    }

    private String entityInfo() {
        return "model";
    }

    private String serviceInfo() {
        return "service";
    }

    private String serviceImplInfo() {
        return "service.impl";
    }

    private String mapperInfo() {
        return "dao";
    }

    private String mapperXmlInfo() {
        return "dao.mapping";
    }

    private String controllerInfo() {
        return "controller";
    }
}

