/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.generator.formdesign.config.designvo.MidTableInfo;
import com.baomidou.mybatisplus.generator.formdesign.config.po.TableField;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.contant.GodAxeExceptionType;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.dto.GenCodePreData;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.util.GenPreDataUtil;
import com.jxdinfo.hussar.formdesign.desgin.cell.common.utildata.TableRelationShipInfo;
import com.jxdinfo.hussar.formdesign.desgin.form.vo.TableTreeNode;
import com.jxdinfo.hussar.formdesign.desgin.publish.model.PublishTableModel;
import com.jxdinfo.hussar.formdesign.desgin.publish.service.DatabaseInfoService;
import com.jxdinfo.hussar.formdesign.desgin.tableinfo.model.GodTableData;
import com.jxdinfo.hussar.formdesign.desgin.tableinfo.model.GodTableField;
import com.jxdinfo.hussar.formdesign.exception.GodAxeException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DatabaseInfoServiceImpl
implements DatabaseInfoService {
    private Logger logger = LoggerFactory.getLogger(DatabaseInfoServiceImpl.class);
    @Value(value="${form-design.project-path}")
    private String projectPath;
    @Value(value="${form-design.project-name}")
    private String projectName;
    @Value(value="${form-design.project-store-path}")
    private String projectStorePath;
    @Value(value="${form-design.page-store-path}")
    private String tableStructureStorePath;

    @Override
    public PublishTableModel getAllDatabaseInfoPath() throws IOException {
        String tableStorePath = this.projectPath + this.projectStorePath + this.projectName + this.tableStructureStorePath;
        PublishTableModel publishTableModel = new PublishTableModel();
        this.recursiveFiles(tableStorePath, publishTableModel);
        return publishTableModel;
    }

    @Override
    public TableRelationShipInfo getTableRelatedInfo(String tableName, String tableRelated, GenCodePreData genCodePreData) throws GodAxeException {
        TableRelationShipInfo tableRelationShipInfo = new TableRelationShipInfo();
        boolean tableRelation = false;
        for (Map.Entry<String, TableTreeNode> map : genCodePreData.getTablesData().entrySet()) {
            Map tableInfo = (Map)JSON.parseObject((String)map.getValue().getData(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            JSONObject jsonObject = (JSONObject)tableInfo.get("table");
            if (!ToolUtil.isNotEmpty((Object)jsonObject) || tableRelation) continue;
            if (map.getValue().isBetweenTable()) {
                MidTableInfo midTableInfo = this.getMidTableInfo(tableName, tableRelated, jsonObject, genCodePreData);
                if (!ToolUtil.isNotEmpty((Object)midTableInfo)) continue;
                tableRelation = true;
                tableRelationShipInfo.setHaveMidTable(true);
                tableRelationShipInfo.setMidTableInfo(midTableInfo);
                continue;
            }
            if (!tableName.equals(jsonObject.getString("name"))) continue;
            tableRelation = this.getReInfo(jsonObject, tableName, tableRelated, tableRelationShipInfo);
        }
        if (!tableRelation) {
            throw new GodAxeException(GodAxeExceptionType.TABLE_RELATION_NOT_FOUND, tableName + "\n" + tableRelated);
        }
        return tableRelationShipInfo;
    }

    private boolean getReInfo(JSONObject jsonObject, String tableName, String tableRelated, TableRelationShipInfo tableRelationShipInfo) {
        if (tableName.equals(jsonObject.getString("name"))) {
            List jsonArray = jsonObject.getJSONArray("fields").toJavaList(JSONObject.class);
            for (JSONObject obj : jsonArray) {
                String reName = obj.getString("relationTableName");
                String reShip = obj.getString("relationship");
                String reShow = obj.getString("relationTableShowField");
                if (!ToolUtil.isNotEmpty((Object)reName) || !reName.equals(tableRelated) || !ToolUtil.isNotEmpty((Object)reShip)) continue;
                tableRelationShipInfo.setTable(reName);
                tableRelationShipInfo.setField(reShip);
                tableRelationShipInfo.setReTable(tableName);
                tableRelationShipInfo.setReField(obj.getString("name"));
                tableRelationShipInfo.setReShow(reShow);
                return true;
            }
        }
        return false;
    }

    private void recursiveFiles(String path, PublishTableModel publishTableModel) throws IOException {
        String tableStorePath = this.projectPath + this.projectStorePath + this.projectName + this.tableStructureStorePath;
        tableStorePath = tableStorePath.replaceAll("/", Matcher.quoteReplacement(File.separator));
        File file = new File(path);
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        if (files.length == 0) {
            this.logger.info(path + "\u8be5\u6587\u4ef6\u5939\u4e0b\u6ca1\u6709\u6587\u4ef6");
            return;
        }
        for (File f : files) {
            File fileMeta;
            TableTreeNode tmp;
            if (f.isDirectory()) {
                this.recursiveFiles(f.getAbsolutePath(), publishTableModel);
                continue;
            }
            if (!f.isFile() || f.getName().endsWith(".meta") || !"table".equals((tmp = (TableTreeNode)JSON.parseObject((String)FileUtils.readFileToString((File)(fileMeta = new File(f.getAbsolutePath() + ".meta")), (String)"utf-8"), TableTreeNode.class)).getType()) || !ToolUtil.isNotEmpty((Object)tmp.getName())) continue;
            String filePath = f.getAbsolutePath();
            String filePathRelative = filePath.replace(tableStorePath, "").replace("\\", "/");
            String data = FileUtils.readFileToString((File)f, (String)"utf-8");
            if (tmp.isBetweenTable()) {
                publishTableModel.addMidTable(tmp.getName(), filePathRelative);
            } else {
                publishTableModel.addCommonTable(tmp.getName(), filePathRelative);
                GodTableData godTableData = (GodTableData)JSON.parseObject((String)data, GodTableData.class);
                List<GodTableField> godTableFields = godTableData.getTable().getFields();
                if (ToolUtil.isNotEmpty(godTableFields)) {
                    for (GodTableField godTableField : godTableFields) {
                        String fieldType;
                        if (ToolUtil.isNotEmpty((Object)godTableField.getRelationTableName()) && ToolUtil.isNotEmpty((Object)godTableField.getRelationship())) {
                            publishTableModel.addMainRelateTableInfo((String)godTableField.getRelationTableName(), tmp.getName());
                        }
                        if (!ToolUtil.isNotEmpty((Object)(fieldType = godTableField.getRelationFieldType())) || !"logicalDelete".equals(godTableField.getRelationFieldType())) continue;
                        publishTableModel.addLogicalInfo(tmp.getName(), godTableField.getName());
                    }
                }
            }
            tmp.setData(data);
            publishTableModel.addTableData(tmp.getName(), tmp);
        }
    }

    @Override
    public JSONArray getTableFields(String path, String tableName) {
        String tableStorePath = this.projectPath + this.projectStorePath + this.projectName + this.tableStructureStorePath;
        JSONArray res = new JSONArray();
        tableStorePath = tableStorePath.replaceAll("/", Matcher.quoteReplacement(File.separator));
        File file = "".equals(path) ? new File(tableStorePath) : new File(path);
        File[] files = file.listFiles();
        if (files == null) {
            return null;
        }
        if (files.length == 0) {
            this.logger.info(path + "\u8be5\u6587\u4ef6\u5939\u4e0b\u6ca1\u6709\u6587\u4ef6");
            return null;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                JSONArray rec = this.getTableFields(f.getAbsolutePath(), tableName);
                if (rec == null) continue;
                res.addAll((Collection)rec);
                continue;
            }
            if (!f.isFile() || f.getName().endsWith(".meta")) continue;
            File fileMeta = new File(f.getAbsolutePath() + ".meta");
            TableTreeNode tmp = null;
            try {
                tmp = (TableTreeNode)JSON.parseObject((String)FileUtils.readFileToString((File)fileMeta, (String)"utf-8"), TableTreeNode.class);
                if (!"table".equals(tmp.getType()) || !tableName.equals(tmp.getName())) continue;
                String filePath = f.getAbsolutePath();
                File dbdFile = new File(filePath);
                String dbdFileStr = FileUtils.readFileToString((File)dbdFile, (String)"utf-8");
                JSONObject dbdFileJson = JSON.parseObject((String)dbdFileStr);
                res = dbdFileJson.getJSONObject("table").getJSONArray("fields");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    private MidTableInfo getMidTableInfo(String tableName1, String tableName2, JSONObject table, GenCodePreData genCodePreData) {
        MidTableInfo midTableInfo = new MidTableInfo();
        List jsonArray = table.getJSONArray("fields").toJavaList(JSONObject.class);
        for (JSONObject obj : jsonArray) {
            TableField tableField1;
            TableField tableField;
            String midTable = obj.getString("tablename");
            String midFieldName = obj.getString("name");
            String reName = obj.getString("relationTableName");
            String reShip = obj.getString("relationship");
            String quTableName = obj.getString("relationSecondTableName");
            String quFieldName = obj.getString("relationshipSecond");
            if (ToolUtil.isNotEmpty((Object)reName) && reName.equals(tableName2) && ToolUtil.isNotEmpty((Object)reShip)) {
                midTableInfo.setMainTableInfo(GenPreDataUtil.getTableInfo(reName, genCodePreData));
                tableField = GenPreDataUtil.getTableField(genCodePreData, reName, reShip);
                if (ToolUtil.isNotEmpty((Object)tableField)) {
                    midTableInfo.setCapitalMainField(tableField.getCapitalName());
                    midTableInfo.setMainField(tableField);
                }
                midTableInfo.setMidTableInfo(GenPreDataUtil.getTableInfo(midTable, genCodePreData));
                tableField1 = GenPreDataUtil.getTableField(genCodePreData, midTable, midFieldName);
                if (ToolUtil.isNotEmpty((Object)tableField1)) {
                    midTableInfo.setCapitalMidMainField(tableField1.getCapitalName());
                    midTableInfo.setMidMainField(tableField1);
                }
            }
            if (!ToolUtil.isNotEmpty((Object)quTableName) || !quTableName.equals(tableName1) || !ToolUtil.isNotEmpty((Object)quFieldName)) continue;
            midTableInfo.setQuTableInfo(GenPreDataUtil.getTableInfo(quTableName, genCodePreData));
            tableField = GenPreDataUtil.getTableField(genCodePreData, quTableName, quFieldName);
            if (ToolUtil.isNotEmpty((Object)tableField)) {
                midTableInfo.setCapitalQuField(tableField.getCapitalName());
                midTableInfo.setQuField(tableField);
            }
            midTableInfo.setMidTableInfo(GenPreDataUtil.getTableInfo(midTable, genCodePreData));
            tableField1 = GenPreDataUtil.getTableField(genCodePreData, midTable, midFieldName);
            if (!ToolUtil.isNotEmpty((Object)tableField1)) continue;
            midTableInfo.setCapitalMidQuField(tableField1.getCapitalName());
            midTableInfo.setMidQuField(tableField1);
        }
        if (ToolUtil.isNotEmpty((Object)midTableInfo.getCapitalQuField()) && ToolUtil.isNotEmpty((Object)midTableInfo.getCapitalMainField())) {
            return midTableInfo;
        }
        return null;
    }
}

