/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.desgin.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.generator.formdesign.config.po.TableField;
import com.baomidou.mybatisplus.generator.formdesign.config.po.TableInfo;
import com.jxdinfo.hussar.formdesign.desgin.form.service.TemplateService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Service;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private int insKey;
    private int labelTop;
    private int inputTop;
    private int labelLeft;
    private int inputLeft;
    private int topGapOfLabels;
    private int topGapOfInputs;
    private int leftGapOfLabels;
    private int leftGapOfInputs;

    @Override
    public String genPageFromTemplate(TableInfo tableInfo, String templatePath) {
        this.insKey = 1;
        if (this.isGenFromTemplate(tableInfo, templatePath)) {
            try {
                String tableName = tableInfo.getName();
                List tableFields = tableInfo.getFields();
                String template = this.readTemplate(templatePath);
                Map templateMap = (Map)JSON.parseObject((String)template, Map.class);
                Map instancesOfTemplate = (Map)templateMap.get(InstanceDefinitionKey.INSTANCES);
                Map jxdForm = (Map)instancesOfTemplate.get(InstanceDefinitionKey.JXD_FORM);
                JSONObject templateIdHidden = JSONObject.parseObject((String)this.idHidden());
                Map jxdTitle = (Map)instancesOfTemplate.get(InstanceDefinitionKey.JXD_TITLE);
                HashMap<String, Map> instances = new HashMap<String, Map>();
                HashMap<String, Object> result = new HashMap<String, Object>();
                ArrayList<Map> labelsOfTemplate = new ArrayList<Map>();
                ArrayList<Map> inputsOfTemplate = new ArrayList<Map>();
                this.initLabelsAndInputsAndC(instancesOfTemplate, labelsOfTemplate, inputsOfTemplate);
                Map canvas = this.getCanvas(instancesOfTemplate);
                this.sortInstances(labelsOfTemplate);
                this.sortInstances(inputsOfTemplate);
                this.initTopGapOfLabels(labelsOfTemplate);
                this.initTopGapOfInputs(inputsOfTemplate);
                this.initLeftGapOfLabels(labelsOfTemplate);
                this.initLeftGapOfInputs(inputsOfTemplate);
                Map templateLabel = (Map)labelsOfTemplate.get(0);
                Map templateInput = (Map)inputsOfTemplate.get(0);
                result.put(InstanceDefinitionKey.INSTANCES, instances);
                instances.put(InstanceDefinitionKey.CANVAS, canvas);
                instances.put(InstanceDefinitionKey.JXD_FORM, jxdForm);
                JSONArray childrenOfJxdForm = new JSONArray();
                JSONArray childrenOfCanvas = (JSONArray)canvas.get("children");
                jxdForm.put(InstanceDefinitionKey.CHILDREN, childrenOfJxdForm);
                Map propsOfJxdForm = (Map)jxdForm.get(InstanceDefinitionKey.PROPS);
                propsOfJxdForm.put(InstanceDefinitionKey.RELATE_TABLE, tableName);
                result.put(InstanceDefinitionKey.RELATE_TABLE, tableName);
                HashMap formFields = new HashMap();
                propsOfJxdForm.put(InstanceDefinitionKey.FORM_FIELDS, formFields);
                this.initLabelTopAndLeft((Map)labelsOfTemplate.get(0));
                this.initInputTopAndLeft((Map)inputsOfTemplate.get(0));
                tableFields.forEach(arg_0 -> this.lambda$genPageFromTemplate$0((Map)templateIdHidden, instances, formFields, childrenOfCanvas, templateLabel, templateInput, childrenOfJxdForm, arg_0));
                JSONArray hiddenArray = new JSONArray();
                JSONArray eventsList = new JSONArray();
                JSONObject pageStyle = new JSONObject();
                result.put(InstanceDefinitionKey.ROOT_INSTANCE_KEY, InstanceDefinitionKey.CANVAS);
                result.put(InstanceDefinitionKey.EVENTS_LIST, eventsList);
                result.put(InstanceDefinitionKey.PAGE_STYLE, pageStyle);
                Map propsOfJxdTitle = (Map)jxdTitle.get("props");
                String tableCnName = tableInfo.getComment();
                propsOfJxdTitle.put("text", tableCnName);
                childrenOfJxdForm.add((Object)InstanceDefinitionKey.JXD_TITLE);
                instances.put(InstanceDefinitionKey.JXD_TITLE, jxdTitle);
                hiddenArray.add((Object)InstanceDefinitionKey.ID_HIDDEN);
                result.put(InstanceDefinitionKey.HIDDEN_ARRAY, hiddenArray);
                return JSONObject.toJSONString(result);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private void initTopGapOfInputs(List<Map> inputsOfTemplate) {
        if (inputsOfTemplate.size() > 1) {
            Map firstInput = inputsOfTemplate.get(0);
            Map secondInput = inputsOfTemplate.get(1);
            String theTopStrOfFirstInput = String.valueOf(((Map)firstInput.get("style")).get("top"));
            int theTopOfFirstInput = this.getIntegerOfString(theTopStrOfFirstInput);
            String theTopStrOfSecondInput = String.valueOf(((Map)secondInput.get("style")).get("top"));
            int theTopOfSecondInput = this.getIntegerOfString(theTopStrOfSecondInput);
            this.topGapOfInputs = theTopOfSecondInput - theTopOfFirstInput;
        }
    }

    private void initLeftGapOfInputs(List<Map> inputsOfTemplate) {
        if (inputsOfTemplate.size() > 1) {
            Map firstInput = inputsOfTemplate.get(0);
            Map secondInput = inputsOfTemplate.get(1);
            String theLeftStrOfFirstInput = String.valueOf(((Map)firstInput.get("style")).get("left"));
            int theLeftOfFirstInput = this.getIntegerOfString(theLeftStrOfFirstInput);
            String theLeftStrOfSecondInput = String.valueOf(((Map)secondInput.get("style")).get("left"));
            int theLeftOfSecondInput = this.getIntegerOfString(theLeftStrOfSecondInput);
            this.leftGapOfInputs = theLeftOfSecondInput - theLeftOfFirstInput;
        }
    }

    private void initTopGapOfLabels(List<Map> labelsOfTemplate) {
        if (labelsOfTemplate.size() > 1) {
            Map firstLabel = labelsOfTemplate.get(0);
            Map secondLabel = labelsOfTemplate.get(1);
            String theTopStrOfFirstLabel = String.valueOf(((Map)firstLabel.get("style")).get("top"));
            int theTopOfFirstLabel = this.getIntegerOfString(theTopStrOfFirstLabel);
            String theTopStrOfSecondLabel = String.valueOf(((Map)secondLabel.get("style")).get("top"));
            int theTopOfSecondLabel = this.getIntegerOfString(theTopStrOfSecondLabel);
            this.topGapOfLabels = theTopOfSecondLabel - theTopOfFirstLabel;
        }
    }

    private void initLeftGapOfLabels(List<Map> labelsOfTemplate) {
        if (labelsOfTemplate.size() > 1) {
            Map firstLabel = labelsOfTemplate.get(0);
            Map secondLabel = labelsOfTemplate.get(1);
            String theLeftStrOfFirstLabel = String.valueOf(((Map)firstLabel.get("style")).get("left"));
            int theLeftOfFirstLabel = this.getIntegerOfString(theLeftStrOfFirstLabel);
            String theLeftStrOfSecondLabel = String.valueOf(((Map)secondLabel.get("style")).get("left"));
            int theLeftOfSecondLabel = this.getIntegerOfString(theLeftStrOfSecondLabel);
            this.leftGapOfLabels = theLeftOfSecondLabel - theLeftOfFirstLabel;
        }
    }

    private void sortInstances(List<Map> labelsOfTemplate) {
        labelsOfTemplate.sort((a, b) -> {
            String topStringOfA = String.valueOf(((Map)a.get("style")).get("top"));
            int topOfA = this.getIntegerOfString(topStringOfA);
            String topStringOfB = String.valueOf(((Map)b.get("style")).get("top"));
            int topOfB = this.getIntegerOfString(topStringOfB);
            return topOfA - topOfB;
        });
    }

    private void initLabelsAndInputsAndC(Map instancesOfTemplate, List<Map> labelsOfTemplate, List<Map> inputsOfTemplate) {
        Set instancesKeysOfTemplate = instancesOfTemplate.keySet();
        instancesKeysOfTemplate.forEach(instanceKeyOfTemplate -> {
            Map instance = (Map)instancesOfTemplate.get(instanceKeyOfTemplate);
            if ("layLabel".equals(String.valueOf(instance.get("name"))) && !InstanceDefinitionKey.JXD_TITLE.equals(String.valueOf(instance.get("instanceKey")))) {
                labelsOfTemplate.add(instance);
            }
            if ("layInput".equals(String.valueOf(instance.get("name")))) {
                inputsOfTemplate.add(instance);
            }
        });
    }

    private Map getCanvas(Map instancesOfTemplate) {
        Set instancesKeysOfTemplate = instancesOfTemplate.keySet();
        Map[] map = new Map[1];
        instancesKeysOfTemplate.forEach(instanceKeyOfTemplate -> {
            Map instance = (Map)instancesOfTemplate.get(instanceKeyOfTemplate);
            if ("bpmCanvas".equals(String.valueOf(instance.get("name"))) && !InstanceDefinitionKey.JXD_TITLE.equals(String.valueOf(instance.get("instanceKey")))) {
                map[0] = instance;
            }
        });
        map[0].put("instanceKey", InstanceDefinitionKey.CANVAS);
        map[0].put("id", InstanceDefinitionKey.CANVAS);
        return map[0];
    }

    private boolean isGenFromTemplate(TableInfo tableInfo, String templatePath) {
        return null != tableInfo && templatePath != null;
    }

    private String getLabelTop() {
        int res = this.labelTop;
        this.labelTop += this.topGapOfLabels;
        return res + "px";
    }

    private String getLabelLeft() {
        int res = this.labelLeft;
        this.labelLeft += this.leftGapOfLabels;
        return res + "px";
    }

    private String getInputTop() {
        int res = this.inputTop;
        this.inputTop += this.topGapOfInputs;
        return res + "px";
    }

    private String getInputLeft() {
        int res = this.inputLeft;
        this.inputLeft += this.leftGapOfInputs;
        return res + "px";
    }

    private void initLabelTopAndLeft(Map templateLabel) {
        Map templateLabelStyle = (Map)templateLabel.get("style");
        String labelTopOrigin = String.valueOf(templateLabelStyle.get("top"));
        String labelLeftOrigin = String.valueOf(templateLabelStyle.get("left"));
        this.labelTop = this.getIntegerOfString(labelTopOrigin);
        this.labelLeft = this.getIntegerOfString(labelLeftOrigin);
    }

    private void initInputTopAndLeft(Map templateInput) {
        Map templateInputStyle = (Map)templateInput.get("style");
        String inputTopOrigin = String.valueOf(templateInputStyle.get("top"));
        String inputLeftOrigin = String.valueOf(templateInputStyle.get("left"));
        this.inputTop = this.getIntegerOfString(inputTopOrigin);
        this.inputLeft = this.getIntegerOfString(inputLeftOrigin);
    }

    private Integer getIntegerOfString(String origin) {
        String regEx = "[^0-9]";
        Pattern p = Pattern.compile(regEx);
        return Integer.parseInt(p.matcher(origin).replaceAll("").trim());
    }

    private Map renderLabel(Map templateLabel, TableField tableField, String labelKey) {
        Map label = this.clone(templateLabel);
        label.put("instanceKey", labelKey);
        label.put("id", labelKey);
        Map props = (Map)label.get("props");
        props.put("text", tableField.getComment());
        return label;
    }

    private Map renderIdHidden(Map templateIdHidden, TableField tableField) {
        Map idHidden = this.clone(templateIdHidden);
        return idHidden;
    }

    private Map renderInput(Map templateInput, TableField tableField, String labelKey) {
        Map input = this.clone(templateInput);
        input.put("instanceKey", labelKey);
        input.put("id", labelKey);
        Map props = (Map)input.get("props");
        props.put("text", tableField.getComment());
        return input;
    }

    private Map clone(Map map) {
        String mapToString = JSON.toJSONString((Object)map);
        return JSONObject.parseObject((String)mapToString);
    }

    private String readTemplate(String templatePath) throws IOException {
        return FileUtils.readFileToString((File)new File(templatePath), (String)"utf-8");
    }

    private String getInsKey() {
        String resInsKey = "jxd_ins_" + this.insKey;
        ++this.insKey;
        return resInsKey;
    }

    private String idHidden() {
        return "{\n        \"isRoot\": false,\n        \"purpose\": \"\",\n        \"rootWrapKey\": \"\",\n        \"relateInstances\": {},\n        \"editingClassName\": \"jxd-editing-container\",\n        \"className\": \"\",\n        \"isCombo\": false,\n        \"type\": \"\",\n        \"goInPathes\": [],\n        \"taskListener\": [],\n        \"children\": [],\n        \"isLocked\": false,\n        \"exeListener\": [],\n        \"alias\": \"\u9690\u85cf\u57df\",\n        \"id\": \"id_hidden\",\n        \"isComboRoot\": false,\n        \"tableField2InstanceKey\": {},\n        \"directWrapKey\": \"\",\n        \"computedStyle\": {},\n        \"posRelate\": null,\n        \"eventConfigs\": [],\n        \"inputprop\": [],\n        \"index\": 1,\n        \"label\": \"\u9690\u85cf\u57df\",\n        \"isShow\": true,\n        \"props\": {\n          \"name\": \"\u9690\u85cf\u57df\",\n          \"relatedForm\": \"jxd_form\"\n        },\n        \"relevanceTable\": null,\n        \"parentInstanceKey\": \"canvas\",\n        \"name\": \"iHidden\",\n        \"style\": {\n          \"top\": \"-70px\",\n          \"left\": \"0px\",\n          \"width\": \"120px\",\n          \"position\": \"absolute\",\n          \"height\": \"30px\",\n          \"zIndex\": 1002\n        },\n        \"outputprop\": [],\n        \"category\": \"form\",\n        \"calledElement\": {},\n        \"goOutPathes\": [],\n        \"instanceKey\": \"id_hidden\"\n      }";
    }

    private /* synthetic */ void lambda$genPageFromTemplate$0(Map templateIdHidden, Map instances, Map formFields, JSONArray childrenOfCanvas, Map templateLabel, Map templateInput, JSONArray childrenOfJxdForm, TableField tableField) {
        if (tableField.isId()) {
            Map idHidden = this.renderIdHidden(templateIdHidden, tableField);
            String idHiddenKey = InstanceDefinitionKey.ID_HIDDEN;
            instances.put(idHiddenKey, idHidden);
            formFields.put(tableField.getName(), idHiddenKey);
            childrenOfCanvas.add((Object)InstanceDefinitionKey.ID_HIDDEN);
        } else {
            String labelKey = this.getInsKey();
            Map label = this.renderLabel(templateLabel, tableField, labelKey);
            Map labelStyle = (Map)label.get(InstanceDefinitionKey.STYLE);
            String labelTop = this.getLabelTop();
            labelStyle.put(InstanceDefinitionKey.TOP, labelTop);
            String labelLeft = this.getLabelLeft();
            labelStyle.put(InstanceDefinitionKey.LEFT, labelLeft);
            instances.put(labelKey, label);
            String inputKey = this.getInsKey();
            Map input = this.renderInput(templateInput, tableField, inputKey);
            instances.put(inputKey, input);
            Map inputStyle = (Map)input.get(InstanceDefinitionKey.STYLE);
            String inputTop = this.getInputTop();
            inputStyle.put(InstanceDefinitionKey.TOP, inputTop);
            String inputLeft = this.getInputLeft();
            inputStyle.put(InstanceDefinitionKey.LEFT, inputLeft);
            childrenOfJxdForm.add((Object)labelKey);
            childrenOfJxdForm.add((Object)inputKey);
            formFields.put(tableField.getName(), inputKey);
        }
    }

    static abstract class InstanceDefinitionKey {
        static String INSTANCES = "instances";
        static String CANVAS = "canvas";
        static String JXD_FORM = "jxd_form";
        static String JXD_TITLE = "jxd_title";
        static String TEMPLATE_LABEL = "template_label";
        static String TEMPLATE_INPUT = "template_input";
        static String ID_HIDDEN = "id_hidden";
        static String PROPS = "props";
        static String FORM_FIELDS = "formFields";
        static String STYLE = "style";
        static String TOP = "top";
        static String LEFT = "left";
        static String ROOT_INSTANCE_KEY = "rootInstanceKey";
        static String HIDDEN_ARRAY = "hiddenArray";
        static String PAGE_STYLE = "pageStyle";
        static String CHILDREN = "children";
        static String EVENTS_LIST = "eventsList";
        static String RELATE_TABLE = "relateTable";

        InstanceDefinitionKey() {
        }
    }
}

